/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.common.component.ClassLoaderFactory;
import org.jboss.dna.common.component.StandardClassLoaderFactory;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.Location;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.Workspace;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.inmemory.InMemoryRepositorySource;
import org.jboss.dna.graph.mimetype.MimeTypeDetector;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathExpression;
import org.jboss.dna.graph.property.PathNotFoundException;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.basic.RootPath;
import org.jboss.dna.graph.request.InvalidWorkspaceException;
import org.jboss.dna.graph.sequencer.StreamSequencer;
import org.jboss.dna.repository.DnaEngine;
import org.jboss.dna.repository.DnaLexicon;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class DnaConfiguration {
    public static final String DEFAULT_WORKSPACE_NAME = "";
    public static final String DEFAULT_PATH = "/";
    public static final String DEFAULT_CONFIGURATION_SOURCE_NAME = "DNA Configuration Repository";
    private final ExecutionContext context;
    private final Problems problems = new SimpleProblems();
    private ConfigurationDefinition configurationContent;
    private Graph.Batch changes;
    private final Map<String, SequencerDefinition<? extends DnaConfiguration>> sequencerDefinitions = new HashMap<String, SequencerDefinition<? extends DnaConfiguration>>();
    private final Map<String, RepositorySourceDefinition<? extends DnaConfiguration>> repositorySourceDefinitions = new HashMap<String, RepositorySourceDefinition<? extends DnaConfiguration>>();
    private final Map<String, MimeTypeDetectorDefinition<? extends DnaConfiguration>> mimeTypeDetectorDefinitions = new HashMap<String, MimeTypeDetectorDefinition<? extends DnaConfiguration>>();

    public DnaConfiguration() {
        this(new ExecutionContext());
    }

    public DnaConfiguration(ExecutionContext context) {
        CheckArg.isNotNull((Object)context, (String)"context");
        this.context = context;
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName(DEFAULT_CONFIGURATION_SOURCE_NAME);
        source.setDefaultWorkspaceName(DEFAULT_WORKSPACE_NAME);
        this.configurationContent = new ConfigurationDefinition((RepositorySource)source, null, null, context, null);
    }

    public DnaConfiguration loadFrom(String pathToConfigurationFile) throws IOException, SAXException {
        CheckArg.isNotEmpty((String)pathToConfigurationFile, (String)"pathToConfigurationFile");
        return this.loadFrom(pathToConfigurationFile, DEFAULT_PATH);
    }

    public DnaConfiguration loadFrom(String pathToConfigurationFile, String path) throws IOException, SAXException {
        CheckArg.isNotEmpty((String)pathToConfigurationFile, (String)"pathToConfigurationFile");
        return this.loadFrom(new File(pathToConfigurationFile), path);
    }

    public DnaConfiguration loadFrom(File configurationFile) throws IOException, SAXException {
        CheckArg.isNotNull((Object)configurationFile, (String)"configurationFile");
        return this.loadFrom(configurationFile, DEFAULT_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DnaConfiguration loadFrom(File configurationFile, String path) throws IOException, SAXException {
        CheckArg.isNotNull((Object)configurationFile, (String)"configurationFile");
        FileInputStream stream = new FileInputStream(configurationFile);
        try {
            DnaConfiguration dnaConfiguration = this.loadFrom(stream, path);
            return dnaConfiguration;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    public DnaConfiguration loadFrom(URL urlToConfigurationFile) throws IOException, SAXException {
        CheckArg.isNotNull((Object)urlToConfigurationFile, (String)"urlToConfigurationFile");
        return this.loadFrom(urlToConfigurationFile, DEFAULT_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DnaConfiguration loadFrom(URL urlToConfigurationFile, String path) throws IOException, SAXException {
        CheckArg.isNotNull((Object)urlToConfigurationFile, (String)"urlToConfigurationFile");
        InputStream stream = urlToConfigurationFile.openStream();
        try {
            DnaConfiguration dnaConfiguration = this.loadFrom(stream, path);
            return dnaConfiguration;
        }
        finally {
            stream.close();
        }
    }

    public DnaConfiguration loadFrom(InputStream configurationFileInputStream) throws IOException, SAXException {
        CheckArg.isNotNull((Object)configurationFileInputStream, (String)"configurationFileInputStream");
        return this.loadFrom(configurationFileInputStream, DEFAULT_PATH);
    }

    public DnaConfiguration loadFrom(InputStream configurationFileInputStream, String path) throws IOException, SAXException {
        CheckArg.isNotNull((Object)configurationFileInputStream, (String)"configurationFileInputStream");
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName(DEFAULT_CONFIGURATION_SOURCE_NAME);
        source.setDefaultWorkspaceName(DEFAULT_WORKSPACE_NAME);
        Path pathToParent = this.path(path != null ? path : DEFAULT_PATH);
        Graph graph = Graph.create((RepositorySource)source, (ExecutionContext)this.context);
        graph.importXmlFrom(configurationFileInputStream).skippingRootElement(true).into(pathToParent);
        this.configurationContent = new ConfigurationDefinition((RepositorySource)source, null, pathToParent, this.context, null);
        return this;
    }

    public DnaConfiguration loadFrom(RepositorySource source) {
        return this.loadFrom(source, null, null);
    }

    public DnaConfiguration loadFrom(RepositorySource source, String workspaceName) {
        CheckArg.isNotNull((Object)source, (String)"source");
        return this.loadFrom(source, workspaceName, null);
    }

    public DnaConfiguration loadFrom(RepositorySource source, String workspaceName, String pathInWorkspace) {
        CheckArg.isNotNull((Object)source, (String)"source");
        Graph graph = Graph.create((RepositorySource)source, (ExecutionContext)this.context);
        if (workspaceName != null) {
            Workspace workspace = null;
            try {
                workspace = graph.useWorkspace(workspaceName);
            }
            catch (InvalidWorkspaceException e) {
                workspace = graph.createWorkspace().named(workspaceName);
            }
            assert (workspace.getRoot() != null);
        }
        Path path = pathInWorkspace != null ? this.path(pathInWorkspace) : this.path(DEFAULT_PATH);
        Node parent = graph.getNodeAt(path);
        assert (parent != null);
        this.configurationContent = new ConfigurationDefinition(source, workspaceName, path, this.context, null);
        return this;
    }

    public ConfigurationDefinition getConfigurationDefinition() {
        return this.configurationContent;
    }

    protected ExecutionContext getExecutionContext() {
        return this.configurationContent.getContext();
    }

    protected Path path() {
        return this.configurationContent.getPath();
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    public Problems getProblems() {
        return this.problems;
    }

    protected Graph.Batch changes() {
        if (this.changes == null) {
            ConfigurationDefinition content = this.getConfigurationDefinition();
            Graph graph = Graph.create((RepositorySource)content.getRepositorySource(), (ExecutionContext)content.getContext());
            if (content.getWorkspace() != null) {
                graph.useWorkspace(content.getWorkspace());
            }
            this.changes = graph.batch();
        }
        return this.changes;
    }

    public boolean hasChanges() {
        Graph.Batch changes = this.changes;
        return changes != null && changes.isExecuteRequired();
    }

    public DnaConfiguration save() {
        Graph.Batch changes = this.changes;
        if (changes != null && changes.isExecuteRequired()) {
            changes.execute();
        }
        this.changes = null;
        this.sequencerDefinitions.clear();
        this.mimeTypeDetectorDefinitions.clear();
        this.repositorySourceDefinitions.clear();
        return this;
    }

    public DnaConfiguration withClassLoaderFactory(ClassLoaderFactory classLoaderFactory) {
        this.configurationContent = this.configurationContent.with(classLoaderFactory);
        return this;
    }

    protected Set<String> getNamesOfComponentsUnder(Name parentName) {
        HashSet<String> names = new HashSet<String>();
        try {
            ConfigurationDefinition content = this.getConfigurationDefinition();
            Path path = this.context.getValueFactories().getPathFactory().create(content.getPath(), new Name[]{parentName});
            for (Location child : (List)content.graph().getChildren().of(path)) {
                names.add(child.getPath().getLastSegment().getString(this.context.getNamespaceRegistry()));
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        return names;
    }

    public Set<MimeTypeDetectorDefinition<? extends DnaConfiguration>> mimeTypeDetectors() {
        Set<String> names = this.getNamesOfComponentsUnder(DnaLexicon.MIME_TYPE_DETECTORS);
        names.addAll(this.mimeTypeDetectorDefinitions.keySet());
        HashSet<MimeTypeDetectorDefinition<? extends DnaConfiguration>> results = new HashSet<MimeTypeDetectorDefinition<? extends DnaConfiguration>>();
        for (String name : names) {
            results.add(this.mimeTypeDetector(name));
        }
        return Collections.unmodifiableSet(results);
    }

    public Set<RepositorySourceDefinition<? extends DnaConfiguration>> repositorySources() {
        Set<String> names = this.getNamesOfComponentsUnder(DnaLexicon.SOURCES);
        names.addAll(this.repositorySourceDefinitions.keySet());
        HashSet<RepositorySourceDefinition<? extends DnaConfiguration>> results = new HashSet<RepositorySourceDefinition<? extends DnaConfiguration>>();
        for (String name : names) {
            results.add(this.repositorySource(name));
        }
        return Collections.unmodifiableSet(results);
    }

    public Set<SequencerDefinition<? extends DnaConfiguration>> sequencers() {
        Set<String> names = this.getNamesOfComponentsUnder(DnaLexicon.SEQUENCERS);
        names.addAll(this.sequencerDefinitions.keySet());
        HashSet<SequencerDefinition<? extends DnaConfiguration>> results = new HashSet<SequencerDefinition<? extends DnaConfiguration>>();
        for (String name : names) {
            results.add(this.sequencer(name));
        }
        return Collections.unmodifiableSet(results);
    }

    public MimeTypeDetectorDefinition<? extends DnaConfiguration> mimeTypeDetector(String name) {
        return this.mimeTypeDetectorDefinition(this, name);
    }

    public RepositorySourceDefinition<? extends DnaConfiguration> repositorySource(String name) {
        return this.repositorySourceDefinition(this, name);
    }

    public SequencerDefinition<? extends DnaConfiguration> sequencer(String name) {
        return this.sequencerDefinition(this, name);
    }

    public DnaConfiguration and() {
        return this;
    }

    public DnaEngine build() {
        this.save();
        return new DnaEngine(this.getExecutionContext(), this.getConfigurationDefinition());
    }

    protected <ReturnType extends DnaConfiguration> MimeTypeDetectorDefinition<ReturnType> mimeTypeDetectorDefinition(ReturnType returnObject, String name) {
        MimeTypeDetectorDefinition<? extends DnaConfiguration> definition = this.mimeTypeDetectorDefinitions.get(name);
        if (definition == null) {
            definition = new MimeTypeDetectorBuilder<DnaConfiguration>(returnObject, this.changes(), this.path(), DnaLexicon.MIME_TYPE_DETECTORS, this.name(name));
            this.mimeTypeDetectorDefinitions.put(name, definition);
        }
        return definition;
    }

    protected <ReturnType extends DnaConfiguration> RepositorySourceDefinition<ReturnType> repositorySourceDefinition(ReturnType returnObject, String name) {
        RepositorySourceDefinition<? extends DnaConfiguration> definition = this.repositorySourceDefinitions.get(name);
        if (definition == null) {
            definition = new SourceBuilder<DnaConfiguration>(returnObject, this.changes(), this.path(), DnaLexicon.SOURCES, this.name(name));
            this.repositorySourceDefinitions.put(name, definition);
        }
        return definition;
    }

    protected <ReturnType extends DnaConfiguration> SequencerDefinition<ReturnType> sequencerDefinition(ReturnType returnObject, String name) {
        SequencerDefinition<? extends DnaConfiguration> definition = this.sequencerDefinitions.get(name);
        if (definition == null) {
            definition = new SequencerBuilder<DnaConfiguration>(returnObject, this.changes(), this.path(), DnaLexicon.SEQUENCERS, this.name(name));
            this.sequencerDefinitions.put(name, definition);
        }
        return definition;
    }

    @Immutable
    public static class ConfigurationDefinition {
        private final ClassLoaderFactory classLoaderFactory;
        private final RepositorySource source;
        private final Path path;
        private final String workspace;
        private final ExecutionContext context;
        private Graph graph;

        protected ConfigurationDefinition(RepositorySource source, String workspace, Path path, ExecutionContext context, ClassLoaderFactory classLoaderFactory) {
            this.source = source;
            this.path = path != null ? path : RootPath.INSTANCE;
            this.workspace = workspace;
            this.context = context;
            this.classLoaderFactory = classLoaderFactory != null ? classLoaderFactory : new StandardClassLoaderFactory();
        }

        public RepositorySource getRepositorySource() {
            return this.source;
        }

        public Path getPath() {
            return this.path;
        }

        public String getWorkspace() {
            return this.workspace;
        }

        public ExecutionContext getContext() {
            return this.context;
        }

        public ClassLoaderFactory getClassLoaderFactory() {
            return this.classLoaderFactory;
        }

        public ConfigurationDefinition with(Path path) {
            return new ConfigurationDefinition(this.source, this.workspace, path, this.context, this.classLoaderFactory);
        }

        public ConfigurationDefinition withWorkspace(String workspace) {
            return new ConfigurationDefinition(this.source, workspace, this.path, this.context, this.classLoaderFactory);
        }

        public ConfigurationDefinition with(ClassLoaderFactory classLoaderFactory) {
            return new ConfigurationDefinition(this.source, this.workspace, this.path, this.context, classLoaderFactory);
        }

        public Graph graph() {
            if (this.graph == null) {
                this.graph = Graph.create((RepositorySource)this.source, (ExecutionContext)this.context);
                if (this.workspace != null) {
                    this.graph.useWorkspace(this.workspace);
                }
            }
            return this.graph;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SequencerBuilder<ReturnType>
    extends GraphComponentBuilder<ReturnType, SequencerDefinition<ReturnType>, StreamSequencer>
    implements SequencerDefinition<ReturnType> {
        protected SequencerBuilder(ReturnType returnObject, Graph.Batch batch, Path path, Name ... names) {
            super(returnObject, batch, path, names);
        }

        @Override
        protected SequencerDefinition<ReturnType> thisType() {
            return this;
        }

        @Override
        public Set<PathExpression> getPathExpressions() {
            HashSet<PathExpression> expressions = new HashSet<PathExpression>();
            try {
                Property existingExpressions = this.getProperty(DnaLexicon.PATH_EXPRESSION);
                if (existingExpressions != null) {
                    for (Object existing : existingExpressions.getValuesAsArray()) {
                        String existingExpression = (String)this.context.getValueFactories().getStringFactory().create(existing);
                        expressions.add(PathExpression.compile((String)existingExpression));
                    }
                }
            }
            catch (PathNotFoundException pathNotFoundException) {
                // empty catch block
            }
            return expressions;
        }

        @Override
        public SequencerDefinition<ReturnType> sequencingFrom(PathExpression expression) {
            CheckArg.isNotNull((Object)expression, (String)"expression");
            Set<PathExpression> compiledExpressions = this.getPathExpressions();
            compiledExpressions.add(expression);
            Object[] strings = new String[compiledExpressions.size()];
            int index = 0;
            for (PathExpression compiledExpression : compiledExpressions) {
                strings[index++] = compiledExpression.getExpression();
            }
            this.setProperty(DnaLexicon.PATH_EXPRESSION, strings);
            return this;
        }

        @Override
        public PathExpressionOutput<ReturnType> sequencingFrom(final String fromPathExpression) {
            CheckArg.isNotEmpty((String)fromPathExpression, (String)"fromPathExpression");
            return new PathExpressionOutput<ReturnType>(){

                @Override
                public SequencerDefinition<ReturnType> andOutputtingTo(String into) {
                    CheckArg.isNotEmpty((String)into, (String)"into");
                    return SequencerBuilder.this.sequencingFrom(PathExpression.compile((String)(fromPathExpression + " => " + into)));
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SourceBuilder<ReturnType>
    extends GraphComponentBuilder<ReturnType, RepositorySourceDefinition<ReturnType>, RepositorySource>
    implements RepositorySourceDefinition<ReturnType> {
        protected SourceBuilder(ReturnType returnObject, Graph.Batch batch, Path path, Name ... names) {
            super(returnObject, batch, path, names);
        }

        @Override
        protected RepositorySourceDefinition<ReturnType> thisType() {
            return this;
        }

        @Override
        public RepositorySourceDefinition<ReturnType> setRetryLimit(int retryLimit) {
            return (RepositorySourceDefinition)this.setProperty(DnaLexicon.RETRY_LIMIT, (Object)retryLimit);
        }

        @Override
        public RepositorySourceDefinition<ReturnType> setProperty(String propertyName, Object value) {
            Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
            if (name.getLocalName().equals(DnaLexicon.RETRY_LIMIT.getLocalName())) {
                name = DnaLexicon.RETRY_LIMIT;
            }
            if (name.getLocalName().equals(DnaLexicon.DESCRIPTION.getLocalName())) {
                name = DnaLexicon.DESCRIPTION;
            }
            return (RepositorySourceDefinition)super.setProperty(name, value);
        }

        @Override
        public Property getProperty(Name name) {
            if (name.getLocalName().equals(DnaLexicon.RETRY_LIMIT.getLocalName())) {
                name = DnaLexicon.RETRY_LIMIT;
            }
            if (name.getLocalName().equals(DnaLexicon.DESCRIPTION.getLocalName())) {
                name = DnaLexicon.DESCRIPTION;
            }
            return super.getProperty(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MimeTypeDetectorBuilder<ReturnType>
    extends GraphComponentBuilder<ReturnType, MimeTypeDetectorDefinition<ReturnType>, MimeTypeDetector>
    implements MimeTypeDetectorDefinition<ReturnType> {
        protected MimeTypeDetectorBuilder(ReturnType returnObject, Graph.Batch batch, Path path, Name ... names) {
            super(returnObject, batch, path, names);
        }

        @Override
        protected MimeTypeDetectorBuilder<ReturnType> thisType() {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class GraphComponentBuilder<ReturnType, ThisType, ComponentType>
    extends GraphReturnable<ReturnType, ThisType>
    implements ChooseClass<ComponentType, ThisType> {
        protected GraphComponentBuilder(ReturnType returnObject, Graph.Batch batch, Path path, Name ... names) {
            super(returnObject, batch, path, names);
        }

        @Override
        public LoadedFrom<ThisType> usingClass(final String classname) {
            return new LoadedFrom<ThisType>(){

                @Override
                public ThisType loadedFromClasspath() {
                    return GraphComponentBuilder.this.setProperty(DnaLexicon.CLASSNAME, (Object)classname);
                }

                @Override
                public ThisType loadedFrom(String ... classpath) {
                    ArrayList<String> classpaths = new ArrayList<String>();
                    for (String value : classpath) {
                        if (value == null || (value = value.trim()).length() == 0 || classpaths.contains(value)) continue;
                        classpaths.add(value);
                    }
                    if (classpaths.size() != 0) {
                        classpath = classpaths.toArray(new String[classpaths.size()]);
                        GraphComponentBuilder.this.setProperty(DnaLexicon.CLASSPATH, (Object[])classpath);
                    }
                    return GraphComponentBuilder.this.setProperty(DnaLexicon.CLASSNAME, (Object)classname);
                }
            };
        }

        @Override
        public ThisType usingClass(Class<? extends ComponentType> componentClass) {
            return this.setProperty(DnaLexicon.CLASSNAME, (Object)componentClass.getCanonicalName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class GraphReturnable<ReturnType, ThisType>
    extends BaseReturnable<ReturnType>
    implements SetDescription<ThisType>,
    SetProperties<ThisType>,
    Removable<ReturnType> {
        protected final ExecutionContext context;
        protected final Graph.Batch batch;
        protected final Path path;
        private Map<Name, Property> properties = new HashMap<Name, Property>();

        protected GraphReturnable(ReturnType returnObject, Graph.Batch batch, Path path, Name ... names) {
            super(returnObject);
            assert (batch != null);
            assert (path != null);
            assert (names.length > 0);
            this.context = batch.getGraph().getContext();
            this.batch = batch;
            this.createIfMissing(path, names).and();
            this.path = this.context.getValueFactories().getPathFactory().create(path, names);
            try {
                this.properties = (Map)batch.getGraph().getPropertiesByName().on(this.path);
            }
            catch (PathNotFoundException e) {
                this.properties = new HashMap<Name, Property>();
            }
        }

        protected Graph.Create<Graph.Batch> createIfMissing(Name child, String ... segments) {
            Path nodePath = this.context.getValueFactories().getPathFactory().create(this.path, new Name[]{child});
            Graph.Create result = this.batch.create(nodePath).orUpdate();
            for (String name : segments) {
                result.and();
                nodePath = this.context.getValueFactories().getPathFactory().create(nodePath, name);
                result = this.batch.create(nodePath).orUpdate();
            }
            return result;
        }

        protected Graph.Create<Graph.Batch> createIfMissing(Name segment) {
            Path nodePath = this.context.getValueFactories().getPathFactory().create(this.path, new Name[]{segment});
            Graph.Create result = this.batch.create(nodePath).orUpdate();
            return result;
        }

        protected Graph.Create<Graph.Batch> createIfMissing(Path path, Name ... segments) {
            Path nodePath = path;
            Graph.Create result = null;
            for (Name name : segments) {
                if (result != null) {
                    result.and();
                }
                nodePath = this.context.getValueFactories().getPathFactory().create(nodePath, new Name[]{name});
                result = this.batch.create(nodePath).orUpdate();
            }
            return result;
        }

        protected Path subpath(Name ... segments) {
            return this.context.getValueFactories().getPathFactory().create(this.path, segments);
        }

        protected abstract ThisType thisType();

        public String getName() {
            return this.path.getLastSegment().getName().getString(this.context.getNamespaceRegistry());
        }

        @Override
        public ThisType setDescription(String description) {
            return this.setProperty(DnaLexicon.DESCRIPTION, (Object)description);
        }

        @Override
        public String getDescription() {
            Property property = this.getProperty(DnaLexicon.DESCRIPTION);
            if (property != null && !property.isEmpty()) {
                return (String)this.context.getValueFactories().getStringFactory().create(property.getFirstValue());
            }
            return null;
        }

        protected ThisType setProperty(Name propertyName, Object value) {
            ((Graph.BatchConjunction)((Graph.SetValuesTo)this.batch.set(propertyName).on(this.path)).to(value)).and();
            this.properties.put(propertyName, this.context.getPropertyFactory().create(propertyName, new Object[]{value}));
            return this.thisType();
        }

        @Override
        public ThisType setProperty(String propertyName, Object value) {
            return this.setProperty((Name)this.context.getValueFactories().getNameFactory().create(propertyName), value);
        }

        public ThisType setProperty(Name propertyName, Object[] values) {
            ((Graph.BatchConjunction)((Graph.SetValuesTo)this.batch.set(propertyName).on(this.path)).to(values)).and();
            this.properties.put(propertyName, this.context.getPropertyFactory().create(propertyName, values));
            return this.thisType();
        }

        @Override
        public ThisType setProperty(String propertyName, Object[] values) {
            return this.setProperty((Name)this.context.getValueFactories().getNameFactory().create(propertyName), values);
        }

        @Override
        public ThisType setProperty(String beanPropertyName, boolean value) {
            return this.setProperty(beanPropertyName, (Object)value);
        }

        @Override
        public ThisType setProperty(String beanPropertyName, int value) {
            return this.setProperty(beanPropertyName, (Object)value);
        }

        @Override
        public ThisType setProperty(String beanPropertyName, short value) {
            return this.setProperty(beanPropertyName, (Object)value);
        }

        @Override
        public ThisType setProperty(String beanPropertyName, long value) {
            return this.setProperty(beanPropertyName, (Object)value);
        }

        @Override
        public ThisType setProperty(String beanPropertyName, double value) {
            return this.setProperty(beanPropertyName, (Object)value);
        }

        @Override
        public ThisType setProperty(String beanPropertyName, float value) {
            return this.setProperty(beanPropertyName, (Object)Float.valueOf(value));
        }

        @Override
        public ThisType setProperty(String beanPropertyName, String value) {
            return this.setProperty(beanPropertyName, (Object)value);
        }

        @Override
        public Property getProperty(String beanPropertyName) {
            return this.properties.get(this.context.getValueFactories().getNameFactory().create(beanPropertyName));
        }

        public Property getProperty(Name beanPropertyName) {
            return this.properties.get(beanPropertyName);
        }

        @Override
        public ReturnType remove() {
            this.batch.delete(this.path);
            this.properties.clear();
            return this.and();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class BaseReturnable<ReturnType>
    implements Returnable<ReturnType> {
        protected final ReturnType returnObject;

        protected BaseReturnable(ReturnType returnObject) {
            this.returnObject = returnObject;
        }

        @Override
        public ReturnType and() {
            return this.returnObject;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PathExpressionOutput<ReturnType> {
        public SequencerDefinition<ReturnType> andOutputtingTo(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SequencerDefinition<ReturnType>
    extends Returnable<ReturnType>,
    SetDescription<SequencerDefinition<ReturnType>>,
    SetProperties<SequencerDefinition<ReturnType>>,
    ChooseClass<StreamSequencer, SequencerDefinition<ReturnType>>,
    Removable<ReturnType> {
        public PathExpressionOutput<ReturnType> sequencingFrom(String var1);

        public SequencerDefinition<ReturnType> sequencingFrom(PathExpression var1);

        public Set<PathExpression> getPathExpressions();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RepositorySourceDefinition<ReturnType>
    extends Returnable<ReturnType>,
    SetDescription<RepositorySourceDefinition<ReturnType>>,
    SetProperties<RepositorySourceDefinition<ReturnType>>,
    ChooseClass<RepositorySource, RepositorySourceDefinition<ReturnType>>,
    Removable<ReturnType>,
    HasName {
        public RepositorySourceDefinition<ReturnType> setRetryLimit(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MimeTypeDetectorDefinition<ReturnType>
    extends Returnable<ReturnType>,
    SetDescription<MimeTypeDetectorDefinition<ReturnType>>,
    SetProperties<MimeTypeDetectorDefinition<ReturnType>>,
    ChooseClass<MimeTypeDetector, MimeTypeDetectorDefinition<ReturnType>>,
    Removable<ReturnType> {
    }

    public static interface HasName {
        public String getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LoadedFrom<ReturnType> {
        public ReturnType loadedFrom(String ... var1);

        public ReturnType loadedFromClasspath();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ChooseClass<ComponentClassType, ReturnType> {
        public LoadedFrom<ReturnType> usingClass(String var1);

        public ReturnType usingClass(Class<? extends ComponentClassType> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SetProperties<ReturnType> {
        public ReturnType setProperty(String var1, int var2);

        public ReturnType setProperty(String var1, long var2);

        public ReturnType setProperty(String var1, short var2);

        public ReturnType setProperty(String var1, boolean var2);

        public ReturnType setProperty(String var1, float var2);

        public ReturnType setProperty(String var1, double var2);

        public ReturnType setProperty(String var1, String var2);

        public ReturnType setProperty(String var1, Object var2);

        public ReturnType setProperty(String var1, Object[] var2);

        public Property getProperty(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SetDescription<ReturnType> {
        public ReturnType setDescription(String var1);

        public String getDescription();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Removable<ReturnType> {
        public ReturnType remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Returnable<ReturnType> {
        public ReturnType and();
    }
}

