/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.Subgraph;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositoryConnectionFactory;
import org.jboss.dna.graph.connector.RepositoryConnectionPool;
import org.jboss.dna.graph.connector.RepositoryContext;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.observe.ChangeObserver;
import org.jboss.dna.graph.observe.ChangeObservers;
import org.jboss.dna.graph.observe.Changes;
import org.jboss.dna.graph.observe.Observable;
import org.jboss.dna.graph.observe.Observer;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.repository.RepositoryI18n;
import org.jboss.dna.repository.service.AbstractServiceAdministrator;
import org.jboss.dna.repository.service.ServiceAdministrator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class RepositoryLibrary
implements RepositoryConnectionFactory,
Observable {
    private final ServiceAdministrator administrator = new Administrator();
    private final ReadWriteLock sourcesLock = new ReentrantReadWriteLock();
    private final CopyOnWriteArrayList<RepositoryConnectionPool> pools = new CopyOnWriteArrayList();
    private RepositoryConnectionFactory delegate;
    private final ExecutionContext executionContext;
    private final ObservationBus observationBus = new InMemoryObservationBus();
    private final RepositorySource configurationSource;
    private final String configurationWorkspaceName;
    private final Path pathToConfigurationRoot;

    public RepositoryLibrary(RepositorySource configurationSource, String configurationWorkspaceName, Path pathToSourcesConfigurationRoot, ExecutionContext context) {
        CheckArg.isNotNull((Object)configurationSource, (String)"configurationSource");
        CheckArg.isNotNull((Object)context, (String)"context");
        CheckArg.isNotNull((Object)pathToSourcesConfigurationRoot, (String)"pathToSourcesConfigurationRoot");
        this.executionContext = context;
        this.configurationSource = configurationSource;
        this.configurationWorkspaceName = configurationWorkspaceName;
        this.pathToConfigurationRoot = pathToSourcesConfigurationRoot;
    }

    protected Path getPathToConfigurationRoot() {
        return this.pathToConfigurationRoot;
    }

    protected RepositorySource getConfigurationSource() {
        return this.configurationSource;
    }

    protected String getConfigurationWorkspaceName() {
        return this.configurationWorkspaceName;
    }

    public boolean register(ChangeObserver observer) {
        return this.observationBus.register(observer);
    }

    public boolean unregister(ChangeObserver observer) {
        return this.observationBus.unregister(observer);
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public ServiceAdministrator getAdministrator() {
        return this.administrator;
    }

    protected void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                pool.shutdown();
            }
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
        this.observationBus.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                if (pool.awaitTermination(timeout, unit)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminating() {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                if (!pool.isTerminating()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool pool : this.pools) {
                if (pool.isTerminated()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
    }

    public Collection<String> getSourceNames() {
        HashSet<String> sourceNames = new HashSet<String>();
        for (RepositoryConnectionPool pool : this.pools) {
            sourceNames.add(pool.getRepositorySource().getName());
        }
        return Collections.unmodifiableCollection(sourceNames);
    }

    public Collection<RepositorySource> getSources() {
        LinkedList<RepositorySource> sources = new LinkedList<RepositorySource>();
        for (RepositoryConnectionPool pool : this.pools) {
            sources.add(pool.getRepositorySource());
        }
        return Collections.unmodifiableCollection(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySource getSource(String sourceName) {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool existingPool : this.pools) {
                RepositorySource source = existingPool.getRepositorySource();
                if (!source.getName().equals(sourceName)) continue;
                RepositorySource repositorySource = source;
                return repositorySource;
            }
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnectionPool getConnectionPool(String sourceName) {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool existingPool : this.pools) {
                RepositorySource source = existingPool.getRepositorySource();
                if (!source.getName().equals(sourceName)) continue;
                RepositoryConnectionPool repositoryConnectionPool = existingPool;
                return repositoryConnectionPool;
            }
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSource(RepositorySource source) {
        if (source == null) {
            return false;
        }
        try {
            this.sourcesLock.writeLock().lock();
            final String sourceName = source.getName();
            for (RepositoryConnectionPool existingPool : this.pools) {
                if (!existingPool.getRepositorySource().getName().equals(sourceName)) continue;
                boolean bl = false;
                return bl;
            }
            final ObservationBus observationBus = this.observationBus;
            RepositoryContext repositoryContext = new RepositoryContext(){

                public ExecutionContext getExecutionContext() {
                    return RepositoryLibrary.this.getExecutionContext();
                }

                public RepositoryConnectionFactory getRepositoryConnectionFactory() {
                    return RepositoryLibrary.this;
                }

                public Observer getObserver() {
                    return observationBus.hasObservers() ? observationBus : null;
                }

                public Subgraph getConfiguration(int depth) {
                    Subgraph result = null;
                    RepositorySource configSource = RepositoryLibrary.this.getConfigurationSource();
                    if (configSource != null) {
                        Graph config = Graph.create((RepositorySource)configSource, (ExecutionContext)this.getExecutionContext());
                        String workspaceName = RepositoryLibrary.this.getConfigurationWorkspaceName();
                        if (workspaceName != null) {
                            config.useWorkspace(workspaceName);
                        }
                        Path configPath = RepositoryLibrary.this.getPathToConfigurationRoot();
                        Path sourcePath = this.getExecutionContext().getValueFactories().getPathFactory().create(configPath, sourceName);
                        result = (Subgraph)config.getSubgraphOfDepth(depth).at(sourcePath);
                    }
                    return result;
                }
            };
            source.initialize(repositoryContext);
            RepositoryConnectionPool pool = new RepositoryConnectionPool(source);
            this.pools.add(pool);
            boolean bl = true;
            return bl;
        }
        finally {
            this.sourcesLock.writeLock().unlock();
        }
    }

    public boolean removeSource(RepositorySource source, long timeToAwait, TimeUnit unit) throws InterruptedException {
        return this.removeSource(source.getName(), timeToAwait, unit) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositorySource removeSource(String name, long timeToAwait, TimeUnit unit) throws InterruptedException {
        try {
            this.sourcesLock.writeLock().lock();
            Iterator<RepositoryConnectionPool> i$ = this.pools.iterator();
            if (i$.hasNext()) {
                RepositoryConnectionPool existingPool = i$.next();
                if (existingPool.getRepositorySource().getName().equals(name)) {
                    existingPool.shutdown();
                    if (timeToAwait > 0L) {
                        existingPool.awaitTermination(timeToAwait, unit);
                    }
                }
                RepositorySource repositorySource = existingPool.getRepositorySource();
                return repositorySource;
            }
        }
        finally {
            this.sourcesLock.writeLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryConnection createConnection(String sourceName) {
        try {
            this.sourcesLock.readLock().lock();
            for (RepositoryConnectionPool existingPool : this.pools) {
                RepositorySource source = existingPool.getRepositorySource();
                if (!source.getName().equals(sourceName)) continue;
                RepositoryConnection repositoryConnection = existingPool.getConnection();
                return repositoryConnection;
            }
            RepositoryConnectionFactory delegate = this.delegate;
            if (delegate != null) {
                RepositoryConnection repositoryConnection = delegate.createConnection(sourceName);
                return repositoryConnection;
            }
        }
        finally {
            this.sourcesLock.readLock().unlock();
        }
        return null;
    }

    protected class InMemoryObservationBus
    implements ObservationBus {
        private final ChangeObservers observers = new ChangeObservers();

        protected InMemoryObservationBus() {
        }

        public boolean register(ChangeObserver observer) {
            return this.observers.register(observer);
        }

        public boolean unregister(ChangeObserver observer) {
            return this.observers.unregister(observer);
        }

        public void notify(Changes changes) {
            if (changes != null) {
                this.observers.broadcast(changes);
            }
        }

        public boolean hasObservers() {
            return !this.observers.isEmpty();
        }

        public void shutdown() {
            this.observers.shutdown();
        }
    }

    protected static interface ObservationBus
    extends Observable,
    Observer {
        public boolean hasObservers();

        public void shutdown();
    }

    protected class Administrator
    extends AbstractServiceAdministrator {
        protected Administrator() {
            super(RepositoryI18n.federationServiceName, ServiceAdministrator.State.STARTED);
        }

        protected void doStart(ServiceAdministrator.State fromState) {
            super.doStart(fromState);
            RepositoryLibrary.this.start();
        }

        protected void doShutdown(ServiceAdministrator.State fromState) {
            super.doShutdown(fromState);
            RepositoryLibrary.this.shutdown();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return RepositoryLibrary.this.awaitTermination(timeout, unit);
        }

        protected boolean doCheckIsTerminated() {
            return RepositoryLibrary.this.isTerminated();
        }
    }
}

