/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.jcr.observation.Event;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.inmemory.InMemoryRepositorySource;
import org.jboss.dna.graph.mimetype.ExtensionBasedMimeTypeDetector;
import org.jboss.dna.graph.mimetype.MimeTypeDetector;
import org.jboss.dna.repository.DnaConfiguration;
import org.jboss.dna.repository.DnaEngine;
import org.jboss.dna.repository.RepositoryLibrary;
import org.jboss.dna.repository.sequencer.MockStreamSequencerA;
import org.jboss.dna.repository.sequencer.SequencingService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class DnaEngineTest {
    private DnaEngine engine;

    @Before
    public void beforeEach() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.engine != null) {
            try {
                this.engine.shutdown();
                this.engine.awaitTermination(3L, TimeUnit.SECONDS);
            }
            finally {
                this.engine = null;
            }
        }
    }

    @Test
    public void shouldAllowCreatingWithEmptyConfig() {
        this.engine = new DnaConfiguration().build();
    }

    @Test
    public void shouldAllowCreatingWithConfigRepository() throws InterruptedException {
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setName("config repo");
        this.engine = new DnaConfiguration().loadFrom((RepositorySource)configSource).build();
        this.engine.start();
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        RepositoryLibrary library = this.engine.getRepositoryService().getRepositoryLibrary();
        Assert.assertThat((Object)library.getConnectionPool("config repo").getInUseCount(), (Matcher)Is.is((Object)0));
        RepositoryConnection connection = library.getConnectionPool("config repo").getConnection();
        Assert.assertThat((Object)connection.ping(500L, TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)true));
        connection.close();
    }

    @Test
    public void shouldAllowCreatingMultipleRepositorySources() throws Exception {
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setName("config repo");
        this.engine = ((DnaConfiguration)((DnaConfiguration.RepositorySourceDefinition)((DnaConfiguration.RepositorySourceDefinition)((DnaConfiguration.RepositorySourceDefinition)new DnaConfiguration().loadFrom((RepositorySource)configSource).and().repositorySource("JCR").usingClass(InMemoryRepositorySource.class)).setDescription("Backing Repository for JCR Implementation")).setProperty("name", "JCR")).and()).save().build();
        this.engine.start();
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        Assert.assertThat((Object)this.engine.getRepositorySource("JCR"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("JCR"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        Assert.assertThat((Object)this.engine.getRepositorySource("JCR").getName(), (Matcher)Is.is((Object)"JCR"));
        RepositoryLibrary library = this.engine.getRepositoryService().getRepositoryLibrary();
        RepositoryConnection connection = library.getConnectionPool("JCR").getConnection();
        Assert.assertThat((Object)connection.ping(500L, TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)true));
        connection.close();
    }

    @Test
    public void shouldAllowAddingMimeTypeDetectors() throws Exception {
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setName("config repo");
        this.engine = ((DnaConfiguration)((DnaConfiguration.MimeTypeDetectorDefinition)((DnaConfiguration.MimeTypeDetectorDefinition)((DnaConfiguration)((DnaConfiguration.RepositorySourceDefinition)((DnaConfiguration.RepositorySourceDefinition)((DnaConfiguration.RepositorySourceDefinition)new DnaConfiguration().loadFrom((RepositorySource)configSource).and().repositorySource("JCR").usingClass(InMemoryRepositorySource.class)).setDescription("Backing Repository for JCR Implementation")).setProperty("name", "JCR")).and()).mimeTypeDetector("default").usingClass(ExtensionBasedMimeTypeDetector.class)).setDescription("Default MimeTypeDetector")).and()).build();
        this.engine.start();
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        MimeTypeDetector detector = this.engine.getExecutionContext().getMimeTypeDetector();
        Assert.assertThat((Object)detector.mimeTypeOf("test", (InputStream)new ByteArrayInputStream("This is useless data".getBytes())), (Matcher)Is.is((Object)"text/plain"));
    }

    @Test
    public void shouldAllowAddingSequencers() throws Exception {
        InMemoryRepositorySource configSource = new InMemoryRepositorySource();
        configSource.setName("config repo");
        this.engine = ((DnaConfiguration)((DnaConfiguration.SequencerDefinition)((DnaConfiguration.SequencerDefinition)((DnaConfiguration)((DnaConfiguration.RepositorySourceDefinition)((DnaConfiguration.RepositorySourceDefinition)((DnaConfiguration.RepositorySourceDefinition)new DnaConfiguration().loadFrom((RepositorySource)configSource).and().repositorySource("JCR").usingClass(InMemoryRepositorySource.class)).setDescription("Backing Repository for JCR Implementation")).setProperty("name", "JCR")).and()).sequencer("Mock Sequencer A").usingClass(MockStreamSequencerA.class)).setDescription("A Mock Sequencer")).sequencingFrom("/**").andOutputtingTo("/").and()).build();
        this.engine.start();
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.engine.getRepositorySource("config repo"), (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(InMemoryRepositorySource.class)));
        SequencingService sequencer = this.engine.getSequencingService();
        Assert.assertThat((Object)sequencer.getStatistics().getNumberOfNodesSequenced(), (Matcher)Is.is((Object)0L));
        Event e1 = (Event)Mockito.mock(Event.class);
        Mockito.stub((Object)e1.getType()).toReturn((Object)1);
        Mockito.stub((Object)e1.getPath()).toReturn((Object)"/test");
        Mockito.stub((Object)e1.getUserID()).toReturn((Object)"Test");
    }

    public static class MockMimeTypeDetector
    implements MimeTypeDetector {
        private String mimeType = "";

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public String mimeTypeOf(String name, InputStream is) {
            return this.mimeType;
        }
    }
}

