/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.common.collection.SimpleProblems;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.graph.DnaLexicon;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.Graph;
import org.jboss.dna.graph.connector.RepositoryConnection;
import org.jboss.dna.graph.connector.RepositorySource;
import org.jboss.dna.graph.connector.inmemory.InMemoryRepositorySource;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.repository.FakeRepositorySource;
import org.jboss.dna.repository.RepositoryLibrary;
import org.jboss.dna.repository.RepositoryService;
import org.jboss.dna.repository.service.ServiceAdministrator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RepositoryServiceTest {
    private RepositoryService service;
    private String configSourceName;
    private String configWorkspaceName;
    private Graph configRepository;
    private InMemoryRepositorySource configRepositorySource;
    private ExecutionContext context;
    private Path root;
    private Problems problems;
    @MockitoAnnotations.Mock
    private RepositoryLibrary sources;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.context = new ExecutionContext();
        this.context.getNamespaceRegistry().register("dna", "http://www.jboss.org/dna/1.0");
        this.configSourceName = "configSource";
        this.configWorkspaceName = null;
        this.configRepositorySource = new InMemoryRepositorySource();
        this.configRepositorySource.setName(this.configSourceName);
        this.configRepositorySource.setDefaultWorkspaceName("default");
        this.configRepository = Graph.create((RepositorySource)this.configRepositorySource, (ExecutionContext)this.context);
        RepositoryConnection configRepositoryConnection = this.configRepositorySource.getConnection();
        Mockito.stub((Object)this.sources.createConnection(this.configSourceName)).toReturn((Object)configRepositoryConnection);
        this.root = this.context.getValueFactories().getPathFactory().createRootPath();
        this.problems = new SimpleProblems();
        this.service = new RepositoryService((RepositorySource)this.configRepositorySource, this.configWorkspaceName, this.root, this.context, this.problems);
    }

    @After
    public void afterEach() throws Exception {
        this.service.getAdministrator().shutdown();
        this.service.getAdministrator().awaitTermination(4L, TimeUnit.SECONDS);
        Logger.getLogger(this.getClass()).trace("", new Object[0]);
    }

    @Test
    public void shouldHaveServiceAdministratorAfterInstantiation() {
        Assert.assertThat((Object)this.service.getAdministrator(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveConfigurationSourceAfterInstantiation() {
        Assert.assertThat((Object)this.service.getConfigurationSourceName(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.service.getConfigurationSourceName(), (Matcher)Is.is((Object)this.configSourceName));
    }

    @Test
    public void shouldHaveAnExecutionEnvironmentAfterInstantiation() {
        Assert.assertThat((Object)this.service.getExecutionEnvironment(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.service.getExecutionEnvironment(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.context)));
    }

    @Test
    public void shouldHaveNullJndiNameAfterInstantiation() {
        Assert.assertThat((Object)this.service.getJndiName(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldAllowShuttingDownBeforeStartingUp() throws Exception {
        Assert.assertThat((Object)this.service.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.PAUSED));
        this.service.getAdministrator().shutdown();
        this.service.getAdministrator().awaitTermination(1L, TimeUnit.SECONDS);
        Assert.assertThat((Object)this.service.getAdministrator().getState(), (Matcher)Is.is((Object)ServiceAdministrator.State.TERMINATED));
    }

    @Test
    public void shouldStartUpUsingConfigurationRepositoryThatContainsNoSources() throws Exception {
        this.configRepository.create("/dna:sources").and();
        this.service.getAdministrator().start();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.sources});
    }

    @Test
    public void shouldStartUpAndCreateRepositoryUsingConfigurationRepositoryThatContainsNoSources() {
        this.configRepository.useWorkspace("default");
        this.configRepository.create("/dna:sources").and();
        this.configRepository.create("/dna:sources/source A").and();
        String className = InMemoryRepositorySource.class.getName();
        ((Graph.SetValuesTo)this.configRepository.set(DnaLexicon.CLASSNAME).on("/dna:sources/source A")).to(className);
        ((Graph.SetValuesTo)this.configRepository.set(DnaLexicon.CLASSPATH).on("/dna:sources/source A")).to("");
        ((Graph.SetValuesTo)this.configRepository.set("retryLimit").on("/dna:sources/source A")).to(3);
        String fedReposPath = "/dna:repositories/fed repos/";
        this.configRepository.create("/dna:repositories").and();
        this.configRepository.create("/dna:repositories/fed repos").and();
        this.configRepository.create("/dna:repositories/fed repos/dna:regions").and();
        this.configRepository.create("/dna:repositories/fed repos/dna:regions/source A").and();
        this.configRepository.create("/dna:repositories/fed repos/dna:regions/source B").and();
        this.configRepository.create("/dna:repositories/fed repos/dna:regions/source C").and();
        this.configRepository.create("/dna:repositories/fed repos/dna:regions/source D").and();
        ((Graph.SetValuesTo)this.configRepository.set(DnaLexicon.TIME_TO_EXPIRE).on(fedReposPath)).to(20000);
        ((Graph.SetValuesTo)this.configRepository.set(DnaLexicon.PROJECTION_RULES).on(fedReposPath + "dna:regions/source A")).to("/a/b/c => /sx/sy");
        ((Graph.SetValuesTo)this.configRepository.set(DnaLexicon.PROJECTION_RULES).on(fedReposPath + "dna:regions/source B")).to("/ => /");
        ((Graph.SetValuesTo)this.configRepository.set(DnaLexicon.PROJECTION_RULES).on(fedReposPath + "dna:regions/source C")).to("/d/e/f => /");
        ((Graph.SetValuesTo)this.configRepository.set(DnaLexicon.PROJECTION_RULES).on(fedReposPath + "dna:regions/source D")).to("/ => /x/y/z");
        this.service.getAdministrator().start();
    }

    @Test
    public void shouldConfigureRepositorySourceWithSetterThatTakesArrayButWithSingleValues() {
        Path configPath = (Path)this.context.getValueFactories().getPathFactory().create("/dna:system");
        this.service = new RepositoryService((RepositorySource)this.configRepositorySource, this.configWorkspaceName, configPath, this.context, this.problems);
        this.configRepository.useWorkspace("default");
        this.configRepository.create("/dna:system").and();
        this.configRepository.create("/dna:system/dna:sources").and();
        this.configRepository.create("/dna:system/dna:sources/source A").and();
        String className = FakeRepositorySource.class.getName();
        ((Graph.SetValuesTo)this.configRepository.set(DnaLexicon.CLASSNAME).on("/dna:system/dna:sources/source A")).to(className);
        ((Graph.SetValuesTo)this.configRepository.set(DnaLexicon.CLASSPATH).on("/dna:system/dna:sources/source A")).to("");
        ((Graph.SetValuesTo)this.configRepository.set("retryLimit").on("/dna:system/dna:sources/source A")).to(3);
        ((Graph.SetValuesTo)this.configRepository.set("intParam").on("/dna:system/dna:sources/source A")).to("3");
        ((Graph.SetValuesTo)this.configRepository.set("shortParam").on("/dna:system/dna:sources/source A")).to("32");
        ((Graph.SetValuesTo)this.configRepository.set("booleanParam").on("/dna:system/dna:sources/source A")).to("true");
        ((Graph.SetValuesTo)this.configRepository.set("stringParam").on("/dna:system/dna:sources/source A")).to("string value");
        ((Graph.SetValuesTo)this.configRepository.set("intArrayParam").on("/dna:system/dna:sources/source A")).to("3");
        ((Graph.SetValuesTo)this.configRepository.set("booleanArrayParam").on("/dna:system/dna:sources/source A")).to("true");
        ((Graph.SetValuesTo)this.configRepository.set("longObjectArrayParam").on("/dna:system/dna:sources/source A")).to("987654321");
        ((Graph.SetValuesTo)this.configRepository.set("booleanObjectArrayParam").on("/dna:system/dna:sources/source A")).to("true");
        ((Graph.SetValuesTo)this.configRepository.set("stringArrayParam").on("/dna:system/dna:sources/source A")).to("string value");
        this.service.getAdministrator().start();
        RepositorySource repositorySourceA = this.service.getRepositoryLibrary().getSource("source A");
        Assert.assertThat((Object)repositorySourceA, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(FakeRepositorySource.class)));
        FakeRepositorySource sourceA = (FakeRepositorySource)repositorySourceA;
        Assert.assertThat((Object)sourceA.getIntParam(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)sourceA.getShortParam(), (Matcher)Is.is((Object)32));
        Assert.assertThat((Object)sourceA.isBooleanParam(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)sourceA.getStringParam(), (Matcher)Is.is((Object)"string value"));
        Assert.assertThat((Object)sourceA.getIntArrayParam(), (Matcher)Is.is((Object)new int[]{3}));
        Assert.assertThat((Object)sourceA.getBooleanArrayParam(), (Matcher)Is.is((Object)new boolean[]{true}));
        Assert.assertThat((Object)sourceA.getLongObjectArrayParam(), (Matcher)Is.is((Object)new Long[]{987654321L}));
        Assert.assertThat((Object)sourceA.getBooleanObjectArrayParam(), (Matcher)Is.is((Object)new Boolean[]{Boolean.TRUE}));
        Assert.assertThat((Object)sourceA.getStringArrayParam(), (Matcher)Is.is((Object)new String[]{"string value"}));
    }
}

