/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencer;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.common.collection.Problems;
import org.jboss.dna.graph.Node;
import org.jboss.dna.graph.observe.NetChangeObserver;
import org.jboss.dna.repository.sequencer.Sequencer;
import org.jboss.dna.repository.sequencer.SequencerConfig;
import org.jboss.dna.repository.sequencer.SequencerContext;
import org.jboss.dna.repository.util.RepositoryNodePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class MockSequencerA
implements Sequencer {
    private SequencerConfig config;
    private AtomicInteger counter = new AtomicInteger();
    private volatile CountDownLatch latch = new CountDownLatch(0);

    public void setExpectedCount(int numExpected) {
        this.latch = new CountDownLatch(numExpected);
    }

    public boolean awaitExecution(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    public void setConfiguration(SequencerConfig sequencerConfiguration) {
        this.config = sequencerConfiguration;
    }

    public void execute(Node input, String sequencedPropertyName, NetChangeObserver.NetChange changes, Set<RepositoryNodePath> outputPaths, SequencerContext context, Problems problems) {
        this.counter.incrementAndGet();
        this.latch.countDown();
    }

    public int getCounter() {
        return this.counter.get();
    }

    public boolean isConfigured() {
        return this.config != null;
    }

    public SequencerConfig getConfiguration() {
        return this.config;
    }

    public String toString() {
        return (this.config != null ? this.config.getName() : "SampleSequencer") + " [" + this.getCounter() + "]";
    }
}

