/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.sequencer;

import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.graph.sequencer.SequencerOutput;
import org.jboss.dna.graph.sequencer.StreamSequencer;
import org.jboss.dna.graph.sequencer.StreamSequencerContext;

@ThreadSafe
public class MockStreamSequencerA
implements StreamSequencer {
    private AtomicInteger counter = new AtomicInteger();
    private volatile CountDownLatch latch = new CountDownLatch(0);

    public void setExpectedCount(int numExpected) {
        this.latch = new CountDownLatch(numExpected);
    }

    public boolean awaitExecution(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        this.counter.incrementAndGet();
        this.latch.countDown();
    }

    public int getCounter() {
        return this.counter.get();
    }

    public String toString() {
        return "MockStreamSequencerA [" + this.getCounter() + "]";
    }
}

