/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.classfile;

import java.io.InputStream;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.graph.sequencer.SequencerOutput;
import org.jboss.dna.graph.sequencer.StreamSequencer;
import org.jboss.dna.graph.sequencer.StreamSequencerContext;
import org.jboss.dna.sequencer.classfile.ClassFileRecorder;
import org.jboss.dna.sequencer.classfile.ClassFileSequencerI18n;
import org.jboss.dna.sequencer.classfile.DefaultClassFileRecorder;
import org.jboss.dna.sequencer.classfile.metadata.ClassFileMetadataReader;
import org.jboss.dna.sequencer.classfile.metadata.ClassMetadata;

@ThreadSafe
public class ClassFileSequencer
implements StreamSequencer {
    private static final ClassFileRecorder DEFAULT_CLASS_FILE_RECORDER = new DefaultClassFileRecorder();
    private ClassFileRecorder classFileRecorder = DEFAULT_CLASS_FILE_RECORDER;

    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        try {
            ClassMetadata classMetadata = ClassFileMetadataReader.instance(stream);
            this.classFileRecorder.recordClass(context, output, classMetadata);
        }
        catch (Exception ex) {
            context.getLogger(this.getClass()).error((Throwable)ex, ClassFileSequencerI18n.errorSequencingClass, new Object[]{context.getInputPath()});
        }
    }

    public void setClassFileRecorderClassName(String classFileRecorderClassName) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (classFileRecorderClassName == null) {
            this.classFileRecorder = DEFAULT_CLASS_FILE_RECORDER;
            return;
        }
        Class<?> classFileRecorderClass = Class.forName(classFileRecorderClassName);
        this.classFileRecorder = (ClassFileRecorder)classFileRecorderClass.newInstance();
    }

    public void setClassFileRecorder(ClassFileRecorder classFileRecorder) {
        this.classFileRecorder = classFileRecorder == null ? DEFAULT_CLASS_FILE_RECORDER : classFileRecorder;
    }
}

