/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.classfile.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javassist.bytecode.ClassFile;
import org.jboss.dna.sequencer.classfile.metadata.ClassMetadata;
import org.jboss.dna.sequencer.classfile.metadata.FieldMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMetadata
extends ClassMetadata {
    private final List<FieldMetadata> enumFields;
    private final List<String> values;

    public EnumMetadata(ClassFile clazz) {
        super(clazz);
        assert ((clazz.getAccessFlags() & 0x4000) == 16384);
        List<FieldMetadata> fieldsFromClass = super.getFields();
        ArrayList<FieldMetadata> enumFields = new ArrayList<FieldMetadata>(fieldsFromClass.size());
        ArrayList<String> values = new ArrayList<String>(fieldsFromClass.size());
        for (FieldMetadata fieldFromClass : fieldsFromClass) {
            if (fieldFromClass.getTypeName().equals(this.getClassName())) {
                values.add(fieldFromClass.getName());
                continue;
            }
            enumFields.add(fieldFromClass);
        }
        this.enumFields = Collections.unmodifiableList(enumFields);
        this.values = Collections.unmodifiableList(values);
    }

    public List<String> getValues() {
        return this.values;
    }

    @Override
    public List<FieldMetadata> getFields() {
        return this.enumFields;
    }

    @Override
    public boolean isEnumeration() {
        return true;
    }
}

