/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.ddl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.sequencer.ddl.DdlParsers;
import org.jboss.dna.sequencer.ddl.StandardDdlLexicon;
import org.jboss.dna.sequencer.ddl.node.AstNode;
import org.jboss.dna.sequencer.ddl.node.AstNodeFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DdlParsersTest {
    private DdlParsers parsers;
    public static final String DDL_TEST_FILE_PATH = "src/test/resources/ddl/";
    private ExecutionContext context;
    private AstNodeFactory nodeFactory;
    private AstNode rootNode;
    private boolean printTest = false;

    @Before
    public void beforeEach() {
        this.parsers = new DdlParsers();
        this.context = new ExecutionContext();
        this.rootNode = new AstNode((Name)this.context.getValueFactories().getNameFactory().create("root_node"));
        this.nodeFactory = new AstNodeFactory(this.context);
    }

    public void printNodeChildren(AstNode node) {
        int count = 1;
        for (AstNode childNode : node.getChildren()) {
            if (!this.printTest) continue;
            System.out.println("NODE(" + count++ + ")  NAME = " + childNode.getName().getString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getFileContent(String filePath) {
        StringBuilder sb = new StringBuilder(1000);
        if (this.printTest) {
            System.out.println("   Getting Content for File = " + filePath);
        }
        if (filePath != null && filePath.length() > 0) {
            FileReader fr = null;
            BufferedReader in = null;
            try {
                fr = new FileReader(filePath);
                in = new BufferedReader(fr);
                int ch = in.read();
                while (ch > -1) {
                    sb.append((char)ch);
                    ch = in.read();
                }
            }
            catch (Exception e) {
                System.out.print(e);
            }
            finally {
                try {
                    fr.close();
                }
                catch (IOException e) {}
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return sb.toString();
    }

    private void printTest(String value) {
        if (this.printTest) {
            System.out.println("TEST:  " + value);
        }
    }

    @Test
    public void shouldParseTypedDdlFile() {
        this.printTest("shouldParseTypedDdlFile()");
        String content = "PARSER_ID = SQL92\n-- SAMPLE DDL FILE\nCREATE TABLE myTableName (PART_COLOR VARCHAR(255) NOT NULL, PART_ID INTEGER DEFAULT (100))\nDROP TABLE list_customers CASCADE";
        this.parsers.parse(content, this.rootNode);
        Assert.assertEquals((Object)"SQL92", (Object)this.rootNode.getProperty(StandardDdlLexicon.PARSER_ID).getFirstValue());
    }

    @Test
    public void shouldParseUntypedDdlFile() {
        this.printTest("shouldParseUntypedDdlFile()");
        String content = "\n-- SAMPLE DDL FILE\nCREATE TABLE myTableName (PART_COLOR VARCHAR(255) NOT NULL, PART_ID INTEGER DEFAULT (100))\nDROP TABLE list_customers CASCADE";
        this.parsers.parse(content, this.rootNode);
        Assert.assertEquals((Object)"SQL92", (Object)this.rootNode.getProperty(StandardDdlLexicon.PARSER_ID).getFirstValue());
    }

    @Test
    public void shouldParseUntypedDerbyFile() {
        this.printTest("shouldParseUntypedDerbyFile()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/derby/derby_test_statements.ddl");
        this.parsers.parse(content, this.rootNode);
        Assert.assertEquals((Object)"DERBY", (Object)this.rootNode.getProperty(StandardDdlLexicon.PARSER_ID).getFirstValue());
    }

    @Test
    public void shouldParseTypedDerbyFile() {
        this.printTest("shouldParseTypedDerbyFile()");
        String content = "PARSER_ID = DERBY\n" + this.getFileContent("src/test/resources/ddl/dialect/derby/derby_test_statements_typed.ddl");
        this.parsers.parse(content, this.rootNode);
        Assert.assertEquals((Object)"DERBY", (Object)this.rootNode.getProperty(StandardDdlLexicon.PARSER_ID).getFirstValue());
    }

    @Test
    public void shouldParseUntypedOracleFile() {
        this.printTest("shouldParseUntypedOracleFile()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/oracle/oracle_test_statements_3.ddl");
        this.parsers.parse(content, this.rootNode);
        Assert.assertEquals((Object)"ORACLE", (Object)this.rootNode.getProperty(StandardDdlLexicon.PARSER_ID).getFirstValue());
    }

    @Test
    public void shouldParseUntypedPostgresFile() {
        this.printTest("shouldParseUntypedPostgresFile()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/postgres/postgres_test_statements_1.ddl");
        this.parsers.parse(content, this.rootNode);
        Assert.assertThat((Object)"POSTGRES", (Matcher)Is.is((Object)((String)this.rootNode.getProperty(StandardDdlLexicon.PARSER_ID).getFirstValue())));
    }

    @Test
    public void shouldParseUnterminatedOracleFile() {
        this.printTest("shouldParseUnterminatedOracleFile()");
        String content = this.getFileContent("src/test/resources/ddl/GFM_Physical.ddl");
        boolean success = this.parsers.parse(content, this.rootNode);
        this.printTest = true;
        List problems = this.nodeFactory.getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_PROBLEM);
        for (AstNode problem : problems) {
            this.printTest(problem.toString());
        }
        Assert.assertThat((Object)success, (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)123));
        List schemaNodes = this.nodeFactory.getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_CREATE_SCHEMA_STATEMENT);
        Assert.assertThat((Object)schemaNodes.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((AstNode)schemaNodes.get(0)).getChildCount(), (Matcher)Is.is((Object)53));
        Assert.assertThat((Object)((AstNode)schemaNodes.get(0)).getName().getString(), (Matcher)Is.is((Object)"GLOBALFORCEMGMT"));
        List alterNodes = this.nodeFactory.getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_ALTER_TABLE_STATEMENT);
        Assert.assertThat((Object)alterNodes.size(), (Matcher)Is.is((Object)120));
        List dropSchemaNodes = this.nodeFactory.getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_DROP_SCHEMA_STATEMENT);
        Assert.assertThat((Object)dropSchemaNodes.size(), (Matcher)Is.is((Object)1));
        List unknownNodes = this.nodeFactory.getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_UNKNOWN_STATEMENT);
        Assert.assertThat((Object)unknownNodes.size(), (Matcher)Is.is((Object)1));
    }
}

