/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.ddl.dialect.derby;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.sequencer.ddl.DdlParserTestHelper;
import org.jboss.dna.sequencer.ddl.StandardDdlLexicon;
import org.jboss.dna.sequencer.ddl.dialect.derby.DerbyDdlParser;
import org.jboss.dna.sequencer.ddl.node.AstNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DerbyDdlParserTest
extends DdlParserTestHelper {
    private DerbyDdlParser parser;
    private AstNode rootNode;
    public static final String DDL_FILE_PATH = "src/test/resources/ddl/dialect/derby/";

    @Before
    public void beforeEach() {
        this.parser = new DerbyDdlParser();
        this.setPrintToConsole(false);
        this.parser.setTestMode(this.isPrintToConsole());
        this.parser.setDoUseTerminator(true);
        this.rootNode = this.parser.nodeFactory().node("ddlRootNode");
    }

    @Test
    public void shouldParseCreateFunctionWithDataTypeReturn() {
        this.printTest("shouldParseCreateFunctionWithDataTypeReturn()");
        String content = "CREATE FUNCTION TO_DEGREES\n( RADIANS DOUBLE )\nRETURNS DOUBLE\nPARAMETER STYLE JAVA\nNO SQL LANGUAGE JAVA\nEXTERNAL NAME 'java.lang.Math.toDegrees';";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
    }

    @Test
    public void shouldParseCreateFunctionWithTableTypeReturn() {
        this.printTest("shouldParseCreateFunctionWithTableTypeReturn()");
        String content = "CREATE FUNCTION PROPERTY_FILE_READER\n( FILENAME VARCHAR( 32672 ), FILESIZE INTEGER )\nRETURNS TABLE (KEY_COL VARCHAR( 10 ), VALUE_COL VARCHAR( 1000 ))\nLANGUAGE JAVA\nPARAMETER STYLE DERBY_JDBC_RESULT_SET\nNO SQL\nEXTERNAL NAME 'vtis.example.PropertyFileVTI.propertyFileVTI';";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
    }

    @Test
    public void shouldParseDropSchemaRestrict() {
        this.printTest("shouldParseDropSchemaRestrict()");
        String content = "DROP SCHEMA SAMP RESTRICT;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseCreateIndex() {
        this.printTest("shouldParseCreateIndex()");
        String content = "CREATE INDEX PAY_DESC ON SAMP.EMPLOYEE (SALARY DESC, UNIT);";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseLockTable() {
        this.printTest("shouldParseLockTable()");
        String content = "LOCK TABLE FlightAvailability IN EXCLUSIVE MODE;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseDeclareGlobaTemporaryTable() {
        this.printTest("shouldParseDeclareGlobaTemporaryTable()");
        String content = "declare global temporary table SESSION.t1(c11 int) not logged;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
    }

    @Test
    public void shouldParseRenameTable() {
        this.printTest("shouldParseRenameTable()");
        String content = "RENAME TABLE SAMP.EMP_ACT TO EMPLOYEE_ACT;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseCreateSynonym() {
        this.printTest("shouldParseCreateSynonym()");
        String content = "CREATE SYNONYM SAMP.T1 FOR SAMP.TABLEWITHLONGNAME;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseCreateTrigger() {
        this.printTest("shouldParseCreateTrigger()");
        String content = "CREATE TRIGGER FLIGHTSDELETE3\nAFTER DELETE ON FLIGHTS\nREFERENCING OLD AS OLD\nFOR EACH ROW\nDELETE FROM FLIGHTAVAILABILITY WHERE FLIGHT_ID = OLD.FLIGHT_ID;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseCreateTrigger_2() {
        this.printTest("shouldParseCreateTrigger_2()");
        String content = "CREATE TRIGGER t1 NO CASCADE BEFORE UPDATE ON x\nFOR EACH ROW MODE DB2SQL\nvalues app.notifyEmail('Jerry', 'Table x is about to be updated');";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldParseGrantStatements() {
        this.printTest("shouldParseGrantStatements()");
        String content = "GRANT SELECT ON TABLE purchaseOrders TO maria,harry;\nGRANT UPDATE, TRIGGER ON TABLE purchaseOrders TO anita,zhi;\nGRANT SELECT ON TABLE orders.bills to PUBLIC;\nGRANT EXECUTE ON PROCEDURE updatePurchases TO george;\nGRANT purchases_reader_role TO george,maria;\nGRANT SELECT ON TABLE purchaseOrders TO purchases_reader_role;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)6));
    }

    @Test
    public void shouldParseAlterTableAlterColumnDefaultRealNumber() {
        this.printTest("shouldParseAlterTableAlterColumnDefaultRealNumber()");
        String content = "ALTER TABLE Employees ALTER COLUMN Salary DEFAULT 1000.0;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
    }

    @Test
    public void shouldParseDropProcedure() {
        this.printTest("shouldParseDropProcedure()");
        String content = "DROP PROCEDURE some_procedure_name";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
    }

    @Test
    public void shouldParseDerbyStatements() {
        this.printTest("shouldParseDerbyStatements()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/derby/derby_test_statements.ddl");
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        List problems = this.parser.nodeFactory().getChildrenForType(this.rootNode, StandardDdlLexicon.TYPE_PROBLEM);
        int nStatements = this.rootNode.getChildCount() - problems.size();
        Assert.assertEquals((long)64L, (long)nStatements);
    }
}

