/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.ddl.dialect.mysql;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jboss.dna.sequencer.ddl.DdlParserTestHelper;
import org.jboss.dna.sequencer.ddl.StandardDdlParser;
import org.jboss.dna.sequencer.ddl.dialect.mysql.MySqlDdlLexicon;
import org.jboss.dna.sequencer.ddl.dialect.mysql.MySqlDdlParser;
import org.jboss.dna.sequencer.ddl.node.AstNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MySqlDdlParserTest
extends DdlParserTestHelper {
    private StandardDdlParser parser;
    private AstNode rootNode;
    public static final String DDL_FILE_PATH = "src/test/resources/ddl/dialect/mysql/";

    @Before
    public void beforeEach() {
        this.parser = new MySqlDdlParser();
        this.setPrintToConsole(false);
        this.parser.setTestMode(this.isPrintToConsole());
        this.parser.setDoUseTerminator(true);
        this.rootNode = this.parser.nodeFactory().node("ddlRootNode");
    }

    @Test
    public void shouldParseCreateTableWithMySqlDataTypes() {
        this.printTest("shouldParseAlterTableAlterColumnDefaultRealNumber()");
        String content = "CREATE TABLE CS_EXT_FILES  (\n     FILE_NAME        VARCHAR(255),\n     FILE_CONTENTS    LONGBLOB,\n     CONFIG_CONTENTS\tLONGTEXT);";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.rootNode.getChild(0).getChildCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.rootNode.getChild(0).getName().getString(), (Matcher)Is.is((Object)"CS_EXT_FILES"));
    }

    @Test
    public void shouldParseTestCreate() {
        this.printTest("shouldParseTestCreate()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/mysql/mysql_test_create.ddl");
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        List problems = this.parser.nodeFactory().getChildrenForType(this.rootNode, MySqlDdlLexicon.TYPE_PROBLEM);
        Assert.assertThat((Object)problems.size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)145));
        List createTables = this.parser.nodeFactory().getChildrenForType(this.rootNode, MySqlDdlLexicon.TYPE_CREATE_TABLE_STATEMENT);
        Assert.assertThat((Object)createTables.size(), (Matcher)Is.is((Object)57));
        List alterTables = this.parser.nodeFactory().getChildrenForType(this.rootNode, MySqlDdlLexicon.TYPE_ALTER_TABLE_STATEMENT);
        Assert.assertThat((Object)alterTables.size(), (Matcher)Is.is((Object)31));
        List createViews = this.parser.nodeFactory().getChildrenForType(this.rootNode, MySqlDdlLexicon.TYPE_CREATE_VIEW_STATEMENT);
        Assert.assertThat((Object)createViews.size(), (Matcher)Is.is((Object)3));
        List createIndexes = this.parser.nodeFactory().getChildrenForType(this.rootNode, MySqlDdlLexicon.TYPE_CREATE_INDEX_STATEMENT);
        Assert.assertThat((Object)createIndexes.size(), (Matcher)Is.is((Object)53));
        List insertIntos = this.parser.nodeFactory().getChildrenForType(this.rootNode, MySqlDdlLexicon.TYPE_INSERT_STATEMENT);
        Assert.assertThat((Object)insertIntos.size(), (Matcher)Is.is((Object)1));
    }

    public void shouldParseMySqlTestStatements() {
        this.printTest("shouldParseMySqlTestStatements()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/mysql/mysql_test_statements.ddl");
        boolean success = this.parser.parse(content, this.rootNode);
        this.printUnknownStatements(this.parser, this.rootNode);
        this.printProblems(this.parser, this.rootNode);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)success));
        List problems = this.parser.nodeFactory().getChildrenForType(this.rootNode, MySqlDdlLexicon.TYPE_PROBLEM);
        Assert.assertThat((Object)problems.size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.rootNode.getChildCount(), (Matcher)Is.is((Object)106));
    }
}

