/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.ddl.dialect.oracle;

import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.sequencer.ddl.DdlParserTestHelper;
import org.jboss.dna.sequencer.ddl.StandardDdlLexicon;
import org.jboss.dna.sequencer.ddl.StandardDdlParser;
import org.jboss.dna.sequencer.ddl.dialect.oracle.OracleDdlLexicon;
import org.jboss.dna.sequencer.ddl.dialect.oracle.OracleDdlParser;
import org.jboss.dna.sequencer.ddl.node.AstNode;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OracleDdlParserTest
extends DdlParserTestHelper {
    private StandardDdlParser parser;
    private AstNode rootNode;
    public static final String DDL_FILE_PATH = "src/test/resources/ddl/dialect/oracle/";

    @Before
    public void beforeEach() {
        this.parser = new OracleDdlParser();
        this.setPrintToConsole(false);
        this.parser.setTestMode(this.isPrintToConsole());
        this.parser.setDoUseTerminator(true);
        this.rootNode = this.parser.nodeFactory().node("ddlRootNode");
    }

    @Test
    public void shouldParseCreateOrReplaceTrigger() {
        this.printTest("shouldParseCreateOrReplaceTrigger()");
        String content = "CREATE OR REPLACE TRIGGER drop_trigger BEFORE DROP ON hr.SCHEMA BEGIN RAISE_APPLICATION_ERROR ( num => -20000,msg => 'Cannot drop object'); END; /";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_CREATE_TRIGGER_STATEMENT));
    }

    @Test
    public void shouldParseAnalyze() {
        this.printTest("shouldParseAnalyze()");
        String content = "ANALYZE TABLE customers VALIDATE STRUCTURE ONLINE;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_ANALYZE_STATEMENT));
    }

    @Test
    public void shouldParseRollbackToSavepoint() {
        this.printTest("shouldParseRollbackToSavepoint()");
        String content = "ROLLBACK TO SAVEPOINT banda_sal;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_ROLLBACK_STATEMENT));
    }

    @Test
    public void shouldParseAlterTableAddREF() {
        this.printTest("shouldParseAlterTableAddREF()");
        String content = "ALTER TABLE staff ADD (REF(dept) WITH ROWID);";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_ALTER_TABLE_STATEMENT));
    }

    @Test
    public void shouldParseAlterTableADDWithNESTED_TABLE() {
        this.printTest("shouldParseAlterTableADDWithNESTED_TABLE()");
        String content = "ALTER TABLE employees ADD (skills skill_table_type) NESTED TABLE skills STORE AS nested_skill_table;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)false, (Object)success);
        Assert.assertEquals((long)2L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_ALTER_TABLE_STATEMENT));
    }

    @Test
    public void shouldParseAlterIndexRename() {
        this.printTest("shouldParseAlterIndexRename()");
        String content = "ALTER INDEX upper_ix RENAME TO upper_name_ix;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_ALTER_INDEX_STATEMENT));
    }

    @Test
    public void shouldParseAlterIndexMODIFY() {
        this.printTest("shouldParseAlterIndexMODIFY()");
        String content = "ALTER INDEX cost_ix MODIFY PARTITION p3 STORAGE(MAXEXTENTS 30) LOGGING;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_ALTER_INDEX_STATEMENT));
    }

    @Test
    public void shouldParseAlterIndexDROP() {
        this.printTest("shouldParseAlterIndexDROP()");
        String content = "ALTER INDEX cost_ix DROP PARTITION p1;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_ALTER_INDEX_STATEMENT));
    }

    @Test
    public void shouldParseAlterIndexTypeADD() {
        this.printTest("shouldParseAlterIndexTypeADD()");
        String content = "ALTER INDEXTYPE position_indextype ADD lob_contains(CLOB, CLOB);";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_ALTER_INDEXTYPE_STATEMENT));
    }

    @Test
    public void shouldParseTEMP_TEST() {
        this.printTest("shouldParseTEMP_TEST()");
        String content = "COMMENT ON COLUMN employees.job_id IS 'abbreviated job title';";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_COMMENT_ON_STATEMENT));
    }

    @Test
    public void shouldParseGrantAllOn() {
        this.printTest("shouldParseGrant()");
        String content = "GRANT ALL ON bonuses TO hr WITH GRANT OPTION;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_GRANT_STATEMENT));
    }

    @Test
    public void shouldParseAlterTableWithModifyClause() {
        this.printTest("shouldParseAlterTableWithModifyClause()");
        String content = "ALTER TABLE employees MODIFY LOB (resume) (CACHE);";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_ALTER_TABLE_STATEMENT));
    }

    @Test
    public void shouldParseAlterTableWithAddColumns() {
        this.printTest("shouldParseAlterTableWithModifyClause()");
        String content = "ALTER TABLE countries \n     ADD (duty_pct     NUMBER(2,2)  CHECK (duty_pct < 10.5),\n     visa_needed  VARCHAR2(3));";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_ALTER_TABLE_STATEMENT));
        Assert.assertEquals((long)3L, (long)childNode.getChildCount());
    }

    @Test
    public void shouldParseJava() {
        this.printTest("shouldParseJava()");
        String content = "CREATE JAVA SOURCE NAMED \"Hello\" AS public class Hello { public static String hello() {return \"Hello World\";   } };";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_CREATE_JAVA_STATEMENT));
    }

    @Test
    public void shouldParseCreateOrReplaceTriggerWithEmbeddedStatements() {
        this.printTest("shouldParseCreateOrReplaceTriggerWithEmbeddedStatements()");
        String content = "CREATE OR REPLACE TRIGGER order_info_insert INSTEAD OF INSERT ON order_info DECLARE   duplicate_info EXCEPTION;   PRAGMA EXCEPTION_INIT (duplicate_info, -00001); BEGIN   INSERT INTO customers     (customer_id, cust_last_name, cust_first_name)   VALUES (   :new.customer_id,    :new.cust_last_name,   :new.cust_first_name); INSERT INTO orders (order_id, order_date, customer_id) VALUES (   :new.order_id,   :new.order_date,   :new.customer_id); EXCEPTION   WHEN duplicate_info THEN    RAISE_APPLICATION_ERROR (       num=> -20107,       msg=> 'Duplicate customer or order ID'); END order_info_insert; /";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_CREATE_TRIGGER_STATEMENT));
    }

    @Test
    public void shouldParseGrantReadOnDirectory() {
        this.printTest("shouldParseGrantReadOnDirectory()");
        String content = "GRANT READ ON DIRECTORY bfile_dir TO hr \n     WITH GRANT OPTION;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), StandardDdlLexicon.TYPE_GRANT_STATEMENT));
    }

    @Test
    public void shouldParseCreateFunction_1() {
        this.printTest("shouldParseCreateFunction_1()");
        String content = "CREATE OR REPLACE FUNCTION text_length(a CLOB) RETURN NUMBER DETERMINISTIC IS BEGIN RETURN DBMS_LOB.GETLENGTH(a); END; /";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_CREATE_FUNCTION_STATEMENT));
    }

    @Test
    public void shouldParseCreateProcedure_1() {
        this.printTest("shouldParseCreateProcedure_1()");
        String content = "CREATE PROCEDURE remove_emp (employee_id NUMBER) AS tot_emps NUMBER;\nBEGIN\n   DELETE FROM employees\n   WHERE employees.employee_id = remove_emp.employee_id;\ntot_emps := tot_emps - 1;\nEND;\n/";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_CREATE_PROCEDURE_STATEMENT));
    }

    @Test
    public void shouldParseCreateProcedure_2() {
        this.printTest("shouldParseCreateProcedure_2()");
        String content = "CREATE OR REPLACE PROCEDURE add_emp (employee_id NUMBER, employee_age NUMBER) AS tot_emps NUMBER;\nBEGIN\n   INSERT INTO employees\n   WHERE employees.employee_id = remove_emp.employee_id;\ntot_emps := tot_emps + 1;\nEND;\n/";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_CREATE_PROCEDURE_STATEMENT));
        Assert.assertEquals((long)2L, (long)childNode.getChildCount());
    }

    @Test
    public void shouldParseOracleProceduresAndFunctions() {
        this.printTest("shouldParseOracleProceduresAndFunctions()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/oracle/create_procedure_statements.ddl");
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)4L, (long)this.rootNode.getChildCount());
    }

    @Test
    public void shouldParseCreateMaterializedView() {
        this.printTest("shouldParseCreateMaterializedView()");
        String content = " CREATE MATERIALIZED VIEW sales_mv\nBUILD IMMEDIATE\nREFRESH FAST ON COMMIT\nAS SELECT t.calendar_year, p.prod_id, \n   SUM(s.amount_sold) AS sum_sales\n   FROM times t, products p, sales s\n   WHERE t.time_id = s.time_id AND p.prod_id = s.prod_id\n   GROUP BY t.calendar_year, p.prod_id;\n";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_CREATE_MATERIALIZED_VIEW_STATEMENT));
    }

    @Test
    public void shouldParseCreateMaterializedViewLog() {
        this.printTest("shouldParseCreateMaterializedViewLog()");
        String content = "CREATE MATERIALIZED VIEW LOG ON products\nWITH ROWID, SEQUENCE (prod_id)\nINCLUDING NEW VALUES;";
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)1L, (long)this.rootNode.getChildCount());
        AstNode childNode = (AstNode)this.rootNode.getChildren().get(0);
        Assert.assertTrue((boolean)this.hasMixinType(childNode.getProperty(JcrLexicon.MIXIN_TYPES), OracleDdlLexicon.TYPE_CREATE_MATERIALIZED_VIEW_LOG_STATEMENT));
    }

    @Test
    public void shouldParseOracleStatements_1() {
        this.printTest("shouldParseOracleStatements_1()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/oracle/oracle_test_statements_1.ddl");
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)50L, (long)this.rootNode.getChildCount());
    }

    @Test
    public void shouldParseOracleStatements_2() {
        this.printTest("shouldParseOracleStatements_2()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/oracle/oracle_test_statements_2.ddl");
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)50L, (long)this.rootNode.getChildCount());
    }

    @Test
    public void shouldParseOracleStatements_3() {
        this.printTest("shouldParseOracleStatements_3()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/oracle/oracle_test_statements_3.ddl");
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)50L, (long)this.rootNode.getChildCount());
    }

    @Test
    public void shouldParseOracleStatements_4() {
        this.printTest("shouldParseOracleStatements_4()");
        String content = this.getFileContent("src/test/resources/ddl/dialect/oracle/oracle_test_statements_4.ddl");
        boolean success = this.parser.parse(content, this.rootNode);
        Assert.assertEquals((Object)true, (Object)success);
        Assert.assertEquals((long)48L, (long)this.rootNode.getChildCount());
    }
}

