/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.ddl.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.sequencer.ddl.node.AstNode;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AstNodeTest {
    private ExecutionContext context;
    private AstNode node;
    private AstNode parent;

    @Before
    public void beforeEach() {
        this.context = new ExecutionContext();
        this.node = new AstNode(this.name("node1"));
    }

    @After
    public void afterEach() {
        this.node = null;
        this.parent = null;
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    protected Path path(String path) {
        return (Path)this.context.getValueFactories().getPathFactory().create(path);
    }

    @Test
    public void shouldCreatePlanNodeWithNameAndNoParent() {
        Name name = this.name("something");
        this.node = new AstNode(name);
        Assert.assertThat((Object)this.node.getName(), (Matcher)Is.is((Object)name));
        Assert.assertThat((Object)this.node.getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldCreatePlanNodeWithNameAndParent() {
        Name name = this.name("something");
        this.parent = new AstNode(this.name("parent"));
        this.node = new AstNode(this.parent, name);
        Assert.assertThat((Object)this.node.getName(), (Matcher)Is.is((Object)name));
        Assert.assertThat((Object)this.node.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithOneChild() {
        this.parent = new AstNode(this.name("parent"));
        this.node = new AstNode(this.parent, this.name("child"));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithTwoChildren() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithMoreThanTwoChildren() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
    }

    @Test
    public void shouldGetFirstChildAndLastChildWithNoChildren() {
        this.parent = new AstNode(this.name("parent"));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldRemoveNodeFromExistingParentWhenSettingParentToNull() {
        this.parent = new AstNode(this.name("parent"));
        this.node = new AstNode(this.parent, this.name("child"));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)1));
        this.node.setParent(null);
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.node.getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldInsertNewParentNodeInBetweenExistingParentAndChild() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)3));
        this.node = new AstNode(this.name("inserted"));
        child2.insertAsParent(this.node);
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.node.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)child2.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
    }

    @Test
    public void shouldInsertNewParentNodeInAboveNodeWithoutParent() {
        AstNode child1 = new AstNode(this.name("childA"));
        this.node = new AstNode(this.name("node"));
        AstNode nodeChild = new AstNode(this.node, this.name("child"));
        child1.insertAsParent(this.node);
        Assert.assertThat((Object)this.node.getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.node.getChildCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.node.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)nodeChild)));
        Assert.assertThat((Object)this.node.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)child1.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.node)));
    }

    @Test
    public void shouldRemoveFromParentWhenThereIsAParent() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        AstNode grandChild21 = new AstNode(child2, this.name("grandChild21"));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)child2.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)grandChild21)));
        Assert.assertThat((Object)child2.removeFromParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getLastChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)child2.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)grandChild21)));
    }

    @Test
    public void shouldRemoveFromParentWhenThereIsNoParent() {
        this.node = new AstNode(this.name("node"));
        AstNode child1 = new AstNode(this.node, this.name("child"));
        Assert.assertThat((Object)this.node.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.node.getChildCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.node.removeFromParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)this.node.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.node.getChildCount(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldReturnListOfChildren() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        List children = this.parent.getChildren();
        Assert.assertThat(children.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat(children.get(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat(children.get(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnImmutableListOfChildren() {
        this.parent = new AstNode(this.name("parent"));
        new AstNode(this.parent, this.name("childA"));
        new AstNode(this.parent, this.name("childB"));
        new AstNode(this.parent, this.name("childC"));
        this.parent.getChildren().clear();
    }

    @Test
    public void shouldReturnIteratorOfChildren() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        Iterator children = this.parent.iterator();
        Assert.assertThat(children.next(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat(children.next(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat(children.next(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)children.hasNext(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void shouldReturnImmutableIteratorOfChildren() {
        this.parent = new AstNode(this.name("parent"));
        new AstNode(this.parent, this.name("childA"));
        new AstNode(this.parent, this.name("childB"));
        new AstNode(this.parent, this.name("childC"));
        Iterator iter = this.parent.iterator();
        iter.next();
        iter.remove();
    }

    @Test
    public void shouldRemoveAllChildrenOfParentWithNoChildrenByReturningEmptyList() {
        this.parent = new AstNode(this.name("parent"));
        List children = this.parent.removeAllChildren();
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)0));
        AstNode child1a = new AstNode(this.parent, this.name("child1A"));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1a)));
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldRemoveAllChildrenAndReturnCopyOfListOfChildren() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        List children = this.parent.removeAllChildren();
        Assert.assertThat(children.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat(children.get(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat(children.get(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)0));
        AstNode child1a = new AstNode(this.parent, this.name("child1A"));
        Assert.assertThat((Object)this.parent.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1a)));
        Assert.assertThat(children.get(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat(children.get(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat(children.get(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)children.size(), (Matcher)Is.is((Object)3));
    }

    @Test
    public void shouldReturnCorrectChildCount() {
        this.parent = new AstNode(this.name("parent"));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)0));
        for (int i = 0; i != 10; ++i) {
            new AstNode(this.parent, this.name("child"));
            Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)(i + 1)));
        }
    }

    @Test
    public void shouldAddChildrenAtEnd() {
        this.parent = new AstNode(this.name("parent"));
        ArrayList<AstNode> children = new ArrayList<AstNode>();
        children.add(new AstNode(this.parent, this.name("child")));
        children.add(new AstNode(this.parent, this.name("child")));
        children.add(new AstNode(this.parent, this.name("child")));
        this.parent.addChildren(children);
        int index = 0;
        for (AstNode child : children) {
            Assert.assertThat((Object)this.parent.getChild(index++), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child)));
        }
    }

    @Test
    public void shouldRemoveChild() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.removeChild(child2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
    }

    @Test
    public void shouldNotRemoveChildIfNotReallyAChild() {
        this.node = new AstNode(this.name("node"));
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.removeChild(this.node), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
    }

    @Test
    public void shouldNotRemoveChildIfReferenceIsNull() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.removeChild(null), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
    }

    @Test
    public void shouldExtractChildByRemovingIfChildHasNoChildren() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        this.parent.extractChild(child2);
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldExtractChildByReplacingWithFirstGrandchild() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        AstNode grandChild1 = new AstNode(child2, this.name("grandchildA"));
        AstNode grandChild2 = new AstNode(child2, this.name("grandchildB"));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        this.parent.extractChild(child2);
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)grandChild1)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChildCount(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)child2.getFirstChild(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)grandChild2)));
        Assert.assertThat((Object)child2.getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void shouldReplaceChild() {
        AstNode parentOfReplacement = new AstNode(this.name("parentOfReplacement"));
        AstNode replacement = new AstNode(parentOfReplacement, this.name("replacement"));
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.replaceChild(child2, replacement), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)replacement)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)replacement.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)child1.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)child2.getParent(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)child3.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)parentOfReplacement.getChildCount(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReplaceChildWithAnotherChildToSwapPositions() {
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.replaceChild(child2, child3), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)child1.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)child2.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
        Assert.assertThat((Object)child3.getParent(), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)this.parent)));
    }

    @Test
    public void shouldNotReplaceChildIfChildNodeIsNotReallyAChild() {
        AstNode nonChild = new AstNode(this.name("nonChild"));
        AstNode replacement = new AstNode(this.name("replacement"));
        this.parent = new AstNode(this.name("parent"));
        AstNode child1 = new AstNode(this.parent, this.name("childA"));
        AstNode child2 = new AstNode(this.parent, this.name("childB"));
        AstNode child3 = new AstNode(this.parent, this.name("childC"));
        Assert.assertThat((Object)this.parent.getChild(0), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child1)));
        Assert.assertThat((Object)this.parent.getChild(1), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child2)));
        Assert.assertThat((Object)this.parent.getChild(2), (Matcher)Is.is((Matcher)IsSame.sameInstance((Object)child3)));
        Assert.assertThat((Object)this.parent.replaceChild(nonChild, replacement), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnPath() {
        AstNode root = new AstNode(this.name("root"));
        AstNode node1 = new AstNode(root, this.name("node1"));
        AstNode node2 = new AstNode(node1, this.name("node2"));
        AstNode node3 = new AstNode(node2, this.name("node3"));
        AstNode node4 = new AstNode(node3, this.name("node4"));
        AstNode node5 = new AstNode(node4, this.name("node5"));
        node4.setProperty(this.name("prop1"), (Object)"value1");
        Assert.assertThat((Object)root.getPath(this.context), (Matcher)Is.is((Object)this.path("/root")));
        Assert.assertThat((Object)node1.getPath(this.context), (Matcher)Is.is((Object)this.path("/root/node1")));
        Assert.assertThat((Object)node2.getPath(this.context), (Matcher)Is.is((Object)this.path("/root/node1/node2")));
        Assert.assertThat((Object)node3.getPath(this.context), (Matcher)Is.is((Object)this.path("/root/node1/node2/node3")));
        Assert.assertThat((Object)node4.getPath(this.context), (Matcher)Is.is((Object)this.path("/root/node1/node2/node3/node4")));
        Assert.assertThat((Object)node5.getPath(this.context), (Matcher)Is.is((Object)this.path("/root/node1/node2/node3/node4/node5")));
    }
}

