SET ANSI_NULL_DFLT_ON ON
GO

CREATE TABLE AUDITENTRIES
(
  TIMESTAMP  VARCHAR(50) NOT NULL,
  CONTEXT    VARCHAR(64) NOT NULL,
  ACTIVITY   VARCHAR(64) NOT NULL,
  RESOURCES  VARCHAR(4000) NOT NULL,
  PRINCIPAL  VARCHAR(255) NOT NULL,
  HOSTNAME   VARCHAR(64) NOT NULL,
  VMID       VARCHAR(64) NOT NULL
)
GO

CREATE TABLE AUTHPERMTYPES
(
  PERMTYPEUID       NUMERIC(10) NOT NULL CONSTRAINT PK_AUTHPERMYPES UNIQUE,
  DISPLAYNAME       VARCHAR(250) NOT NULL,
  FACTORYCLASSNAME  VARCHAR(80) NOT NULL
)
GO

CREATE TABLE AUTHPOLICIES
(
  POLICYUID    NUMERIC(10) NOT NULL CONSTRAINT PK_AUTHPOLICIES UNIQUE,
  DESCRIPTION  VARCHAR(250),
  POLICYNAME   VARCHAR(250) NOT NULL
)
GO

CREATE TABLE AUTHPRINCIPALS
(
  PRINCIPALTYPE  NUMERIC(10) NOT NULL,
  PRINCIPALNAME  VARCHAR(255) NOT NULL,
  POLICYUID      NUMERIC(10) NOT NULL CONSTRAINT FK_ATHPLCY_PLCYUID REFERENCES AUTHPOLICIES (POLICYUID) ,
  GRANTOR        VARCHAR(255) NOT NULL,
  CONSTRAINT PK_AUTHPOLICYPRINCIPALS UNIQUE (PRINCIPALNAME, POLICYUID)
)
GO

CREATE TABLE AUTHREALMS
(
  REALMUID     NUMERIC(10) NOT NULL CONSTRAINT PK_AUTHREALMS UNIQUE,
  REALMNAME    VARCHAR(250) NOT NULL UNIQUE,
  DESCRIPTION  VARCHAR(550)
)
GO

CREATE TABLE CFG_STARTUP_STATE
(STATE INTEGER DEFAULT (0) NULL,
LASTCHANGED VARCHAR(50) )
GO


GO

CREATE TABLE IDTABLE
(
  IDCONTEXT  VARCHAR(20) NOT NULL PRIMARY KEY,
  NEXTID     NUMERIC
)
GO

CREATE TABLE LOGMESSAGETYPES
(
  MESSAGELEVEL  NUMERIC(10) NOT NULL CONSTRAINT PK_LOGMSGTYPS UNIQUE,
  NAME          VARCHAR(64) NOT NULL,
  DISPLAYNAME   VARCHAR(64)
)
GO

CREATE TABLE MM_PRODUCTS
(
  PRODUCT_UID         NUMERIC(10) NOT NULL CONSTRAINT MM_PROD_UID PRIMARY KEY,
  PRODUCT_NAME        VARCHAR(50) NOT NULL,
  PRODUCT_DISPLAY_NM  VARCHAR(100)
)
GO


CREATE TABLE PRINCIPALTYPES
(
  PRINCIPALTYPEUID  NUMERIC(10) NOT NULL CONSTRAINT PK_PRNCPLTYPUID UNIQUE,
  PRINCIPALTYPE     VARCHAR(60) NOT NULL,
  DISPLAYNAME       VARCHAR(80) NOT NULL,
  LASTCHANGEDBY     VARCHAR(255) NOT NULL,
  LASTCHANGED       VARCHAR(50)
)
GO

CREATE TABLE RT_MDLS
(
  MDL_UID           NUMERIC(10) NOT NULL CONSTRAINT PK_MDLS UNIQUE,
  MDL_UUID          VARCHAR(64) NOT NULL,
  MDL_NM            VARCHAR(255) NOT NULL,
  MDL_VERSION       VARCHAR(50),
  DESCRIPTION       VARCHAR(255),
  MDL_URI           VARCHAR(255),
  MDL_TYPE          NUMERIC(3),
  IS_PHYSICAL       CHAR(1) NOT NULL,
  MULTI_SOURCED     CHAR(1) DEFAULT ('0') NULL,  
  VISIBILITY        NUMERIC(3)
)
GO

CREATE TABLE RT_MDL_PRP_NMS
(
  PRP_UID  NUMERIC(10) NOT NULL CONSTRAINT PK_MDL_PRP_NMS UNIQUE,
  MDL_UID  NUMERIC(10) NOT NULL ,
  PRP_NM   VARCHAR(255) NOT NULL
)
GO

CREATE TABLE RT_MDL_PRP_VLS
(
  PRP_UID  NUMERIC(10) NOT NULL ,
  PART_ID  NUMERIC(10) NOT NULL,
  PRP_VL   VARCHAR(255) NOT NULL,
  CONSTRAINT PK_MDL_PRP_VLS UNIQUE (PRP_UID, PART_ID)
)
GO

CREATE TABLE RT_VIRTUAL_DBS
(
  VDB_UID        NUMERIC(10) NOT NULL CONSTRAINT PK_VIRT_DB UNIQUE,
  VDB_VERSION    VARCHAR(50) NOT NULL,
  VDB_NM         VARCHAR(255) NOT NULL,
  DESCRIPTION    VARCHAR(255),
  PROJECT_GUID   VARCHAR(64),
  VDB_STATUS     NUMERIC NOT NULL,
  WSDL_DEFINED   CHAR(1) DEFAULT ('0') NULL,  
  VERSION_BY     VARCHAR(100),
  VERSION_DATE   VARCHAR(50) NOT NULL,
  CREATED_BY     VARCHAR(100),
  CREATION_DATE  VARCHAR(50),
  UPDATED_BY     VARCHAR(100),
  UPDATED_DATE   VARCHAR(50),
  VDB_FILE_NM VARCHAR(2048)
)
GO

CREATE TABLE SERVICESESSIONS
(
  SESSIONUID      NUMERIC(10) NOT NULL CONSTRAINT PK_SERVICESESSIONS UNIQUE,
  PRINCIPAL       VARCHAR(255) NOT NULL,
  APPLICATION     VARCHAR(128) NOT NULL,
  CREATIONTIME    VARCHAR(50),
  CLIENTCOUNT     NUMERIC(10) NOT NULL,
  STATE           NUMERIC(10) NOT NULL,
  STATETIME       VARCHAR(50),
  USESSUBSCRIBER  CHAR(1) NOT NULL,
  PRODUCTINFO1    VARCHAR(255),
  PRODUCTINFO2    VARCHAR(255),
  PRODUCTINFO3    VARCHAR(255),
  PRODUCTINFO4    VARCHAR(255)
)
GO

CREATE TABLE AUTHPERMISSIONS
(
  PERMISSIONUID    NUMERIC(10) NOT NULL CONSTRAINT PK_AUTHPERMISSIONS UNIQUE,
  RESOURCENAME     VARCHAR(250) NOT NULL,
  ACTIONS          NUMERIC(10) NOT NULL,
  CONTENTMODIFIER  VARCHAR(250),
  PERMTYPEUID      NUMERIC(10) NOT NULL CONSTRAINT FK_ATHPRMS_ATHPERM REFERENCES AUTHPERMTYPES (PERMTYPEUID) ,
  REALMUID         NUMERIC(10) NOT NULL CONSTRAINT FK_ATHPRMS_ATHRLMS REFERENCES AUTHREALMS (REALMUID) ,
  POLICYUID        NUMERIC(10) NOT NULL CONSTRAINT FK_ATHPRMS_ATHPLCY REFERENCES AUTHPOLICIES (POLICYUID)
)
GO


CREATE TABLE LOGENTRIES
(
  TIMESTAMP   VARCHAR(50) NOT NULL,
  CONTEXT     VARCHAR(64) NOT NULL,
  MSGLEVEL    NUMERIC(10) NOT NULL CONSTRAINT FK_LOGENTRIES_MSGTYPES REFERENCES LOGMESSAGETYPES (MESSAGELEVEL) ,
  EXCEPTION   VARCHAR(4000),
  MESSAGE     VARCHAR(2000) NOT NULL,
  HOSTNAME    VARCHAR(64) NOT NULL,
  VMID        VARCHAR(64) NOT NULL,
  THREADNAME  VARCHAR(64) NOT NULL,
  VMSEQNUM NUMERIC(7) NOT NULL
)
GO


CREATE TABLE PRODUCTSSESSIONS
(
  PRODUCT_UID  NUMERIC(10) NOT NULL,
  SESSION_UID  NUMERIC(10) NOT NULL,
  PRIMARY KEY (PRODUCT_UID, SESSION_UID)
)
GO

ALTER TABLE PRODUCTSSESSIONS
    ADD CONSTRAINT FK_PRODSESS_PRODS
    FOREIGN KEY (PRODUCT_UID)
    REFERENCES MM_PRODUCTS (PRODUCT_UID)
GO

ALTER TABLE PRODUCTSSESSIONS
    ADD CONSTRAINT FK_PRODSESS_SVCSES
    FOREIGN KEY (SESSION_UID)
    REFERENCES SERVICESESSIONS (SESSIONUID)
GO

CREATE TABLE RT_VDB_MDLS
(
  VDB_UID         NUMERIC(10) NOT NULL ,
  MDL_UID         NUMERIC(10) NOT NULL ,
  CNCTR_BNDNG_NM  VARCHAR(255)
)
GO


CREATE INDEX AWA_SYS_MDL_NM_09BF4B92 ON RT_MDLS (MDL_NM)
GO

CREATE INDEX AWA_SYS_VDB_NM_7F0CB2F5 ON RT_VIRTUAL_DBS (VDB_NM)
GO

CREATE INDEX AWA_SYS_VDB_VERSION_7F0CB2F5 ON RT_VIRTUAL_DBS (VDB_VERSION)
GO

CREATE UNIQUE INDEX MDL_PRP_NMS_UIX ON RT_MDL_PRP_NMS (MDL_UID, PRP_NM)
GO

CREATE UNIQUE INDEX PRNCIPALTYP_UIX ON PRINCIPALTYPES (PRINCIPALTYPE)
GO

CREATE UNIQUE INDEX AUTHPOLICIES_NAM_UIX ON AUTHPOLICIES (POLICYNAME)
GO

CREATE INDEX AWA_SYS_MSGLEVEL_1E6F845E ON LOGENTRIES (MSGLEVEL)
GO


CREATE UNIQUE INDEX AUTHPERM_UIX ON AUTHPERMISSIONS (POLICYUID,RESOURCENAME)
GO

CREATE TABLE CS_EXT_FILES  (
   FILE_UID             DECIMAL(19)                          NOT NULL,
   CHKSUM               DECIMAL(20),
   FILE_NAME            VARCHAR(255)		NOT NULL,
   FILE_CONTENTS        IMAGE,
   CONFIG_CONTENTS      TEXT,
   SEARCH_POS           DECIMAL(10),
   IS_ENABLED           CHAR(1),
   FILE_DESC            VARCHAR(4000),
   CREATED_BY           VARCHAR(100),
   CREATION_DATE        VARCHAR(50),
   UPDATED_BY           VARCHAR(100),
   UPDATE_DATE          VARCHAR(50),
   FILE_TYPE            VARCHAR(30))
GO

ALTER TABLE CS_EXT_FILES
       ADD   PRIMARY KEY (FILE_UID)
GO




ALTER TABLE CS_EXT_FILES ADD CONSTRAINT CSEXFILS_FIL_NA_UK UNIQUE (FILE_NAME)
GO

CREATE TABLE MMSCHEMAINFO_CA
(
    SCRIPTNAME        VARCHAR(50),
    SCRIPTEXECUTEDBY  VARCHAR(50),
    SCRIPTREV         VARCHAR(50),
    RELEASEDATE       VARCHAR(50),
    DATECREATED       DATETIME,
    DATEUPDATED       DATETIME,
    UPDATEID          VARCHAR(50),
    METAMATRIXSERVERURL  VARCHAR(100)
)
GO

CREATE TABLE CFG_LOCK (
  USER_NAME       VARCHAR(50) NOT NULL,
  DATETIME_ACQUIRED VARCHAR(50) NOT NULL,
  DATETIME_EXPIRE VARCHAR(50) NOT NULL,
  HOST       VARCHAR(100),
  LOCK_TYPE NUMERIC (1) )
GO

CREATE TABLE CS_SYSTEM_PROPS (
	PROPERTY_NAME VARCHAR(255),
	PROPERTY_VALUE VARCHAR(255)
)
GO

CREATE UNIQUE INDEX SYSPROPS_KEY ON CS_SYSTEM_PROPS (PROPERTY_NAME)
GO


CREATE TABLE TX_MMXCMDLOG
(REQUESTID  VARCHAR(255)  NOT NULL,
TXNUID  VARCHAR(50)  NULL,
CMDPOINT  NUMERIC(10)  NOT NULL,
SESSIONUID  VARCHAR(255)  NOT NULL,
APP_NAME  VARCHAR(255)  NULL,
PRINCIPAL_NA  VARCHAR(255)  NOT NULL,
VDBNAME  VARCHAR(255)  NOT NULL,
VDBVERSION  VARCHAR(50)  NOT NULL,
CREATED_TS  VARCHAR(50)  NULL,
ENDED_TS  VARCHAR(50)  NULL,
CMD_STATUS  NUMERIC(10)  NOT NULL,
SQL_ID  NUMERIC(10) NULL,
FINL_ROWCNT NUMERIC(10) NULL
)
GO


CREATE TABLE TX_SRCCMDLOG
(REQUESTID  VARCHAR(255)  NOT NULL,
NODEID  NUMERIC(10)  NOT NULL,
SUBTXNUID  VARCHAR(50)  NULL,
CMD_STATUS  NUMERIC(10)  NOT NULL,
MDL_NM  VARCHAR(255)  NOT NULL,
CNCTRNAME  VARCHAR(255)  NOT NULL,
CMDPOINT  NUMERIC(10)  NOT NULL,
SESSIONUID  VARCHAR(255)  NOT NULL,
PRINCIPAL_NA  VARCHAR(255)  NOT NULL,
CREATED_TS  VARCHAR(50)  NULL,
ENDED_TS  VARCHAR(50)  NULL,
SQL_ID  NUMERIC(10)  NULL,
FINL_ROWCNT  NUMERIC(10)  NULL
)
GO



CREATE TABLE TX_SQL ( SQL_ID  NUMERIC(10)    NOT NULL,
    SQL_VL  TEXT )
GO
ALTER TABLE TX_SQL 
    ADD CONSTRAINT TX_SQL_PK
PRIMARY KEY (SQL_ID)
GO


-- Build Script
--     RDBMS           : Microsoft SQL Server 7.X/2000
--     Generated With  : MetaMatrix MetaBase Modeler Release 3.1 SP6(Build 1672)
--     Generated On    : 2003-12-11 15:53:43
--     Generate From
--         Model       : RepositorySchema.xml
--         Model Type  : PhysicalModel
--         Metamodel   : Relational (http://www.metamatrix.com/metabase/3.0/metamodels/Relational.xml)
--         Model UUID  : mmuuid:eb6f4180-dbd4-1eab-890d-8f6b86baf96d
--     Generation Options
--         Generate Comments             : true
--         Generate Drop Statements      : true
--
-- The ITEMS table stores the raw, structure-independent information about the items contained by the Repository. This table is capable of persisting multiple versions of an item.
--
CREATE TABLE MBR_ITEMS
(
  ITEM_ID_P1        NUMERIC(20) NOT NULL,
  ITEM_ID_P2        NUMERIC(20) NOT NULL,
  ITEM_VERSION      VARCHAR(80) NOT NULL,
  ITEM_NAME         VARCHAR(255) NOT NULL,
  UPPER_ITEM_NAME   VARCHAR(255) NOT NULL,
  COMMENT_FLD       VARCHAR(2000),
  LOCK_HOLDER       VARCHAR(100),
  LOCK_DATE         VARCHAR(50),
  CREATED_BY        VARCHAR(100) NOT NULL,
  CREATION_DATE     VARCHAR(50) NOT NULL,
  ITEM_TYPE         NUMERIC(10) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The ITEMS table stores the raw, structure-independent information about the items contained by the Repository. This table is capable of persisting multiple versions of an item.', N'user', @table_owner, N'table', N'MBR_ITEMS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the item''s UUID.', N'user', @table_owner, N'table', N'MBR_ITEMS', N'column', N'ITEM_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the item''s UUID.', N'user', @table_owner, N'table', N'MBR_ITEMS', N'column', N'ITEM_ID_P2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The item''s version. Examples of the format are "1.1", "1.3".', N'user', @table_owner, N'table', N'MBR_ITEMS', N'column', N'ITEM_VERSION'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The item''s name.', N'user', @table_owner, N'table', N'MBR_ITEMS', N'column', N'ITEM_NAME'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The uppercase form of the item''s name.', N'user', @table_owner, N'table', N'MBR_ITEMS', N'column', N'UPPER_ITEM_NAME'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The comment for this version of the item. If this item record is the first version, the comment is that supplied when adding the item to the repository. Otherwise, the comment is that supplied when checking in changes (and thus creating a new version).', N'user', @table_owner, N'table', N'MBR_ITEMS', N'column', N'COMMENT_FLD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The name of the user that currently has a lock on this item.', N'user', @table_owner, N'table', N'MBR_ITEMS', N'column', N'LOCK_HOLDER'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The timestamp that the current lockholder (if any) acquired the lock.', N'user', @table_owner, N'table', N'MBR_ITEMS', N'column', N'LOCK_DATE'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The name of the user that created this version of the item.', N'user', @table_owner, N'table', N'MBR_ITEMS', N'column', N'CREATED_BY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The timestamp that this version of the item was created.', N'user', @table_owner, N'table', N'MBR_ITEMS', N'column', N'CREATION_DATE'
GO

--
-- The ITEM_CONTENTS table stores the contents for items (files) stored in the repository. This table is capable of persisting multiple versions of the contents for an item.
--
CREATE TABLE MBR_ITEM_CONTENTS
(
  ITEM_ID_P1     NUMERIC(20) NOT NULL,
  ITEM_ID_P2     NUMERIC(20) NOT NULL,
  ITEM_VERSION   VARCHAR(80) NOT NULL,
  ITEM_CONTENT   IMAGE NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The ITEM_CONTENTS table stores the contents for items (files) stored in the repository. This table is capable of persisting multiple versions of the contents for an item.', N'user', @table_owner, N'table', N'MBR_ITEM_CONTENTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the item''s UUID.', N'user', @table_owner, N'table', N'MBR_ITEM_CONTENTS', N'column', N'ITEM_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the item''s UUID.', N'user', @table_owner, N'table', N'MBR_ITEM_CONTENTS', N'column', N'ITEM_ID_P2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The item''s version.', N'user', @table_owner, N'table', N'MBR_ITEM_CONTENTS', N'column', N'ITEM_VERSION'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The contents of the item.', N'user', @table_owner, N'table', N'MBR_ITEM_CONTENTS', N'column', N'ITEM_CONTENT'
GO

--
-- The ENTRIES table stores the structure information for all the objects stored in the Repository. This includes both folders and items.
--
CREATE TABLE MBR_ENTRIES
(
  ENTRY_ID_P1          NUMERIC(20) NOT NULL,
  ENTRY_ID_P2          NUMERIC(20) NOT NULL,
  ENTRY_NAME           VARCHAR(255) NOT NULL,
  UPPER_ENTRY_NAME     VARCHAR(255) NOT NULL,
  ITEM_ID_P1           NUMERIC(20),
  ITEM_ID_P2           NUMERIC(20),
  ITEM_VERSION         VARCHAR(80),
  PARENT_ENTRY_ID_P1   NUMERIC(20),
  PARENT_ENTRY_ID_P2   NUMERIC(20),
  DELETED              NUMERIC(1) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The ENTRIES table stores the structure information for all the objects stored in the Repository. This includes both folders and items.', N'user', @table_owner, N'table', N'MBR_ENTRIES'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the entry''s UUID.', N'user', @table_owner, N'table', N'MBR_ENTRIES', N'column', N'ENTRY_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the entry''s UUID.', N'user', @table_owner, N'table', N'MBR_ENTRIES', N'column', N'ENTRY_ID_P2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The name of the entry.', N'user', @table_owner, N'table', N'MBR_ENTRIES', N'column', N'ENTRY_NAME'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The uppercase form of the entry''s name. This is to support searching when the case is not known a priori.', N'user', @table_owner, N'table', N'MBR_ENTRIES', N'column', N'UPPER_ENTRY_NAME'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the UUID for the item; if a folder, this is null.', N'user', @table_owner, N'table', N'MBR_ENTRIES', N'column', N'ITEM_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the UUID for the item; if a folder, this is null.', N'user', @table_owner, N'table', N'MBR_ENTRIES', N'column', N'ITEM_ID_P2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The item''s version.', N'user', @table_owner, N'table', N'MBR_ENTRIES', N'column', N'ITEM_VERSION'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the UUID for the parent entry.', N'user', @table_owner, N'table', N'MBR_ENTRIES', N'column', N'PARENT_ENTRY_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the UUID for the parent entry.', N'user', @table_owner, N'table', N'MBR_ENTRIES', N'column', N'PARENT_ENTRY_ID_P2'
GO

--
-- The LABELS table stores the various labels that have been defined.
--
CREATE TABLE MBR_LABELS
(
  LABEL_ID_P1     NUMERIC(20) NOT NULL,
  LABEL_ID_P2     NUMERIC(20) NOT NULL,
  LABEL_FLD       VARCHAR(255) NOT NULL,
  COMMENT_FLD     VARCHAR(2000),
  CREATED_BY      VARCHAR(100) NOT NULL,
  CREATION_DATE   VARCHAR(50) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The LABELS table stores the various labels that have been defined.', N'user', @table_owner, N'table', N'MBR_LABELS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the label''s UUID.', N'user', @table_owner, N'table', N'MBR_LABELS', N'column', N'LABEL_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the label''s UUID.', N'user', @table_owner, N'table', N'MBR_LABELS', N'column', N'LABEL_ID_P2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The label.', N'user', @table_owner, N'table', N'MBR_LABELS', N'column', N'LABEL_FLD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The comment for the label.', N'user', @table_owner, N'table', N'MBR_LABELS', N'column', N'COMMENT_FLD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The name of the user that created this label.', N'user', @table_owner, N'table', N'MBR_LABELS', N'column', N'CREATED_BY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The timestamp that this label was created.', N'user', @table_owner, N'table', N'MBR_LABELS', N'column', N'CREATION_DATE'
GO

--
-- The ITEM_LABELS table maintains the relationships between the ITEMS and the LABELs; that is, the labels that have been applied to each of the item versions. (This is a simple intersect table.)
--
CREATE TABLE MBR_ITEM_LABELS
(
  ITEM_ID_P1     NUMERIC(20) NOT NULL,
  ITEM_ID_P2     NUMERIC(20) NOT NULL,
  ITEM_VERSION   VARCHAR(80) NOT NULL,
  LABEL_ID_P1    NUMERIC(20) NOT NULL,
  LABEL_ID_P2    NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The ITEM_LABELS table maintains the relationships between the ITEMS and the LABELs; that is, the labels that have been applied to each of the item versions. (This is a simple intersect table.)', N'user', @table_owner, N'table', N'MBR_ITEM_LABELS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the item''s UUID.', N'user', @table_owner, N'table', N'MBR_ITEM_LABELS', N'column', N'ITEM_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the item''s UUID.', N'user', @table_owner, N'table', N'MBR_ITEM_LABELS', N'column', N'ITEM_ID_P2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The item''s version.', N'user', @table_owner, N'table', N'MBR_ITEM_LABELS', N'column', N'ITEM_VERSION'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the label''s UUID.', N'user', @table_owner, N'table', N'MBR_ITEM_LABELS', N'column', N'LABEL_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the label''s UUID.', N'user', @table_owner, N'table', N'MBR_ITEM_LABELS', N'column', N'LABEL_ID_P2'
GO

--
-- The ITEM_LABELS table maintains the relationships between the ITEMS and the LABELs; that is, the labels that have been applied to each of the item versions. (This is a simple intersect table.)
--
CREATE TABLE MBR_FOLDER_LABELS
(
  ENTRY_ID_P1   NUMERIC(20) NOT NULL,
  ENTRY_ID_P2   NUMERIC(20) NOT NULL,
  LABEL_ID_P1   NUMERIC(20) NOT NULL,
  LABEL_ID_P2   NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The ITEM_LABELS table maintains the relationships between the ITEMS and the LABELs; that is, the labels that have been applied to each of the item versions. (This is a simple intersect table.)', N'user', @table_owner, N'table', N'MBR_FOLDER_LABELS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the folder''s UUID.', N'user', @table_owner, N'table', N'MBR_FOLDER_LABELS', N'column', N'ENTRY_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the folder''s UUID.', N'user', @table_owner, N'table', N'MBR_FOLDER_LABELS', N'column', N'ENTRY_ID_P2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the label''s UUID.', N'user', @table_owner, N'table', N'MBR_FOLDER_LABELS', N'column', N'LABEL_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the label''s UUID.', N'user', @table_owner, N'table', N'MBR_FOLDER_LABELS', N'column', N'LABEL_ID_P2'
GO

CREATE TABLE MBR_ITEM_TYPES
(
  ITEM_TYPE_CODE   NUMERIC(10) NOT NULL,
  ITEM_TYPE_NM     VARCHAR(20) NOT NULL
)
GO

CREATE TABLE MBR_POLICIES
(
  POLICY_NAME     VARCHAR(250) NOT NULL,
  CREATION_DATE   VARCHAR(50),
  CHANGE_DATE     VARCHAR(50),
  GRANTOR         VARCHAR(32)
)
GO

CREATE TABLE MBR_POL_PERMS
(
  ENTRY_ID_P1   NUMERIC(20) NOT NULL,
  ENTRY_ID_P2   NUMERIC(20) NOT NULL,
  POLICY_NAME   VARCHAR(250) NOT NULL,
  CREATE_BIT    CHAR(1) NOT NULL,
  READ_BIT      CHAR(1) NOT NULL,
  UPDATE_BIT    CHAR(1) NOT NULL,
  DELETE_BIT    CHAR(1) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 1 of the entry''s UUID.', N'user', @table_owner, N'table', N'MBR_POL_PERMS', N'column', N'ENTRY_ID_P1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'Part 2 of the entry''s UUID.', N'user', @table_owner, N'table', N'MBR_POL_PERMS', N'column', N'ENTRY_ID_P2'
GO

CREATE TABLE MBR_POL_USERS
(
  POLICY_NAME   VARCHAR(250) NOT NULL,
  USER_NAME     VARCHAR(80) NOT NULL
)
GO

CREATE UNIQUE INDEX MBR_ENT_NM_PNT_IX ON MBR_ENTRIES (UPPER_ENTRY_NAME,PARENT_ENTRY_ID_P1,PARENT_ENTRY_ID_P2)
GO

CREATE INDEX MBR_ITEMS_ID_IX ON MBR_ITEMS (ITEM_ID_P1,ITEM_ID_P2)
GO

CREATE INDEX MBR_ENT_PARNT_IX ON MBR_ENTRIES (PARENT_ENTRY_ID_P1)
GO

CREATE INDEX MBR_ENT_NM_IX ON MBR_ENTRIES (UPPER_ENTRY_NAME)
GO

ALTER TABLE MBR_ITEMS
  ADD CONSTRAINT PK_ITEMS
    PRIMARY KEY (ITEM_ID_P1,ITEM_ID_P2,ITEM_VERSION)
GO

ALTER TABLE MBR_ITEM_CONTENTS
  ADD CONSTRAINT PK_ITEM_CONTENTS
    PRIMARY KEY (ITEM_ID_P1,ITEM_ID_P2,ITEM_VERSION)
GO

ALTER TABLE MBR_ENTRIES
  ADD CONSTRAINT PK_ENTRIES
    PRIMARY KEY (ENTRY_ID_P1,ENTRY_ID_P2)
GO

ALTER TABLE MBR_LABELS
  ADD CONSTRAINT PK_LABELS
    PRIMARY KEY (LABEL_ID_P1,LABEL_ID_P2)
GO

ALTER TABLE MBR_ITEM_LABELS
  ADD CONSTRAINT PK_ITEM_LABELS
    PRIMARY KEY (ITEM_ID_P1,ITEM_ID_P2,ITEM_VERSION,LABEL_ID_P1,LABEL_ID_P2)
GO

ALTER TABLE MBR_FOLDER_LABELS
  ADD CONSTRAINT PK_FOLDER_LABELS
    PRIMARY KEY (ENTRY_ID_P1,ENTRY_ID_P2,LABEL_ID_P1,LABEL_ID_P2)
GO

ALTER TABLE MBR_POLICIES
  ADD CONSTRAINT PK_POLICIES
    PRIMARY KEY (POLICY_NAME)
GO

ALTER TABLE MBR_POL_PERMS
  ADD CONSTRAINT PK_POL_PERMS
    PRIMARY KEY (ENTRY_ID_P1,ENTRY_ID_P2,POLICY_NAME)
GO

ALTER TABLE MBR_POL_USERS
  ADD CONSTRAINT PK_POL_USERS
    PRIMARY KEY (POLICY_NAME,USER_NAME)
GO

-- (generated from DtcBase/ObjectIndex)

CREATE TABLE DD_INDEX
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  NME                  VARCHAR(1000),
  DETAIL_TBLE_NME      VARCHAR(20) NOT NULL,
  VIRT_DETL_TBLE_NME   VARCHAR(128) NOT NULL,
  MDL_LGCL_ID          VARCHAR(1000),
  MDL_UUID1            NUMERIC(20) NOT NULL,
  MDL_UUID2            NUMERIC(20) NOT NULL,
  MDL_UUID_STRING      VARCHAR(44) NOT NULL,
  MTACLS_TYPE_ID       NUMERIC(19) NOT NULL,
  PARENT_LGCL_ID       VARCHAR(1000),
  PARENT_UUID1         NUMERIC(20),
  PARENT_UUID2         NUMERIC(20),
  PARENT_UUID_STRING   VARCHAR(44),
  TXN_ID               NUMERIC(19) NOT NULL
)
GO

-- (generated from DtcBase/Models)

CREATE TABLE DD_MDL
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NME           VARCHAR(128) NOT NULL,
  TXN_ID        NUMERIC(19) NOT NULL,
  VRSION        VARCHAR(20) NOT NULL
)
GO

-- (generated from DtcBase/Metaclasses)

CREATE TABLE DD_MTACLS_TYPE
(
  ID           NUMERIC(19) NOT NULL,
  MTACLS_URI   VARCHAR(300) NOT NULL,
  MTAMDL_ID    NUMERIC(19) NOT NULL,
  DSPLY_NME    VARCHAR(128) NOT NULL
)
GO

-- (generated from DtcBase/Metamodels)

CREATE TABLE DD_MTAMDL
(
  ID          NUMERIC(19) NOT NULL,
  URI         VARCHAR(256) NOT NULL,
  DSPLY_NME   VARCHAR(128) NOT NULL
)
GO

-- (generated from DtcBase/TransactionLog)

CREATE TABLE DD_TXN_LOG
(
  ID          NUMERIC(19) NOT NULL,
  USER_NME    VARCHAR(128),
  BEGIN_TXN   VARCHAR(50),
  END_TXN     VARCHAR(50),
  ACTION      VARCHAR(128),
  TXN_STATE   NUMERIC(6)
)
GO

-- (generated from DtcBase/Relationships)

CREATE TABLE DD_RELATIONSHIPS
(
  REFERRER_LGCL_ID       VARCHAR(1000),
  REFERRER_UUID1         NUMERIC(20) NOT NULL,
  REFERRER_UUID2         NUMERIC(20) NOT NULL,
  REFERRER_UUID_STRING   VARCHAR(44) NOT NULL,
  REFEREE_LGCL_ID        VARCHAR(1000),
  REFEREE_UUID1          NUMERIC(20) NOT NULL,
  REFEREE_UUID2          NUMERIC(20) NOT NULL,
  REFEREE_UUID_STRING    VARCHAR(44) NOT NULL,
  REFEREE_POSITION       NUMERIC(10) NOT NULL,
  REL_FTRE_ID            NUMERIC(19) NOT NULL,
  TXN_ID                 NUMERIC(19) NOT NULL
)
GO

-- (generated from DtcBase/ModelMtamdlIntersect)

CREATE TABLE DD_MDL_MTAMDL
(
  MDL_LGCL_ID       VARCHAR(1000),
  MDL_UUID1         NUMERIC(20) NOT NULL,
  MDL_UUID2         NUMERIC(20) NOT NULL,
  MDL_UUID_STRING   VARCHAR(44) NOT NULL,
  MTAMDL_ID         NUMERIC(19) NOT NULL,
  TXN_ID            NUMERIC(19) NOT NULL
)
GO

-- (generated from DtcBase/MetaclassFeatures)

CREATE TABLE DD_FTRE
(
  ID                NUMERIC(19) NOT NULL,
  MTACLS_FTRE_URI   VARCHAR(300) NOT NULL,
  MTACLS_TYPE_ID    NUMERIC(19) NOT NULL,
  MTAMDL_ID         NUMERIC(19) NOT NULL
)
GO

-- (generated from DtcBase/TransactionStates)

CREATE TABLE DD_TXN_STATES
(
  ID      NUMERIC(6) NOT NULL,
  STATE   VARCHAR(128) NOT NULL
)
GO

--
-- The model class name for the set enumeration values held in this table is: PushDownType
-- (generated from Function/PushDownType)

CREATE TABLE DD_METM_PUSHDWNTYP
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: PushDownType', N'user', @table_owner, N'table', N'DD_METM_PUSHDWNTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_METM_PUSHDWNTYP', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_METM_PUSHDWNTYP', N'column', N'VALUE'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ScalarFunction
-- (generated from Function/ScalarFunction)

CREATE TABLE DD_METM_SCALRFNCTN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  CATGRY        VARCHAR(256),
  PUSHDWN       NUMERIC(20),
  INVCTNCLSS    VARCHAR(256),
  INVCTNMTHD    VARCHAR(256),
  DETRMNSTC     CHAR(1),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ScalarFunction', N'user', @table_owner, N'table', N'DD_METM_SCALRFNCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_METM_SCALRFNCTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_METM_SCALRFNCTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_METM_SCALRFNCTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_METM_SCALRFNCTN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: category', N'user', @table_owner, N'table', N'DD_METM_SCALRFNCTN', N'column', N'CATGRY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: pushDown', N'user', @table_owner, N'table', N'DD_METM_SCALRFNCTN', N'column', N'PUSHDWN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: invocationClass', N'user', @table_owner, N'table', N'DD_METM_SCALRFNCTN', N'column', N'INVCTNCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: invocationMethod', N'user', @table_owner, N'table', N'DD_METM_SCALRFNCTN', N'column', N'INVCTNMTHD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: deterministic', N'user', @table_owner, N'table', N'DD_METM_SCALRFNCTN', N'column', N'DETRMNSTC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: FunctionParameter
-- (generated from Function/FunctionParameter)

CREATE TABLE DD_METM_FUNCTNPRMT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  TYP           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: FunctionParameter', N'user', @table_owner, N'table', N'DD_METM_FUNCTNPRMT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_METM_FUNCTNPRMT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_METM_FUNCTNPRMT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_METM_FUNCTNPRMT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_METM_FUNCTNPRMT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_METM_FUNCTNPRMT', N'column', N'TYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ReturnParameter
-- (generated from Function/ReturnParameter)

CREATE TABLE DD_METM_RETRNPRMTR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TYP           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ReturnParameter', N'user', @table_owner, N'table', N'DD_METM_RETRNPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_METM_RETRNPRMTR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_METM_RETRNPRMTR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_METM_RETRNPRMTR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_METM_RETRNPRMTR', N'column', N'TYP'
GO

--
-- The model class name for the set enumeration values held in this table is: Severity
-- (generated from Manifest/Severity)

CREATE TABLE DD_VIRT_SEVRTY
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: Severity', N'user', @table_owner, N'table', N'DD_VIRT_SEVRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_VIRT_SEVRTY', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_VIRT_SEVRTY', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: ModelAccessibility
-- (generated from Manifest/ModelAccessibility)

CREATE TABLE DD_VIRT_MODLCCSSBL
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: ModelAccessibility', N'user', @table_owner, N'table', N'DD_VIRT_MODLCCSSBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_VIRT_MODLCCSSBL', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_VIRT_MODLCCSSBL', N'column', N'VALUE'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: VirtualDatabase
-- (generated from Manifest/VirtualDatabase)

CREATE TABLE DD_VIRT_VIRTLDTBS
(
  LGCL_ID          VARCHAR(1000),
  UUID1            NUMERIC(20) NOT NULL,
  UUID2            NUMERIC(20) NOT NULL,
  UUID_STRING      VARCHAR(44) NOT NULL,
  SEVRTY           NUMERIC(20),
  NAM              VARCHAR(256),
  IDENTFR          VARCHAR(256),
  UUID             VARCHAR(256),
  DESCRPTN         TEXT,
  VERSN            VARCHAR(256),
  PROVDR           VARCHAR(256),
  TIMLSTCHNGD      VARCHAR(256),
  TIMLSTPRDCD      VARCHAR(256),
  TIMLSTCHNGDSDT   VARCHAR(128),
  TIMLSTPRDCDSDT   VARCHAR(128),
  PRODCRNM         VARCHAR(256),
  PRODCRVRSN       VARCHAR(256),
  INCLDMDLFLS      CHAR(1),
  TXN_ID           NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: VirtualDatabase', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: severity', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'SEVRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: identifier', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'IDENTFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uuid', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'UUID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: description', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'DESCRPTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: version', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'VERSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: provider', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'PROVDR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: timeLastChanged', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'TIMLSTCHNGD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: timeLastProduced', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'TIMLSTPRDCD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: timeLastChangedAsDate', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'TIMLSTCHNGDSDT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: timeLastProducedAsDate', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'TIMLSTPRDCDSDT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: producerName', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'PRODCRNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: producerVersion', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'PRODCRVRSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: includeModelFiles', N'user', @table_owner, N'table', N'DD_VIRT_VIRTLDTBS', N'column', N'INCLDMDLFLS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ModelReference
-- (generated from Manifest/ModelReference)

CREATE TABLE DD_VIRT_MODLRFRNC
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  NAM                  VARCHAR(256),
  PATH                 VARCHAR(256),
  MODLLCTN             VARCHAR(256),
  UUID                 VARCHAR(256),
  MODLTYP              NUMERIC(20),
  PRIMRYMTMDLR         VARCHAR(256),
  SEVRTY               NUMERIC(20),
  VERSN                VARCHAR(256),
  URI                  VARCHAR(512),
  VISBL                CHAR(1),
  ACCSSBLTY            NUMERIC(20),
  TIMLSTSYNCHRNZD      VARCHAR(256),
  TIMLSTSYNCHRNZDSDT   VARCHAR(256),
  CHECKSM              NUMERIC(20),
  USES                 NUMERIC(20),
  USEDBY               NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ModelReference', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: path', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'PATH'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: modelLocation', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'MODLLCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uuid', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'UUID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: modelType', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'MODLTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: primaryMetamodelUri', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'PRIMRYMTMDLR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: severity', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'SEVRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: version', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'VERSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uri', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visible', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'VISBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: accessibility', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'ACCSSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: timeLastSynchronized', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'TIMLSTSYNCHRNZD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: timeLastSynchronizedAsDate', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'TIMLSTSYNCHRNZDSDT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: checksum', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'CHECKSM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uses', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'USES'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: usedBy', N'user', @table_owner, N'table', N'DD_VIRT_MODLRFRNC', N'column', N'USEDBY'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ProblemMarker
-- (generated from Manifest/ProblemMarker)

CREATE TABLE DD_VIRT_PROBLMMRKR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  SEVRTY        NUMERIC(20),
  MESSG         VARCHAR(256),
  TARGT         VARCHAR(256),
  TARGTR        VARCHAR(256),
  COD           NUMERIC(20),
  STACKTRC      TEXT,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ProblemMarker', N'user', @table_owner, N'table', N'DD_VIRT_PROBLMMRKR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_PROBLMMRKR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_PROBLMMRKR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_VIRT_PROBLMMRKR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: severity', N'user', @table_owner, N'table', N'DD_VIRT_PROBLMMRKR', N'column', N'SEVRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: message', N'user', @table_owner, N'table', N'DD_VIRT_PROBLMMRKR', N'column', N'MESSG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_VIRT_PROBLMMRKR', N'column', N'TARGT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetUri', N'user', @table_owner, N'table', N'DD_VIRT_PROBLMMRKR', N'column', N'TARGTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: code', N'user', @table_owner, N'table', N'DD_VIRT_PROBLMMRKR', N'column', N'COD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: stackTrace', N'user', @table_owner, N'table', N'DD_VIRT_PROBLMMRKR', N'column', N'STACKTRC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ModelSource
-- (generated from Manifest/ModelSource)

CREATE TABLE DD_VIRT_MODLSRC
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ModelSource', N'user', @table_owner, N'table', N'DD_VIRT_MODLSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_MODLSRC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_MODLSRC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_VIRT_MODLSRC', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ModelSourceProperty
-- (generated from Manifest/ModelSourceProperty)

CREATE TABLE DD_VIRT_MODLSRCPRP
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  VAL           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ModelSourceProperty', N'user', @table_owner, N'table', N'DD_VIRT_MODLSRCPRP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_MODLSRCPRP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_MODLSRCPRP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_VIRT_MODLSRCPRP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_VIRT_MODLSRCPRP', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_VIRT_MODLSRCPRP', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: WsdlOptions
-- (generated from Manifest/WsdlOptions)

CREATE TABLE DD_VIRT_WSDLPTNS
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TARGTNMSPCR   VARCHAR(256),
  DEFLTNMSPCR   VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: WsdlOptions', N'user', @table_owner, N'table', N'DD_VIRT_WSDLPTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_WSDLPTNS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_WSDLPTNS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_VIRT_WSDLPTNS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetNamespaceUri', N'user', @table_owner, N'table', N'DD_VIRT_WSDLPTNS', N'column', N'TARGTNMSPCR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultNamespaceUri', N'user', @table_owner, N'table', N'DD_VIRT_WSDLPTNS', N'column', N'DEFLTNMSPCR'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: NonModelReference
-- (generated from Manifest/NonModelReference)

CREATE TABLE DD_VIRT_NONMDLRFRN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  PATH          VARCHAR(256),
  CHECKSM       NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: NonModelReference', N'user', @table_owner, N'table', N'DD_VIRT_NONMDLRFRN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_NONMDLRFRN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_VIRT_NONMDLRFRN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_VIRT_NONMDLRFRN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_VIRT_NONMDLRFRN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: path', N'user', @table_owner, N'table', N'DD_VIRT_NONMDLRFRN', N'column', N'PATH'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: checksum', N'user', @table_owner, N'table', N'DD_VIRT_NONMDLRFRN', N'column', N'CHECKSM'
GO

--
-- The model class name for the set enumeration values held in this table is: SoapEncoding
-- (generated from Xml/SoapEncoding)

CREATE TABLE DD_XMLD_SOAPNCDNG
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: SoapEncoding', N'user', @table_owner, N'table', N'DD_XMLD_SOAPNCDNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XMLD_SOAPNCDNG', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XMLD_SOAPNCDNG', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: ChoiceErrorMode
-- (generated from Xml/ChoiceErrorMode)

CREATE TABLE DD_XMLD_CHOCRRRMD
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: ChoiceErrorMode', N'user', @table_owner, N'table', N'DD_XMLD_CHOCRRRMD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XMLD_CHOCRRRMD', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XMLD_CHOCRRRMD', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: ValueType
-- (generated from Xml/ValueType)

CREATE TABLE DD_XMLD_VALTYP
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: ValueType', N'user', @table_owner, N'table', N'DD_XMLD_VALTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XMLD_VALTYP', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XMLD_VALTYP', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: BuildStatus
-- (generated from Xml/BuildStatus)

CREATE TABLE DD_XMLD_BUILDSTTS
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: BuildStatus', N'user', @table_owner, N'table', N'DD_XMLD_BUILDSTTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XMLD_BUILDSTTS', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XMLD_BUILDSTTS', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: NormalizationType
-- (generated from Xml/NormalizationType)

CREATE TABLE DD_XMLD_NORMLZTNTY
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: NormalizationType', N'user', @table_owner, N'table', N'DD_XMLD_NORMLZTNTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XMLD_NORMLZTNTY', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XMLD_NORMLZTNTY', N'column', N'VALUE'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlFragment
-- (generated from Xml/XmlFragment)

CREATE TABLE DD_XMLD_XMLFRGMNT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlFragment', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNT', N'column', N'NAM'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlDocument
-- (generated from Xml/XmlDocument)

CREATE TABLE DD_XMLD_XMLDCMNT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  ENCDNG        VARCHAR(256),
  FORMTTD       CHAR(1),
  VERSN         VARCHAR(256),
  STANDLN       CHAR(1),
  SOAPNCDNG     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlDocument', N'user', @table_owner, N'table', N'DD_XMLD_XMLDCMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLDCMNT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLDCMNT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLDCMNT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XMLD_XMLDCMNT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: encoding', N'user', @table_owner, N'table', N'DD_XMLD_XMLDCMNT', N'column', N'ENCDNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: formatted', N'user', @table_owner, N'table', N'DD_XMLD_XMLDCMNT', N'column', N'FORMTTD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: version', N'user', @table_owner, N'table', N'DD_XMLD_XMLDCMNT', N'column', N'VERSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: standalone', N'user', @table_owner, N'table', N'DD_XMLD_XMLDCMNT', N'column', N'STANDLN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: soapEncoding', N'user', @table_owner, N'table', N'DD_XMLD_XMLDCMNT', N'column', N'SOAPNCDNG'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlElement
-- (generated from Xml/XmlElement)

CREATE TABLE DD_XMLD_XMLLMNT
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  BUILDSTT        NUMERIC(20),
  NAM             VARCHAR(256),
  EXCLDFRMDCMNT   CHAR(1),
  MINCCRS         NUMERIC(20),
  MAXCCRS         NUMERIC(20),
  XSDCMPNNT       NUMERIC(20),
  NAMSPC          NUMERIC(20),
  CHOCCRTR        VARCHAR(256),
  CHOCRDR         NUMERIC(20),
  DEFLTFR         NUMERIC(20),
  VAL             VARCHAR(256),
  VALTYP          NUMERIC(20),
  RECRSV          CHAR(1),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlElement', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: buildState', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'BUILDSTT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: excludeFromDocument', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'EXCLDFRMDCMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'MINCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'MAXCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: xsdComponent', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'XSDCMPNNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: namespace', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'NAMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceCriteria', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'CHOCCRTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceOrder', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'CHOCRDR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultFor', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'DEFLTFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: valueType', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'VALTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursive', N'user', @table_owner, N'table', N'DD_XMLD_XMLLMNT', N'column', N'RECRSV'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlAttribute
-- (generated from Xml/XmlAttribute)

CREATE TABLE DD_XMLD_XMLTTRBT
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  BUILDSTT        NUMERIC(20),
  NAM             VARCHAR(256),
  EXCLDFRMDCMNT   CHAR(1),
  MINCCRS         NUMERIC(20),
  MAXCCRS         NUMERIC(20),
  XSDCMPNNT       NUMERIC(20),
  NAMSPC          NUMERIC(20),
  VAL             VARCHAR(256),
  VALTYP          NUMERIC(20),
  USE1            NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlAttribute', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: buildState', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'BUILDSTT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: excludeFromDocument', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'EXCLDFRMDCMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'MINCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'MAXCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: xsdComponent', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'XSDCMPNNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: namespace', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'NAMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: valueType', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'VALTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: use', N'user', @table_owner, N'table', N'DD_XMLD_XMLTTRBT', N'column', N'USE1'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlRoot
-- (generated from Xml/XmlRoot)

CREATE TABLE DD_XMLD_XMLRT
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  BUILDSTT        NUMERIC(20),
  NAM             VARCHAR(256),
  EXCLDFRMDCMNT   CHAR(1),
  MINCCRS         NUMERIC(20),
  MAXCCRS         NUMERIC(20),
  XSDCMPNNT       NUMERIC(20),
  NAMSPC          NUMERIC(20),
  CHOCCRTR        VARCHAR(256),
  CHOCRDR         NUMERIC(20),
  DEFLTFR         NUMERIC(20),
  VAL             VARCHAR(256),
  VALTYP          NUMERIC(20),
  RECRSV          CHAR(1),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlRoot', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: buildState', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'BUILDSTT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: excludeFromDocument', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'EXCLDFRMDCMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'MINCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'MAXCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: xsdComponent', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'XSDCMPNNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: namespace', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'NAMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceCriteria', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'CHOCCRTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceOrder', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'CHOCRDR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultFor', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'DEFLTFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: valueType', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'VALTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursive', N'user', @table_owner, N'table', N'DD_XMLD_XMLRT', N'column', N'RECRSV'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlComment
-- (generated from Xml/XmlComment)

CREATE TABLE DD_XMLD_XMLCMMNT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TEXT          VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlComment', N'user', @table_owner, N'table', N'DD_XMLD_XMLCMMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLCMMNT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLCMMNT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLCMMNT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: text', N'user', @table_owner, N'table', N'DD_XMLD_XMLCMMNT', N'column', N'TEXT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlNamespace
-- (generated from Xml/XmlNamespace)

CREATE TABLE DD_XMLD_XMLNMSPC
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  PREFX         VARCHAR(256),
  URI           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlNamespace', N'user', @table_owner, N'table', N'DD_XMLD_XMLNMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLNMSPC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLNMSPC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLNMSPC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: prefix', N'user', @table_owner, N'table', N'DD_XMLD_XMLNMSPC', N'column', N'PREFX'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uri', N'user', @table_owner, N'table', N'DD_XMLD_XMLNMSPC', N'column', N'URI'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlSequence
-- (generated from Xml/XmlSequence)

CREATE TABLE DD_XMLD_XMLSQNC
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  CHOCCRTR        VARCHAR(256),
  CHOCRDR         NUMERIC(20),
  DEFLTFR         NUMERIC(20),
  BUILDSTT        NUMERIC(20),
  EXCLDFRMDCMNT   CHAR(1),
  MINCCRS         NUMERIC(20),
  MAXCCRS         NUMERIC(20),
  XSDCMPNNT       NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlSequence', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceCriteria', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'CHOCCRTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceOrder', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'CHOCRDR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultFor', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'DEFLTFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: buildState', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'BUILDSTT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: excludeFromDocument', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'EXCLDFRMDCMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'MINCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'MAXCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: xsdComponent', N'user', @table_owner, N'table', N'DD_XMLD_XMLSQNC', N'column', N'XSDCMPNNT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlAll
-- (generated from Xml/XmlAll)

CREATE TABLE DD_XMLD_XMLLL
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  CHOCCRTR        VARCHAR(256),
  CHOCRDR         NUMERIC(20),
  DEFLTFR         NUMERIC(20),
  BUILDSTT        NUMERIC(20),
  EXCLDFRMDCMNT   CHAR(1),
  MINCCRS         NUMERIC(20),
  MAXCCRS         NUMERIC(20),
  XSDCMPNNT       NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlAll', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceCriteria', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'CHOCCRTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceOrder', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'CHOCRDR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultFor', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'DEFLTFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: buildState', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'BUILDSTT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: excludeFromDocument', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'EXCLDFRMDCMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'MINCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'MAXCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: xsdComponent', N'user', @table_owner, N'table', N'DD_XMLD_XMLLL', N'column', N'XSDCMPNNT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlChoice
-- (generated from Xml/XmlChoice)

CREATE TABLE DD_XMLD_XMLCHC
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  CHOCCRTR        VARCHAR(256),
  CHOCRDR         NUMERIC(20),
  DEFLTFR         NUMERIC(20),
  BUILDSTT        NUMERIC(20),
  EXCLDFRMDCMNT   CHAR(1),
  MINCCRS         NUMERIC(20),
  MAXCCRS         NUMERIC(20),
  XSDCMPNNT       NUMERIC(20),
  DEFLTRRRMD      NUMERIC(20),
  DEFLTPTN        NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlChoice', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceCriteria', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'CHOCCRTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceOrder', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'CHOCRDR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultFor', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'DEFLTFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: buildState', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'BUILDSTT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: excludeFromDocument', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'EXCLDFRMDCMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'MINCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'MAXCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: xsdComponent', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'XSDCMPNNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultErrorMode', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'DEFLTRRRMD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultOption', N'user', @table_owner, N'table', N'DD_XMLD_XMLCHC', N'column', N'DEFLTPTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ProcessingInstruction
-- (generated from Xml/ProcessingInstruction)

CREATE TABLE DD_XMLD_PROCSSNGNS
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  RAWTXT        VARCHAR(256),
  TARGT         VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ProcessingInstruction', N'user', @table_owner, N'table', N'DD_XMLD_PROCSSNGNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_PROCSSNGNS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_PROCSSNGNS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_PROCSSNGNS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rawText', N'user', @table_owner, N'table', N'DD_XMLD_PROCSSNGNS', N'column', N'RAWTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_XMLD_PROCSSNGNS', N'column', N'TARGT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XmlFragmentUse
-- (generated from Xml/XmlFragmentUse)

CREATE TABLE DD_XMLD_XMLFRGMNTS
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  BUILDSTT        NUMERIC(20),
  NAM             VARCHAR(256),
  EXCLDFRMDCMNT   CHAR(1),
  MINCCRS         NUMERIC(20),
  MAXCCRS         NUMERIC(20),
  XSDCMPNNT       NUMERIC(20),
  NAMSPC          NUMERIC(20),
  CHOCCRTR        VARCHAR(256),
  CHOCRDR         NUMERIC(20),
  DEFLTFR         NUMERIC(20),
  FRAGMNT         NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XmlFragmentUse', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: buildState', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'BUILDSTT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: excludeFromDocument', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'EXCLDFRMDCMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'MINCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxOccurs', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'MAXCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: xsdComponent', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'XSDCMPNNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: namespace', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'NAMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceCriteria', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'CHOCCRTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: choiceOrder', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'CHOCRDR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultFor', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'DEFLTFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fragment', N'user', @table_owner, N'table', N'DD_XMLD_XMLFRGMNTS', N'column', N'FRAGMNT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EAttribute
-- (generated from Ecore/EAttribute)

CREATE TABLE DD_ECOR_EATTRBT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  ORDRD         CHAR(1),
  UNIQ          CHAR(1),
  LOWRBND       NUMERIC(20),
  UPPRBND       NUMERIC(20),
  MANY          CHAR(1),
  REQRD         CHAR(1),
  ETYP          NUMERIC(20),
  CHANGBL       CHAR(1),
  VOLTL         CHAR(1),
  TRANSNT       CHAR(1),
  DEFLTVLLTRL   VARCHAR(256),
  DEFLTVL       VARCHAR(256),
  UNSTTBL       CHAR(1),
  DERVD         CHAR(1),
  ID            CHAR(1),
  EATTRBTTYP    NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EAttribute', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ordered', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'ORDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unique', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'UNIQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lowerBound', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'LOWRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: upperBound', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'UPPRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: many', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'MANY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: required', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'REQRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eType', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'ETYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: changeable', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'CHANGBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: volatile', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'VOLTL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: transient', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'TRANSNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValueLiteral', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'DEFLTVLLTRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unsettable', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'UNSTTBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: derived', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'DERVD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: iD', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAttributeType', N'user', @table_owner, N'table', N'DD_ECOR_EATTRBT', N'column', N'EATTRBTTYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EAnnotation
-- (generated from Ecore/EAnnotation)

CREATE TABLE DD_ECOR_EANNTTN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  SOURC         VARCHAR(256),
  REFRNCS       NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EAnnotation', N'user', @table_owner, N'table', N'DD_ECOR_EANNTTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EANNTTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EANNTTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EANNTTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: source', N'user', @table_owner, N'table', N'DD_ECOR_EANNTTN', N'column', N'SOURC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: references', N'user', @table_owner, N'table', N'DD_ECOR_EANNTTN', N'column', N'REFRNCS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EClass
-- (generated from Ecore/EClass)

CREATE TABLE DD_ECOR_ECLSS
(
  LGCL_ID           VARCHAR(1000),
  UUID1             NUMERIC(20) NOT NULL,
  UUID2             NUMERIC(20) NOT NULL,
  UUID_STRING       VARCHAR(44) NOT NULL,
  NAM               VARCHAR(256),
  INSTNCCLSSNM      VARCHAR(256),
  INSTNCCLSS        VARCHAR(256),
  DEFLTVL           VARCHAR(256),
  ABSTRCT           CHAR(1),
  INTRFC            CHAR(1),
  ESUPRTYPS         NUMERIC(20),
  EALLTTRBTS        NUMERIC(20),
  EALLRFRNCS        NUMERIC(20),
  EREFRNCS          NUMERIC(20),
  EATTRBTS          NUMERIC(20),
  EALLCNTNMNTS      NUMERIC(20),
  EALLPRTNS         NUMERIC(20),
  EALLSTRCTRLFTRS   NUMERIC(20),
  EALLSPRTYPS       NUMERIC(20),
  EIDTTRBT          NUMERIC(20),
  TXN_ID            NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EClass', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instanceClassName', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'INSTNCCLSSNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instanceClass', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'INSTNCCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: abstract', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'ABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: interface', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'INTRFC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eSuperTypes', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'ESUPRTYPS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllAttributes', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'EALLTTRBTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllReferences', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'EALLRFRNCS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eReferences', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'EREFRNCS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAttributes', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'EATTRBTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllContainments', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'EALLCNTNMNTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllOperations', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'EALLPRTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllStructuralFeatures', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'EALLSTRCTRLFTRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllSuperTypes', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'EALLSPRTYPS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eIDAttribute', N'user', @table_owner, N'table', N'DD_ECOR_ECLSS', N'column', N'EIDTTRBT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EDataType
-- (generated from Ecore/EDataType)

CREATE TABLE DD_ECOR_EDATTYP
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  NAM            VARCHAR(256),
  INSTNCCLSSNM   VARCHAR(256),
  INSTNCCLSS     VARCHAR(256),
  DEFLTVL        VARCHAR(256),
  SERLZBL        CHAR(1),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EDataType', N'user', @table_owner, N'table', N'DD_ECOR_EDATTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EDATTYP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EDATTYP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EDATTYP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_ECOR_EDATTYP', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instanceClassName', N'user', @table_owner, N'table', N'DD_ECOR_EDATTYP', N'column', N'INSTNCCLSSNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instanceClass', N'user', @table_owner, N'table', N'DD_ECOR_EDATTYP', N'column', N'INSTNCCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_ECOR_EDATTYP', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: serializable', N'user', @table_owner, N'table', N'DD_ECOR_EDATTYP', N'column', N'SERLZBL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EEnum
-- (generated from Ecore/EEnum)

CREATE TABLE DD_ECOR_EENM
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  NAM            VARCHAR(256),
  INSTNCCLSSNM   VARCHAR(256),
  INSTNCCLSS     VARCHAR(256),
  DEFLTVL        VARCHAR(256),
  SERLZBL        CHAR(1),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EEnum', N'user', @table_owner, N'table', N'DD_ECOR_EENM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EENM', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EENM', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EENM', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_ECOR_EENM', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instanceClassName', N'user', @table_owner, N'table', N'DD_ECOR_EENM', N'column', N'INSTNCCLSSNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instanceClass', N'user', @table_owner, N'table', N'DD_ECOR_EENM', N'column', N'INSTNCCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_ECOR_EENM', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: serializable', N'user', @table_owner, N'table', N'DD_ECOR_EENM', N'column', N'SERLZBL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EEnumLiteral
-- (generated from Ecore/EEnumLiteral)

CREATE TABLE DD_ECOR_EENMLTRL
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  VAL           NUMERIC(20),
  INSTNC        VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EEnumLiteral', N'user', @table_owner, N'table', N'DD_ECOR_EENMLTRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EENMLTRL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EENMLTRL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EENMLTRL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_ECOR_EENMLTRL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_ECOR_EENMLTRL', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instance', N'user', @table_owner, N'table', N'DD_ECOR_EENMLTRL', N'column', N'INSTNC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EFactory
-- (generated from Ecore/EFactory)

CREATE TABLE DD_ECOR_EFACTRY
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  EPACKG        NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EFactory', N'user', @table_owner, N'table', N'DD_ECOR_EFACTRY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EFACTRY', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EFACTRY', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EFACTRY', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ePackage', N'user', @table_owner, N'table', N'DD_ECOR_EFACTRY', N'column', N'EPACKG'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EObject
-- (generated from Ecore/EObject)

CREATE TABLE DD_ECOR_EOBJCT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EObject', N'user', @table_owner, N'table', N'DD_ECOR_EOBJCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EOBJCT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EOBJCT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EOBJCT', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EOperation
-- (generated from Ecore/EOperation)

CREATE TABLE DD_ECOR_EOPRTN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  ORDRD         CHAR(1),
  UNIQ          CHAR(1),
  LOWRBND       NUMERIC(20),
  UPPRBND       NUMERIC(20),
  MANY          CHAR(1),
  REQRD         CHAR(1),
  ETYP          NUMERIC(20),
  EEXCPTNS      NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EOperation', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ordered', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'ORDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unique', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'UNIQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lowerBound', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'LOWRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: upperBound', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'UPPRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: many', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'MANY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: required', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'REQRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eType', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'ETYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eExceptions', N'user', @table_owner, N'table', N'DD_ECOR_EOPRTN', N'column', N'EEXCPTNS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EPackage
-- (generated from Ecore/EPackage)

CREATE TABLE DD_ECOR_EPACKG
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  NAM            VARCHAR(256),
  NSUR           VARCHAR(256),
  NSPRFX         VARCHAR(256),
  EFACTRYNSTNC   NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EPackage', N'user', @table_owner, N'table', N'DD_ECOR_EPACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EPACKG', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EPACKG', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EPACKG', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_ECOR_EPACKG', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nsURI', N'user', @table_owner, N'table', N'DD_ECOR_EPACKG', N'column', N'NSUR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nsPrefix', N'user', @table_owner, N'table', N'DD_ECOR_EPACKG', N'column', N'NSPRFX'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eFactoryInstance', N'user', @table_owner, N'table', N'DD_ECOR_EPACKG', N'column', N'EFACTRYNSTNC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EParameter
-- (generated from Ecore/EParameter)

CREATE TABLE DD_ECOR_EPARMTR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  ORDRD         CHAR(1),
  UNIQ          CHAR(1),
  LOWRBND       NUMERIC(20),
  UPPRBND       NUMERIC(20),
  MANY          CHAR(1),
  REQRD         CHAR(1),
  ETYP          NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EParameter', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ordered', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'ORDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unique', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'UNIQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lowerBound', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'LOWRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: upperBound', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'UPPRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: many', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'MANY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: required', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'REQRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eType', N'user', @table_owner, N'table', N'DD_ECOR_EPARMTR', N'column', N'ETYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EReference
-- (generated from Ecore/EReference)

CREATE TABLE DD_ECOR_EREFRNC
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  ORDRD         CHAR(1),
  UNIQ          CHAR(1),
  LOWRBND       NUMERIC(20),
  UPPRBND       NUMERIC(20),
  MANY          CHAR(1),
  REQRD         CHAR(1),
  ETYP          NUMERIC(20),
  CHANGBL       CHAR(1),
  VOLTL         CHAR(1),
  TRANSNT       CHAR(1),
  DEFLTVLLTRL   VARCHAR(256),
  DEFLTVL       VARCHAR(256),
  UNSTTBL       CHAR(1),
  DERVD         CHAR(1),
  CONTNMNT      CHAR(1),
  CONTNR        CHAR(1),
  RESLVPRXS     CHAR(1),
  EOPPST        NUMERIC(20),
  EREFRNCTYP    NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EReference', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ordered', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'ORDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unique', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'UNIQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lowerBound', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'LOWRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: upperBound', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'UPPRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: many', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'MANY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: required', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'REQRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eType', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'ETYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: changeable', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'CHANGBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: volatile', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'VOLTL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: transient', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'TRANSNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValueLiteral', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'DEFLTVLLTRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unsettable', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'UNSTTBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: derived', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'DERVD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: containment', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'CONTNMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolveProxies', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'RESLVPRXS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eOpposite', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'EOPPST'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eReferenceType', N'user', @table_owner, N'table', N'DD_ECOR_EREFRNC', N'column', N'EREFRNCTYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EStringToStringMapEntry
-- (generated from Ecore/EStringToStringMapEntry)

CREATE TABLE DD_ECOR_ESTRNGTSTR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  KEY1          VARCHAR(256),
  VAL           TEXT,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EStringToStringMapEntry', N'user', @table_owner, N'table', N'DD_ECOR_ESTRNGTSTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_ESTRNGTSTR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_ECOR_ESTRNGTSTR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_ECOR_ESTRNGTSTR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: key', N'user', @table_owner, N'table', N'DD_ECOR_ESTRNGTSTR', N'column', N'KEY1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_ECOR_ESTRNGTSTR', N'column', N'VAL'
GO

--
-- The model class name for the set enumeration values held in this table is: VisibilityKind
-- (generated from Uml2/VisibilityKind)

CREATE TABLE DD_UML_VISBLTYKND
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: VisibilityKind', N'user', @table_owner, N'table', N'DD_UML_VISBLTYKND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_UML_VISBLTYKND', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_UML_VISBLTYKND', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: ParameterDirectionKind
-- (generated from Uml2/ParameterDirectionKind)

CREATE TABLE DD_UML_PARMTRDRCTN
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: ParameterDirectionKind', N'user', @table_owner, N'table', N'DD_UML_PARMTRDRCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_UML_PARMTRDRCTN', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_UML_PARMTRDRCTN', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: AggregationKind
-- (generated from Uml2/AggregationKind)

CREATE TABLE DD_UML_AGGRGTNKND
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: AggregationKind', N'user', @table_owner, N'table', N'DD_UML_AGGRGTNKND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_UML_AGGRGTNKND', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_UML_AGGRGTNKND', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: CallConcurrencyKind
-- (generated from Uml2/CallConcurrencyKind)

CREATE TABLE DD_UML_CALLCNCRRNC
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: CallConcurrencyKind', N'user', @table_owner, N'table', N'DD_UML_CALLCNCRRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_UML_CALLCNCRRNC', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_UML_CALLCNCRRNC', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: ParameterEffectKind
-- (generated from Uml2/ParameterEffectKind)

CREATE TABLE DD_UML_PARMTRFFCTK
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: ParameterEffectKind', N'user', @table_owner, N'table', N'DD_UML_PARMTRFFCTK'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_UML_PARMTRFFCTK', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_UML_PARMTRFFCTK', N'column', N'VALUE'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Comment
-- (generated from Uml2/Comment)

CREATE TABLE DD_UML_COMMNT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  OWNDLMNT      NUMERIC(20),
  OWNR          NUMERIC(20),
  BODY          VARCHAR(256),
  ANNTTDLMNT    NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Comment', N'user', @table_owner, N'table', N'DD_UML_COMMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_COMMNT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_COMMNT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_COMMNT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_COMMNT', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_COMMNT', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: body', N'user', @table_owner, N'table', N'DD_UML_COMMNT', N'column', N'BODY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: annotatedElement', N'user', @table_owner, N'table', N'DD_UML_COMMNT', N'column', N'ANNTTDLMNT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Class
-- (generated from Uml2/Class)

CREATE TABLE DD_UML_CLASS
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  PACKG                NUMERIC(20),
  REDFNTNCNTXT         NUMERIC(20),
  ISLF                 VARCHAR(256),
  FEATR                NUMERIC(20),
  ISABSTRCT            VARCHAR(256),
  INHRTDMMBR           NUMERIC(20),
  GENRL                NUMERIC(20),
  ATTRBT               NUMERIC(20),
  REDFNDCLSSFR         NUMERIC(20),
  POWRTYPXTNT          NUMERIC(20),
  USECS                NUMERIC(20),
  REPRSNTTN            NUMERIC(20),
  CLASSFRBHVR          NUMERIC(20),
  PART                 NUMERIC(20),
  ROL                  NUMERIC(20),
  SUPRCLSS             NUMERIC(20),
  EXTNSN               NUMERIC(20),
  ISACTV               VARCHAR(256),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Class', N'user', @table_owner, N'table', N'DD_UML_CLASS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: package', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'PACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: feature', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'FEATR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isAbstract', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'ISABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inheritedMember', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'INHRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: general', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'GENRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attribute', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'ATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedClassifier', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'REDFNDCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: powertypeExtent', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'POWRTYPXTNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: useCase', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'USECS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: representation', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'REPRSNTTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: classifierBehavior', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'CLASSFRBHVR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: part', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'PART'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: role', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'ROL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: superClass', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'SUPRCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: extension', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'EXTNSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isActive', N'user', @table_owner, N'table', N'DD_UML_CLASS', N'column', N'ISACTV'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Property
-- (generated from Uml2/Property)

CREATE TABLE DD_UML_PROPRTY
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  OWNDLMNT        NUMERIC(20),
  OWNR            NUMERIC(20),
  NAM             VARCHAR(256),
  QUALFDNM        VARCHAR(256),
  VISBLTY         NUMERIC(20),
  CLINTDPNDNCY    NUMERIC(20),
  REDFNTNCNTXT    NUMERIC(20),
  ISLF            VARCHAR(256),
  FEATRNGCLSSFR   NUMERIC(20),
  ISSTTC          VARCHAR(256),
  TYP             NUMERIC(20),
  ISORDRD         VARCHAR(256),
  ISUNQ           VARCHAR(256),
  LOWR            VARCHAR(256),
  UPPR            VARCHAR(256),
  ISRDNLY         VARCHAR(256),
  TEMPLTPRMTR     NUMERIC(20),
  END1            NUMERIC(20),
  DEPLYDLMNT      NUMERIC(20),
  DEFLT           VARCHAR(256),
  ISCMPST         VARCHAR(256),
  ISDRVD          VARCHAR(256),
  CLASS_          NUMERIC(20),
  OPPST           NUMERIC(20),
  ISDRVDNN        VARCHAR(256),
  REDFNDPRPRTY    NUMERIC(20),
  SUBSTTDPRPRTY   NUMERIC(20),
  ASSCTN          NUMERIC(20),
  AGGRGTN         NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Property', N'user', @table_owner, N'table', N'DD_UML_PROPRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: featuringClassifier', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'FEATRNGCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isStatic', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'ISSTTC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isOrdered', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'ISORDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isUnique', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'ISUNQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lower', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'LOWR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: upper', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'UPPR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isReadOnly', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'ISRDNLY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: end', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'END1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: deployedElement', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'DEPLYDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: default', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'DEFLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isComposite', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'ISCMPST'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isDerived', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'ISDRVD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: class_', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'CLASS_'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: opposite', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'OPPST'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isDerivedUnion', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'ISDRVDNN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedProperty', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'REDFNDPRPRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: subsettedProperty', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'SUBSTTDPRPRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: association', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'ASSCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aggregation', N'user', @table_owner, N'table', N'DD_UML_PROPRTY', N'column', N'AGGRGTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Operation
-- (generated from Uml2/Operation)

CREATE TABLE DD_UML_OPERTN
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  OWNDLMNT        NUMERIC(20),
  OWNR            NUMERIC(20),
  NAM             VARCHAR(256),
  QUALFDNM        VARCHAR(256),
  VISBLTY         NUMERIC(20),
  CLINTDPNDNCY    NUMERIC(20),
  MEMBR           NUMERIC(20),
  IMPRTDMMBR      NUMERIC(20),
  REDFNTNCNTXT    NUMERIC(20),
  ISLF            VARCHAR(256),
  FEATRNGCLSSFR   NUMERIC(20),
  ISSTTC          VARCHAR(256),
  PARMTR          NUMERIC(20),
  RAISDXCPTN      NUMERIC(20),
  ISABSTRCT       VARCHAR(256),
  METHD           NUMERIC(20),
  CONCRRNCY       NUMERIC(20),
  TYP             NUMERIC(20),
  ISORDRD         VARCHAR(256),
  ISUNQ           VARCHAR(256),
  LOWR            VARCHAR(256),
  UPPR            VARCHAR(256),
  TEMPLTPRMTR     NUMERIC(20),
  ISQRY           VARCHAR(256),
  PRECNDTN        NUMERIC(20),
  POSTCNDTN       NUMERIC(20),
  REDFNDPRTN      NUMERIC(20),
  BODYCNDTN       NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Operation', N'user', @table_owner, N'table', N'DD_UML_OPERTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: featuringClassifier', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'FEATRNGCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isStatic', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'ISSTTC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: parameter', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'PARMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: raisedException', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'RAISDXCPTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isAbstract', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'ISABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: method', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'METHD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: concurrency', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'CONCRRNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isOrdered', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'ISORDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isUnique', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'ISUNQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lower', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'LOWR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: upper', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'UPPR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isQuery', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'ISQRY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: precondition', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'PRECNDTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: postcondition', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'POSTCNDTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedOperation', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'REDFNDPRTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: bodyCondition', N'user', @table_owner, N'table', N'DD_UML_OPERTN', N'column', N'BODYCNDTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Parameter
-- (generated from Uml2/Parameter)

CREATE TABLE DD_UML_PARMTR
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  OWNDLMNT       NUMERIC(20),
  OWNR           NUMERIC(20),
  NAM            VARCHAR(256),
  QUALFDNM       VARCHAR(256),
  VISBLTY        NUMERIC(20),
  CLINTDPNDNCY   NUMERIC(20),
  TEMPLTPRMTR    NUMERIC(20),
  END1           NUMERIC(20),
  TYP            NUMERIC(20),
  ISORDRD        VARCHAR(256),
  ISUNQ          VARCHAR(256),
  LOWR           VARCHAR(256),
  UPPR           VARCHAR(256),
  DEFLT          VARCHAR(256),
  DIRCTN         NUMERIC(20),
  ISEXCPTN       VARCHAR(256),
  ISSTRM         VARCHAR(256),
  EFFCT          NUMERIC(20),
  PARMTRST       NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Parameter', N'user', @table_owner, N'table', N'DD_UML_PARMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: end', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'END1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isOrdered', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'ISORDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isUnique', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'ISUNQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lower', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'LOWR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: upper', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'UPPR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: default', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'DEFLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: direction', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'DIRCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isException', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'ISEXCPTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isStream', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'ISSTRM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effect', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'EFFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: parameterSet', N'user', @table_owner, N'table', N'DD_UML_PARMTR', N'column', N'PARMTRST'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Package
-- (generated from Uml2/Package)

CREATE TABLE DD_UML_PACKG
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  NESTDPCKG            NUMERIC(20),
  NESTNGPCKG           NUMERIC(20),
  OWNDTYP              NUMERIC(20),
  APPLDPRFL            NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Package', N'user', @table_owner, N'table', N'DD_UML_PACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nestedPackage', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'NESTDPCKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nestingPackage', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'NESTNGPCKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedType', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'OWNDTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: appliedProfile', N'user', @table_owner, N'table', N'DD_UML_PACKG', N'column', N'APPLDPRFL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Enumeration
-- (generated from Uml2/Enumeration)

CREATE TABLE DD_UML_ENUMRTN
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  PACKG                NUMERIC(20),
  REDFNTNCNTXT         NUMERIC(20),
  ISLF                 VARCHAR(256),
  FEATR                NUMERIC(20),
  ISABSTRCT            VARCHAR(256),
  INHRTDMMBR           NUMERIC(20),
  GENRL                NUMERIC(20),
  ATTRBT               NUMERIC(20),
  REDFNDCLSSFR         NUMERIC(20),
  POWRTYPXTNT          NUMERIC(20),
  USECS                NUMERIC(20),
  REPRSNTTN            NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Enumeration', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: package', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'PACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: feature', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'FEATR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isAbstract', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'ISABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inheritedMember', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'INHRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: general', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'GENRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attribute', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'ATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedClassifier', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'REDFNDCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: powertypeExtent', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'POWRTYPXTNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: useCase', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'USECS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: representation', N'user', @table_owner, N'table', N'DD_UML_ENUMRTN', N'column', N'REPRSNTTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: DataType
-- (generated from Uml2/DataType)

CREATE TABLE DD_UML_DATTYP
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  PACKG                NUMERIC(20),
  REDFNTNCNTXT         NUMERIC(20),
  ISLF                 VARCHAR(256),
  FEATR                NUMERIC(20),
  ISABSTRCT            VARCHAR(256),
  INHRTDMMBR           NUMERIC(20),
  GENRL                NUMERIC(20),
  ATTRBT               NUMERIC(20),
  REDFNDCLSSFR         NUMERIC(20),
  POWRTYPXTNT          NUMERIC(20),
  USECS                NUMERIC(20),
  REPRSNTTN            NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: DataType', N'user', @table_owner, N'table', N'DD_UML_DATTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: package', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'PACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: feature', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'FEATR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isAbstract', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'ISABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inheritedMember', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'INHRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: general', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'GENRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attribute', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'ATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedClassifier', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'REDFNDCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: powertypeExtent', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'POWRTYPXTNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: useCase', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'USECS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: representation', N'user', @table_owner, N'table', N'DD_UML_DATTYP', N'column', N'REPRSNTTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: EnumerationLiteral
-- (generated from Uml2/EnumerationLiteral)

CREATE TABLE DD_UML_ENUMRTNLTRL
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  DEPLYDLMNT           NUMERIC(20),
  CLASSFR              NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: EnumerationLiteral', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: deployedElement', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'DEPLYDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: classifier', N'user', @table_owner, N'table', N'DD_UML_ENUMRTNLTRL', N'column', N'CLASSFR'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: PrimitiveType
-- (generated from Uml2/PrimitiveType)

CREATE TABLE DD_UML_PRIMTVTYP
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  PACKG                NUMERIC(20),
  REDFNTNCNTXT         NUMERIC(20),
  ISLF                 VARCHAR(256),
  FEATR                NUMERIC(20),
  ISABSTRCT            VARCHAR(256),
  INHRTDMMBR           NUMERIC(20),
  GENRL                NUMERIC(20),
  ATTRBT               NUMERIC(20),
  REDFNDCLSSFR         NUMERIC(20),
  POWRTYPXTNT          NUMERIC(20),
  USECS                NUMERIC(20),
  REPRSNTTN            NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: PrimitiveType', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: package', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'PACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: feature', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'FEATR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isAbstract', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'ISABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inheritedMember', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'INHRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: general', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'GENRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attribute', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'ATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedClassifier', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'REDFNDCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: powertypeExtent', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'POWRTYPXTNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: useCase', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'USECS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: representation', N'user', @table_owner, N'table', N'DD_UML_PRIMTVTYP', N'column', N'REPRSNTTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Constraint
-- (generated from Uml2/Constraint)

CREATE TABLE DD_UML_CONSTRNT
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  CONTXT               NUMERIC(20),
  CONSTRNDLMNT         NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Constraint', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: context', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'CONTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: constrainedElement', N'user', @table_owner, N'table', N'DD_UML_CONSTRNT', N'column', N'CONSTRNDLMNT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: LiteralBoolean
-- (generated from Uml2/LiteralBoolean)

CREATE TABLE DD_UML_LITRLBLN
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  OWNDLMNT       NUMERIC(20),
  OWNR           NUMERIC(20),
  NAM            VARCHAR(256),
  QUALFDNM       VARCHAR(256),
  VISBLTY        NUMERIC(20),
  CLINTDPNDNCY   NUMERIC(20),
  TYP            NUMERIC(20),
  TEMPLTPRMTR    NUMERIC(20),
  VAL            VARCHAR(256),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: LiteralBoolean', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_UML_LITRLBLN', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: LiteralString
-- (generated from Uml2/LiteralString)

CREATE TABLE DD_UML_LITRLSTRNG
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  OWNDLMNT       NUMERIC(20),
  OWNR           NUMERIC(20),
  NAM            VARCHAR(256),
  QUALFDNM       VARCHAR(256),
  VISBLTY        NUMERIC(20),
  CLINTDPNDNCY   NUMERIC(20),
  TYP            NUMERIC(20),
  TEMPLTPRMTR    NUMERIC(20),
  VAL            VARCHAR(256),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: LiteralString', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_UML_LITRLSTRNG', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: LiteralNull
-- (generated from Uml2/LiteralNull)

CREATE TABLE DD_UML_LITRLNLL
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  OWNDLMNT       NUMERIC(20),
  OWNR           NUMERIC(20),
  NAM            VARCHAR(256),
  QUALFDNM       VARCHAR(256),
  VISBLTY        NUMERIC(20),
  CLINTDPNDNCY   NUMERIC(20),
  TYP            NUMERIC(20),
  TEMPLTPRMTR    NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: LiteralNull', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_LITRLNLL', N'column', N'TEMPLTPRMTR'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: LiteralInteger
-- (generated from Uml2/LiteralInteger)

CREATE TABLE DD_UML_LITRLNTGR
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  OWNDLMNT       NUMERIC(20),
  OWNR           NUMERIC(20),
  NAM            VARCHAR(256),
  QUALFDNM       VARCHAR(256),
  VISBLTY        NUMERIC(20),
  CLINTDPNDNCY   NUMERIC(20),
  TYP            NUMERIC(20),
  TEMPLTPRMTR    NUMERIC(20),
  VAL            VARCHAR(256),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: LiteralInteger', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_UML_LITRLNTGR', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: LiteralUnlimitedNatural
-- (generated from Uml2/LiteralUnlimitedNatural)

CREATE TABLE DD_UML_LITRLNLMTDN
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  OWNDLMNT       NUMERIC(20),
  OWNR           NUMERIC(20),
  NAM            VARCHAR(256),
  QUALFDNM       VARCHAR(256),
  VISBLTY        NUMERIC(20),
  CLINTDPNDNCY   NUMERIC(20),
  TYP            NUMERIC(20),
  TEMPLTPRMTR    NUMERIC(20),
  VAL            VARCHAR(256),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: LiteralUnlimitedNatural', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_UML_LITRLNLMTDN', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: InstanceSpecification
-- (generated from Uml2/InstanceSpecification)

CREATE TABLE DD_UML_INSTNCSPCFC
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  DEPLYDLMNT           NUMERIC(20),
  CLASSFR              NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: InstanceSpecification', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: deployedElement', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'DEPLYDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: classifier', N'user', @table_owner, N'table', N'DD_UML_INSTNCSPCFC', N'column', N'CLASSFR'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Slot
-- (generated from Uml2/Slot)

CREATE TABLE DD_UML_SLOT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  OWNDLMNT      NUMERIC(20),
  OWNR          NUMERIC(20),
  DEFNNGFTR     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Slot', N'user', @table_owner, N'table', N'DD_UML_SLOT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_SLOT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_SLOT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_SLOT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_SLOT', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_SLOT', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: definingFeature', N'user', @table_owner, N'table', N'DD_UML_SLOT', N'column', N'DEFNNGFTR'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Generalization
-- (generated from Uml2/Generalization)

CREATE TABLE DD_UML_GENRLZTN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  OWNDLMNT      NUMERIC(20),
  OWNR          NUMERIC(20),
  RELTDLMNT     NUMERIC(20),
  SOURC         NUMERIC(20),
  TARGT         NUMERIC(20),
  GENRL         NUMERIC(20),
  ISSBSTTTBL    VARCHAR(256),
  GENRLZTNST    NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Generalization', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedElement', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'RELTDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: source', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'SOURC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'TARGT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: general', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'GENRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isSubstitutable', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'ISSBSTTTBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: generalizationSet', N'user', @table_owner, N'table', N'DD_UML_GENRLZTN', N'column', N'GENRLZTNST'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ElementImport
-- (generated from Uml2/ElementImport)

CREATE TABLE DD_UML_ELEMNTMPRT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  OWNDLMNT      NUMERIC(20),
  OWNR          NUMERIC(20),
  RELTDLMNT     NUMERIC(20),
  SOURC         NUMERIC(20),
  TARGT         NUMERIC(20),
  VISBLTY       NUMERIC(20),
  ALIS          VARCHAR(256),
  IMPRTDLMNT    NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ElementImport', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedElement', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'RELTDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: source', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'SOURC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'TARGT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: alias', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'ALIS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedElement', N'user', @table_owner, N'table', N'DD_UML_ELEMNTMPRT', N'column', N'IMPRTDLMNT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: PackageImport
-- (generated from Uml2/PackageImport)

CREATE TABLE DD_UML_PACKGMPRT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  OWNDLMNT      NUMERIC(20),
  OWNR          NUMERIC(20),
  RELTDLMNT     NUMERIC(20),
  SOURC         NUMERIC(20),
  TARGT         NUMERIC(20),
  VISBLTY       NUMERIC(20),
  IMPRTDPCKG    NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: PackageImport', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedElement', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT', N'column', N'RELTDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: source', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT', N'column', N'SOURC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT', N'column', N'TARGT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedPackage', N'user', @table_owner, N'table', N'DD_UML_PACKGMPRT', N'column', N'IMPRTDPCKG'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Association
-- (generated from Uml2/Association)

CREATE TABLE DD_UML_ASSCTN
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  PACKG                NUMERIC(20),
  REDFNTNCNTXT         NUMERIC(20),
  ISLF                 VARCHAR(256),
  FEATR                NUMERIC(20),
  ISABSTRCT            VARCHAR(256),
  INHRTDMMBR           NUMERIC(20),
  GENRL                NUMERIC(20),
  ATTRBT               NUMERIC(20),
  REDFNDCLSSFR         NUMERIC(20),
  POWRTYPXTNT          NUMERIC(20),
  USECS                NUMERIC(20),
  REPRSNTTN            NUMERIC(20),
  RELTDLMNT            NUMERIC(20),
  ISDRVD               VARCHAR(256),
  ENDTYP               NUMERIC(20),
  MEMBRND              NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Association', N'user', @table_owner, N'table', N'DD_UML_ASSCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: package', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'PACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: feature', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'FEATR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isAbstract', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'ISABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inheritedMember', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'INHRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: general', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'GENRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attribute', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'ATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedClassifier', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'REDFNDCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: powertypeExtent', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'POWRTYPXTNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: useCase', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'USECS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: representation', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'REPRSNTTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedElement', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'RELTDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isDerived', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'ISDRVD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: endType', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'ENDTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: memberEnd', N'user', @table_owner, N'table', N'DD_UML_ASSCTN', N'column', N'MEMBRND'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: PackageMerge
-- (generated from Uml2/PackageMerge)

CREATE TABLE DD_UML_PACKGMRG
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  OWNDLMNT      NUMERIC(20),
  OWNR          NUMERIC(20),
  RELTDLMNT     NUMERIC(20),
  SOURC         NUMERIC(20),
  TARGT         NUMERIC(20),
  MERGDPCKG     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: PackageMerge', N'user', @table_owner, N'table', N'DD_UML_PACKGMRG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PACKGMRG', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PACKGMRG', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_PACKGMRG', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_PACKGMRG', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_PACKGMRG', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedElement', N'user', @table_owner, N'table', N'DD_UML_PACKGMRG', N'column', N'RELTDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: source', N'user', @table_owner, N'table', N'DD_UML_PACKGMRG', N'column', N'SOURC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_UML_PACKGMRG', N'column', N'TARGT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: mergedPackage', N'user', @table_owner, N'table', N'DD_UML_PACKGMRG', N'column', N'MERGDPCKG'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Stereotype
-- (generated from Uml2/Stereotype)

CREATE TABLE DD_UML_STERTYP
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  PACKG                NUMERIC(20),
  REDFNTNCNTXT         NUMERIC(20),
  ISLF                 VARCHAR(256),
  FEATR                NUMERIC(20),
  ISABSTRCT            VARCHAR(256),
  INHRTDMMBR           NUMERIC(20),
  GENRL                NUMERIC(20),
  ATTRBT               NUMERIC(20),
  REDFNDCLSSFR         NUMERIC(20),
  POWRTYPXTNT          NUMERIC(20),
  USECS                NUMERIC(20),
  REPRSNTTN            NUMERIC(20),
  CLASSFRBHVR          NUMERIC(20),
  PART                 NUMERIC(20),
  ROL                  NUMERIC(20),
  SUPRCLSS             NUMERIC(20),
  EXTNSN               NUMERIC(20),
  ISACTV               VARCHAR(256),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Stereotype', N'user', @table_owner, N'table', N'DD_UML_STERTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: package', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'PACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: feature', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'FEATR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isAbstract', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'ISABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inheritedMember', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'INHRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: general', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'GENRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attribute', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'ATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedClassifier', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'REDFNDCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: powertypeExtent', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'POWRTYPXTNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: useCase', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'USECS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: representation', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'REPRSNTTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: classifierBehavior', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'CLASSFRBHVR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: part', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'PART'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: role', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'ROL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: superClass', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'SUPRCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: extension', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'EXTNSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isActive', N'user', @table_owner, N'table', N'DD_UML_STERTYP', N'column', N'ISACTV'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Profile
-- (generated from Uml2/Profile)

CREATE TABLE DD_UML_PROFL
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  NESTDPCKG            NUMERIC(20),
  NESTNGPCKG           NUMERIC(20),
  OWNDTYP              NUMERIC(20),
  APPLDPRFL            NUMERIC(20),
  OWNDSTRTYP           NUMERIC(20),
  METCLSSRFRNC         NUMERIC(20),
  METMDLRFRNC          NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Profile', N'user', @table_owner, N'table', N'DD_UML_PROFL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nestedPackage', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'NESTDPCKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nestingPackage', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'NESTNGPCKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedType', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'OWNDTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: appliedProfile', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'APPLDPRFL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedStereotype', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'OWNDSTRTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: metaclassReference', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'METCLSSRFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: metamodelReference', N'user', @table_owner, N'table', N'DD_UML_PROFL', N'column', N'METMDLRFRNC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ProfileApplication
-- (generated from Uml2/ProfileApplication)

CREATE TABLE DD_UML_PROFLPPLCTN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  OWNDLMNT      NUMERIC(20),
  OWNR          NUMERIC(20),
  RELTDLMNT     NUMERIC(20),
  SOURC         NUMERIC(20),
  TARGT         NUMERIC(20),
  VISBLTY       NUMERIC(20),
  IMPRTDPCKG    NUMERIC(20),
  IMPRTDPRFL    NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ProfileApplication', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedElement', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'RELTDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: source', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'SOURC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'TARGT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedPackage', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'IMPRTDPCKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedProfile', N'user', @table_owner, N'table', N'DD_UML_PROFLPPLCTN', N'column', N'IMPRTDPRFL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Extension
-- (generated from Uml2/Extension)

CREATE TABLE DD_UML_EXTNSN
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  PACKG                NUMERIC(20),
  REDFNTNCNTXT         NUMERIC(20),
  ISLF                 VARCHAR(256),
  FEATR                NUMERIC(20),
  ISABSTRCT            VARCHAR(256),
  INHRTDMMBR           NUMERIC(20),
  GENRL                NUMERIC(20),
  ATTRBT               NUMERIC(20),
  REDFNDCLSSFR         NUMERIC(20),
  POWRTYPXTNT          NUMERIC(20),
  USECS                NUMERIC(20),
  REPRSNTTN            NUMERIC(20),
  RELTDLMNT            NUMERIC(20),
  ISDRVD               VARCHAR(256),
  ENDTYP               NUMERIC(20),
  MEMBRND              NUMERIC(20),
  ISRQRD               VARCHAR(256),
  METCLSS              NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Extension', N'user', @table_owner, N'table', N'DD_UML_EXTNSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: package', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'PACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: feature', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'FEATR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isAbstract', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'ISABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inheritedMember', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'INHRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: general', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'GENRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attribute', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'ATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedClassifier', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'REDFNDCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: powertypeExtent', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'POWRTYPXTNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: useCase', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'USECS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: representation', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'REPRSNTTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedElement', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'RELTDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isDerived', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'ISDRVD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: endType', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'ENDTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: memberEnd', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'MEMBRND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isRequired', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'ISRQRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: metaclass', N'user', @table_owner, N'table', N'DD_UML_EXTNSN', N'column', N'METCLSS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ExtensionEnd
-- (generated from Uml2/ExtensionEnd)

CREATE TABLE DD_UML_EXTNSNND
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  OWNDLMNT        NUMERIC(20),
  OWNR            NUMERIC(20),
  NAM             VARCHAR(256),
  QUALFDNM        VARCHAR(256),
  VISBLTY         NUMERIC(20),
  CLINTDPNDNCY    NUMERIC(20),
  REDFNTNCNTXT    NUMERIC(20),
  ISLF            VARCHAR(256),
  FEATRNGCLSSFR   NUMERIC(20),
  ISSTTC          VARCHAR(256),
  TYP             NUMERIC(20),
  ISORDRD         VARCHAR(256),
  ISUNQ           VARCHAR(256),
  LOWR            VARCHAR(256),
  UPPR            VARCHAR(256),
  ISRDNLY         VARCHAR(256),
  TEMPLTPRMTR     NUMERIC(20),
  END1            NUMERIC(20),
  DEPLYDLMNT      NUMERIC(20),
  DEFLT           VARCHAR(256),
  ISCMPST         VARCHAR(256),
  ISDRVD          VARCHAR(256),
  CLASS_          NUMERIC(20),
  OPPST           NUMERIC(20),
  ISDRVDNN        VARCHAR(256),
  REDFNDPRPRTY    NUMERIC(20),
  SUBSTTDPRPRTY   NUMERIC(20),
  ASSCTN          NUMERIC(20),
  AGGRGTN         NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ExtensionEnd', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: featuringClassifier', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'FEATRNGCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isStatic', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'ISSTTC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isOrdered', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'ISORDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isUnique', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'ISUNQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lower', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'LOWR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: upper', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'UPPR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isReadOnly', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'ISRDNLY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: end', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'END1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: deployedElement', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'DEPLYDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: default', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'DEFLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isComposite', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'ISCMPST'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isDerived', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'ISDRVD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: class_', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'CLASS_'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: opposite', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'OPPST'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isDerivedUnion', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'ISDRVDNN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedProperty', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'REDFNDPRPRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: subsettedProperty', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'SUBSTTDPRPRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: association', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'ASSCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aggregation', N'user', @table_owner, N'table', N'DD_UML_EXTNSNND', N'column', N'AGGRGTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Dependency
-- (generated from Uml2/Dependency)

CREATE TABLE DD_UML_DEPNDNCY
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  RELTDLMNT            NUMERIC(20),
  SOURC                NUMERIC(20),
  TARGT                NUMERIC(20),
  CLINT                NUMERIC(20),
  SUPPLR               NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Dependency', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedElement', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'RELTDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: source', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'SOURC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'TARGT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: client', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'CLINT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: supplier', N'user', @table_owner, N'table', N'DD_UML_DEPNDNCY', N'column', N'SUPPLR'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: GeneralizationSet
-- (generated from Uml2/GeneralizationSet)

CREATE TABLE DD_UML_GENRLZTNST
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  ISCVRNG              VARCHAR(256),
  ISDSJNT              VARCHAR(256),
  POWRTYP              NUMERIC(20),
  GENRLZTN             NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: GeneralizationSet', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isCovering', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'ISCVRNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isDisjoint', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'ISDSJNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: powertype', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'POWRTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: generalization', N'user', @table_owner, N'table', N'DD_UML_GENRLZTNST', N'column', N'GENRLZTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: AssociationClass
-- (generated from Uml2/AssociationClass)

CREATE TABLE DD_UML_ASSCTNCLSS
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  PACKG                NUMERIC(20),
  REDFNTNCNTXT         NUMERIC(20),
  ISLF                 VARCHAR(256),
  FEATR                NUMERIC(20),
  ISABSTRCT            VARCHAR(256),
  INHRTDMMBR           NUMERIC(20),
  GENRL                NUMERIC(20),
  ATTRBT               NUMERIC(20),
  REDFNDCLSSFR         NUMERIC(20),
  POWRTYPXTNT          NUMERIC(20),
  USECS                NUMERIC(20),
  REPRSNTTN            NUMERIC(20),
  CLASSFRBHVR          NUMERIC(20),
  PART                 NUMERIC(20),
  ROL                  NUMERIC(20),
  SUPRCLSS             NUMERIC(20),
  EXTNSN               NUMERIC(20),
  ISACTV               VARCHAR(256),
  RELTDLMNT            NUMERIC(20),
  ISDRVD               VARCHAR(256),
  ENDTYP               NUMERIC(20),
  MEMBRND              NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: AssociationClass', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: package', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'PACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: feature', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'FEATR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isAbstract', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'ISABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inheritedMember', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'INHRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: general', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'GENRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attribute', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'ATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedClassifier', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'REDFNDCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: powertypeExtent', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'POWRTYPXTNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: useCase', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'USECS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: representation', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'REPRSNTTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: classifierBehavior', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'CLASSFRBHVR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: part', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'PART'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: role', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'ROL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: superClass', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'SUPRCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: extension', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'EXTNSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isActive', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'ISACTV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedElement', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'RELTDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isDerived', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'ISDRVD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: endType', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'ENDTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: memberEnd', N'user', @table_owner, N'table', N'DD_UML_ASSCTNCLSS', N'column', N'MEMBRND'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Model
-- (generated from Uml2/Model)

CREATE TABLE DD_UML_MODL
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  NESTDPCKG            NUMERIC(20),
  NESTNGPCKG           NUMERIC(20),
  OWNDTYP              NUMERIC(20),
  APPLDPRFL            NUMERIC(20),
  VIEWPNT              VARCHAR(256),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Model', N'user', @table_owner, N'table', N'DD_UML_MODL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nestedPackage', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'NESTDPCKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nestingPackage', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'NESTNGPCKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedType', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'OWNDTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: appliedProfile', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'APPLDPRFL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: viewpoint', N'user', @table_owner, N'table', N'DD_UML_MODL', N'column', N'VIEWPNT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Interface
-- (generated from Uml2/Interface)

CREATE TABLE DD_UML_INTRFC
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  OWNDLMNT             NUMERIC(20),
  OWNR                 NUMERIC(20),
  NAM                  VARCHAR(256),
  QUALFDNM             VARCHAR(256),
  VISBLTY              NUMERIC(20),
  CLINTDPNDNCY         NUMERIC(20),
  MEMBR                NUMERIC(20),
  IMPRTDMMBR           NUMERIC(20),
  TEMPLTPRMTR          NUMERIC(20),
  PACKGBLLMNT_VSBLTY   NUMERIC(20),
  PACKG                NUMERIC(20),
  REDFNTNCNTXT         NUMERIC(20),
  ISLF                 VARCHAR(256),
  FEATR                NUMERIC(20),
  ISABSTRCT            VARCHAR(256),
  INHRTDMMBR           NUMERIC(20),
  GENRL                NUMERIC(20),
  ATTRBT               NUMERIC(20),
  REDFNDCLSSFR         NUMERIC(20),
  POWRTYPXTNT          NUMERIC(20),
  USECS                NUMERIC(20),
  REPRSNTTN            NUMERIC(20),
  REDFNDNTRFC          NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Interface', N'user', @table_owner, N'table', N'DD_UML_INTRFC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: member', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'MEMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: importedMember', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'IMPRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: packageableElement_visibility', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'PACKGBLLMNT_VSBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: package', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'PACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinitionContext', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'REDFNTNCNTXT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isLeaf', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'ISLF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: feature', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'FEATR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: isAbstract', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'ISABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inheritedMember', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'INHRTDMMBR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: general', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'GENRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attribute', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'ATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedClassifier', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'REDFNDCLSSFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: powertypeExtent', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'POWRTYPXTNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: useCase', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'USECS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: representation', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'REPRSNTTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: redefinedInterface', N'user', @table_owner, N'table', N'DD_UML_INTRFC', N'column', N'REDFNDNTRFC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: StringExpression
-- (generated from Uml2/StringExpression)

CREATE TABLE DD_UML_STRNGXPRSSN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  OWNDLMNT      NUMERIC(20),
  OWNR          NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: StringExpression', N'user', @table_owner, N'table', N'DD_UML_STRNGXPRSSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_STRNGXPRSSN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_STRNGXPRSSN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_STRNGXPRSSN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_STRNGXPRSSN', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_STRNGXPRSSN', N'column', N'OWNR'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: DurationInterval
-- (generated from Uml2/DurationInterval)

CREATE TABLE DD_UML_DURTNNTRVL
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  OWNDLMNT       NUMERIC(20),
  OWNR           NUMERIC(20),
  NAM            VARCHAR(256),
  QUALFDNM       VARCHAR(256),
  VISBLTY        NUMERIC(20),
  CLINTDPNDNCY   NUMERIC(20),
  TYP            NUMERIC(20),
  TEMPLTPRMTR    NUMERIC(20),
  MIN            NUMERIC(20),
  MAX            NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: DurationInterval', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: min', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'MIN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: max', N'user', @table_owner, N'table', N'DD_UML_DURTNNTRVL', N'column', N'MAX'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: TimeInterval
-- (generated from Uml2/TimeInterval)

CREATE TABLE DD_UML_TIMNTRVL
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  OWNDLMNT       NUMERIC(20),
  OWNR           NUMERIC(20),
  NAM            VARCHAR(256),
  QUALFDNM       VARCHAR(256),
  VISBLTY        NUMERIC(20),
  CLINTDPNDNCY   NUMERIC(20),
  TYP            NUMERIC(20),
  TEMPLTPRMTR    NUMERIC(20),
  MIN            NUMERIC(20),
  MAX            NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: TimeInterval', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: templateParameter', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'TEMPLTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: min', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'MIN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: max', N'user', @table_owner, N'table', N'DD_UML_TIMNTRVL', N'column', N'MAX'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ParameterSet
-- (generated from Uml2/ParameterSet)

CREATE TABLE DD_UML_PARMTRST
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  OWNDLMNT       NUMERIC(20),
  OWNR           NUMERIC(20),
  NAM            VARCHAR(256),
  QUALFDNM       VARCHAR(256),
  VISBLTY        NUMERIC(20),
  CLINTDPNDNCY   NUMERIC(20),
  PARMTR         NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ParameterSet', N'user', @table_owner, N'table', N'DD_UML_PARMTRST'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PARMTRST', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_UML_PARMTRST', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_UML_PARMTRST', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ownedElement', N'user', @table_owner, N'table', N'DD_UML_PARMTRST', N'column', N'OWNDLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: owner', N'user', @table_owner, N'table', N'DD_UML_PARMTRST', N'column', N'OWNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_UML_PARMTRST', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qualifiedName', N'user', @table_owner, N'table', N'DD_UML_PARMTRST', N'column', N'QUALFDNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visibility', N'user', @table_owner, N'table', N'DD_UML_PARMTRST', N'column', N'VISBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: clientDependency', N'user', @table_owner, N'table', N'DD_UML_PARMTRST', N'column', N'CLINTDPNDNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: parameter', N'user', @table_owner, N'table', N'DD_UML_PARMTRST', N'column', N'PARMTR'
GO

--
-- The model class name for the set enumeration values held in this table is: CaseConversion
-- (generated from Jdbc/CaseConversion)

CREATE TABLE DD_JDBC_CASCNVRSN
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: CaseConversion', N'user', @table_owner, N'table', N'DD_JDBC_CASCNVRSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_JDBC_CASCNVRSN', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_JDBC_CASCNVRSN', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: SourceNames
-- (generated from Jdbc/SourceNames)

CREATE TABLE DD_JDBC_SOURCNMS
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: SourceNames', N'user', @table_owner, N'table', N'DD_JDBC_SOURCNMS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_JDBC_SOURCNMS', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_JDBC_SOURCNMS', N'column', N'VALUE'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: JdbcSourceProperty
-- (generated from Jdbc/JdbcSourceProperty)

CREATE TABLE DD_JDBC_JDBCSRCPRP
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  VAL           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: JdbcSourceProperty', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRCPRP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRCPRP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRCPRP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRCPRP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRCPRP', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRCPRP', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: JdbcDriver
-- (generated from Jdbc/JdbcDriver)

CREATE TABLE DD_JDBC_JDBCDRVR
(
  LGCL_ID             VARCHAR(1000),
  UUID1               NUMERIC(20) NOT NULL,
  UUID2               NUMERIC(20) NOT NULL,
  UUID_STRING         VARCHAR(44) NOT NULL,
  NAM                 VARCHAR(256),
  URLSYNTX            VARCHAR(256),
  JARFLRS             VARCHAR(256),
  AVALBLDRVRCLSSNMS   VARCHAR(256),
  PREFRRDDRVRCLSSNM   VARCHAR(256),
  TXN_ID              NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: JdbcDriver', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVR', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: urlSyntax', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVR', N'column', N'URLSYNTX'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: jarFileUris', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVR', N'column', N'JARFLRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: availableDriverClassNames', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVR', N'column', N'AVALBLDRVRCLSSNMS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: preferredDriverClassName', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVR', N'column', N'PREFRRDDRVRCLSSNM'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: JdbcSource
-- (generated from Jdbc/JdbcSource)

CREATE TABLE DD_JDBC_JDBCSRC
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  JDBCDRVR      NUMERIC(20),
  NAM           VARCHAR(256),
  DRIVRNM       VARCHAR(256),
  DRIVRCLSS     VARCHAR(256),
  USERNM        VARCHAR(256),
  URL           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: JdbcSource', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: jdbcDriver', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRC', N'column', N'JDBCDRVR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRC', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: driverName', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRC', N'column', N'DRIVRNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: driverClass', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRC', N'column', N'DRIVRCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: username', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRC', N'column', N'USERNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: url', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRC', N'column', N'URL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: JdbcDriverContainer
-- (generated from Jdbc/JdbcDriverContainer)

CREATE TABLE DD_JDBC_JDBCDRVRCN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: JdbcDriverContainer', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVRCN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVRCN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVRCN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCDRVRCN', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: JdbcSourceContainer
-- (generated from Jdbc/JdbcSourceContainer)

CREATE TABLE DD_JDBC_JDBCSRCCNT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: JdbcSourceContainer', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRCCNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRCCNT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRCCNT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCSRCCNT', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: JdbcImportSettings
-- (generated from Jdbc/JdbcImportSettings)

CREATE TABLE DD_JDBC_JDBCMPRTST
(
  LGCL_ID           VARCHAR(1000),
  UUID1             NUMERIC(20) NOT NULL,
  UUID2             NUMERIC(20) NOT NULL,
  UUID_STRING       VARCHAR(44) NOT NULL,
  CRETCTLGSNMDL     CHAR(1),
  CRETSCHMSNMDL     CHAR(1),
  CONVRTCSNMDL      NUMERIC(20),
  GENRTSRCNMSNMDL   NUMERIC(20),
  INCLDDCTLGPTHS    VARCHAR(256),
  INCLDDSCHMPTHS    VARCHAR(256),
  EXCLDDBJCTPTHS    VARCHAR(256),
  INCLDFRGNKYS      CHAR(1),
  INCLDNDXS         CHAR(1),
  INCLDPRCDRS       CHAR(1),
  INCLDPPRXMTNDXS   CHAR(1),
  INCLDNQNDXS       CHAR(1),
  INCLDDTBLTYPS     VARCHAR(256),
  TXN_ID            NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: JdbcImportSettings', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: createCatalogsInModel', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'CRETCTLGSNMDL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: createSchemasInModel', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'CRETSCHMSNMDL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: convertCaseInModel', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'CONVRTCSNMDL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: generateSourceNamesInModel', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'GENRTSRCNMSNMDL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: includedCatalogPaths', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'INCLDDCTLGPTHS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: includedSchemaPaths', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'INCLDDSCHMPTHS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: excludedObjectPaths', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'EXCLDDBJCTPTHS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: includeForeignKeys', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'INCLDFRGNKYS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: includeIndexes', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'INCLDNDXS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: includeProcedures', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'INCLDPRCDRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: includeApproximateIndexes', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'INCLDPPRXMTNDXS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: includeUniqueIndexes', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'INCLDNQNDXS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: includedTableTypes', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTST', N'column', N'INCLDDTBLTYPS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: JdbcImportOptions
-- (generated from Jdbc/JdbcImportOptions)

CREATE TABLE DD_JDBC_JDBCMPRTPT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  VAL           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: JdbcImportOptions', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTPT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTPT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTPT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTPT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTPT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_JDBC_JDBCMPRTPT', N'column', N'VAL'
GO

--
-- The model class name for the set enumeration values held in this table is: ModelType
-- (generated from Core/ModelType)

CREATE TABLE DD_COR_MODLTYP
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: ModelType', N'user', @table_owner, N'table', N'DD_COR_MODLTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_COR_MODLTYP', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_COR_MODLTYP', N'column', N'VALUE'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Annotation
-- (generated from Core/Annotation)

CREATE TABLE DD_COR_ANNTTN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  DESCRPTN      TEXT,
  KEYWRDS       VARCHAR(256),
  ANNTTDBJCT    NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Annotation', N'user', @table_owner, N'table', N'DD_COR_ANNTTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_ANNTTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_ANNTTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_COR_ANNTTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: description', N'user', @table_owner, N'table', N'DD_COR_ANNTTN', N'column', N'DESCRPTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: keywords', N'user', @table_owner, N'table', N'DD_COR_ANNTTN', N'column', N'KEYWRDS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: annotatedObject', N'user', @table_owner, N'table', N'DD_COR_ANNTTN', N'column', N'ANNTTDBJCT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: AnnotationContainer
-- (generated from Core/AnnotationContainer)

CREATE TABLE DD_COR_ANNTTNCNTNR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: AnnotationContainer', N'user', @table_owner, N'table', N'DD_COR_ANNTTNCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_ANNTTNCNTNR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_ANNTTNCNTNR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_COR_ANNTTNCNTNR', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ModelAnnotation
-- (generated from Core/ModelAnnotation)

CREATE TABLE DD_COR_MODLNNTTN
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  DESCRPTN        TEXT,
  NAMNSRC         VARCHAR(256),
  PRIMRYMTMDLR    VARCHAR(256),
  MODLTYP         NUMERIC(20),
  MAXSTSZ         NUMERIC(20),
  VISBL           CHAR(1),
  SUPPRTSDSTNCT   CHAR(1),
  SUPPRTSJN       CHAR(1),
  SUPPRTSRDRBY    CHAR(1),
  SUPPRTSTRJN     CHAR(1),
  SUPPRTSWHRLL    CHAR(1),
  NAMSPCR         VARCHAR(256),
  PRODCRNM        VARCHAR(256),
  PRODCRVRSN      VARCHAR(256),
  EXTNSNPCKG      NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ModelAnnotation', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: description', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'DESCRPTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: primaryMetamodelUri', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'PRIMRYMTMDLR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: modelType', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'MODLTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxSetSize', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'MAXSTSZ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: visible', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'VISBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: supportsDistinct', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'SUPPRTSDSTNCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: supportsJoin', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'SUPPRTSJN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: supportsOrderBy', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'SUPPRTSRDRBY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: supportsOuterJoin', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'SUPPRTSTRJN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: supportsWhereAll', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'SUPPRTSWHRLL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: namespaceUri', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'NAMSPCR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ProducerName', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'PRODCRNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ProducerVersion', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'PRODCRVRSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: extensionPackage', N'user', @table_owner, N'table', N'DD_COR_MODLNNTTN', N'column', N'EXTNSNPCKG'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Link
-- (generated from Core/Link)

CREATE TABLE DD_COR_LINK
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  DESCRPTN      TEXT,
  REFRNCS       VARCHAR(256),
  LINKDBJCTS    NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Link', N'user', @table_owner, N'table', N'DD_COR_LINK'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_LINK', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_LINK', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_COR_LINK', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_COR_LINK', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: description', N'user', @table_owner, N'table', N'DD_COR_LINK', N'column', N'DESCRPTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: references', N'user', @table_owner, N'table', N'DD_COR_LINK', N'column', N'REFRNCS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: linkedObjects', N'user', @table_owner, N'table', N'DD_COR_LINK', N'column', N'LINKDBJCTS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: LinkContainer
-- (generated from Core/LinkContainer)

CREATE TABLE DD_COR_LINKCNTNR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: LinkContainer', N'user', @table_owner, N'table', N'DD_COR_LINKCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_LINKCNTNR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_LINKCNTNR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_COR_LINKCNTNR', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ModelImport
-- (generated from Core/ModelImport)

CREATE TABLE DD_COR_MODLMPRT
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  NAM            VARCHAR(256),
  PATH           VARCHAR(256),
  MODLLCTN       VARCHAR(256),
  UUID           VARCHAR(256),
  MODLTYP        NUMERIC(20),
  PRIMRYMTMDLR   VARCHAR(256),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ModelImport', N'user', @table_owner, N'table', N'DD_COR_MODLMPRT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_MODLMPRT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_COR_MODLMPRT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_COR_MODLMPRT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_COR_MODLMPRT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: path', N'user', @table_owner, N'table', N'DD_COR_MODLMPRT', N'column', N'PATH'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: modelLocation', N'user', @table_owner, N'table', N'DD_COR_MODLMPRT', N'column', N'MODLLCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uuid', N'user', @table_owner, N'table', N'DD_COR_MODLMPRT', N'column', N'UUID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: modelType', N'user', @table_owner, N'table', N'DD_COR_MODLMPRT', N'column', N'MODLTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: primaryMetamodelUri', N'user', @table_owner, N'table', N'DD_COR_MODLMPRT', N'column', N'PRIMRYMTMDLR'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XClass
-- (generated from Extension/XClass)

CREATE TABLE DD_EXTN_XCLSS
(
  LGCL_ID           VARCHAR(1000),
  UUID1             NUMERIC(20) NOT NULL,
  UUID2             NUMERIC(20) NOT NULL,
  UUID_STRING       VARCHAR(44) NOT NULL,
  NAM               VARCHAR(256),
  INSTNCCLSSNM      VARCHAR(256),
  INSTNCCLSS        VARCHAR(256),
  DEFLTVL           VARCHAR(256),
  ABSTRCT           CHAR(1),
  INTRFC            CHAR(1),
  ESUPRTYPS         NUMERIC(20),
  EALLTTRBTS        NUMERIC(20),
  EALLRFRNCS        NUMERIC(20),
  EREFRNCS          NUMERIC(20),
  EATTRBTS          NUMERIC(20),
  EALLCNTNMNTS      NUMERIC(20),
  EALLPRTNS         NUMERIC(20),
  EALLSTRCTRLFTRS   NUMERIC(20),
  EALLSPRTYPS       NUMERIC(20),
  EIDTTRBT          NUMERIC(20),
  EXTNDDCLSS        NUMERIC(20),
  TXN_ID            NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XClass', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instanceClassName', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'INSTNCCLSSNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instanceClass', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'INSTNCCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: abstract', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'ABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: interface', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'INTRFC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eSuperTypes', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'ESUPRTYPS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllAttributes', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'EALLTTRBTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllReferences', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'EALLRFRNCS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eReferences', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'EREFRNCS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAttributes', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'EATTRBTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllContainments', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'EALLCNTNMNTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllOperations', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'EALLPRTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllStructuralFeatures', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'EALLSTRCTRLFTRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAllSuperTypes', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'EALLSPRTYPS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eIDAttribute', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'EIDTTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: extendedClass', N'user', @table_owner, N'table', N'DD_EXTN_XCLSS', N'column', N'EXTNDDCLSS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XPackage
-- (generated from Extension/XPackage)

CREATE TABLE DD_EXTN_XPACKG
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  NAM            VARCHAR(256),
  NSUR           VARCHAR(256),
  NSPRFX         VARCHAR(256),
  EFACTRYNSTNC   NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XPackage', N'user', @table_owner, N'table', N'DD_EXTN_XPACKG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_EXTN_XPACKG', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_EXTN_XPACKG', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_EXTN_XPACKG', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_EXTN_XPACKG', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nsURI', N'user', @table_owner, N'table', N'DD_EXTN_XPACKG', N'column', N'NSUR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nsPrefix', N'user', @table_owner, N'table', N'DD_EXTN_XPACKG', N'column', N'NSPRFX'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eFactoryInstance', N'user', @table_owner, N'table', N'DD_EXTN_XPACKG', N'column', N'EFACTRYNSTNC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XAttribute
-- (generated from Extension/XAttribute)

CREATE TABLE DD_EXTN_XATTRBT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  ORDRD         CHAR(1),
  UNIQ          CHAR(1),
  LOWRBND       NUMERIC(20),
  UPPRBND       NUMERIC(20),
  MANY          CHAR(1),
  REQRD         CHAR(1),
  ETYP          NUMERIC(20),
  CHANGBL       CHAR(1),
  VOLTL         CHAR(1),
  TRANSNT       CHAR(1),
  DEFLTVLLTRL   VARCHAR(256),
  DEFLTVL       VARCHAR(256),
  UNSTTBL       CHAR(1),
  DERVD         CHAR(1),
  ID            CHAR(1),
  EATTRBTTYP    NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XAttribute', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ordered', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'ORDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unique', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'UNIQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lowerBound', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'LOWRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: upperBound', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'UPPRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: many', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'MANY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: required', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'REQRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eType', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'ETYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: changeable', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'CHANGBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: volatile', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'VOLTL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: transient', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'TRANSNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValueLiteral', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'DEFLTVLLTRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unsettable', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'UNSTTBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: derived', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'DERVD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: iD', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: eAttributeType', N'user', @table_owner, N'table', N'DD_EXTN_XATTRBT', N'column', N'EATTRBTTYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XEnum
-- (generated from Extension/XEnum)

CREATE TABLE DD_EXTN_XENM
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  NAM            VARCHAR(256),
  INSTNCCLSSNM   VARCHAR(256),
  INSTNCCLSS     VARCHAR(256),
  DEFLTVL        VARCHAR(256),
  SERLZBL        CHAR(1),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XEnum', N'user', @table_owner, N'table', N'DD_EXTN_XENM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_EXTN_XENM', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_EXTN_XENM', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_EXTN_XENM', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_EXTN_XENM', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instanceClassName', N'user', @table_owner, N'table', N'DD_EXTN_XENM', N'column', N'INSTNCCLSSNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instanceClass', N'user', @table_owner, N'table', N'DD_EXTN_XENM', N'column', N'INSTNCCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_EXTN_XENM', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: serializable', N'user', @table_owner, N'table', N'DD_EXTN_XENM', N'column', N'SERLZBL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XEnumLiteral
-- (generated from Extension/XEnumLiteral)

CREATE TABLE DD_EXTN_XENMLTRL
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  VAL           NUMERIC(20),
  INSTNC        VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XEnumLiteral', N'user', @table_owner, N'table', N'DD_EXTN_XENMLTRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_EXTN_XENMLTRL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_EXTN_XENMLTRL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_EXTN_XENMLTRL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_EXTN_XENMLTRL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_EXTN_XENMLTRL', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: instance', N'user', @table_owner, N'table', N'DD_EXTN_XENMLTRL', N'column', N'INSTNC'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDAttributeUseCategory
-- (generated from Xsd/XSDAttributeUseCategory)

CREATE TABLE DD_XSD_XSDTTRBTSCT
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDAttributeUseCategory', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTSCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTSCT', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTSCT', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDCardinality
-- (generated from Xsd/XSDCardinality)

CREATE TABLE DD_XSD_XSDCRDNLTY
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDCardinality', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTY', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTY', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDComplexFinal
-- (generated from Xsd/XSDComplexFinal)

CREATE TABLE DD_XSD_XSDCMPLXFNL
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDComplexFinal', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXFNL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXFNL', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXFNL', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDCompositor
-- (generated from Xsd/XSDCompositor)

CREATE TABLE DD_XSD_XSDCMPSTR
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDCompositor', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPSTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPSTR', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPSTR', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDConstraint
-- (generated from Xsd/XSDConstraint)

CREATE TABLE DD_XSD_XSDCNSTRNT
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDConstraint', N'user', @table_owner, N'table', N'DD_XSD_XSDCNSTRNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDCNSTRNT', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDCNSTRNT', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDContentTypeCategory
-- (generated from Xsd/XSDContentTypeCategory)

CREATE TABLE DD_XSD_XSDCNTNTTYP
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDContentTypeCategory', N'user', @table_owner, N'table', N'DD_XSD_XSDCNTNTTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDCNTNTTYP', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDCNTNTTYP', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDDerivationMethod
-- (generated from Xsd/XSDDerivationMethod)

CREATE TABLE DD_XSD_XSDDRVTNMTH
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDDerivationMethod', N'user', @table_owner, N'table', N'DD_XSD_XSDDRVTNMTH'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDDRVTNMTH', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDDRVTNMTH', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDDiagnosticSeverity
-- (generated from Xsd/XSDDiagnosticSeverity)

CREATE TABLE DD_XSD_XSDDGNSTCSV
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDDiagnosticSeverity', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTCSV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTCSV', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTCSV', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDDisallowedSubstitutions
-- (generated from Xsd/XSDDisallowedSubstitutions)

CREATE TABLE DD_XSD_XSDDSLLWDSB
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDDisallowedSubstitutions', N'user', @table_owner, N'table', N'DD_XSD_XSDDSLLWDSB'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDDSLLWDSB', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDDSLLWDSB', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDForm
-- (generated from Xsd/XSDForm)

CREATE TABLE DD_XSD_XSDFRM
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDForm', N'user', @table_owner, N'table', N'DD_XSD_XSDFRM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDFRM', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDFRM', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDIdentityConstraintCategory
-- (generated from Xsd/XSDIdentityConstraintCategory)

CREATE TABLE DD_XSD_XSDDNTTYCNS
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDIdentityConstraintCategory', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYCNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYCNS', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYCNS', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDNamespaceConstraintCategory
-- (generated from Xsd/XSDNamespaceConstraintCategory)

CREATE TABLE DD_XSD_XSDNMSPCCNS
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDNamespaceConstraintCategory', N'user', @table_owner, N'table', N'DD_XSD_XSDNMSPCCNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDNMSPCCNS', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDNMSPCCNS', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDOrdered
-- (generated from Xsd/XSDOrdered)

CREATE TABLE DD_XSD_XSDRDRD
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDOrdered', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRD', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRD', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDProcessContents
-- (generated from Xsd/XSDProcessContents)

CREATE TABLE DD_XSD_XSDPRCSSCNT
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDProcessContents', N'user', @table_owner, N'table', N'DD_XSD_XSDPRCSSCNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDPRCSSCNT', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDPRCSSCNT', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDProhibitedSubstitutions
-- (generated from Xsd/XSDProhibitedSubstitutions)

CREATE TABLE DD_XSD_XSDPRHBTDSB
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDProhibitedSubstitutions', N'user', @table_owner, N'table', N'DD_XSD_XSDPRHBTDSB'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDPRHBTDSB', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDPRHBTDSB', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDSimpleFinal
-- (generated from Xsd/XSDSimpleFinal)

CREATE TABLE DD_XSD_XSDSMPLFNL
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDSimpleFinal', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLFNL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLFNL', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLFNL', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDSubstitutionGroupExclusions
-- (generated from Xsd/XSDSubstitutionGroupExclusions)

CREATE TABLE DD_XSD_XSDSBSTTTNG
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDSubstitutionGroupExclusions', N'user', @table_owner, N'table', N'DD_XSD_XSDSBSTTTNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDSBSTTTNG', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDSBSTTTNG', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDVariety
-- (generated from Xsd/XSDVariety)

CREATE TABLE DD_XSD_XSDVRTY
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDVariety', N'user', @table_owner, N'table', N'DD_XSD_XSDVRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDVRTY', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDVRTY', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDWhiteSpace
-- (generated from Xsd/XSDWhiteSpace)

CREATE TABLE DD_XSD_XSDWHTSPC
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDWhiteSpace', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPC', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPC', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: XSDXPathVariety
-- (generated from Xsd/XSDXPathVariety)

CREATE TABLE DD_XSD_XSDXPTHVRTY
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: XSDXPathVariety', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHVRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHVRTY', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHVRTY', N'column', N'VALUE'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDAnnotation
-- (generated from Xsd/XSDAnnotation)

CREATE TABLE DD_XSD_XSDNNTTN
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  APPLCTNNFRMTN   TEXT,
  USERNFRMTN      TEXT,
  ATTRBTS         TEXT,
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDAnnotation', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: applicationInformation', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN', N'column', N'APPLCTNNFRMTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: userInformation', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN', N'column', N'USERNFRMTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributes', N'user', @table_owner, N'table', N'DD_XSD_XSDNNTTN', N'column', N'ATTRBTS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDAttributeDeclaration
-- (generated from Xsd/XSDAttributeDeclaration)

CREATE TABLE DD_XSD_XSDTTRBTDCL
(
  LGCL_ID             VARCHAR(1000),
  UUID1               NUMERIC(20) NOT NULL,
  UUID2               NUMERIC(20) NOT NULL,
  UUID_STRING         VARCHAR(44) NOT NULL,
  ELEMNT              TEXT,
  CONTNR              NUMERIC(20),
  ROOTCNTNR           NUMERIC(20),
  SCHM                NUMERIC(20),
  NAM                 VARCHAR(256),
  TARGTNMSPC          VARCHAR(256),
  ALISNM              VARCHAR(256),
  URI                 VARCHAR(256),
  ALISR               VARCHAR(256),
  QNAM                VARCHAR(256),
  VAL                 TEXT,
  CONSTRNT            NUMERIC(20),
  FORM                NUMERIC(20),
  LEXCLVL             VARCHAR(256),
  GLOBL               CHAR(1),
  FEATRRFRNC          CHAR(1),
  SCOP                NUMERIC(20),
  RESLVDFTR           NUMERIC(20),
  TYP                 NUMERIC(20),
  ATTRBTDCLRTNRFRNC   CHAR(1),
  TYPDFNTN            NUMERIC(20),
  RESLVDTTRBTDCLRTN   NUMERIC(20),
  TXN_ID              NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDAttributeDeclaration', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetNamespace', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'TARGTNMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasName', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'ALISNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uRI', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasURI', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'ALISR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qName', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'QNAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: constraint', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'CONSTRNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: form', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'FORM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: global', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'GLOBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: featureReference', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'FEATRRFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: scope', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'SCOP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvedFeature', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'RESLVDFTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributeDeclarationReference', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'ATTRBTDCLRTNRFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: typeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'TYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvedAttributeDeclaration', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTDCL', N'column', N'RESLVDTTRBTDCLRTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDAttributeGroupDefinition
-- (generated from Xsd/XSDAttributeGroupDefinition)

CREATE TABLE DD_XSD_XSDTTRBTGRP
(
  LGCL_ID               VARCHAR(1000),
  UUID1                 NUMERIC(20) NOT NULL,
  UUID2                 NUMERIC(20) NOT NULL,
  UUID_STRING           VARCHAR(44) NOT NULL,
  ELEMNT                TEXT,
  CONTNR                NUMERIC(20),
  ROOTCNTNR             NUMERIC(20),
  SCHM                  NUMERIC(20),
  NAM                   VARCHAR(256),
  TARGTNMSPC            VARCHAR(256),
  ALISNM                VARCHAR(256),
  URI                   VARCHAR(256),
  ALISR                 VARCHAR(256),
  QNAM                  VARCHAR(256),
  CIRCLR                CHAR(1),
  ATTRBTGRPDFNTNRFRNC   CHAR(1),
  ATTRBTSS              NUMERIC(20),
  ATTRBTWLDCRD          NUMERIC(20),
  RESLVDTTRBTGRPDFNTN   NUMERIC(20),
  TXN_ID                NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDAttributeGroupDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetNamespace', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'TARGTNMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasName', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'ALISNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uRI', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasURI', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'ALISR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qName', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'QNAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: circular', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'CIRCLR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributeGroupDefinitionReference', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'ATTRBTGRPDFNTNRFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributeUses', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'ATTRBTSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributeWildcard', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'ATTRBTWLDCRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvedAttributeGroupDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTGRP', N'column', N'RESLVDTTRBTGRPDFNTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDAttributeUse
-- (generated from Xsd/XSDAttributeUse)

CREATE TABLE DD_XSD_XSDTTRBTS
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  ELEMNT         TEXT,
  CONTNR         NUMERIC(20),
  ROOTCNTNR      NUMERIC(20),
  SCHM           NUMERIC(20),
  REQRD          CHAR(1),
  VAL            TEXT,
  CONSTRNT       NUMERIC(20),
  USE1           NUMERIC(20),
  LEXCLVL        VARCHAR(256),
  ATTRBTDCLRTN   NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDAttributeUse', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: required', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'REQRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: constraint', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'CONSTRNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: use', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'USE1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributeDeclaration', N'user', @table_owner, N'table', N'DD_XSD_XSDTTRBTS', N'column', N'ATTRBTDCLRTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDBoundedFacet
-- (generated from Xsd/XSDBoundedFacet)

CREATE TABLE DD_XSD_XSDBNDDFCT
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  VAL             CHAR(1),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDBoundedFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDBNDDFCT', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDCardinalityFacet
-- (generated from Xsd/XSDCardinalityFacet)

CREATE TABLE DD_XSD_XSDCRDNLTYF
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  VAL             NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDCardinalityFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDCRDNLTYF', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDComplexTypeDefinition
-- (generated from Xsd/XSDComplexTypeDefinition)

CREATE TABLE DD_XSD_XSDCMPLXTYP
(
  LGCL_ID           VARCHAR(1000),
  UUID1             NUMERIC(20) NOT NULL,
  UUID2             NUMERIC(20) NOT NULL,
  UUID_STRING       VARCHAR(44) NOT NULL,
  ELEMNT            TEXT,
  CONTNR            NUMERIC(20),
  ROOTCNTNR         NUMERIC(20),
  SCHM              NUMERIC(20),
  NAM               VARCHAR(256),
  TARGTNMSPC        VARCHAR(256),
  ALISNM            VARCHAR(256),
  URI               VARCHAR(256),
  ALISR             VARCHAR(256),
  QNAM              VARCHAR(256),
  CIRCLR            CHAR(1),
  ANNTTNS           NUMERIC(20),
  ROOTTYP           NUMERIC(20),
  BASTYP            NUMERIC(20),
  SIMPLTYP          NUMERIC(20),
  COMPLXTYP         NUMERIC(20),
  DERVTNMTHD        NUMERIC(20),
  FINL              NUMERIC(20),
  ABSTRCT           CHAR(1),
  CONTNTTYPCTGRY    NUMERIC(20),
  PROHBTDSBSTTTNS   NUMERIC(20),
  LEXCLFNL          NUMERIC(20),
  BLOCK             NUMERIC(20),
  MIXD              CHAR(1),
  BASTYPDFNTN       NUMERIC(20),
  CONTNTTYP         NUMERIC(20),
  ATTRBTSS          NUMERIC(20),
  ATTRBTWLDCRD      NUMERIC(20),
  ROOTTYPDFNTN      NUMERIC(20),
  TXN_ID            NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDComplexTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetNamespace', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'TARGTNMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasName', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'ALISNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uRI', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasURI', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'ALISR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qName', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'QNAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: circular', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'CIRCLR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: annotations', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'ANNTTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootType', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'ROOTTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: baseType', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'BASTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleType', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'SIMPLTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: complexType', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'COMPLXTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: derivationMethod', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'DERVTNMTHD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: final', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'FINL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: abstract', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'ABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: contentTypeCategory', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'CONTNTTYPCTGRY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: prohibitedSubstitutions', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'PROHBTDSBSTTTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalFinal', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'LEXCLFNL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: block', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'BLOCK'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: mixed', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'MIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: baseTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'BASTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: contentType', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'CONTNTTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributeUses', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'ATTRBTSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributeWildcard', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'ATTRBTWLDCRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDCMPLXTYP', N'column', N'ROOTTYPDFNTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDDiagnostic
-- (generated from Xsd/XSDDiagnostic)

CREATE TABLE DD_XSD_XSDDGNSTC
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  ELEMNT         TEXT,
  CONTNR         NUMERIC(20),
  ROOTCNTNR      NUMERIC(20),
  SCHM           NUMERIC(20),
  SEVRTY         NUMERIC(20),
  MESSG          VARCHAR(256),
  LOCTNR         VARCHAR(256),
  LIN            NUMERIC(20),
  COLMN          NUMERIC(20),
  NOD            TEXT,
  ANNTTNR        VARCHAR(256),
  COMPNNTS       NUMERIC(20),
  PRIMRYCMPNNT   NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDDiagnostic', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: severity', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'SEVRTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: message', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'MESSG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: locationURI', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'LOCTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: line', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'LIN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: column', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'COLMN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: node', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'NOD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: annotationURI', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'ANNTTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: components', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'COMPNNTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: primaryComponent', N'user', @table_owner, N'table', N'DD_XSD_XSDDGNSTC', N'column', N'PRIMRYCMPNNT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDElementDeclaration
-- (generated from Xsd/XSDElementDeclaration)

CREATE TABLE DD_XSD_XSDLMNTDCLR
(
  LGCL_ID             VARCHAR(1000),
  UUID1               NUMERIC(20) NOT NULL,
  UUID2               NUMERIC(20) NOT NULL,
  UUID_STRING         VARCHAR(44) NOT NULL,
  ELEMNT              TEXT,
  CONTNR              NUMERIC(20),
  ROOTCNTNR           NUMERIC(20),
  SCHM                NUMERIC(20),
  NAM                 VARCHAR(256),
  TARGTNMSPC          VARCHAR(256),
  ALISNM              VARCHAR(256),
  URI                 VARCHAR(256),
  ALISR               VARCHAR(256),
  QNAM                VARCHAR(256),
  VAL                 TEXT,
  CONSTRNT            NUMERIC(20),
  FORM                NUMERIC(20),
  LEXCLVL             VARCHAR(256),
  GLOBL               CHAR(1),
  FEATRRFRNC          CHAR(1),
  SCOP                NUMERIC(20),
  RESLVDFTR           NUMERIC(20),
  TYP                 NUMERIC(20),
  NILLBL              CHAR(1),
  DISLLWDSBSTTTNS     NUMERIC(20),
  SUBSTTTNGRPXCLSNS   NUMERIC(20),
  ABSTRCT             CHAR(1),
  LEXCLFNL            NUMERIC(20),
  BLOCK               NUMERIC(20),
  ELEMNTDCLRTNRFRNC   CHAR(1),
  CIRCLR              CHAR(1),
  TYPDFNTN            NUMERIC(20),
  RESLVDLMNTDCLRTN    NUMERIC(20),
  SUBSTTTNGRPFFLTN    NUMERIC(20),
  SUBSTTTNGRP         NUMERIC(20),
  TXN_ID              NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDElementDeclaration', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetNamespace', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'TARGTNMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasName', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'ALISNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uRI', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasURI', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'ALISR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qName', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'QNAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: constraint', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'CONSTRNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: form', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'FORM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: global', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'GLOBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: featureReference', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'FEATRRFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: scope', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'SCOP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvedFeature', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'RESLVDFTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'TYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nillable', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'NILLBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: disallowedSubstitutions', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'DISLLWDSBSTTTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: substitutionGroupExclusions', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'SUBSTTTNGRPXCLSNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: abstract', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'ABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalFinal', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'LEXCLFNL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: block', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'BLOCK'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: elementDeclarationReference', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'ELEMNTDCLRTNRFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: circular', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'CIRCLR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: typeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'TYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvedElementDeclaration', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'RESLVDLMNTDCLRTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: substitutionGroupAffiliation', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'SUBSTTTNGRPFFLTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: substitutionGroup', N'user', @table_owner, N'table', N'DD_XSD_XSDLMNTDCLR', N'column', N'SUBSTTTNGRP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDEnumerationFacet
-- (generated from Xsd/XSDEnumerationFacet)

CREATE TABLE DD_XSD_XSDNMRTNFCT
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  ANNTTNS         NUMERIC(20),
  VAL             TEXT,
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDEnumerationFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: annotations', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'ANNTTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRTNFCT', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDFractionDigitsFacet
-- (generated from Xsd/XSDFractionDigitsFacet)

CREATE TABLE DD_XSD_XSDFRCTNDGT
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  FIXD            CHAR(1),
  VAL             NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDFractionDigitsFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixed', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'FIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDFRCTNDGT', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDIdentityConstraintDefinition
-- (generated from Xsd/XSDIdentityConstraintDefinition)

CREATE TABLE DD_XSD_XSDDNTTYC_1
(
  LGCL_ID               VARCHAR(1000),
  UUID1                 NUMERIC(20) NOT NULL,
  UUID2                 NUMERIC(20) NOT NULL,
  UUID_STRING           VARCHAR(44) NOT NULL,
  ELEMNT                TEXT,
  CONTNR                NUMERIC(20),
  ROOTCNTNR             NUMERIC(20),
  SCHM                  NUMERIC(20),
  NAM                   VARCHAR(256),
  TARGTNMSPC            VARCHAR(256),
  ALISNM                VARCHAR(256),
  URI                   VARCHAR(256),
  ALISR                 VARCHAR(256),
  QNAM                  VARCHAR(256),
  IDENTTYCNSTRNTCTGRY   NUMERIC(20),
  REFRNCDKY             NUMERIC(20),
  TXN_ID                NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDIdentityConstraintDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetNamespace', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'TARGTNMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasName', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'ALISNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uRI', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasURI', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'ALISR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qName', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'QNAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: identityConstraintCategory', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'IDENTTYCNSTRNTCTGRY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: referencedKey', N'user', @table_owner, N'table', N'DD_XSD_XSDDNTTYC_1', N'column', N'REFRNCDKY'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDImport
-- (generated from Xsd/XSDImport)

CREATE TABLE DD_XSD_XSDMPRT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  ELEMNT        TEXT,
  CONTNR        NUMERIC(20),
  ROOTCNTNR     NUMERIC(20),
  SCHM          NUMERIC(20),
  SCHMLCTN      VARCHAR(256),
  RESLVDSCHM    NUMERIC(20),
  NAMSPC        VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDImport', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schemaLocation', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT', N'column', N'SCHMLCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvedSchema', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT', N'column', N'RESLVDSCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: namespace', N'user', @table_owner, N'table', N'DD_XSD_XSDMPRT', N'column', N'NAMSPC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDInclude
-- (generated from Xsd/XSDInclude)

CREATE TABLE DD_XSD_XSDNCLD
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  ELEMNT         TEXT,
  CONTNR         NUMERIC(20),
  ROOTCNTNR      NUMERIC(20),
  SCHM           NUMERIC(20),
  SCHMLCTN       VARCHAR(256),
  RESLVDSCHM     NUMERIC(20),
  INCRPRTDSCHM   NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDInclude', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schemaLocation', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD', N'column', N'SCHMLCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvedSchema', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD', N'column', N'RESLVDSCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: incorporatedSchema', N'user', @table_owner, N'table', N'DD_XSD_XSDNCLD', N'column', N'INCRPRTDSCHM'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDLengthFacet
-- (generated from Xsd/XSDLengthFacet)

CREATE TABLE DD_XSD_XSDLNGTHFCT
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  FIXD            CHAR(1),
  VAL             NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDLengthFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixed', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'FIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDLNGTHFCT', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDMaxExclusiveFacet
-- (generated from Xsd/XSDMaxExclusiveFacet)

CREATE TABLE DD_XSD_XSDMXXCLSVF
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  FIXD            CHAR(1),
  VAL             TEXT,
  INCLSV          CHAR(1),
  EXCLSV          CHAR(1),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDMaxExclusiveFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixed', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'FIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inclusive', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'INCLSV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: exclusive', N'user', @table_owner, N'table', N'DD_XSD_XSDMXXCLSVF', N'column', N'EXCLSV'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDMaxInclusiveFacet
-- (generated from Xsd/XSDMaxInclusiveFacet)

CREATE TABLE DD_XSD_XSDMXNCLSVF
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  FIXD            CHAR(1),
  VAL             TEXT,
  INCLSV          CHAR(1),
  EXCLSV          CHAR(1),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDMaxInclusiveFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixed', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'FIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inclusive', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'INCLSV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: exclusive', N'user', @table_owner, N'table', N'DD_XSD_XSDMXNCLSVF', N'column', N'EXCLSV'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDMaxLengthFacet
-- (generated from Xsd/XSDMaxLengthFacet)

CREATE TABLE DD_XSD_XSDMXLNGTHF
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  FIXD            CHAR(1),
  VAL             NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDMaxLengthFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixed', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'FIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDMXLNGTHF', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDMinExclusiveFacet
-- (generated from Xsd/XSDMinExclusiveFacet)

CREATE TABLE DD_XSD_XSDMNXCLSVF
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  FIXD            CHAR(1),
  VAL             TEXT,
  INCLSV          CHAR(1),
  EXCLSV          CHAR(1),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDMinExclusiveFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixed', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'FIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inclusive', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'INCLSV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: exclusive', N'user', @table_owner, N'table', N'DD_XSD_XSDMNXCLSVF', N'column', N'EXCLSV'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDMinInclusiveFacet
-- (generated from Xsd/XSDMinInclusiveFacet)

CREATE TABLE DD_XSD_XSDMNNCLSVF
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  FIXD            CHAR(1),
  VAL             TEXT,
  INCLSV          CHAR(1),
  EXCLSV          CHAR(1),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDMinInclusiveFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixed', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'FIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'VAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inclusive', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'INCLSV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: exclusive', N'user', @table_owner, N'table', N'DD_XSD_XSDMNNCLSVF', N'column', N'EXCLSV'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDMinLengthFacet
-- (generated from Xsd/XSDMinLengthFacet)

CREATE TABLE DD_XSD_XSDMNLNGTHF
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  FIXD            CHAR(1),
  VAL             NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDMinLengthFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixed', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'FIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDMNLNGTHF', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDModelGroup
-- (generated from Xsd/XSDModelGroup)

CREATE TABLE DD_XSD_XSDMDLGRP
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  ELEMNT        TEXT,
  CONTNR        NUMERIC(20),
  ROOTCNTNR     NUMERIC(20),
  SCHM          NUMERIC(20),
  COMPSTR       NUMERIC(20),
  PARTCLS       NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDModelGroup', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRP', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRP', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRP', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRP', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: compositor', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRP', N'column', N'COMPSTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: particles', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRP', N'column', N'PARTCLS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDModelGroupDefinition
-- (generated from Xsd/XSDModelGroupDefinition)

CREATE TABLE DD_XSD_XSDMDLGRPDF
(
  LGCL_ID             VARCHAR(1000),
  UUID1               NUMERIC(20) NOT NULL,
  UUID2               NUMERIC(20) NOT NULL,
  UUID_STRING         VARCHAR(44) NOT NULL,
  ELEMNT              TEXT,
  CONTNR              NUMERIC(20),
  ROOTCNTNR           NUMERIC(20),
  SCHM                NUMERIC(20),
  NAM                 VARCHAR(256),
  TARGTNMSPC          VARCHAR(256),
  ALISNM              VARCHAR(256),
  URI                 VARCHAR(256),
  ALISR               VARCHAR(256),
  QNAM                VARCHAR(256),
  CIRCLR              CHAR(1),
  MODLGRPDFNTNRFRNC   CHAR(1),
  RESLVDMDLGRPDFNTN   NUMERIC(20),
  TXN_ID              NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDModelGroupDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetNamespace', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'TARGTNMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasName', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'ALISNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uRI', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasURI', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'ALISR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qName', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'QNAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: circular', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'CIRCLR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: modelGroupDefinitionReference', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'MODLGRPDFNTNRFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvedModelGroupDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDMDLGRPDF', N'column', N'RESLVDMDLGRPDFNTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDNotationDeclaration
-- (generated from Xsd/XSDNotationDeclaration)

CREATE TABLE DD_XSD_XSDNTTNDCLR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  ELEMNT        TEXT,
  CONTNR        NUMERIC(20),
  ROOTCNTNR     NUMERIC(20),
  SCHM          NUMERIC(20),
  NAM           VARCHAR(256),
  TARGTNMSPC    VARCHAR(256),
  ALISNM        VARCHAR(256),
  URI           VARCHAR(256),
  ALISR         VARCHAR(256),
  QNAM          VARCHAR(256),
  SYSTMDNTFR    VARCHAR(256),
  PUBLCDNTFR    VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDNotationDeclaration', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetNamespace', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'TARGTNMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasName', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'ALISNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uRI', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasURI', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'ALISR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qName', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'QNAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: systemIdentifier', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'SYSTMDNTFR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: publicIdentifier', N'user', @table_owner, N'table', N'DD_XSD_XSDNTTNDCLR', N'column', N'PUBLCDNTFR'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDNumericFacet
-- (generated from Xsd/XSDNumericFacet)

CREATE TABLE DD_XSD_XSDNMRCFCT
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  VAL             CHAR(1),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDNumericFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDNMRCFCT', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDOrderedFacet
-- (generated from Xsd/XSDOrderedFacet)

CREATE TABLE DD_XSD_XSDRDRDFCT
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  VAL             NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDOrderedFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDRDRDFCT', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDParticle
-- (generated from Xsd/XSDParticle)

CREATE TABLE DD_XSD_XSDPRTCL
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  ELEMNT        TEXT,
  CONTNR        NUMERIC(20),
  ROOTCNTNR     NUMERIC(20),
  SCHM          NUMERIC(20),
  MINCCRS       NUMERIC(20),
  MAXCCRS       NUMERIC(20),
  TERM          NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDParticle', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minOccurs', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL', N'column', N'MINCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxOccurs', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL', N'column', N'MAXCCRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: term', N'user', @table_owner, N'table', N'DD_XSD_XSDPRTCL', N'column', N'TERM'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDPatternFacet
-- (generated from Xsd/XSDPatternFacet)

CREATE TABLE DD_XSD_XSDPTTRNFCT
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  ANNTTNS         NUMERIC(20),
  VAL             TEXT,
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDPatternFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: annotations', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'ANNTTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDPTTRNFCT', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDRedefine
-- (generated from Xsd/XSDRedefine)

CREATE TABLE DD_XSD_XSDRDFN
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  ELEMNT         TEXT,
  CONTNR         NUMERIC(20),
  ROOTCNTNR      NUMERIC(20),
  SCHM           NUMERIC(20),
  SCHMLCTN       VARCHAR(256),
  RESLVDSCHM     NUMERIC(20),
  INCRPRTDSCHM   NUMERIC(20),
  ANNTTNS        NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDRedefine', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schemaLocation', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'SCHMLCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvedSchema', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'RESLVDSCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: incorporatedSchema', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'INCRPRTDSCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: annotations', N'user', @table_owner, N'table', N'DD_XSD_XSDRDFN', N'column', N'ANNTTNS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDSchema
-- (generated from Xsd/XSDSchema)

CREATE TABLE DD_XSD_XSDSCHM
(
  LGCL_ID                VARCHAR(1000),
  UUID1                  NUMERIC(20) NOT NULL,
  UUID2                  NUMERIC(20) NOT NULL,
  UUID_STRING            VARCHAR(44) NOT NULL,
  ELEMNT                 TEXT,
  CONTNR                 NUMERIC(20),
  ROOTCNTNR              NUMERIC(20),
  SCHM                   NUMERIC(20),
  DOCMNT                 TEXT,
  SCHMLCTN               VARCHAR(256),
  TARGTNMSPC             VARCHAR(256),
  ATTRBTFRMDFLT          NUMERIC(20),
  ELEMNTFRMDFLT          NUMERIC(20),
  FINLDFLT               NUMERIC(20),
  BLOCKDFLT              NUMERIC(20),
  VERSN                  VARCHAR(256),
  ELEMNTDCLRTNS          NUMERIC(20),
  ATTRBTDCLRTNS          NUMERIC(20),
  ATTRBTGRPDFNTNS        NUMERIC(20),
  TYPDFNTNS              NUMERIC(20),
  MODLGRPDFNTNS          NUMERIC(20),
  IDENTTYCNSTRNTDFNTNS   NUMERIC(20),
  NOTTNDCLRTNS           NUMERIC(20),
  ANNTTNS                NUMERIC(20),
  ALLDGNSTCS             NUMERIC(20),
  REFRNCNGDRCTVS         NUMERIC(20),
  ROOTVRSN               NUMERIC(20),
  ORIGNLVRSN             NUMERIC(20),
  SCHMFRSCHM             NUMERIC(20),
  TXN_ID                 NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDSchema', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: document', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'DOCMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schemaLocation', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'SCHMLCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetNamespace', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'TARGTNMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributeFormDefault', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ATTRBTFRMDFLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: elementFormDefault', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ELEMNTFRMDFLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: finalDefault', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'FINLDFLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: blockDefault', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'BLOCKDFLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: version', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'VERSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: elementDeclarations', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ELEMNTDCLRTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributeDeclarations', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ATTRBTDCLRTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: attributeGroupDefinitions', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ATTRBTGRPDFNTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: typeDefinitions', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'TYPDFNTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: modelGroupDefinitions', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'MODLGRPDFNTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: identityConstraintDefinitions', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'IDENTTYCNSTRNTDFNTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: notationDeclarations', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'NOTTNDCLRTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: annotations', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ANNTTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: allDiagnostics', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ALLDGNSTCS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: referencingDirectives', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'REFRNCNGDRCTVS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootVersion', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ROOTVRSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: originalVersion', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'ORIGNLVRSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schemaForSchema', N'user', @table_owner, N'table', N'DD_XSD_XSDSCHM', N'column', N'SCHMFRSCHM'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDSimpleTypeDefinition
-- (generated from Xsd/XSDSimpleTypeDefinition)

CREATE TABLE DD_XSD_XSDSMPLTYPD
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  ELEMNT               TEXT,
  CONTNR               NUMERIC(20),
  ROOTCNTNR            NUMERIC(20),
  SCHM                 NUMERIC(20),
  NAM                  VARCHAR(256),
  TARGTNMSPC           VARCHAR(256),
  ALISNM               VARCHAR(256),
  URI                  VARCHAR(256),
  ALISR                VARCHAR(256),
  QNAM                 VARCHAR(256),
  CIRCLR               CHAR(1),
  ANNTTNS              NUMERIC(20),
  ROOTTYP              NUMERIC(20),
  BASTYP               NUMERIC(20),
  SIMPLTYP             NUMERIC(20),
  COMPLXTYP            NUMERIC(20),
  VARTY                NUMERIC(20),
  FINL                 NUMERIC(20),
  LEXCLFNL             NUMERIC(20),
  VALDFCTS             VARCHAR(256),
  FACTS                NUMERIC(20),
  MEMBRTYPDFNTNS       NUMERIC(20),
  BASTYPDFNTN          NUMERIC(20),
  PRIMTVTYPDFNTN       NUMERIC(20),
  ITEMTYPDFNTN         NUMERIC(20),
  ROOTTYPDFNTN         NUMERIC(20),
  MINFCT               NUMERIC(20),
  MAXFCT               NUMERIC(20),
  MAXNCLSVFCT          NUMERIC(20),
  MINNCLSVFCT          NUMERIC(20),
  MINXCLSVFCT          NUMERIC(20),
  MAXXCLSVFCT          NUMERIC(20),
  LENGTHFCT            NUMERIC(20),
  WHITSPCFCT           NUMERIC(20),
  ENUMRTNFCTS          NUMERIC(20),
  PATTRNFCTS           NUMERIC(20),
  CARDNLTYFCT          NUMERIC(20),
  NUMRCFCT             NUMERIC(20),
  MAXLNGTHFCT          NUMERIC(20),
  MINLNGTHFCT          NUMERIC(20),
  TOTLDGTSFCT          NUMERIC(20),
  FRACTNDGTSFCT        NUMERIC(20),
  ORDRDFCT             NUMERIC(20),
  BOUNDDFCT            NUMERIC(20),
  EFFCTVMXFCT          NUMERIC(20),
  EFFCTVWHTSPCFCT      NUMERIC(20),
  EFFCTVMXLNGTHFCT     NUMERIC(20),
  EFFCTVFRCTNDGTSFCT   NUMERIC(20),
  EFFCTVPTTRNFCT       NUMERIC(20),
  EFFCTVNMRTNFCT       NUMERIC(20),
  EFFCTVTTLDGTSFCT     NUMERIC(20),
  EFFCTVMNLNGTHFCT     NUMERIC(20),
  EFFCTVLNGTHFCT       NUMERIC(20),
  EFFCTVMNFCT          NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDSimpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targetNamespace', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'TARGTNMSPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasName', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'ALISNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uRI', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasURI', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'ALISR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: qName', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'QNAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: circular', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'CIRCLR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: annotations', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'ANNTTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootType', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'ROOTTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: baseType', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'BASTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleType', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'SIMPLTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: complexType', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'COMPLXTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: variety', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'VARTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: final', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'FINL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalFinal', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'LEXCLFNL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: validFacets', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'VALDFCTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facets', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'FACTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: memberTypeDefinitions', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'MEMBRTYPDFNTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: baseTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'BASTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: primitiveTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'PRIMTVTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: itemTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'ITEMTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'ROOTTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'MINFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'MAXFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxInclusiveFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'MAXNCLSVFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minInclusiveFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'MINNCLSVFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minExclusiveFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'MINXCLSVFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxExclusiveFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'MAXXCLSVFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lengthFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'LENGTHFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: whiteSpaceFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'WHITSPCFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: enumerationFacets', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'ENUMRTNFCTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: patternFacets', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'PATTRNFCTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: cardinalityFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'CARDNLTYFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: numericFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'NUMRCFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxLengthFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'MAXLNGTHFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minLengthFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'MINLNGTHFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: totalDigitsFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'TOTLDGTSFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fractionDigitsFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'FRACTNDGTSFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: orderedFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'ORDRDFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: boundedFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'BOUNDDFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveMaxFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'EFFCTVMXFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveWhiteSpaceFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'EFFCTVWHTSPCFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveMaxLengthFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'EFFCTVMXLNGTHFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveFractionDigitsFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'EFFCTVFRCTNDGTSFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectivePatternFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'EFFCTVPTTRNFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveEnumerationFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'EFFCTVNMRTNFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveTotalDigitsFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'EFFCTVTTLDGTSFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveMinLengthFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'EFFCTVMNLNGTHFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveLengthFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'EFFCTVLNGTHFCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveMinFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDSMPLTYPD', N'column', N'EFFCTVMNFCT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDTotalDigitsFacet
-- (generated from Xsd/XSDTotalDigitsFacet)

CREATE TABLE DD_XSD_XSDTTLDGTSF
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  FIXD            CHAR(1),
  VAL             NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDTotalDigitsFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixed', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'FIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDTTLDGTSF', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDWhiteSpaceFacet
-- (generated from Xsd/XSDWhiteSpaceFacet)

CREATE TABLE DD_XSD_XSDWHTSPCFC
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  ELEMNT          TEXT,
  CONTNR          NUMERIC(20),
  ROOTCNTNR       NUMERIC(20),
  SCHM            NUMERIC(20),
  LEXCLVL         TEXT,
  FACTNM          VARCHAR(256),
  EFFCTVVL        TEXT,
  SIMPLTYPDFNTN   NUMERIC(20),
  FIXD            CHAR(1),
  VAL             NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDWhiteSpaceFacet', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalValue', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'LEXCLVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: facetName', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'FACTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: effectiveValue', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'EFFCTVVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: simpleTypeDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'SIMPLTYPDFNTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixed', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'FIXD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDWHTSPCFC', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDWildcard
-- (generated from Xsd/XSDWildcard)

CREATE TABLE DD_XSD_XSDWLDCRD
(
  LGCL_ID              VARCHAR(1000),
  UUID1                NUMERIC(20) NOT NULL,
  UUID2                NUMERIC(20) NOT NULL,
  UUID_STRING          VARCHAR(44) NOT NULL,
  ELEMNT               TEXT,
  CONTNR               NUMERIC(20),
  ROOTCNTNR            NUMERIC(20),
  SCHM                 NUMERIC(20),
  NAMSPCCNSTRNTCTGRY   NUMERIC(20),
  NAMSPCCNSTRNT        VARCHAR(256),
  PROCSSCNTNTS         NUMERIC(20),
  LEXCLNMSPCCNSTRNT    VARCHAR(256),
  ANNTTNS              NUMERIC(20),
  TXN_ID               NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDWildcard', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: namespaceConstraintCategory', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'NAMSPCCNSTRNTCTGRY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: namespaceConstraint', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'NAMSPCCNSTRNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: processContents', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'PROCSSCNTNTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lexicalNamespaceConstraint', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'LEXCLNMSPCCNSTRNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: annotations', N'user', @table_owner, N'table', N'DD_XSD_XSDWLDCRD', N'column', N'ANNTTNS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: XSDXPathDefinition
-- (generated from Xsd/XSDXPathDefinition)

CREATE TABLE DD_XSD_XSDXPTHDFNT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  ELEMNT        TEXT,
  CONTNR        NUMERIC(20),
  ROOTCNTNR     NUMERIC(20),
  SCHM          NUMERIC(20),
  VARTY         NUMERIC(20),
  VAL           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: XSDXPathDefinition', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHDFNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHDFNT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHDFNT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHDFNT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: element', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHDFNT', N'column', N'ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: container', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHDFNT', N'column', N'CONTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: rootContainer', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHDFNT', N'column', N'ROOTCNTNR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: schema', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHDFNT', N'column', N'SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: variety', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHDFNT', N'column', N'VARTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_XSD_XSDXPTHDFNT', N'column', N'VAL'
GO

--
-- The model class name for the set enumeration values held in this table is: RecursionErrorMode
-- (generated from Transformation/RecursionErrorMode)

CREATE TABLE DD_TRAN_RECRSNRRRM
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: RecursionErrorMode', N'user', @table_owner, N'table', N'DD_TRAN_RECRSNRRRM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_TRAN_RECRSNRRRM', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_TRAN_RECRSNRRRM', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: JoinType
-- (generated from Transformation/JoinType)

CREATE TABLE DD_TRAN_JOINTYP
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: JoinType', N'user', @table_owner, N'table', N'DD_TRAN_JOINTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_TRAN_JOINTYP', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_TRAN_JOINTYP', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: SortDirection
-- (generated from Transformation/SortDirection)

CREATE TABLE DD_TRAN_SORTDRCTN
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: SortDirection', N'user', @table_owner, N'table', N'DD_TRAN_SORTDRCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_TRAN_SORTDRCTN', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_TRAN_SORTDRCTN', N'column', N'VALUE'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: TransformationContainer
-- (generated from Transformation/TransformationContainer)

CREATE TABLE DD_TRAN_TRANSFRMTN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: TransformationContainer', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRMTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRMTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRMTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRMTN', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: SqlTransformation
-- (generated from Transformation/SqlTransformation)

CREATE TABLE DD_TRAN_SQLTRNSFRM
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  HELPDBJCT      NUMERIC(20),
  SELCTSQL       TEXT,
  INSRTSQL       TEXT,
  UPDTSQL        TEXT,
  DELTSQL        TEXT,
  INSRTLLWD      CHAR(1),
  UPDTLLWD       CHAR(1),
  DELTLLWD       CHAR(1),
  OUTPTLCKD      CHAR(1),
  INSRTSQLDFLT   CHAR(1),
  UPDTSQLDFLT    CHAR(1),
  DELTSQLDFLT    CHAR(1),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: SqlTransformation', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: helpedObject', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'HELPDBJCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: selectSql', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'SELCTSQL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: insertSql', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'INSRTSQL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: updateSql', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'UPDTSQL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: deleteSql', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'DELTSQL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: insertAllowed', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'INSRTLLWD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: updateAllowed', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'UPDTLLWD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: deleteAllowed', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'DELTLLWD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLocked', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'OUTPTLCKD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: insertSqlDefault', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'INSRTSQLDFLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: updateSqlDefault', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'UPDTSQLDFLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: deleteSqlDefault', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSFRM', N'column', N'DELTSQLDFLT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: TransformationMapping
-- (generated from Transformation/TransformationMapping)

CREATE TABLE DD_TRAN_TRANSFRM_1
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  INPTS         NUMERIC(20),
  OUTPTS        NUMERIC(20),
  TYPMPPNG      NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: TransformationMapping', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRM_1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRM_1', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRM_1', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRM_1', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputs', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRM_1', N'column', N'INPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputs', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRM_1', N'column', N'OUTPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: typeMapping', N'user', @table_owner, N'table', N'DD_TRAN_TRANSFRM_1', N'column', N'TYPMPPNG'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: SqlAlias
-- (generated from Transformation/SqlAlias)

CREATE TABLE DD_TRAN_SQLLS
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  ALIS          VARCHAR(256),
  ALISDBJCT     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: SqlAlias', N'user', @table_owner, N'table', N'DD_TRAN_SQLLS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SQLLS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SQLLS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_SQLLS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: alias', N'user', @table_owner, N'table', N'DD_TRAN_SQLLS', N'column', N'ALIS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: aliasedObject', N'user', @table_owner, N'table', N'DD_TRAN_SQLLS', N'column', N'ALISDBJCT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: SqlTransformationMappingRoot
-- (generated from Transformation/SqlTransformationMappingRoot)

CREATE TABLE DD_TRAN_SQLTRNSF_1
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  INPTS         NUMERIC(20),
  OUTPTS        NUMERIC(20),
  TYPMPPNG      NUMERIC(20),
  OUTPTRDNLY    CHAR(1),
  TOPTBTTM      CHAR(1),
  COMMNDSTCK    VARCHAR(256),
  TARGT         NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: SqlTransformationMappingRoot', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputs', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1', N'column', N'INPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputs', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1', N'column', N'OUTPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: typeMapping', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1', N'column', N'TYPMPPNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputReadOnly', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1', N'column', N'OUTPTRDNLY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: topToBottom', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1', N'column', N'TOPTBTTM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: commandStack', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1', N'column', N'COMMNDSTCK'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_TRAN_SQLTRNSF_1', N'column', N'TARGT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: FragmentMappingRoot
-- (generated from Transformation/FragmentMappingRoot)

CREATE TABLE DD_TRAN_FRAGMNTMPP
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  INPTS         NUMERIC(20),
  OUTPTS        NUMERIC(20),
  TYPMPPNG      NUMERIC(20),
  OUTPTRDNLY    CHAR(1),
  TOPTBTTM      CHAR(1),
  COMMNDSTCK    VARCHAR(256),
  TARGT         NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: FragmentMappingRoot', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputs', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP', N'column', N'INPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputs', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP', N'column', N'OUTPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: typeMapping', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP', N'column', N'TYPMPPNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputReadOnly', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP', N'column', N'OUTPTRDNLY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: topToBottom', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP', N'column', N'TOPTBTTM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: commandStack', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP', N'column', N'COMMNDSTCK'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_TRAN_FRAGMNTMPP', N'column', N'TARGT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: TreeMappingRoot
-- (generated from Transformation/TreeMappingRoot)

CREATE TABLE DD_TRAN_TREMPPNGRT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  INPTS         NUMERIC(20),
  OUTPTS        NUMERIC(20),
  TYPMPPNG      NUMERIC(20),
  OUTPTRDNLY    CHAR(1),
  TOPTBTTM      CHAR(1),
  COMMNDSTCK    VARCHAR(256),
  TARGT         NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: TreeMappingRoot', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputs', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT', N'column', N'INPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputs', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT', N'column', N'OUTPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: typeMapping', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT', N'column', N'TYPMPPNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputReadOnly', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT', N'column', N'OUTPTRDNLY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: topToBottom', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT', N'column', N'TOPTBTTM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: commandStack', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT', N'column', N'COMMNDSTCK'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_TRAN_TREMPPNGRT', N'column', N'TARGT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: MappingClass
-- (generated from Transformation/MappingClass)

CREATE TABLE DD_TRAN_MAPPNGCLSS
(
  LGCL_ID          VARCHAR(1000),
  UUID1            NUMERIC(20) NOT NULL,
  UUID2            NUMERIC(20) NOT NULL,
  UUID_STRING      VARCHAR(44) NOT NULL,
  NAM              VARCHAR(256),
  RECRSV           CHAR(1),
  RECRSNLLWD       CHAR(1),
  RECRSNCRTR       VARCHAR(256),
  RECRSNLMT        NUMERIC(20),
  RECRSNLMTRRRMD   NUMERIC(20),
  TXN_ID           NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: MappingClass', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCLSS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCLSS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCLSS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCLSS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCLSS', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursive', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCLSS', N'column', N'RECRSV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursionAllowed', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCLSS', N'column', N'RECRSNLLWD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursionCriteria', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCLSS', N'column', N'RECRSNCRTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursionLimit', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCLSS', N'column', N'RECRSNLMT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursionLimitErrorMode', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCLSS', N'column', N'RECRSNLMTRRRMD'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: MappingClassColumn
-- (generated from Transformation/MappingClassColumn)

CREATE TABLE DD_TRAN_MAPPNGCL_1
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  TYP           NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: MappingClassColumn', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_1', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_1', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_1', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_1', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_1', N'column', N'TYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: StagingTable
-- (generated from Transformation/StagingTable)

CREATE TABLE DD_TRAN_STAGNGTBL
(
  LGCL_ID          VARCHAR(1000),
  UUID1            NUMERIC(20) NOT NULL,
  UUID2            NUMERIC(20) NOT NULL,
  UUID_STRING      VARCHAR(44) NOT NULL,
  NAM              VARCHAR(256),
  RECRSV           CHAR(1),
  RECRSNLLWD       CHAR(1),
  RECRSNCRTR       VARCHAR(256),
  RECRSNLMT        NUMERIC(20),
  RECRSNLMTRRRMD   NUMERIC(20),
  TXN_ID           NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: StagingTable', N'user', @table_owner, N'table', N'DD_TRAN_STAGNGTBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_STAGNGTBL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_STAGNGTBL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_STAGNGTBL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_STAGNGTBL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursive', N'user', @table_owner, N'table', N'DD_TRAN_STAGNGTBL', N'column', N'RECRSV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursionAllowed', N'user', @table_owner, N'table', N'DD_TRAN_STAGNGTBL', N'column', N'RECRSNLLWD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursionCriteria', N'user', @table_owner, N'table', N'DD_TRAN_STAGNGTBL', N'column', N'RECRSNCRTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursionLimit', N'user', @table_owner, N'table', N'DD_TRAN_STAGNGTBL', N'column', N'RECRSNLMT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: recursionLimitErrorMode', N'user', @table_owner, N'table', N'DD_TRAN_STAGNGTBL', N'column', N'RECRSNLMTRRRMD'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: MappingClassSet
-- (generated from Transformation/MappingClassSet)

CREATE TABLE DD_TRAN_MAPPNGCL_2
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TARGT         NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: MappingClassSet', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_2', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_2', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_2', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_2', N'column', N'TARGT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: MappingClassSetContainer
-- (generated from Transformation/MappingClassSetContainer)

CREATE TABLE DD_TRAN_MAPPNGCL_3
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: MappingClassSetContainer', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_3'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_3', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_3', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_MAPPNGCL_3', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: InputParameter
-- (generated from Transformation/InputParameter)

CREATE TABLE DD_TRAN_INPTPRMTR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  TYP           NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: InputParameter', N'user', @table_owner, N'table', N'DD_TRAN_INPTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_INPTPRMTR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_INPTPRMTR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_INPTPRMTR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_INPTPRMTR', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_TRAN_INPTPRMTR', N'column', N'TYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: InputSet
-- (generated from Transformation/InputSet)

CREATE TABLE DD_TRAN_INPTST
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: InputSet', N'user', @table_owner, N'table', N'DD_TRAN_INPTST'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_INPTST', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_INPTST', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_INPTST', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: InputBinding
-- (generated from Transformation/InputBinding)

CREATE TABLE DD_TRAN_INPTBNDNG
(
  LGCL_ID          VARCHAR(1000),
  UUID1            NUMERIC(20) NOT NULL,
  UUID2            NUMERIC(20) NOT NULL,
  UUID_STRING      VARCHAR(44) NOT NULL,
  INPTPRMTR        NUMERIC(20),
  MAPPNGCLSSCLMN   NUMERIC(20),
  TXN_ID           NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: InputBinding', N'user', @table_owner, N'table', N'DD_TRAN_INPTBNDNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_INPTBNDNG', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_INPTBNDNG', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_INPTBNDNG', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputParameter', N'user', @table_owner, N'table', N'DD_TRAN_INPTBNDNG', N'column', N'INPTPRMTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: mappingClassColumn', N'user', @table_owner, N'table', N'DD_TRAN_INPTBNDNG', N'column', N'MAPPNGCLSSCLMN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: DataFlowMappingRoot
-- (generated from Transformation/DataFlowMappingRoot)

CREATE TABLE DD_TRAN_DATFLWMPPN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  INPTS         NUMERIC(20),
  OUTPTS        NUMERIC(20),
  TYPMPPNG      NUMERIC(20),
  OUTPTRDNLY    CHAR(1),
  TOPTBTTM      CHAR(1),
  COMMNDSTCK    VARCHAR(256),
  TARGT         NUMERIC(20),
  ALLWSPTMZTN   CHAR(1),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: DataFlowMappingRoot', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputs', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'INPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputs', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'OUTPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: typeMapping', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'TYPMPPNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputReadOnly', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'OUTPTRDNLY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: topToBottom', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'TOPTBTTM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: commandStack', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'COMMNDSTCK'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'TARGT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: allowsOptimization', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWMPPN', N'column', N'ALLWSPTMZTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: DataFlowNode
-- (generated from Transformation/DataFlowNode)

CREATE TABLE DD_TRAN_DATFLWND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: DataFlowNode', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWND', N'column', N'OUTPTLNKS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: DataFlowLink
-- (generated from Transformation/DataFlowLink)

CREATE TABLE DD_TRAN_DATFLWLNK
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  OUTPTND       NUMERIC(20),
  INPTND        NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: DataFlowLink', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWLNK'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWLNK', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWLNK', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWLNK', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputNode', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWLNK', N'column', N'OUTPTND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputNode', N'user', @table_owner, N'table', N'DD_TRAN_DATFLWLNK', N'column', N'INPTND'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Expression
-- (generated from Transformation/Expression)

CREATE TABLE DD_TRAN_EXPRSSN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  VAL           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Expression', N'user', @table_owner, N'table', N'DD_TRAN_EXPRSSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_EXPRSSN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_EXPRSSN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_EXPRSSN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: value', N'user', @table_owner, N'table', N'DD_TRAN_EXPRSSN', N'column', N'VAL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: TargetNode
-- (generated from Transformation/TargetNode)

CREATE TABLE DD_TRAN_TARGTND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TARGT         NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: TargetNode', N'user', @table_owner, N'table', N'DD_TRAN_TARGTND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_TARGTND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_TARGTND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_TARGTND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_TARGTND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_TARGTND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_TARGTND', N'column', N'OUTPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: target', N'user', @table_owner, N'table', N'DD_TRAN_TARGTND', N'column', N'TARGT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: SourceNode
-- (generated from Transformation/SourceNode)

CREATE TABLE DD_TRAN_SOURCND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  SOURC         NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: SourceNode', N'user', @table_owner, N'table', N'DD_TRAN_SOURCND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SOURCND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SOURCND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_SOURCND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_SOURCND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_SOURCND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_SOURCND', N'column', N'OUTPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: source', N'user', @table_owner, N'table', N'DD_TRAN_SOURCND', N'column', N'SOURC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: OperationNodeGroup
-- (generated from Transformation/OperationNodeGroup)

CREATE TABLE DD_TRAN_OPERTNNDGR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: OperationNodeGroup', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNNDGR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNNDGR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNNDGR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNNDGR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNNDGR', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNNDGR', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNNDGR', N'column', N'OUTPTLNKS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: OperationNode
-- (generated from Transformation/OperationNode)

CREATE TABLE DD_TRAN_OPERTNND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: OperationNode', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_OPERTNND', N'column', N'OUTPTLNKS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: JoinNode
-- (generated from Transformation/JoinNode)

CREATE TABLE DD_TRAN_JOINND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TYP           NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: JoinNode', N'user', @table_owner, N'table', N'DD_TRAN_JOINND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_JOINND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_JOINND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_JOINND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_JOINND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_JOINND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_JOINND', N'column', N'OUTPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_TRAN_JOINND', N'column', N'TYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: UnionNode
-- (generated from Transformation/UnionNode)

CREATE TABLE DD_TRAN_UNINND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: UnionNode', N'user', @table_owner, N'table', N'DD_TRAN_UNINND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_UNINND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_UNINND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_UNINND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_UNINND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_UNINND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_UNINND', N'column', N'OUTPTLNKS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ProjectionNode
-- (generated from Transformation/ProjectionNode)

CREATE TABLE DD_TRAN_PROJCTNND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ProjectionNode', N'user', @table_owner, N'table', N'DD_TRAN_PROJCTNND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_PROJCTNND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_PROJCTNND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_PROJCTNND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_PROJCTNND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_PROJCTNND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_PROJCTNND', N'column', N'OUTPTLNKS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: FilterNode
-- (generated from Transformation/FilterNode)

CREATE TABLE DD_TRAN_FILTRND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: FilterNode', N'user', @table_owner, N'table', N'DD_TRAN_FILTRND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_FILTRND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_FILTRND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_FILTRND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_FILTRND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_FILTRND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_FILTRND', N'column', N'OUTPTLNKS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: GroupingNode
-- (generated from Transformation/GroupingNode)

CREATE TABLE DD_TRAN_GROPNGND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: GroupingNode', N'user', @table_owner, N'table', N'DD_TRAN_GROPNGND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_GROPNGND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_GROPNGND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_GROPNGND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_GROPNGND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_GROPNGND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_GROPNGND', N'column', N'OUTPTLNKS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: DupRemovalNode
-- (generated from Transformation/DupRemovalNode)

CREATE TABLE DD_TRAN_DUPRMVLND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: DupRemovalNode', N'user', @table_owner, N'table', N'DD_TRAN_DUPRMVLND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_DUPRMVLND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_DUPRMVLND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_DUPRMVLND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_DUPRMVLND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_DUPRMVLND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_DUPRMVLND', N'column', N'OUTPTLNKS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: SortNode
-- (generated from Transformation/SortNode)

CREATE TABLE DD_TRAN_SORTND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: SortNode', N'user', @table_owner, N'table', N'DD_TRAN_SORTND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SORTND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SORTND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_SORTND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_SORTND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_SORTND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_SORTND', N'column', N'OUTPTLNKS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: SqlNode
-- (generated from Transformation/SqlNode)

CREATE TABLE DD_TRAN_SQLND
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  INPTLNKS      NUMERIC(20),
  OUTPTLNKS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: SqlNode', N'user', @table_owner, N'table', N'DD_TRAN_SQLND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SQLND', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_TRAN_SQLND', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_TRAN_SQLND', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_TRAN_SQLND', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputLinks', N'user', @table_owner, N'table', N'DD_TRAN_SQLND', N'column', N'INPTLNKS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputLinks', N'user', @table_owner, N'table', N'DD_TRAN_SQLND', N'column', N'OUTPTLNKS'
GO

--
-- The model class name for the set enumeration values held in this table is: NullableType
-- (generated from Relational/NullableType)

CREATE TABLE DD_RELT_NULLBLTYP
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: NullableType', N'user', @table_owner, N'table', N'DD_RELT_NULLBLTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_RELT_NULLBLTYP', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_RELT_NULLBLTYP', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: DirectionKind
-- (generated from Relational/DirectionKind)

CREATE TABLE DD_RELT_DIRCTNKND
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: DirectionKind', N'user', @table_owner, N'table', N'DD_RELT_DIRCTNKND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_RELT_DIRCTNKND', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_RELT_DIRCTNKND', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: MultiplicityKind
-- (generated from Relational/MultiplicityKind)

CREATE TABLE DD_RELT_MULTPLCTYK
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: MultiplicityKind', N'user', @table_owner, N'table', N'DD_RELT_MULTPLCTYK'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_RELT_MULTPLCTYK', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_RELT_MULTPLCTYK', N'column', N'VALUE'
GO

--
-- The model class name for the set enumeration values held in this table is: SearchabilityType
-- (generated from Relational/SearchabilityType)

CREATE TABLE DD_RELT_SEARCHBLTY
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: SearchabilityType', N'user', @table_owner, N'table', N'DD_RELT_SEARCHBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_RELT_SEARCHBLTY', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_RELT_SEARCHBLTY', N'column', N'VALUE'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Column
-- (generated from Relational/Column)

CREATE TABLE DD_RELT_COLMN
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  NAM            VARCHAR(256),
  NAMNSRC        VARCHAR(256),
  NATVTYP        VARCHAR(256),
  LENGTH         NUMERIC(20),
  FIXDLNGTH      CHAR(1),
  PRECSN         NUMERIC(20),
  SCAL           NUMERIC(20),
  NULLBL         NUMERIC(20),
  AUTNCRMNTD     CHAR(1),
  DEFLTVL        VARCHAR(256),
  MINMMVL        VARCHAR(256),
  MAXMMVL        VARCHAR(256),
  FORMT          VARCHAR(256),
  CHARCTRSTNM    VARCHAR(256),
  COLLTNNM       VARCHAR(256),
  SELCTBL        CHAR(1),
  UPDTBL         CHAR(1),
  CASSNSTV       CHAR(1),
  SEARCHBLTY     NUMERIC(20),
  CURRNCY        CHAR(1),
  RADX           NUMERIC(20),
  SIGND          CHAR(1),
  DISTNCTVLCNT   NUMERIC(20),
  NULLVLCNT      NUMERIC(20),
  UNIQKYS        NUMERIC(20),
  INDXS          NUMERIC(20),
  FORGNKYS       NUMERIC(20),
  ACCSSPTTRNS    NUMERIC(20),
  TYP            NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Column', N'user', @table_owner, N'table', N'DD_RELT_COLMN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nativeType', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'NATVTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: length', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'LENGTH'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixedLength', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'FIXDLNGTH'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: precision', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'PRECSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: scale', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'SCAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nullable', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'NULLBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: autoIncremented', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'AUTNCRMNTD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minimumValue', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'MINMMVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maximumValue', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'MAXMMVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: format', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'FORMT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: characterSetName', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'CHARCTRSTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: collationName', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'COLLTNNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: selectable', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'SELCTBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: updateable', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'UPDTBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: caseSensitive', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'CASSNSTV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: searchability', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'SEARCHBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: currency', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'CURRNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: radix', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'RADX'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: signed', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'SIGND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: distinctValueCount', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'DISTNCTVLCNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nullValueCount', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'NULLVLCNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uniqueKeys', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'UNIQKYS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: indexes', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'INDXS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: foreignKeys', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'FORGNKYS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: accessPatterns', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'ACCSSPTTRNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_RELT_COLMN', N'column', N'TYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Schema
-- (generated from Relational/Schema)

CREATE TABLE DD_RELT_SCHM
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Schema', N'user', @table_owner, N'table', N'DD_RELT_SCHM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_SCHM', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_SCHM', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_SCHM', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_SCHM', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_SCHM', N'column', N'NAMNSRC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: PrimaryKey
-- (generated from Relational/PrimaryKey)

CREATE TABLE DD_RELT_PRIMRYKY
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  COLMNS        NUMERIC(20),
  FORGNKYS      NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: PrimaryKey', N'user', @table_owner, N'table', N'DD_RELT_PRIMRYKY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_PRIMRYKY', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_PRIMRYKY', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_PRIMRYKY', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_PRIMRYKY', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_PRIMRYKY', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: columns', N'user', @table_owner, N'table', N'DD_RELT_PRIMRYKY', N'column', N'COLMNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: foreignKeys', N'user', @table_owner, N'table', N'DD_RELT_PRIMRYKY', N'column', N'FORGNKYS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ForeignKey
-- (generated from Relational/ForeignKey)

CREATE TABLE DD_RELT_FORGNKY
(
  LGCL_ID            VARCHAR(1000),
  UUID1              NUMERIC(20) NOT NULL,
  UUID2              NUMERIC(20) NOT NULL,
  UUID_STRING        VARCHAR(44) NOT NULL,
  NAM                VARCHAR(256),
  NAMNSRC            VARCHAR(256),
  FORGNKYMLTPLCTY    NUMERIC(20),
  PRIMRYKYMLTPLCTY   NUMERIC(20),
  COLMNS             NUMERIC(20),
  UNIQKY             NUMERIC(20),
  TXN_ID             NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ForeignKey', N'user', @table_owner, N'table', N'DD_RELT_FORGNKY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_FORGNKY', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_FORGNKY', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_FORGNKY', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_FORGNKY', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_FORGNKY', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: foreignKeyMultiplicity', N'user', @table_owner, N'table', N'DD_RELT_FORGNKY', N'column', N'FORGNKYMLTPLCTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: primaryKeyMultiplicity', N'user', @table_owner, N'table', N'DD_RELT_FORGNKY', N'column', N'PRIMRYKYMLTPLCTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: columns', N'user', @table_owner, N'table', N'DD_RELT_FORGNKY', N'column', N'COLMNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uniqueKey', N'user', @table_owner, N'table', N'DD_RELT_FORGNKY', N'column', N'UNIQKY'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: View
-- (generated from Relational/View)

CREATE TABLE DD_RELT_VIEW
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  NAM             VARCHAR(256),
  NAMNSRC         VARCHAR(256),
  SYSTM           CHAR(1),
  CARDNLTY        NUMERIC(20),
  SUPPRTSPDT      CHAR(1),
  MATRLZD         CHAR(1),
  LOGCLRLTNSHPS   NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: View', N'user', @table_owner, N'table', N'DD_RELT_VIEW'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_VIEW', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_VIEW', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_VIEW', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_VIEW', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_VIEW', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: system', N'user', @table_owner, N'table', N'DD_RELT_VIEW', N'column', N'SYSTM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: cardinality', N'user', @table_owner, N'table', N'DD_RELT_VIEW', N'column', N'CARDNLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: supportsUpdate', N'user', @table_owner, N'table', N'DD_RELT_VIEW', N'column', N'SUPPRTSPDT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: materialized', N'user', @table_owner, N'table', N'DD_RELT_VIEW', N'column', N'MATRLZD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: logicalRelationships', N'user', @table_owner, N'table', N'DD_RELT_VIEW', N'column', N'LOGCLRLTNSHPS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Catalog
-- (generated from Relational/Catalog)

CREATE TABLE DD_RELT_CATLG
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Catalog', N'user', @table_owner, N'table', N'DD_RELT_CATLG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_CATLG', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_CATLG', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_CATLG', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_CATLG', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_CATLG', N'column', N'NAMNSRC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Procedure
-- (generated from Relational/Procedure)

CREATE TABLE DD_RELT_PROCDR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  FUNCTN        CHAR(1),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Procedure', N'user', @table_owner, N'table', N'DD_RELT_PROCDR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_PROCDR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_PROCDR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_PROCDR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_PROCDR', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_PROCDR', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: function', N'user', @table_owner, N'table', N'DD_RELT_PROCDR', N'column', N'FUNCTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Index
-- (generated from Relational/Index)

CREATE TABLE DD_RELT_INDX
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  FILTRCNDTN    VARCHAR(256),
  NULLBL        CHAR(1),
  AUTPDT        CHAR(1),
  UNIQ          CHAR(1),
  COLMNS        NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Index', N'user', @table_owner, N'table', N'DD_RELT_INDX'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_INDX', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_INDX', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_INDX', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_INDX', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_INDX', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: filterCondition', N'user', @table_owner, N'table', N'DD_RELT_INDX', N'column', N'FILTRCNDTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nullable', N'user', @table_owner, N'table', N'DD_RELT_INDX', N'column', N'NULLBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: autoUpdate', N'user', @table_owner, N'table', N'DD_RELT_INDX', N'column', N'AUTPDT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unique', N'user', @table_owner, N'table', N'DD_RELT_INDX', N'column', N'UNIQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: columns', N'user', @table_owner, N'table', N'DD_RELT_INDX', N'column', N'COLMNS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ProcedureParameter
-- (generated from Relational/ProcedureParameter)

CREATE TABLE DD_RELT_PROCDRPRMT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  DIRCTN        NUMERIC(20),
  DEFLTVL       VARCHAR(256),
  NATVTYP       VARCHAR(256),
  LENGTH        NUMERIC(20),
  PRECSN        NUMERIC(20),
  SCAL          NUMERIC(20),
  NULLBL        NUMERIC(20),
  RADX          NUMERIC(20),
  TYP           NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ProcedureParameter', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: direction', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'DIRCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nativeType', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'NATVTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: length', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'LENGTH'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: precision', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'PRECSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: scale', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'SCAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nullable', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'NULLBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: radix', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'RADX'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_RELT_PROCDRPRMT', N'column', N'TYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: UniqueConstraint
-- (generated from Relational/UniqueConstraint)

CREATE TABLE DD_RELT_UNIQCNSTRN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  COLMNS        NUMERIC(20),
  FORGNKYS      NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: UniqueConstraint', N'user', @table_owner, N'table', N'DD_RELT_UNIQCNSTRN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_UNIQCNSTRN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_UNIQCNSTRN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_UNIQCNSTRN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_UNIQCNSTRN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_UNIQCNSTRN', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: columns', N'user', @table_owner, N'table', N'DD_RELT_UNIQCNSTRN', N'column', N'COLMNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: foreignKeys', N'user', @table_owner, N'table', N'DD_RELT_UNIQCNSTRN', N'column', N'FORGNKYS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: AccessPattern
-- (generated from Relational/AccessPattern)

CREATE TABLE DD_RELT_ACCSSPTTRN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  COLMNS        NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: AccessPattern', N'user', @table_owner, N'table', N'DD_RELT_ACCSSPTTRN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_ACCSSPTTRN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_ACCSSPTTRN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_ACCSSPTTRN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_ACCSSPTTRN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_ACCSSPTTRN', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: columns', N'user', @table_owner, N'table', N'DD_RELT_ACCSSPTTRN', N'column', N'COLMNS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: LogicalRelationship
-- (generated from Relational/LogicalRelationship)

CREATE TABLE DD_RELT_LOGCLRLTNS
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: LogicalRelationship', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLTNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLTNS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLTNS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLTNS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLTNS', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLTNS', N'column', N'NAMNSRC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: LogicalRelationshipEnd
-- (generated from Relational/LogicalRelationshipEnd)

CREATE TABLE DD_RELT_LOGCLRLT_1
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  MULTPLCTY     NUMERIC(20),
  TABL          NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: LogicalRelationshipEnd', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLT_1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLT_1', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLT_1', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLT_1', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLT_1', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLT_1', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: multiplicity', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLT_1', N'column', N'MULTPLCTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: table', N'user', @table_owner, N'table', N'DD_RELT_LOGCLRLT_1', N'column', N'TABL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: BaseTable
-- (generated from Relational/BaseTable)

CREATE TABLE DD_RELT_BASTBL
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  NAM             VARCHAR(256),
  NAMNSRC         VARCHAR(256),
  SYSTM           CHAR(1),
  CARDNLTY        NUMERIC(20),
  SUPPRTSPDT      CHAR(1),
  MATRLZD         CHAR(1),
  LOGCLRLTNSHPS   NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: BaseTable', N'user', @table_owner, N'table', N'DD_RELT_BASTBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_BASTBL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_BASTBL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_BASTBL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_BASTBL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_BASTBL', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: system', N'user', @table_owner, N'table', N'DD_RELT_BASTBL', N'column', N'SYSTM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: cardinality', N'user', @table_owner, N'table', N'DD_RELT_BASTBL', N'column', N'CARDNLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: supportsUpdate', N'user', @table_owner, N'table', N'DD_RELT_BASTBL', N'column', N'SUPPRTSPDT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: materialized', N'user', @table_owner, N'table', N'DD_RELT_BASTBL', N'column', N'MATRLZD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: logicalRelationships', N'user', @table_owner, N'table', N'DD_RELT_BASTBL', N'column', N'LOGCLRLTNSHPS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ProcedureResult
-- (generated from Relational/ProcedureResult)

CREATE TABLE DD_RELT_PROCDRRSLT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ProcedureResult', N'user', @table_owner, N'table', N'DD_RELT_PROCDRRSLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_PROCDRRSLT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_PROCDRRSLT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_PROCDRRSLT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_PROCDRRSLT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_RELT_PROCDRRSLT', N'column', N'NAMNSRC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: MappingHelper
-- (generated from Mapping/MappingHelper)

CREATE TABLE DD_MAPP_MAPPNGHLPR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  HELPDBJCT     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: MappingHelper', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGHLPR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGHLPR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGHLPR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGHLPR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: helpedObject', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGHLPR', N'column', N'HELPDBJCT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Mapping
-- (generated from Mapping/Mapping)

CREATE TABLE DD_MAPP_MAPPNG
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  INPTS         NUMERIC(20),
  OUTPTS        NUMERIC(20),
  TYPMPPNG      NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Mapping', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNG', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNG', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNG', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputs', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNG', N'column', N'INPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputs', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNG', N'column', N'OUTPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: typeMapping', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNG', N'column', N'TYPMPPNG'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: TypeConverter
-- (generated from Mapping/TypeConverter)

CREATE TABLE DD_MAPP_TYPCNVRTR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  HELPDBJCT     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: TypeConverter', N'user', @table_owner, N'table', N'DD_MAPP_TYPCNVRTR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_TYPCNVRTR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_TYPCNVRTR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_MAPP_TYPCNVRTR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: helpedObject', N'user', @table_owner, N'table', N'DD_MAPP_TYPCNVRTR', N'column', N'HELPDBJCT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: FunctionPair
-- (generated from Mapping/FunctionPair)

CREATE TABLE DD_MAPP_FUNCTNPR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  HELPDBJCT     NUMERIC(20),
  IN2T          NUMERIC(20),
  OUT2N         NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: FunctionPair', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNPR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNPR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNPR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNPR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: helpedObject', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNPR', N'column', N'HELPDBJCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: in2out', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNPR', N'column', N'IN2T'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: out2in', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNPR', N'column', N'OUT2N'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: FunctionNamePair
-- (generated from Mapping/FunctionNamePair)

CREATE TABLE DD_MAPP_FUNCTNNMPR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  HELPDBJCT     NUMERIC(20),
  IN2T          VARCHAR(256),
  OUT2N         VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: FunctionNamePair', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNNMPR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNNMPR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNNMPR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNNMPR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: helpedObject', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNNMPR', N'column', N'HELPDBJCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: in2out', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNNMPR', N'column', N'IN2T'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: out2in', N'user', @table_owner, N'table', N'DD_MAPP_FUNCTNNMPR', N'column', N'OUT2N'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: MappingStrategy
-- (generated from Mapping/MappingStrategy)

CREATE TABLE DD_MAPP_MAPPNGSTRT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  HELPDBJCT     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: MappingStrategy', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGSTRT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGSTRT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGSTRT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGSTRT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: helpedObject', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGSTRT', N'column', N'HELPDBJCT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: MappingRoot
-- (generated from Mapping/MappingRoot)

CREATE TABLE DD_MAPP_MAPPNGRT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  INPTS         NUMERIC(20),
  OUTPTS        NUMERIC(20),
  TYPMPPNG      NUMERIC(20),
  OUTPTRDNLY    CHAR(1),
  TOPTBTTM      CHAR(1),
  COMMNDSTCK    VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: MappingRoot', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGRT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGRT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGRT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGRT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: inputs', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGRT', N'column', N'INPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputs', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGRT', N'column', N'OUTPTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: typeMapping', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGRT', N'column', N'TYPMPPNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: outputReadOnly', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGRT', N'column', N'OUTPTRDNLY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: topToBottom', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGRT', N'column', N'TOPTBTTM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: commandStack', N'user', @table_owner, N'table', N'DD_MAPP_MAPPNGRT', N'column', N'COMMNDSTCK'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ComplexTypeConverter
-- (generated from Mapping/ComplexTypeConverter)

CREATE TABLE DD_MAPP_COMPLXTYPC
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  HELPDBJCT     NUMERIC(20),
  IN2T          NUMERIC(20),
  OUT2N         NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ComplexTypeConverter', N'user', @table_owner, N'table', N'DD_MAPP_COMPLXTYPC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_COMPLXTYPC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_MAPP_COMPLXTYPC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_MAPP_COMPLXTYPC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: helpedObject', N'user', @table_owner, N'table', N'DD_MAPP_COMPLXTYPC', N'column', N'HELPDBJCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: in2out', N'user', @table_owner, N'table', N'DD_MAPP_COMPLXTYPC', N'column', N'IN2T'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: out2in', N'user', @table_owner, N'table', N'DD_MAPP_COMPLXTYPC', N'column', N'OUT2N'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Category
-- (generated from Dataaccess/Category)

CREATE TABLE DD_DATC_CATGRY
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Category', N'user', @table_owner, N'table', N'DD_DATC_CATGRY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_CATGRY', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_CATGRY', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_CATGRY', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_CATGRY', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_CATGRY', N'column', N'NAMNSRC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Group
-- (generated from Dataaccess/Group)

CREATE TABLE DD_DATC_GROP
(
  LGCL_ID         VARCHAR(1000),
  UUID1           NUMERIC(20) NOT NULL,
  UUID2           NUMERIC(20) NOT NULL,
  UUID_STRING     VARCHAR(44) NOT NULL,
  NAM             VARCHAR(256),
  NAMNSRC         VARCHAR(256),
  SYSTM           CHAR(1),
  CARDNLTY        NUMERIC(20),
  SUPPRTSPDT      CHAR(1),
  MATRLZD         CHAR(1),
  LOGCLRLTNSHPS   NUMERIC(20),
  TXN_ID          NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Group', N'user', @table_owner, N'table', N'DD_DATC_GROP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_GROP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_GROP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_GROP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_GROP', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_GROP', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: system', N'user', @table_owner, N'table', N'DD_DATC_GROP', N'column', N'SYSTM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: cardinality', N'user', @table_owner, N'table', N'DD_DATC_GROP', N'column', N'CARDNLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: supportsUpdate', N'user', @table_owner, N'table', N'DD_DATC_GROP', N'column', N'SUPPRTSPDT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: materialized', N'user', @table_owner, N'table', N'DD_DATC_GROP', N'column', N'MATRLZD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: logicalRelationships', N'user', @table_owner, N'table', N'DD_DATC_GROP', N'column', N'LOGCLRLTNSHPS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Element
-- (generated from Dataaccess/Element)

CREATE TABLE DD_DATC_ELEMNT
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  NAM            VARCHAR(256),
  NAMNSRC        VARCHAR(256),
  NATVTYP        VARCHAR(256),
  LENGTH         NUMERIC(20),
  FIXDLNGTH      CHAR(1),
  PRECSN         NUMERIC(20),
  SCAL           NUMERIC(20),
  NULLBL         NUMERIC(20),
  AUTNCRMNTD     CHAR(1),
  DEFLTVL        VARCHAR(256),
  MINMMVL        VARCHAR(256),
  MAXMMVL        VARCHAR(256),
  FORMT          VARCHAR(256),
  CHARCTRSTNM    VARCHAR(256),
  COLLTNNM       VARCHAR(256),
  SELCTBL        CHAR(1),
  UPDTBL         CHAR(1),
  CASSNSTV       CHAR(1),
  SEARCHBLTY     NUMERIC(20),
  CURRNCY        CHAR(1),
  RADX           NUMERIC(20),
  SIGND          CHAR(1),
  DISTNCTVLCNT   NUMERIC(20),
  NULLVLCNT      NUMERIC(20),
  UNIQKYS        NUMERIC(20),
  INDXS          NUMERIC(20),
  FORGNKYS       NUMERIC(20),
  ACCSSPTTRNS    NUMERIC(20),
  TYP            NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Element', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nativeType', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'NATVTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: length', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'LENGTH'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: fixedLength', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'FIXDLNGTH'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: precision', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'PRECSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: scale', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'SCAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nullable', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'NULLBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: autoIncremented', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'AUTNCRMNTD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: minimumValue', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'MINMMVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maximumValue', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'MAXMMVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: format', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'FORMT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: characterSetName', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'CHARCTRSTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: collationName', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'COLLTNNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: selectable', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'SELCTBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: updateable', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'UPDTBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: caseSensitive', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'CASSNSTV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: searchability', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'SEARCHBLTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: currency', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'CURRNCY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: radix', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'RADX'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: signed', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'SIGND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: distinctValueCount', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'DISTNCTVLCNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nullValueCount', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'NULLVLCNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uniqueKeys', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'UNIQKYS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: indexes', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'INDXS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: foreignKeys', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'FORGNKYS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: accessPatterns', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'ACCSSPTTRNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_DATC_ELEMNT', N'column', N'TYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Procedure
-- (generated from Dataaccess/Procedure_1)

CREATE TABLE DD_DATC_PROCDR
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  FUNCTN        CHAR(1),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Procedure', N'user', @table_owner, N'table', N'DD_DATC_PROCDR'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_PROCDR', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_PROCDR', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_PROCDR', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_PROCDR', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_PROCDR', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: function', N'user', @table_owner, N'table', N'DD_DATC_PROCDR', N'column', N'FUNCTN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Index
-- (generated from Dataaccess/Index_1)

CREATE TABLE DD_DATC_INDX
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  FILTRCNDTN    VARCHAR(256),
  NULLBL        CHAR(1),
  AUTPDT        CHAR(1),
  UNIQ          CHAR(1),
  COLMNS        NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Index', N'user', @table_owner, N'table', N'DD_DATC_INDX'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_INDX', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_INDX', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_INDX', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_INDX', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_INDX', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: filterCondition', N'user', @table_owner, N'table', N'DD_DATC_INDX', N'column', N'FILTRCNDTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nullable', N'user', @table_owner, N'table', N'DD_DATC_INDX', N'column', N'NULLBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: autoUpdate', N'user', @table_owner, N'table', N'DD_DATC_INDX', N'column', N'AUTPDT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unique', N'user', @table_owner, N'table', N'DD_DATC_INDX', N'column', N'UNIQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: columns', N'user', @table_owner, N'table', N'DD_DATC_INDX', N'column', N'COLMNS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: PrimaryKey
-- (generated from Dataaccess/PrimaryKey_1)

CREATE TABLE DD_DATC_PRIMRYKY
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  COLMNS        NUMERIC(20),
  FORGNKYS      NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: PrimaryKey', N'user', @table_owner, N'table', N'DD_DATC_PRIMRYKY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_PRIMRYKY', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_PRIMRYKY', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_PRIMRYKY', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_PRIMRYKY', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_PRIMRYKY', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: columns', N'user', @table_owner, N'table', N'DD_DATC_PRIMRYKY', N'column', N'COLMNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: foreignKeys', N'user', @table_owner, N'table', N'DD_DATC_PRIMRYKY', N'column', N'FORGNKYS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: UniqueConstraint
-- (generated from Dataaccess/UniqueConstraint_1)

CREATE TABLE DD_DATC_UNIQCNSTRN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  COLMNS        NUMERIC(20),
  FORGNKYS      NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: UniqueConstraint', N'user', @table_owner, N'table', N'DD_DATC_UNIQCNSTRN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_UNIQCNSTRN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_UNIQCNSTRN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_UNIQCNSTRN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_UNIQCNSTRN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_UNIQCNSTRN', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: columns', N'user', @table_owner, N'table', N'DD_DATC_UNIQCNSTRN', N'column', N'COLMNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: foreignKeys', N'user', @table_owner, N'table', N'DD_DATC_UNIQCNSTRN', N'column', N'FORGNKYS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ProcedureParameter
-- (generated from Dataaccess/ProcedureParameter_1)

CREATE TABLE DD_DATC_PROCDRPRMT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  DIRCTN        NUMERIC(20),
  DEFLTVL       VARCHAR(256),
  NATVTYP       VARCHAR(256),
  LENGTH        NUMERIC(20),
  PRECSN        NUMERIC(20),
  SCAL          NUMERIC(20),
  NULLBL        NUMERIC(20),
  RADX          NUMERIC(20),
  TYP           NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ProcedureParameter', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: direction', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'DIRCTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: defaultValue', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'DEFLTVL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nativeType', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'NATVTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: length', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'LENGTH'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: precision', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'PRECSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: scale', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'SCAL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nullable', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'NULLBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: radix', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'RADX'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_DATC_PROCDRPRMT', N'column', N'TYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ForeignKey
-- (generated from Dataaccess/ForeignKey_1)

CREATE TABLE DD_DATC_FORGNKY
(
  LGCL_ID            VARCHAR(1000),
  UUID1              NUMERIC(20) NOT NULL,
  UUID2              NUMERIC(20) NOT NULL,
  UUID_STRING        VARCHAR(44) NOT NULL,
  NAM                VARCHAR(256),
  NAMNSRC            VARCHAR(256),
  FORGNKYMLTPLCTY    NUMERIC(20),
  PRIMRYKYMLTPLCTY   NUMERIC(20),
  COLMNS             NUMERIC(20),
  UNIQKY             NUMERIC(20),
  TXN_ID             NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ForeignKey', N'user', @table_owner, N'table', N'DD_DATC_FORGNKY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_FORGNKY', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_FORGNKY', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_FORGNKY', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_FORGNKY', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_FORGNKY', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: foreignKeyMultiplicity', N'user', @table_owner, N'table', N'DD_DATC_FORGNKY', N'column', N'FORGNKYMLTPLCTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: primaryKeyMultiplicity', N'user', @table_owner, N'table', N'DD_DATC_FORGNKY', N'column', N'PRIMRYKYMLTPLCTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: columns', N'user', @table_owner, N'table', N'DD_DATC_FORGNKY', N'column', N'COLMNS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uniqueKey', N'user', @table_owner, N'table', N'DD_DATC_FORGNKY', N'column', N'UNIQKY'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: ProcedureResult
-- (generated from Dataaccess/ProcedureResult_1)

CREATE TABLE DD_DATC_PROCDRRSLT
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: ProcedureResult', N'user', @table_owner, N'table', N'DD_DATC_PROCDRRSLT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_PROCDRRSLT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_PROCDRRSLT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_PROCDRRSLT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_PROCDRRSLT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_PROCDRRSLT', N'column', N'NAMNSRC'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: AccessPattern
-- (generated from Dataaccess/AccessPattern_1)

CREATE TABLE DD_DATC_ACCSSPTTRN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  NAMNSRC       VARCHAR(256),
  COLMNS        NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: AccessPattern', N'user', @table_owner, N'table', N'DD_DATC_ACCSSPTTRN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_ACCSSPTTRN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_DATC_ACCSSPTTRN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_DATC_ACCSSPTTRN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_DATC_ACCSSPTTRN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: nameInSource', N'user', @table_owner, N'table', N'DD_DATC_ACCSSPTTRN', N'column', N'NAMNSRC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: columns', N'user', @table_owner, N'table', N'DD_DATC_ACCSSPTTRN', N'column', N'COLMNS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Operation
-- (generated from Webservice/Operation_1)

CREATE TABLE DD_WEBS_OPERTN
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  PATTRN        VARCHAR(256),
  SAF           CHAR(1),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Operation', N'user', @table_owner, N'table', N'DD_WEBS_OPERTN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_OPERTN', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_OPERTN', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_WEBS_OPERTN', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_WEBS_OPERTN', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: pattern', N'user', @table_owner, N'table', N'DD_WEBS_OPERTN', N'column', N'PATTRN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: safe', N'user', @table_owner, N'table', N'DD_WEBS_OPERTN', N'column', N'SAF'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Input
-- (generated from Webservice/Input)

CREATE TABLE DD_WEBS_INPT
(
  LGCL_ID          VARCHAR(1000),
  UUID1            NUMERIC(20) NOT NULL,
  UUID2            NUMERIC(20) NOT NULL,
  UUID_STRING      VARCHAR(44) NOT NULL,
  NAM              VARCHAR(256),
  CONTNTLMNT       NUMERIC(20),
  CONTNTCMPLXTYP   NUMERIC(20),
  CONTNTSMPLTYP    NUMERIC(20),
  TXN_ID           NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Input', N'user', @table_owner, N'table', N'DD_WEBS_INPT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_INPT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_INPT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_WEBS_INPT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_WEBS_INPT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: contentElement', N'user', @table_owner, N'table', N'DD_WEBS_INPT', N'column', N'CONTNTLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: contentComplexType', N'user', @table_owner, N'table', N'DD_WEBS_INPT', N'column', N'CONTNTCMPLXTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: contentSimpleType', N'user', @table_owner, N'table', N'DD_WEBS_INPT', N'column', N'CONTNTSMPLTYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Output
-- (generated from Webservice/Output)

CREATE TABLE DD_WEBS_OUTPT
(
  LGCL_ID          VARCHAR(1000),
  UUID1            NUMERIC(20) NOT NULL,
  UUID2            NUMERIC(20) NOT NULL,
  UUID_STRING      VARCHAR(44) NOT NULL,
  NAM              VARCHAR(256),
  CONTNTLMNT       NUMERIC(20),
  CONTNTCMPLXTYP   NUMERIC(20),
  CONTNTSMPLTYP    NUMERIC(20),
  XMLDCMNT         NUMERIC(20),
  TXN_ID           NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Output', N'user', @table_owner, N'table', N'DD_WEBS_OUTPT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_OUTPT', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_OUTPT', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_WEBS_OUTPT', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_WEBS_OUTPT', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: contentElement', N'user', @table_owner, N'table', N'DD_WEBS_OUTPT', N'column', N'CONTNTLMNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: contentComplexType', N'user', @table_owner, N'table', N'DD_WEBS_OUTPT', N'column', N'CONTNTCMPLXTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: contentSimpleType', N'user', @table_owner, N'table', N'DD_WEBS_OUTPT', N'column', N'CONTNTSMPLTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: xmlDocument', N'user', @table_owner, N'table', N'DD_WEBS_OUTPT', N'column', N'XMLDCMNT'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Interface
-- (generated from Webservice/Interface_1)

CREATE TABLE DD_WEBS_INTRFC
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Interface', N'user', @table_owner, N'table', N'DD_WEBS_INTRFC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_INTRFC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_INTRFC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_WEBS_INTRFC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_WEBS_INTRFC', N'column', N'NAM'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: SampleMessages
-- (generated from Webservice/SampleMessages)

CREATE TABLE DD_WEBS_SAMPLMSSGS
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: SampleMessages', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLMSSGS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLMSSGS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLMSSGS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLMSSGS', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: SampleFile
-- (generated from Webservice/SampleFile)

CREATE TABLE DD_WEBS_SAMPLFL
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  URL           VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: SampleFile', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: url', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFL', N'column', N'URL'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: SampleFromXsd
-- (generated from Webservice/SampleFromXsd)

CREATE TABLE DD_WEBS_SAMPLFRMXS
(
  LGCL_ID            VARCHAR(1000),
  UUID1              NUMERIC(20) NOT NULL,
  UUID2              NUMERIC(20) NOT NULL,
  UUID_STRING        VARCHAR(44) NOT NULL,
  MAXNMBRFLVLSTBLD   NUMERIC(20),
  TXN_ID             NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: SampleFromXsd', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFRMXS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFRMXS', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFRMXS', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFRMXS', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: maxNumberOfLevelsToBuild', N'user', @table_owner, N'table', N'DD_WEBS_SAMPLFRMXS', N'column', N'MAXNMBRFLVLSTBLD'
GO

--
-- The model class name for the set enumeration values held in this table is: RelationshipTypeStatus
-- (generated from Relationship/RelationshipTypeStatus)

CREATE TABLE DD_RELT_RELTNSHPTY
(
  ID      NUMERIC(20) NOT NULL,
  VALUE   VARCHAR(500)
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The model class name for the set enumeration values held in this table is: RelationshipTypeStatus', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPTY'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is the unique identifier for the values in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPTY', N'column', N'ID'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is an enumeration value in this table which stores allowed values as part of an enumeration as defined by the metamodel.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPTY', N'column', N'VALUE'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: RelationshipType
-- (generated from Relationship/RelationshipType)

CREATE TABLE DD_RELT_RELTNSHP_1
(
  LGCL_ID        VARCHAR(1000),
  UUID1          NUMERIC(20) NOT NULL,
  UUID2          NUMERIC(20) NOT NULL,
  UUID_STRING    VARCHAR(44) NOT NULL,
  NAM            TEXT,
  DIRCTD         CHAR(1),
  EXCLSV         CHAR(1),
  CROSSMDL       CHAR(1),
  ABSTRCT        CHAR(1),
  USERDFND       CHAR(1),
  STATS          NUMERIC(20),
  STERTYP        VARCHAR(256),
  CONSTRNT       VARCHAR(256),
  LABL           VARCHAR(256),
  OPPSTLBL       VARCHAR(256),
  RELTNSHPFTRS   NUMERIC(20),
  SUPRTYP        NUMERIC(20),
  SUBTYP         NUMERIC(20),
  TXN_ID         NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: RelationshipType', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: directed', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'DIRCTD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: exclusive', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'EXCLSV'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: crossModel', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'CROSSMDL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: abstract', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'ABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: userDefined', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'USERDFND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: status', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'STATS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: stereotype', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'STERTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: constraint', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'CONSTRNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: label', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'LABL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: oppositeLabel', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'OPPSTLBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relationshipFeatures', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'RELTNSHPFTRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: superType', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'SUPRTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: subType', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP_1', N'column', N'SUBTYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: Relationship
-- (generated from Relationship/Relationship)

CREATE TABLE DD_RELT_RELTNSHP
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           TEXT,
  TARGTS        NUMERIC(20),
  SOURCS        NUMERIC(20),
  TYP           NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: Relationship', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: targets', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP', N'column', N'TARGTS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: sources', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP', N'column', N'SOURCS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: type', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHP', N'column', N'TYP'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: FileReference
-- (generated from Relationship/FileReference)

CREATE TABLE DD_RELT_FILRFRNC
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  URI           VARCHAR(256),
  RESLVBL       CHAR(1),
  ENCDNG        VARCHAR(256),
  ABSTRCT       VARCHAR(256),
  KEYWRDS       VARCHAR(256),
  RELTDRS       VARCHAR(256),
  TOOLNM        VARCHAR(256),
  TOOLVRSN      VARCHAR(256),
  FORMTNM       VARCHAR(256),
  FORMTVRSN     VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: FileReference', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uri', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvable', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'RESLVBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: encoding', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'ENCDNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: abstract', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'ABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: keywords', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'KEYWRDS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedUris', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'RELTDRS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: toolName', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'TOOLNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: toolVersion', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'TOOLVRSN'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: formatName', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'FORMTNM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: formatVersion', N'user', @table_owner, N'table', N'DD_RELT_FILRFRNC', N'column', N'FORMTVRSN'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: RelationshipRole
-- (generated from Relationship/RelationshipRole)

CREATE TABLE DD_RELT_RELTNSHPRL
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           TEXT,
  STERTYP       VARCHAR(256),
  ORDRD         CHAR(1),
  UNIQ          CHAR(1),
  NAVGBL        CHAR(1),
  LOWRBND       NUMERIC(20),
  UPPRBND       NUMERIC(20),
  CONSTRNT      VARCHAR(256),
  OPPSTRL       NUMERIC(20),
  INCLDTYPS     NUMERIC(20),
  EXCLDTYPS     NUMERIC(20),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: RelationshipRole', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: stereotype', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'STERTYP'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: ordered', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'ORDRD'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: unique', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'UNIQ'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: navigable', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'NAVGBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: lowerBound', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'LOWRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: upperBound', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'UPPRBND'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: constraint', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'CONSTRNT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: oppositeRole', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'OPPSTRL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: includeTypes', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'INCLDTYPS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: excludeTypes', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPRL', N'column', N'EXCLDTYPS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: PlaceholderReferenceContainer
-- (generated from Relationship/PlaceholderReferenceContainer)

CREATE TABLE DD_RELT_PLACHLDRRF
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: PlaceholderReferenceContainer', N'user', @table_owner, N'table', N'DD_RELT_PLACHLDRRF'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_PLACHLDRRF', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_PLACHLDRRF', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_PLACHLDRRF', N'column', N'UUID_STRING'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: UriReference
-- (generated from Relationship/UriReference)

CREATE TABLE DD_RELT_URIRFRNC
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           VARCHAR(256),
  URI           VARCHAR(256),
  RESLVBL       CHAR(1),
  ENCDNG        VARCHAR(256),
  ABSTRCT       VARCHAR(256),
  KEYWRDS       VARCHAR(256),
  RELTDRS       VARCHAR(256),
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: UriReference', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC', N'column', N'NAM'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: uri', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC', N'column', N'URI'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: resolvable', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC', N'column', N'RESLVBL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: encoding', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC', N'column', N'ENCDNG'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: abstract', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC', N'column', N'ABSTRCT'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: keywords', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC', N'column', N'KEYWRDS'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: relatedUris', N'user', @table_owner, N'table', N'DD_RELT_URIRFRNC', N'column', N'RELTDRS'
GO

--
-- The metamodel type of the metadata model objects that can be stored in this table is: RelationshipFolder
-- (generated from Relationship/RelationshipFolder)

CREATE TABLE DD_RELT_RELTNSHPFL
(
  LGCL_ID       VARCHAR(1000),
  UUID1         NUMERIC(20) NOT NULL,
  UUID2         NUMERIC(20) NOT NULL,
  UUID_STRING   VARCHAR(44) NOT NULL,
  NAM           TEXT,
  TXN_ID        NUMERIC(20) NOT NULL
)
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'The metamodel type of the metadata model objects that can be stored in this table is: RelationshipFolder', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPFL'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part first of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPFL', N'column', N'UUID1'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column represents part second of a two part primary key for this table.  The two parts of this key are a representation of a UUID.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPFL', N'column', N'UUID2'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This column is a string representation of the UUID which is also represented in this table by the two UUID1 and UUID2 columns as longs.', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPFL', N'column', N'UUID_STRING'
GO
DECLARE @table_owner varchar(255)
SELECT @table_owner = USER
exec sp_addextendedproperty N'MS_Description', N'This is the feature name as defined in the model class for the feature values which are stored in this column: name', N'user', @table_owner, N'table', N'DD_RELT_RELTNSHPFL', N'column', N'NAM'
GO

CREATE INDEX DD_INDEX_IX1 ON DD_INDEX (LGCL_ID)
GO

CREATE INDEX DD_INDEX_IX4 ON DD_INDEX (UUID_STRING)
GO

CREATE INDEX DD_MDL_IX1 ON DD_MDL (LGCL_ID)
GO

CREATE INDEX DD_MDL_IX4 ON DD_MDL (UUID_STRING)
G