/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.ddl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jboss.dna.common.text.ParsingException;
import org.jboss.dna.common.util.IoUtil;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.io.Destination;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.PathFactory;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.sequencer.SequencerOutput;
import org.jboss.dna.graph.sequencer.StreamSequencer;
import org.jboss.dna.graph.sequencer.StreamSequencerContext;
import org.jboss.dna.sequencer.ddl.DdlParsers;
import org.jboss.dna.sequencer.ddl.DdlSequencerI18n;
import org.jboss.dna.sequencer.ddl.node.AstNode;

public class DdlSequencer
implements StreamSequencer {
    protected Destination destination;
    protected Path outputPath;
    protected PathFactory pathFactory;

    public void sequence(InputStream stream, SequencerOutput output, StreamSequencerContext context) {
        this.pathFactory = context.getValueFactories().getPathFactory();
        DdlParsers parsers = new DdlParsers();
        AstNode rootNode = null;
        try {
            rootNode = parsers.parse(IoUtil.read((InputStream)stream));
            Path nodePath = rootNode.getPath((ExecutionContext)context);
            for (Property property : rootNode.getProperties()) {
                output.setProperty(nodePath, property.getName(), property.getValuesAsArray());
            }
            this.convertAstNodesToGraphNodes(rootNode, nodePath, output, context);
        }
        catch (ParsingException e) {
            context.getProblems().addError((Throwable)e, DdlSequencerI18n.errorParsingDdlContent, new Object[]{e.getLocalizedMessage()});
        }
        catch (IOException e) {
            context.getProblems().addError((Throwable)e, DdlSequencerI18n.errorSequencingDdlContent, new Object[]{e.getLocalizedMessage()});
        }
    }

    protected void convertAstNodesToGraphNodes(AstNode parentNode, Path parentPath, SequencerOutput output, StreamSequencerContext context) {
        List<AstNode> children = parentNode.getChildren();
        for (AstNode child : children) {
            Path nodePath = child.getPath((ExecutionContext)context);
            for (Property property : child.getProperties()) {
                output.setProperty(nodePath, property.getName(), property.getValuesAsArray());
            }
            this.convertAstNodesToGraphNodes(child, nodePath, output, context);
        }
    }
}

