/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.ddl.dialect.mysql;

import java.util.ArrayList;
import java.util.List;
import org.jboss.dna.common.text.ParsingException;
import org.jboss.dna.sequencer.ddl.DdlTokenStream;
import org.jboss.dna.sequencer.ddl.StandardDdlLexicon;
import org.jboss.dna.sequencer.ddl.StandardDdlParser;
import org.jboss.dna.sequencer.ddl.datatype.DataType;
import org.jboss.dna.sequencer.ddl.datatype.DataTypeParser;
import org.jboss.dna.sequencer.ddl.dialect.mysql.MySqlDdlConstants;
import org.jboss.dna.sequencer.ddl.dialect.mysql.MySqlDdlLexicon;
import org.jboss.dna.sequencer.ddl.node.AstNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySqlDdlParser
extends StandardDdlParser
implements MySqlDdlConstants,
MySqlDdlConstants.MySqlStatementStartPhrases {
    private final String parserId = "MYSQL";
    static List<String[]> mysqlDataTypeStrings = new ArrayList<String[]>();
    private static final String TERMINATOR = ";";

    public MySqlDdlParser() {
        this.initialize();
    }

    @Override
    public String getId() {
        return this.parserId;
    }

    private void initialize() {
        this.setDatatypeParser(new MySqlDataTypeParser());
        this.setDoUseTerminator(true);
        this.setTerminator(TERMINATOR);
        mysqlDataTypeStrings.addAll(MySqlDdlConstants.MySqlDataTypes.CUSTOM_DATATYPE_START_PHRASES);
    }

    @Override
    public void registerWords(DdlTokenStream tokens) {
        super.registerWords(tokens);
        this.registerKeyWords(CUSTOM_KEYWORDS);
        this.registerKeyWords(MySqlDdlConstants.MySqlDataTypes.CUSTOM_DATATYPE_START_WORDS);
        this.registerStatementStartPhrase(ALTER_PHRASES);
        this.registerStatementStartPhrase(CREATE_PHRASES);
        this.registerStatementStartPhrase(DROP_PHRASES);
        this.registerStatementStartPhrase(MISC_PHRASES);
    }

    @Override
    protected AstNode parseCreateStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_CREATE_INDEX)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_INDEX, parentNode, MySqlDdlLexicon.TYPE_CREATE_INDEX_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_UNIQUE_INDEX)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_UNIQUE_INDEX, parentNode, MySqlDdlLexicon.TYPE_CREATE_INDEX_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_FUNCTION)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_FUNCTION, parentNode, MySqlDdlLexicon.TYPE_CREATE_FUNCTION_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_PROCEDURE)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_PROCEDURE, parentNode, MySqlDdlLexicon.TYPE_CREATE_PROCEDURE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_SERVER)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_SERVER, parentNode, MySqlDdlLexicon.TYPE_CREATE_SERVER_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_TRIGGER)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_TRIGGER, parentNode, MySqlDdlLexicon.TYPE_CREATE_TRIGGER_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_EVENT)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_EVENT, parentNode, MySqlDdlLexicon.TYPE_CREATE_EVENT_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_TABLESPACE)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_TABLESPACE, parentNode, MySqlDdlLexicon.TYPE_CREATE_TABLESPACE_STATEMENT);
        }
        if (tokens.matches(STMT_CREATE_DEFINER)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_DEFINER, parentNode, MySqlDdlLexicon.TYPE_CREATE_DEFINER_STATEMENT);
        }
        return super.parseCreateStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseAlterStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_ALTER_ALGORITHM)) {
            return this.parseStatement(tokens, STMT_ALTER_ALGORITHM, parentNode, MySqlDdlLexicon.TYPE_ALTER_ALGORITHM_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_DATABASE)) {
            return this.parseStatement(tokens, STMT_ALTER_DATABASE, parentNode, MySqlDdlLexicon.TYPE_ALTER_DATABASE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_DEFINER)) {
            return this.parseStatement(tokens, STMT_ALTER_DEFINER, parentNode, MySqlDdlLexicon.TYPE_ALTER_DEFINER_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_EVENT)) {
            return this.parseStatement(tokens, STMT_ALTER_EVENT, parentNode, MySqlDdlLexicon.TYPE_ALTER_EVENT_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_FUNCTION)) {
            return this.parseStatement(tokens, STMT_ALTER_FUNCTION, parentNode, MySqlDdlLexicon.TYPE_ALTER_FUNCTION_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_LOGFILE_GROUP)) {
            return this.parseStatement(tokens, STMT_ALTER_LOGFILE_GROUP, parentNode, MySqlDdlLexicon.TYPE_ALTER_LOGFILE_GROUP_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_PROCEDURE)) {
            return this.parseStatement(tokens, STMT_ALTER_PROCEDURE, parentNode, MySqlDdlLexicon.TYPE_ALTER_PROCEDURE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_SCHEMA)) {
            return this.parseStatement(tokens, STMT_ALTER_SCHEMA, parentNode, MySqlDdlLexicon.TYPE_ALTER_SCHEMA_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_SERVER)) {
            return this.parseStatement(tokens, STMT_ALTER_SERVER, parentNode, MySqlDdlLexicon.TYPE_ALTER_SERVER_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_ALTER_TABLESPACE, parentNode, MySqlDdlLexicon.TYPE_ALTER_TABLESPACE_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_SQL_SECURITY)) {
            return this.parseStatement(tokens, STMT_ALTER_SQL_SECURITY, parentNode, MySqlDdlLexicon.TYPE_ALTER_VIEW_STATEMENT);
        }
        if (tokens.matches(STMT_ALTER_IGNORE_TABLE) || tokens.matches(STMT_ALTER_ONLINE_TABLE) || tokens.matches(STMT_ALTER_ONLINE_IGNORE_TABLE) || tokens.matches(STMT_ALTER_OFFLINE_TABLE) || tokens.matches(STMT_ALTER_OFFLINE_IGNORE_TABLE)) {
            return this.parseAlterTableStatement(tokens, parentNode);
        }
        return super.parseAlterStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseAlterTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return super.parseAlterTableStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseCustomStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_RENAME_DATABASE)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_RENAME_DATABASE);
            String oldName = this.parseName(tokens);
            tokens.consume("TO");
            AstNode node = this.nodeFactory().node(oldName, parentNode, MySqlDdlLexicon.TYPE_RENAME_DATABASE_STATEMENT);
            String newName = this.parseName(tokens);
            node.setProperty(StandardDdlLexicon.NEW_NAME, (Object)newName);
            this.markEndOfStatement(tokens, node);
            return node;
        }
        if (tokens.matches(STMT_RENAME_SCHEMA)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_RENAME_SCHEMA);
            String oldName = this.parseName(tokens);
            tokens.consume("TO");
            AstNode node = this.nodeFactory().node(oldName, parentNode, MySqlDdlLexicon.TYPE_RENAME_SCHEMA_STATEMENT);
            String newName = this.parseName(tokens);
            node.setProperty(StandardDdlLexicon.NEW_NAME, (Object)newName);
            this.markEndOfStatement(tokens, node);
            return node;
        }
        if (tokens.matches(STMT_RENAME_TABLE)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_RENAME_TABLE);
            String oldName = this.parseName(tokens);
            tokens.consume("TO");
            String newName = this.parseName(tokens);
            AstNode node = this.nodeFactory().node(oldName, parentNode, MySqlDdlLexicon.TYPE_RENAME_TABLE_STATEMENT);
            node.setProperty(StandardDdlLexicon.NEW_NAME, (Object)newName);
            if (!tokens.matches(",")) {
                this.markEndOfStatement(tokens, node);
                return node;
            }
            ArrayList<AstNode> nodes = new ArrayList<AstNode>();
            nodes.add(node);
            while (tokens.matches(",")) {
                tokens.consume(",");
                oldName = this.parseName(tokens);
                tokens.consume("TO");
                newName = this.parseName(tokens);
                node = this.nodeFactory().node(oldName, parentNode, MySqlDdlLexicon.TYPE_RENAME_TABLE_STATEMENT);
                node.setProperty(StandardDdlLexicon.NEW_NAME, (Object)newName);
                nodes.add(node);
            }
            this.markEndOfStatement(tokens, (AstNode)nodes.get(0));
            String originalExpression = (String)((AstNode)nodes.get(0)).getProperty(StandardDdlLexicon.DDL_EXPRESSION).getFirstValue();
            Object startLineNumber = ((AstNode)nodes.get(0)).getProperty(StandardDdlLexicon.DDL_START_LINE_NUMBER).getFirstValue();
            Object startColumnNumber = ((AstNode)nodes.get(0)).getProperty(StandardDdlLexicon.DDL_START_COLUMN_NUMBER).getFirstValue();
            Object startCharIndex = ((AstNode)nodes.get(0)).getProperty(StandardDdlLexicon.DDL_START_CHAR_INDEX).getFirstValue();
            for (AstNode nextNode : nodes) {
                oldName = nextNode.getName().getString();
                newName = (String)nextNode.getProperty(StandardDdlLexicon.NEW_NAME).getFirstValue();
                String express = "RENAME TABLE " + oldName + " " + "TO" + " " + newName + TERMINATOR;
                nextNode.setProperty(StandardDdlLexicon.DDL_EXPRESSION, (Object)express);
                nextNode.setProperty(StandardDdlLexicon.DDL_ORIGINAL_EXPRESSION, (Object)originalExpression);
                nextNode.setProperty(StandardDdlLexicon.DDL_START_LINE_NUMBER, startLineNumber);
                nextNode.setProperty(StandardDdlLexicon.DDL_START_COLUMN_NUMBER, startColumnNumber);
                nextNode.setProperty(StandardDdlLexicon.DDL_START_CHAR_INDEX, startCharIndex);
            }
            return (AstNode)nodes.get(0);
        }
        return super.parseCustomStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseDropStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_DROP_DATABASE)) {
            return this.parseStatement(tokens, STMT_DROP_DATABASE, parentNode, MySqlDdlLexicon.TYPE_DROP_DATABASE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_EVENT)) {
            return this.parseStatement(tokens, STMT_DROP_EVENT, parentNode, MySqlDdlLexicon.TYPE_DROP_EVENT_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_FUNCTION)) {
            return this.parseStatement(tokens, STMT_DROP_FUNCTION, parentNode, MySqlDdlLexicon.TYPE_DROP_FUNCTION_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_INDEX)) {
            return this.parseStatement(tokens, STMT_DROP_INDEX, parentNode, MySqlDdlLexicon.TYPE_DROP_INDEX_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_OFFLINE_INDEX)) {
            return this.parseStatement(tokens, STMT_DROP_OFFLINE_INDEX, parentNode, MySqlDdlLexicon.TYPE_DROP_INDEX_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_ONLINE_INDEX)) {
            return this.parseStatement(tokens, STMT_DROP_ONLINE_INDEX, parentNode, MySqlDdlLexicon.TYPE_DROP_INDEX_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_LOGFILE_GROUP)) {
            return this.parseStatement(tokens, STMT_DROP_LOGFILE_GROUP, parentNode, MySqlDdlLexicon.TYPE_DROP_LOGFILE_GROUP_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_PROCEDURE)) {
            return this.parseStatement(tokens, STMT_DROP_PROCEDURE, parentNode, MySqlDdlLexicon.TYPE_DROP_PROCEDURE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_SERVER)) {
            return this.parseStatement(tokens, STMT_DROP_SERVER, parentNode, MySqlDdlLexicon.TYPE_DROP_SERVER_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_DROP_TABLESPACE, parentNode, MySqlDdlLexicon.TYPE_DROP_TABLESPACE_STATEMENT);
        }
        if (tokens.matches(STMT_DROP_TRIGGER)) {
            return this.parseStatement(tokens, STMT_DROP_TRIGGER, parentNode, MySqlDdlLexicon.TYPE_DROP_TRIGGER_STATEMENT);
        }
        return super.parseDropStatement(tokens, parentNode);
    }

    @Override
    protected List<String> getCustomDataTypeStartWords() {
        return MySqlDdlConstants.MySqlDataTypes.CUSTOM_DATATYPE_START_WORDS;
    }

    class MySqlDataTypeParser
    extends DataTypeParser
    implements MySqlDdlConstants.MySqlDataTypes {
        MySqlDataTypeParser() {
        }

        protected boolean isCustomDataType(DdlTokenStream tokens) throws ParsingException {
            for (String[] stmts : mysqlDataTypeStrings) {
                if (!tokens.matches(stmts)) continue;
                return true;
            }
            return super.isCustomDataType(tokens);
        }

        protected DataType parseApproxNumericType(DdlTokenStream tokens) throws ParsingException {
            DataType dType = super.parseApproxNumericType(tokens);
            tokens.canConsume("UNSIGNED");
            tokens.canConsume("ZEROFILL");
            tokens.canConsume("UNSIGNED");
            return dType;
        }

        protected DataType parseBitStringType(DdlTokenStream tokens) throws ParsingException {
            return super.parseBitStringType(tokens);
        }

        protected int parseBracketedInteger(DdlTokenStream tokens, DataType dataType) {
            return super.parseBracketedInteger(tokens, dataType);
        }

        protected DataType parseCharStringType(DdlTokenStream tokens) throws ParsingException {
            DataType result = super.parseCharStringType(tokens);
            tokens.canConsume("FOR", new String[]{"BIT", "DATA"});
            return result;
        }

        protected DataType parseCustomType(DdlTokenStream tokens) throws ParsingException {
            DataType dataType = null;
            if (tokens.matches(MySqlDdlConstants.DTYPE_FIXED) || tokens.matches(MySqlDdlConstants.DTYPE_DOUBLE)) {
                dataType = new DataType();
                String typeName = tokens.consume();
                dataType.setName(typeName);
                int precision = 0;
                int scale = 0;
                if (tokens.matches("(")) {
                    this.consume(tokens, dataType, false, "(");
                    precision = this.parseInteger(tokens, dataType);
                    scale = tokens.canConsume(",") ? this.parseInteger(tokens, dataType) : this.getDefaultScale();
                    tokens.consume(")");
                } else {
                    precision = this.getDefaultPrecision();
                    scale = this.getDefaultScale();
                }
                dataType.setPrecision(precision);
                dataType.setScale(scale);
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_MEDIUMBLOB) || tokens.matches(MySqlDdlConstants.DTYPE_LONGBLOB) || tokens.matches(MySqlDdlConstants.DTYPE_BLOB) || tokens.matches(MySqlDdlConstants.DTYPE_TINYBLOB) || tokens.matches(MySqlDdlConstants.DTYPE_YEAR) || tokens.matches(MySqlDdlConstants.DTYPE_DATETIME) || tokens.matches(MySqlDdlConstants.DTYPE_BOOLEAN) || tokens.matches(MySqlDdlConstants.DTYPE_BOOL)) {
                String typeName = tokens.consume();
                dataType = new DataType(typeName);
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_MEDIUMINT) || tokens.matches(MySqlDdlConstants.DTYPE_TINYINT) || tokens.matches(MySqlDdlConstants.DTYPE_VARBINARY) || tokens.matches(MySqlDdlConstants.DTYPE_BINARY) || tokens.matches(MySqlDdlConstants.DTYPE_BIGINT)) {
                String typeName = tokens.consume();
                dataType = new DataType(typeName);
                int length = this.getDefaultLength();
                if (tokens.matches("(")) {
                    length = this.parseBracketedInteger(tokens, dataType);
                }
                dataType.setLength(length);
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_NATIONAL_VARCHAR)) {
                String typeName = this.getStatementTypeName(MySqlDdlConstants.DTYPE_NATIONAL_VARCHAR);
                dataType = new DataType(typeName);
                tokens.consume(MySqlDdlConstants.DTYPE_NATIONAL_VARCHAR);
                int length = this.getDefaultLength();
                if (tokens.matches("(")) {
                    length = this.parseBracketedInteger(tokens, dataType);
                }
                dataType.setLength(length);
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_MEDIUMTEXT) || tokens.matches(MySqlDdlConstants.DTYPE_TEXT) || tokens.matches(MySqlDdlConstants.DTYPE_LONGTEXT) || tokens.matches(MySqlDdlConstants.DTYPE_TINYTEXT)) {
                String typeName = tokens.consume();
                dataType = new DataType(typeName);
                tokens.canConsume("BINARY");
                tokens.canConsume("COLLATE", new String[]{"any value"});
                tokens.canConsume("CHARACTER", new String[]{"SET", "any value"});
                tokens.canConsume("COLLATE", new String[]{"any value"});
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_SET)) {
                String typeName = tokens.consume();
                dataType = new DataType(typeName);
                tokens.consume("(");
                do {
                    tokens.consume();
                } while (tokens.canConsume(","));
                tokens.consume(")");
                tokens.canConsume("COLLATE", new String[]{"any value"});
                tokens.canConsume("CHARACTER", new String[]{"SET", "any value"});
                tokens.canConsume("COLLATE", new String[]{"any value"});
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_ENUM)) {
                String typeName = tokens.consume();
                dataType = new DataType(typeName);
                tokens.consume("(");
                do {
                    tokens.consume();
                } while (tokens.canConsume(","));
                tokens.consume(")");
                tokens.canConsume("COLLATE", new String[]{"any value"});
                tokens.canConsume("CHARACTER", new String[]{"SET", "any value"});
                tokens.canConsume("COLLATE", new String[]{"any value"});
            }
            if (dataType == null) {
                dataType = super.parseCustomType(tokens);
            }
            tokens.canConsume("UNSIGNED");
            tokens.canConsume("ZEROFILL");
            tokens.canConsume("UNSIGNED");
            return dataType;
        }

        protected DataType parseDateTimeType(DdlTokenStream tokens) throws ParsingException {
            return super.parseDateTimeType(tokens);
        }

        protected DataType parseExactNumericType(DdlTokenStream tokens) throws ParsingException {
            DataType dType = super.parseExactNumericType(tokens);
            tokens.canConsume("UNSIGNED");
            tokens.canConsume("ZEROFILL");
            tokens.canConsume("UNSIGNED");
            return dType;
        }
    }
}

