/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.ddl.node;

import java.util.ArrayList;
import java.util.List;
import org.jboss.dna.graph.ExecutionContext;
import org.jboss.dna.graph.JcrLexicon;
import org.jboss.dna.graph.JcrNtLexicon;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.property.NamespaceRegistry;
import org.jboss.dna.graph.property.Path;
import org.jboss.dna.graph.property.Property;
import org.jboss.dna.graph.property.ValueFactory;
import org.jboss.dna.graph.property.basic.LongValueFactory;
import org.jboss.dna.graph.property.basic.SimpleNamespaceRegistry;
import org.jboss.dna.graph.property.basic.StringValueFactory;
import org.jboss.dna.sequencer.ddl.node.AstNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstNodeFactory {
    private ExecutionContext context;
    private LongValueFactory longFactory;
    private StringValueFactory stringFactory;

    public AstNodeFactory(ExecutionContext context) {
        this.context = context;
        this.stringFactory = new StringValueFactory((NamespaceRegistry)new SimpleNamespaceRegistry(), Path.URL_DECODER, Path.URL_ENCODER);
        this.longFactory = new LongValueFactory(Path.URL_DECODER, (ValueFactory)this.stringFactory);
    }

    public AstNodeFactory() {
        this.context = new ExecutionContext();
    }

    public Name name(String name) {
        assert (name != null);
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    public AstNode node(String name) {
        assert (name != null);
        AstNode node = new AstNode(this.name(name));
        node.setProperty(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.UNSTRUCTURED);
        return node;
    }

    public AstNode node(String name, AstNode parent, Object ... types) {
        assert (name != null);
        assert (parent != null);
        assert (types != null);
        assert (types.length > 0);
        AstNode node = new AstNode(this.name(name));
        node.setProperty(JcrLexicon.MIXIN_TYPES, types);
        node.setProperty(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.UNSTRUCTURED);
        node.setParent(parent);
        return node;
    }

    public AstNode node(String name, AstNode parent, Name type) {
        assert (name != null);
        assert (parent != null);
        assert (type != null);
        AstNode node = new AstNode(this.name(name));
        node.setProperty(JcrLexicon.MIXIN_TYPES, (Object)type);
        node.setProperty(JcrLexicon.PRIMARY_TYPE, (Object)JcrNtLexicon.UNSTRUCTURED);
        node.setParent(parent);
        return node;
    }

    public void setType(AstNode node, Name type) {
        assert (node != null);
        assert (type != null);
        node.setProperty(JcrLexicon.MIXIN_TYPES, (Object)type);
    }

    public List<AstNode> getChildrenForType(AstNode astNode, Name nodeType) {
        assert (astNode != null);
        assert (nodeType != null);
        ArrayList<AstNode> childrenOfType = new ArrayList<AstNode>(astNode.getChildCount());
        for (AstNode child : astNode.getChildren()) {
            if (!this.hasMixinType(child.getProperty(JcrLexicon.MIXIN_TYPES), nodeType)) continue;
            childrenOfType.add(child);
        }
        return childrenOfType;
    }

    public AstNode getChildforNameAndType(AstNode astNode, String name, Name nodeType) {
        assert (astNode != null);
        assert (name != null);
        assert (nodeType != null);
        for (AstNode child : astNode.getChildren()) {
            if (!this.hasMixinType(child.getProperty(JcrLexicon.MIXIN_TYPES), nodeType) || !name.equalsIgnoreCase(child.getName().getString())) continue;
            return child;
        }
        return null;
    }

    private boolean hasMixinType(Property mixins, Name mixinType) {
        assert (mixins != null);
        assert (mixinType != null);
        for (Object prop : mixins.getValuesAsArray()) {
            if (!(prop instanceof Name) || !prop.equals(mixinType)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMixinType(AstNode node, Name mixinType) {
        assert (node != null);
        assert (mixinType != null);
        return this.hasMixinType(node.getProperty(JcrLexicon.MIXIN_TYPES), mixinType);
    }

    public int createInt(String stringValue) {
        return this.longFactory.create(stringValue).intValue();
    }
}

