/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.images;

import java.io.InputStream;
import org.jboss.dna.graph.properties.Name;
import org.jboss.dna.graph.properties.NameFactory;
import org.jboss.dna.graph.properties.Path;
import org.jboss.dna.graph.properties.PathFactory;
import org.jboss.dna.graph.sequencers.SequencerContext;
import org.jboss.dna.graph.sequencers.SequencerOutput;
import org.jboss.dna.graph.sequencers.StreamSequencer;
import org.jboss.dna.sequencer.images.ImageMetadata;

public class ImageMetadataSequencer
implements StreamSequencer {
    public static final String METADATA_NODE = "image:metadata";
    public static final String IMAGE_PRIMARY_TYPE = "jcr:primaryType";
    public static final String IMAGE_MIXINS = "jcr:mixinTypes";
    public static final String IMAGE_MIME_TYPE = "jcr:mimeType";
    public static final String IMAGE_ENCODING = "jcr:encoding";
    public static final String IMAGE_FORMAT_NAME = "image:formatName";
    public static final String IMAGE_WIDTH = "image:width";
    public static final String IMAGE_HEIGHT = "image:height";
    public static final String IMAGE_BITS_PER_PIXEL = "image:bitsPerPixel";
    public static final String IMAGE_PROGRESSIVE = "image:progressive";
    public static final String IMAGE_NUMBER_OF_IMAGES = "image:numberOfImages";
    public static final String IMAGE_PHYSICAL_WIDTH_DPI = "image:physicalWidthDpi";
    public static final String IMAGE_PHYSICAL_HEIGHT_DPI = "image:physicalHeightDpi";
    public static final String IMAGE_PHYSICAL_WIDTH_INCHES = "image:physicalWidthInches";
    public static final String IMAGE_PHYSICAL_HEIGHT_INCHES = "image:physicalHeightInches";

    public void sequence(InputStream stream, SequencerOutput output, SequencerContext context) {
        ImageMetadata metadata = new ImageMetadata();
        metadata.setInput(stream);
        metadata.setDetermineImageNumber(true);
        metadata.setCollectComments(true);
        if (!metadata.check()) {
            metadata = null;
        }
        if (metadata != null) {
            NameFactory nameFactory = context.getValueFactories().getNameFactory();
            PathFactory pathFactory = context.getValueFactories().getPathFactory();
            Path metadataNode = (Path)pathFactory.create(METADATA_NODE);
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_PRIMARY_TYPE), new Object[]{METADATA_NODE});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_MIME_TYPE), new Object[]{metadata.getMimeType()});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_FORMAT_NAME), new Object[]{metadata.getFormatName()});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_WIDTH), new Object[]{metadata.getWidth()});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_HEIGHT), new Object[]{metadata.getHeight()});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_BITS_PER_PIXEL), new Object[]{metadata.getBitsPerPixel()});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_PROGRESSIVE), new Object[]{metadata.isProgressive()});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_NUMBER_OF_IMAGES), new Object[]{metadata.getNumberOfImages()});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_PHYSICAL_WIDTH_DPI), new Object[]{metadata.getPhysicalWidthDpi()});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_PHYSICAL_HEIGHT_DPI), new Object[]{metadata.getPhysicalHeightDpi()});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_PHYSICAL_WIDTH_INCHES), new Object[]{Float.valueOf(metadata.getPhysicalWidthInch())});
            output.setProperty(metadataNode, (Name)nameFactory.create(IMAGE_PHYSICAL_HEIGHT_INCHES), new Object[]{Float.valueOf(metadata.getPhysicalHeightInch())});
        }
    }
}

