/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.image;

import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.hamcrest.number.IsCloseTo;
import org.jboss.dna.sequencer.image.ImageMetadata;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ImageMetadataTest {
    private ImageMetadata image;
    private InputStream imageStream;

    @Before
    public void beforeEach() {
        this.image = new ImageMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.imageStream != null) {
            try {
                this.imageStream.close();
            }
            finally {
                this.imageStream = null;
            }
        }
    }

    protected InputStream getTestImage(String resourcePath) {
        return this.getClass().getResourceAsStream("/" + resourcePath);
    }

    @Test
    public void shouldBeAbleToCreateWithDefaultConstructor() {
        Assert.assertThat((Object)new ImageMetadata(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldBeAbleToLoadPngImage() {
        InputStream stream = this.getTestImage("caution.png");
        this.image.setInput(stream);
        this.image.setDetermineImageNumber(true);
        this.image.setCollectComments(true);
        Assert.assertThat((Object)this.image.check(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.image.getFormatName(), (Matcher)Is.is((Object)"PNG"));
        Assert.assertThat((Object)this.image.getMimeType(), (Matcher)Is.is((Object)"image/png"));
        Assert.assertThat((Object)this.image.getWidth(), (Matcher)Is.is((Object)48));
        Assert.assertThat((Object)this.image.getHeight(), (Matcher)Is.is((Object)48));
        Assert.assertThat((Object)this.image.getBitsPerPixel(), (Matcher)Is.is((Object)24));
        Assert.assertThat((Object)this.image.isProgressive(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.image.getNumberOfImages(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.image.getPhysicalWidthDpi(), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)this.image.getPhysicalHeightDpi(), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)Float.valueOf(this.image.getPhysicalWidthInch()), (Matcher)Is.is((Object)Float.valueOf(-1.0f)));
        Assert.assertThat((Object)Float.valueOf(this.image.getPhysicalHeightInch()), (Matcher)Is.is((Object)Float.valueOf(-1.0f)));
        Assert.assertThat((Object)this.image.getNumberOfComments(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldBeAbleToLoadGifImage() {
        InputStream stream = this.getTestImage("caution.gif");
        this.image.setInput(stream);
        this.image.setDetermineImageNumber(true);
        this.image.setCollectComments(true);
        Assert.assertThat((Object)this.image.check(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.image.getFormatName(), (Matcher)Is.is((Object)"GIF"));
        Assert.assertThat((Object)this.image.getMimeType(), (Matcher)Is.is((Object)"image/gif"));
        Assert.assertThat((Object)this.image.getWidth(), (Matcher)Is.is((Object)48));
        Assert.assertThat((Object)this.image.getHeight(), (Matcher)Is.is((Object)48));
        Assert.assertThat((Object)this.image.getBitsPerPixel(), (Matcher)Is.is((Object)8));
        Assert.assertThat((Object)this.image.isProgressive(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.image.getNumberOfImages(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.image.getPhysicalWidthDpi(), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)this.image.getPhysicalHeightDpi(), (Matcher)Is.is((Object)-1));
        Assert.assertThat((Object)Float.valueOf(this.image.getPhysicalWidthInch()), (Matcher)Is.is((Object)Float.valueOf(-1.0f)));
        Assert.assertThat((Object)Float.valueOf(this.image.getPhysicalHeightInch()), (Matcher)Is.is((Object)Float.valueOf(-1.0f)));
        Assert.assertThat((Object)this.image.getNumberOfComments(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldBeAbleToLoadJpegImage() {
        InputStream stream = this.getTestImage("caution.jpg");
        this.image.setInput(stream);
        this.image.setDetermineImageNumber(true);
        this.image.setCollectComments(true);
        Assert.assertThat((Object)this.image.check(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.image.getFormatName(), (Matcher)Is.is((Object)"JPEG"));
        Assert.assertThat((Object)this.image.getMimeType(), (Matcher)Is.is((Object)"image/jpeg"));
        Assert.assertThat((Object)this.image.getWidth(), (Matcher)Is.is((Object)48));
        Assert.assertThat((Object)this.image.getHeight(), (Matcher)Is.is((Object)48));
        Assert.assertThat((Object)this.image.getBitsPerPixel(), (Matcher)Is.is((Object)24));
        Assert.assertThat((Object)this.image.isProgressive(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.image.getNumberOfImages(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.image.getPhysicalWidthDpi(), (Matcher)Is.is((Object)72));
        Assert.assertThat((Object)this.image.getPhysicalHeightDpi(), (Matcher)Is.is((Object)72));
        Assert.assertThat((Object)this.image.getPhysicalWidthInch(), (Matcher)Is.is((Matcher)IsCloseTo.closeTo((double)0.66666666, (double)1.0E-5)));
        Assert.assertThat((Object)this.image.getPhysicalHeightInch(), (Matcher)Is.is((Matcher)IsCloseTo.closeTo((double)0.66666666, (double)1.0E-5)));
        Assert.assertThat((Object)this.image.getNumberOfComments(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldNotBeAbleToLoadPictImage() {
        InputStream stream = this.getTestImage("caution.pict");
        this.image.setInput(stream);
        this.image.setDetermineImageNumber(true);
        this.image.setCollectComments(true);
        Assert.assertThat((Object)this.image.check(), (Matcher)Is.is((Object)false));
    }
}

