/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.jpdl3;

import java.io.InputStream;
import java.util.List;
import org.jboss.dna.sequencer.jpdl3.JPDL3EndStateMetadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3Metadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3StartStateMetadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3TransitionMetadata;
import org.jbpm.util.ClassLoaderUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JPDL3MetadataTest {
    JPDL3Metadata metadata;

    @Before
    public void beforeEach() {
        this.metadata = JPDL3MetadataTest.createJPDLMetadata();
    }

    @After
    public void afterEach() {
    }

    @Test
    public void shouldHaveName() {
        Assert.assertEquals((Object)"Pd-Name", (Object)this.metadata.getPdName());
    }

    @Test
    public void shouldHaveStartState() {
        JPDL3StartStateMetadata jPDL3StartStateMetadata = this.metadata.getStartStateMetadata();
        Assert.assertNotNull((Object)jPDL3StartStateMetadata);
        Assert.assertEquals((Object)"S0", (Object)jPDL3StartStateMetadata.getName());
        List transitions = jPDL3StartStateMetadata.getTransitions();
        for (JPDL3TransitionMetadata jPDL3TransitionMetadata : transitions) {
            Assert.assertEquals((Object)"Tr01_S01", (Object)jPDL3TransitionMetadata.getName());
            Assert.assertEquals((Object)"Phase01", (Object)jPDL3TransitionMetadata.getTo());
        }
    }

    @Test
    public void shouldHaveEndState() {
        JPDL3EndStateMetadata jPDL3EndStateMetadata = this.metadata.getEndStateMetadata();
        Assert.assertNotNull((Object)jPDL3EndStateMetadata);
        Assert.assertEquals((Object)"S1", (Object)jPDL3EndStateMetadata.getName());
    }

    public static JPDL3Metadata createJPDLMetadata() {
        InputStream stream = ClassLoaderUtil.getStream((String)"processdefinition.xml");
        JPDL3Metadata metadata = JPDL3Metadata.instance((InputStream)stream);
        Assert.assertNotNull((Object)metadata);
        return metadata;
    }
}

