/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.jpdl3;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.dna.sequencer.jpdl3.JPDL3EndStateMetadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3StartStateMetadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3TransitionMetadata;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.EndState;
import org.jbpm.graph.node.StartState;

public class JPDL3Metadata {
    private String pdName;
    private JPDL3StartStateMetadata jPDL3StartStateMetadata;
    private JPDL3EndStateMetadata jPDL3EndStateMetadata;

    private JPDL3Metadata() {
    }

    public static JPDL3Metadata instance(InputStream stream) {
        ProcessDefinition processDefinition = ProcessDefinition.parseXmlInputStream((InputStream)stream);
        if (processDefinition != null) {
            JPDL3Metadata jplMetadata = new JPDL3Metadata();
            if (processDefinition.getName() != null) {
                jplMetadata.setPdName(processDefinition.getName());
            }
            List nodes = processDefinition.getNodes();
            for (Node node : nodes) {
                if (node instanceof StartState) {
                    StartState startState = (StartState)node;
                    JPDL3StartStateMetadata jPDL3StartStateMetadata = new JPDL3StartStateMetadata();
                    if (startState.getName() != null) {
                        jPDL3StartStateMetadata.setName(startState.getName());
                    }
                    ArrayList<JPDL3TransitionMetadata> transitions = new ArrayList<JPDL3TransitionMetadata>();
                    for (Transition transition : startState.getLeavingTransitions()) {
                        Node toNode;
                        JPDL3TransitionMetadata jPDL3TransitionMetadata = new JPDL3TransitionMetadata();
                        if (transition.getName() != null) {
                            jPDL3TransitionMetadata.setName(transition.getName());
                        }
                        if ((toNode = transition.getTo()) != null) {
                            jPDL3TransitionMetadata.setTo(toNode.getName());
                        }
                        transitions.add(jPDL3TransitionMetadata);
                    }
                    jPDL3StartStateMetadata.setTransitions(transitions);
                    jplMetadata.setStartStateMetadata(jPDL3StartStateMetadata);
                }
                if (!(node instanceof EndState)) continue;
                EndState endState = (EndState)node;
                JPDL3EndStateMetadata jPDL3EndStateMetadata = new JPDL3EndStateMetadata();
                if (endState.getName() != null) {
                    jPDL3EndStateMetadata.setName(endState.getName());
                }
                jplMetadata.setEndStateMetadata(jPDL3EndStateMetadata);
            }
            return jplMetadata;
        }
        return null;
    }

    public String getPdName() {
        return this.pdName;
    }

    public void setPdName(String pdName) {
        this.pdName = pdName;
    }

    public JPDL3StartStateMetadata getStartStateMetadata() {
        return this.jPDL3StartStateMetadata;
    }

    public JPDL3EndStateMetadata getEndStateMetadata() {
        return this.jPDL3EndStateMetadata;
    }

    public void setStartStateMetadata(JPDL3StartStateMetadata jPDL3StartStateMetadata) {
        this.jPDL3StartStateMetadata = jPDL3StartStateMetadata;
    }

    public void setEndStateMetadata(JPDL3EndStateMetadata jPDL3EndStateMetadata) {
        this.jPDL3EndStateMetadata = jPDL3EndStateMetadata;
    }
}

