/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.jpdl3;

import java.io.InputStream;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.jboss.dna.sequencer.jpdl3.JPDL3EndStateMetadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3Metadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3StartStateMetadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3SwimlaneMetadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3TaskMetadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3TaskNodeMetadata;
import org.jboss.dna.sequencer.jpdl3.JPDL3TransitionMetadata;
import org.jbpm.util.ClassLoaderUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JPDL3MetadataTest {
    JPDL3Metadata metadata;

    @Before
    public void beforeEach() {
        this.metadata = JPDL3MetadataTest.createJPDLMetadata();
    }

    @After
    public void afterEach() {
    }

    @Test
    public void shouldHaveName() {
        Assert.assertEquals((Object)"Pd-Name", (Object)this.metadata.getPdName());
    }

    @Test
    public void shouldHaveOneOrMoreSwimlaneNode() {
        List swimlanes = this.metadata.getSwimlanes();
        Assert.assertThat((Object)swimlanes.isEmpty(), (Matcher)Is.is((Object)false));
        for (JPDL3SwimlaneMetadata swimlane : swimlanes) {
            if (swimlane.getName().equals("SL1")) {
                Assert.assertThat((Object)swimlane.getAssignment(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                Assert.assertThat((Object)swimlane.getAssignment().getFqClassName(), (Matcher)Is.is((Object)"com.sample.assigned.Task1Handler"));
                Assert.assertThat((Object)swimlane.getAssignment().getConfigType(), (Matcher)Is.is((Object)"constructor"));
                continue;
            }
            if (swimlane.getName().equals("SL2")) {
                Assert.assertThat((Object)swimlane.getAssignment(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                Assert.assertNotNull((Object)swimlane.getAssignment());
                Assert.assertThat((Object)swimlane.getAssignment().getFqClassName(), (Matcher)Is.is((Object)"com.sample.assigned.Task2Handler"));
                continue;
            }
            if (swimlane.getName().equals("SL3")) {
                Assert.assertThat((Object)swimlane.getAssignment(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
                Assert.assertThat((Object)swimlane.getAssignment().getFqClassName(), (Matcher)Is.is((Object)"org.jbpm.identity.assignment.ExpressionAssignmentHandler"));
                Assert.assertThat((Object)swimlane.getAssignment().getExpression(), (Matcher)Is.is((Object)"<expression>group(group1)</expression>"));
                continue;
            }
            if (swimlane.getName().equals("SL4")) {
                Assert.assertThat((Object)swimlane.getAssignment(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
                Assert.assertThat((Object)swimlane.getActorIdExpression(), (Matcher)Is.is((Object)"bobthebuilder"));
                continue;
            }
            if (!swimlane.getName().equals("SL5")) continue;
            Assert.assertThat((Object)swimlane.getAssignment(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
            Assert.assertThat((Object)swimlane.getPooledActorsExpression(), (Matcher)Is.is((Object)"hippies,hells angles"));
        }
    }

    @Test
    public void shouldHaveStartState() {
        JPDL3StartStateMetadata jPDL3StartStateMetadata = this.metadata.getStartStateMetadata();
        Assert.assertNotNull((Object)jPDL3StartStateMetadata);
        Assert.assertEquals((Object)"S0", (Object)jPDL3StartStateMetadata.getName());
        List transitions = jPDL3StartStateMetadata.getTransitions();
        for (JPDL3TransitionMetadata jPDL3TransitionMetadata : transitions) {
            Assert.assertEquals((Object)"Tr01_S01", (Object)jPDL3TransitionMetadata.getName());
            Assert.assertEquals((Object)"Phase01", (Object)jPDL3TransitionMetadata.getTo());
        }
    }

    @Test
    public void shouldHaveEndState() {
        JPDL3EndStateMetadata jPDL3EndStateMetadata = this.metadata.getEndStateMetadata();
        Assert.assertNotNull((Object)jPDL3EndStateMetadata);
        Assert.assertEquals((Object)"S1", (Object)jPDL3EndStateMetadata.getName());
    }

    @Test
    public void shouldHaveATaskNode() {
        List taskNodes = this.metadata.getTaskNodes();
        Assert.assertThat((Object)(taskNodes.size() > 0 ? 1 : 0), (Matcher)Is.is((Object)true));
        for (JPDL3TaskNodeMetadata jPDL3TaskNodeMetadata : taskNodes) {
            if (jPDL3TaskNodeMetadata.getName().equals("Phase01")) {
                List tasks = jPDL3TaskNodeMetadata.getTasks();
                Assert.assertThat((Object)(tasks.size() == 2 ? 1 : 0), (Matcher)Is.is((Object)true));
                for (JPDL3TaskMetadata jPDL3TaskMetadata : tasks) {
                    if (!jPDL3TaskMetadata.getName().equals("Task01_Phase01")) continue;
                    String swimlane = jPDL3TaskMetadata.getSwimlane();
                    Assert.assertThat((Object)swimlane, (Matcher)Is.is((Object)"SL1"));
                }
            }
            List transitions = jPDL3TaskNodeMetadata.getTransitions();
            for (JPDL3TransitionMetadata transitionMetadata : transitions) {
                String transitionName = transitionMetadata.getName();
                if (transitionName.equals("Tr01_Phase01")) {
                    Assert.assertThat((Object)transitionMetadata.getTo(), (Matcher)Is.is((Object)"Phase02"));
                    continue;
                }
                if (transitionName.equals("Tr01_Phase02")) {
                    Assert.assertThat((Object)transitionMetadata.getTo(), (Matcher)Is.is((Object)"Phase03"));
                    continue;
                }
                if (transitionName.equals("Tr01_Phase03")) {
                    Assert.assertThat((Object)transitionMetadata.getTo(), (Matcher)Is.is((Object)"Phase04"));
                    continue;
                }
                if (transitionName.equals("Tr01_Phase04")) {
                    Assert.assertThat((Object)transitionMetadata.getTo(), (Matcher)Is.is((Object)"Phase05"));
                    continue;
                }
                if (transitionName.equals("Tr01_Phase05")) {
                    Assert.assertThat((Object)transitionMetadata.getTo(), (Matcher)Is.is((Object)"Phase06"));
                    continue;
                }
                if (!transitionName.equals("Tr01_Phase06")) continue;
                Assert.assertThat((Object)transitionMetadata.getTo(), (Matcher)Is.is((Object)"S1"));
            }
        }
    }

    public static JPDL3Metadata createJPDLMetadata() {
        InputStream stream = ClassLoaderUtil.getStream((String)"processdefinition.xml");
        JPDL3Metadata metadata = JPDL3Metadata.instance((InputStream)stream);
        Assert.assertNotNull((Object)metadata);
        return metadata;
    }
}

