/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.sequencer.MockSequencerContext;
import org.jboss.dna.graph.sequencer.MockSequencerOutput;
import org.jboss.dna.graph.sequencer.SequencerContext;
import org.jboss.dna.graph.sequencer.SequencerOutput;
import org.jboss.dna.sequencer.xml.InheritingXmlSequencer;
import org.jboss.dna.sequencer.xml.XmlSequencer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InheritingXmlSequencerTest {
    private static final String DOCUMENT = "dnaxml:document";
    private XmlSequencer sequencer;
    private InputStream stream;
    private MockSequencerOutput output;
    private URL xsd;
    private SequencerContext context;

    @Before
    public void beforeEach() {
        this.sequencer = new InheritingXmlSequencer();
        this.context = new MockSequencerContext();
        this.output = new MockSequencerOutput(this.context);
        this.xsd = this.getClass().getClassLoader().getResource("Descriptor.1.0.xsd");
        Assert.assertThat((Object)this.xsd, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            finally {
                this.stream = null;
            }
        }
    }

    @Test
    public void shouldSequenceXsds() throws IOException {
        Assert.assertThat((Object)this.sequencer.getAttributeScoping(), (Matcher)Is.is((Object)XmlSequencer.AttributeScoping.INHERIT_ELEMENT_NAMESPACE));
        this.verifyDocument(this.xsd);
        this.verifyName("xs:schema", "jcr:primaryType", "nt:unstructured");
        this.verifyString("xs:schema", "xs:targetNamespace", "http://ns.adobe.com/air/application/1.0");
        this.verifyString("xs:schema", "xs:elementFormDefault", "qualified");
        this.verifyName("xs:schema/xs:element", "jcr:primaryType", "nt:unstructured");
        this.verifyString("xs:schema/xs:element", "xs:name", "application");
    }

    private <T> T verify(String nodePath, String property, Class<T> expectedClass) {
        Object[] values = this.output.getPropertyValues(nodePath.length() == 0 ? "" : nodePath, property);
        Assert.assertThat((Object)values, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)values.length, (Matcher)Is.is((Object)1));
        Object value = values[0];
        Assert.assertThat((Object)value, (Matcher)IsInstanceOf.instanceOf(expectedClass));
        return expectedClass.cast(value);
    }

    private void verifyDocument(URL url) throws IOException {
        this.stream = url.openStream();
        Assert.assertThat((Object)this.stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.stream, (SequencerOutput)this.output, this.context);
        this.verifyName("", "jcr:primaryType", DOCUMENT);
    }

    private void verifyName(String nodePath, String property, String expectedName) {
        Name name = this.verify(nodePath, property, Name.class);
        Assert.assertThat((Object)name, (Matcher)Is.is((Object)this.context.getValueFactories().getNameFactory().create(expectedName)));
    }

    private void verifyString(String nodePath, String property, String expectedString) {
        String string = this.verify(nodePath, property, String.class);
        Assert.assertThat((Object)string, (Matcher)Is.is((Object)expectedString));
    }
}

