/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.sequencer.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.jboss.dna.graph.property.Name;
import org.jboss.dna.graph.sequencer.MockSequencerContext;
import org.jboss.dna.graph.sequencer.MockSequencerOutput;
import org.jboss.dna.graph.sequencer.SequencerOutput;
import org.jboss.dna.graph.sequencer.StreamSequencerContext;
import org.jboss.dna.sequencer.xml.XmlSequencer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSequencerTest {
    private static final String CDATA = "dnaxml:cData";
    private static final String CDATA_CONTENT = "dnaxml:cDataContent";
    private static final String DOCUMENT = "dnaxml:document";
    private static final String DTD_NAME = "dnadtd:name";
    private static final String DTD_SYSTEM_ID = "dnadtd:systemId";
    private static final String DTD_VALUE = "dnadtd:value";
    private static final String ELEMENT_CONTENT = "dnaxml:elementContent";
    private static final String ENTITY = "dnadtd:entity";
    private static final String PI = "dnaxml:processingInstruction";
    private static final String PI_CONTENT = "dnaxml:processingInstructionContent";
    private static final String TARGET = "dnaxml:target";
    private XmlSequencer sequencer;
    private InputStream stream;
    private MockSequencerOutput output;
    private URL xml2;
    private URL xml3;
    private URL xml4;
    private URL xsd;
    private StreamSequencerContext context;

    @Before
    public void beforeEach() {
        this.sequencer = new XmlSequencer();
        this.context = new MockSequencerContext();
        this.output = new MockSequencerOutput(this.context);
        this.xml2 = this.getClass().getClassLoader().getResource("master.xml");
        Assert.assertThat((Object)this.xml2, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.xml3 = this.getClass().getClassLoader().getResource("CurrencyFormatterExample.mxml");
        Assert.assertThat((Object)this.xml3, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.xml4 = this.getClass().getClassLoader().getResource("plugin.xml");
        Assert.assertThat((Object)this.xml4, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.xsd = this.getClass().getClassLoader().getResource("Descriptor.1.0.xsd");
        Assert.assertThat((Object)this.xsd, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @After
    public void afterEach() throws Exception {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            finally {
                this.stream = null;
            }
        }
    }

    @Test
    public void shouldHandleNamespaces() throws IOException {
        this.verifyDocument(this.xml2);
        this.verifyName("book[1]/bookinfo[1]/xi:include[1]", "jcr:primaryType", "nt:unstructured");
        this.verifyString("book[1]/bookinfo[1]/xi:include[1]", "href", "Author_Group.xml");
        this.verifyName("book[1]/bookinfo[1]/xi:include[2]", "jcr:primaryType", "nt:unstructured");
        this.verifyString("book[1]/bookinfo[1]/xi:include[2]", "href", "Legal_Notice.xml");
    }

    @Test
    public void shouldSequenceEntityDeclarations() throws IOException {
        this.verifyDocument(this.xml2);
        this.verifyName("dnadtd:entity[1]", "jcr:primaryType", ENTITY);
        this.verifyString("dnadtd:entity[1]", DTD_NAME, "%RH-ENTITIES");
        this.verifyString("dnadtd:entity[1]", DTD_SYSTEM_ID, "Common_Config/rh-entities.ent");
        this.verifyName("dnadtd:entity[2]", "jcr:primaryType", ENTITY);
        this.verifyString("dnadtd:entity[2]", DTD_NAME, "versionNumber");
        this.verifyString("dnadtd:entity[2]", DTD_VALUE, "0.1");
        this.verifyName("dnadtd:entity[3]", "jcr:primaryType", ENTITY);
        this.verifyString("dnadtd:entity[3]", DTD_NAME, "copyrightYear");
        this.verifyString("dnadtd:entity[3]", DTD_VALUE, "2008");
    }

    @Test
    public void shouldSequenceElementContent() throws IOException {
        this.verifyDocument(this.xml2);
        this.verifyString("book[1]/chapter[1]/para[8]/dnaxml:elementContent[1]", ELEMENT_CONTENT, "JBoss DNA is building other features as well. One goal of JBoss DNA is to create federated repositories that dynamically merge the information from multiple databases, services, applications, and other JCR repositories. Another is to create customized views based upon the type of data and the role of the user that is accessing the data. And yet another is to create a REST-ful API to allow the JCR content to be accessed easily by other applications written in other languages.");
    }

    @Test
    public void shouldSequenceCData() throws IOException {
        this.verifyDocument(this.xml3);
        this.verifyString("mx:Application[1]/mx:Script[1]/dnaxml:cData[1]", CDATA_CONTENT, "\n\n              import mx.events.ValidationResultEvent;\t\t\t\n              private var vResult:ValidationResultEvent;\n\t\t\t\n              // Event handler to validate and format input.\n              private function Format():void {\n              \n                    vResult = numVal.validate();\n\n                    if (vResult.type==ValidationResultEvent.VALID) {\n                        var temp:Number=Number(priceUS.text); \n                        formattedUSPrice.text= usdFormatter.format(temp);\n                    }\n                    \n                    else {\n                       formattedUSPrice.text=\"\";\n                    }\n              }\n        ");
    }

    @Test
    public void shouldSequenceProcessingInstructions() throws IOException {
        this.verifyDocument(this.xml4);
        this.verifyName("dnaxml:processingInstruction[1]", "jcr:primaryType", PI);
        this.verifyString("dnaxml:processingInstruction[1]", TARGET, "eclipse");
        this.verifyString("dnaxml:processingInstruction[1]", PI_CONTENT, "version=\"3.0\"");
    }

    @Test
    public void shouldSequenceXsds() throws IOException {
        this.sequencer.setAttributeScoping(XmlSequencer.AttributeScoping.INHERIT_ELEMENT_NAMESPACE);
        this.verifyDocument(this.xsd);
        this.verifyName("xs:schema", "jcr:primaryType", "nt:unstructured");
        this.verifyString("xs:schema", "xs:targetNamespace", "http://ns.adobe.com/air/application/1.0");
        this.verifyString("xs:schema", "xs:elementFormDefault", "qualified");
        this.verifyName("xs:schema/xs:element", "jcr:primaryType", "nt:unstructured");
        this.verifyString("xs:schema/xs:element", "xs:name", "application");
    }

    private <T> T verify(String nodePath, String property, Class<T> expectedClass) {
        Object[] values = this.output.getPropertyValues(nodePath.length() == 0 ? "" : nodePath, property);
        Assert.assertThat((Object)values, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)values.length, (Matcher)Is.is((Object)1));
        Object value = values[0];
        Assert.assertThat((Object)value, (Matcher)IsInstanceOf.instanceOf(expectedClass));
        return expectedClass.cast(value);
    }

    private void verifyDocument(URL url) throws IOException {
        this.stream = url.openStream();
        Assert.assertThat((Object)this.stream, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        this.sequencer.sequence(this.stream, (SequencerOutput)this.output, this.context);
        this.verifyName("", "jcr:primaryType", DOCUMENT);
    }

    private void verifyName(String nodePath, String property, String expectedName) {
        Name name = this.verify(nodePath, property, Name.class);
        Assert.assertThat((Object)name, (Matcher)Is.is((Object)this.context.getValueFactories().getNameFactory().create(expectedName)));
    }

    private void verifyString(String nodePath, String property, String expectedString) {
        String string = this.verify(nodePath, property, String.class);
        Assert.assertThat((Object)string, (Matcher)Is.is((Object)expectedString));
    }
}

