/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.spi.sequencers;

import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.jboss.dna.spi.sequencers.SequencerOutput;

@NotThreadSafe
public class MockSequencerOutput
implements SequencerOutput {
    private final Map<String, Object[]> properties = new HashMap<String, Object[]>();
    private final Map<String, String[]> references = new HashMap<String, String[]>();

    public void setProperty(String nodePath, String property, Object ... values) {
        String key = this.getKey(nodePath, property);
        if (values == null || values.length == 0) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, values);
        }
    }

    public void setReference(String nodePath, String property, String ... paths) {
        String key = this.getKey(nodePath, property);
        if (paths == null || paths.length == 0) {
            this.references.remove(key);
        } else {
            this.references.put(key, paths);
        }
    }

    public Object[] getPropertyValues(String nodePath, String property) {
        String key = this.getKey(nodePath, property);
        return this.properties.get(key);
    }

    public String[] getReferenceValues(String nodePath, String property) {
        String key = this.getKey(nodePath, property);
        return this.references.get(key);
    }

    public boolean hasProperty(String nodePath, String property) {
        String key = nodePath + "@" + property;
        return this.properties.containsKey(key);
    }

    public boolean hasReference(String nodePath, String property) {
        String key = nodePath + "@" + property;
        return this.references.containsKey(key);
    }

    public boolean hasProperties() {
        return this.properties.size() > 0;
    }

    public boolean hasReferences() {
        return this.references.size() > 0;
    }

    protected String getKey(String nodePath, String property) {
        return nodePath + "@" + property;
    }
}

