/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.web.jcr.rest.client;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.jboss.dna.web.jcr.rest.client.Status;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;

public final class StatusTest {
    private static final Status ERROR_STATUS = new Status(Status.Severity.ERROR, null, null);
    private static final Status INFO_STATUS = new Status(Status.Severity.INFO, null, null);
    private static final Status WARNING_STATUS = new Status(Status.Severity.WARNING, null, null);
    private static final Status UNKNOWN_STATUS = new Status(Status.Severity.UNKNOWN, null, null);
    private static final Status NULL_SEVERITY_STATUS = new Status(null, null, null);

    @Test
    public void shouldHaveErrorSeverity() {
        Assert.assertThat((Object)ERROR_STATUS.isError(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)ERROR_STATUS.isInfo(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)ERROR_STATUS.isOk(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)ERROR_STATUS.isUnknown(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)ERROR_STATUS.isWarning(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveInfoSeverity() {
        Assert.assertThat((Object)INFO_STATUS.isInfo(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)INFO_STATUS.isError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)INFO_STATUS.isOk(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)INFO_STATUS.isUnknown(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)INFO_STATUS.isWarning(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveOkSeverity() {
        Assert.assertThat((Object)Status.OK_STATUS.isOk(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)Status.OK_STATUS.isError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)Status.OK_STATUS.isInfo(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)Status.OK_STATUS.isUnknown(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)Status.OK_STATUS.isWarning(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveUnknownSeverity() {
        Assert.assertThat((Object)UNKNOWN_STATUS.isUnknown(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)UNKNOWN_STATUS.isError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)UNKNOWN_STATUS.isInfo(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)UNKNOWN_STATUS.isOk(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)UNKNOWN_STATUS.isWarning(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveUnknownSeverityWhenNullSeverity() {
        Assert.assertThat((Object)NULL_SEVERITY_STATUS.isUnknown(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)NULL_SEVERITY_STATUS.isError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)NULL_SEVERITY_STATUS.isInfo(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)NULL_SEVERITY_STATUS.isOk(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)NULL_SEVERITY_STATUS.isWarning(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldHaveWarningSeverity() {
        Assert.assertThat((Object)WARNING_STATUS.isWarning(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)WARNING_STATUS.isError(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)WARNING_STATUS.isInfo(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)WARNING_STATUS.isOk(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)WARNING_STATUS.isUnknown(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldNotHaveNullMessageWhenConstructedWithNullMessage() {
        Assert.assertThat((Object)new Status(Status.Severity.WARNING, null, null).getMessage(), (Matcher)IsNot.not((Object)Matchers.isNull()));
    }

    @Test
    public void shouldBeAbleToPrintWithMessageAndNullException() {
        new Status(Status.Severity.WARNING, "the message goes here", null).toString();
    }

    @Test
    public void shouldBeAbleToPrintWithMessageAndException() {
        new Status(Status.Severity.WARNING, "the message goes here", (Throwable)new RuntimeException("exception message")).toString();
    }

    @Test
    public void shouldBeAbleToPrintWithNullMessageAndException() {
        new Status(Status.Severity.WARNING, null, (Throwable)new RuntimeException("exception message")).toString();
    }

    @Test
    public void shouldBeAbleToPrintWithNullMessageAndNullException() {
        new Status(Status.Severity.WARNING, null, null).toString();
    }
}

