/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.web.jcr.rest.client.domain;

import net.jcip.annotations.Immutable;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.HashCode;
import org.jboss.dna.web.jcr.rest.client.RestClientI18n;
import org.jboss.dna.web.jcr.rest.client.domain.IDnaObject;
import org.jboss.dna.web.jcr.rest.client.domain.Repository;
import org.jboss.dna.web.jcr.rest.client.domain.Server;

@Immutable
public class Workspace
implements IDnaObject {
    private final String name;
    private final Repository repository;

    public Workspace(String name, Repository repository) {
        CheckArg.isNotNull((Object)name, (String)"name");
        CheckArg.isNotNull((Object)repository, (String)"repository");
        this.name = name;
        this.repository = repository;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Workspace otherWorkspace = (Workspace)obj;
        return this.name.equals(otherWorkspace.name) && this.repository.equals(otherWorkspace.repository);
    }

    public String getName() {
        return this.name;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Server getServer() {
        return this.repository.getServer();
    }

    public String getShortDescription() {
        return RestClientI18n.workspaceShortDescription.text(new Object[]{this.name, this.repository.getName()});
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.name, this.repository});
    }

    public String toString() {
        return this.getShortDescription();
    }
}

