/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.web.jcr.rest.client.json;

import java.net.URL;
import net.jcip.annotations.Immutable;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.web.jcr.rest.client.domain.Workspace;
import org.jboss.dna.web.jcr.rest.client.json.JsonNode;
import org.jboss.dna.web.jcr.rest.client.json.JsonUtils;
import org.jboss.dna.web.jcr.rest.client.json.WorkspaceNode;

@Immutable
public final class FolderNode
extends JsonNode {
    private final Workspace workspace;

    public FolderNode(Workspace workspace, String fullPath) throws Exception {
        super(fullPath);
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        CheckArg.isNotNull((Object)fullPath, (String)"fullPath");
        this.workspace = workspace;
        JSONObject properties = new JSONObject();
        properties.put("jcr:primaryType", (Object)"nt:folder");
        this.put("properties", properties);
    }

    public String getPath() {
        return this.getId();
    }

    public URL getUrl() throws Exception {
        WorkspaceNode workspaceNode = new WorkspaceNode(this.workspace);
        StringBuilder url = new StringBuilder(workspaceNode.getUrl().toString());
        String path = this.getPath();
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        url.append(JsonUtils.encode(path));
        return new URL(url.toString());
    }
}

