/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.web.jcr.rest.client.json;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import org.jboss.dna.common.util.CheckArg;
import org.jboss.dna.common.util.Logger;
import org.jboss.dna.web.jcr.rest.client.IRestClient;
import org.jboss.dna.web.jcr.rest.client.RestClientI18n;
import org.jboss.dna.web.jcr.rest.client.Status;
import org.jboss.dna.web.jcr.rest.client.domain.Repository;
import org.jboss.dna.web.jcr.rest.client.domain.Server;
import org.jboss.dna.web.jcr.rest.client.domain.Workspace;
import org.jboss.dna.web.jcr.rest.client.http.HttpClientConnection;
import org.jboss.dna.web.jcr.rest.client.json.FileNode;
import org.jboss.dna.web.jcr.rest.client.json.FolderNode;
import org.jboss.dna.web.jcr.rest.client.json.IJsonConstants;
import org.jboss.dna.web.jcr.rest.client.json.RepositoryNode;
import org.jboss.dna.web.jcr.rest.client.json.ServerNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsonRestClient
implements IRestClient {
    private final Logger logger = Logger.getLogger(JsonRestClient.class);

    private HttpClientConnection connect(Server server, URL url, IJsonConstants.RequestMethod method) throws Exception {
        this.logger.trace("connect: url={0}, method={1}", new Object[]{url, method});
        return new HttpClientConnection(server, url, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFileNode(Workspace workspace, String path, File file) throws Exception {
        this.logger.trace("createFileNode: workspace={0}, path={1}, file={2}", new Object[]{workspace.getName(), path, file.getAbsolutePath()});
        FileNode fileNode = new FileNode(workspace, path, file);
        HttpClientConnection connection = this.connect(workspace.getServer(), fileNode.getUrl(), IJsonConstants.RequestMethod.POST);
        try {
            this.logger.trace("createFileNode: create node={0}", new Object[]{fileNode});
            connection.write(fileNode.getContent());
            int responseCode = connection.getResponseCode();
            if (responseCode != 201) {
                this.logger.error(RestClientI18n.connectionErrorMsg, new Object[]{responseCode, "createFileNode"});
                String msg = RestClientI18n.createFileFailedMsg.text(new Object[]{file.getName(), path, workspace.getName(), responseCode});
                throw new RuntimeException(msg);
            }
        }
        finally {
            if (connection != null) {
                this.logger.trace("createFileNode: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFolderNode(Workspace workspace, String path) throws Exception {
        this.logger.trace("createFolderNode: workspace={0}, path={1}", new Object[]{workspace.getName(), path});
        FolderNode folderNode = new FolderNode(workspace, path);
        HttpClientConnection connection = this.connect(workspace.getServer(), folderNode.getUrl(), IJsonConstants.RequestMethod.POST);
        try {
            this.logger.trace("createFolderNode: create node={0}", new Object[]{folderNode});
            connection.write(folderNode.getContent());
            int responseCode = connection.getResponseCode();
            if (responseCode != 201) {
                this.logger.error(RestClientI18n.connectionErrorMsg, new Object[]{responseCode, "createFolderNode"});
                String msg = RestClientI18n.createFolderFailedMsg.text(new Object[]{path, workspace.getName(), responseCode});
                throw new RuntimeException(msg);
            }
        }
        finally {
            if (connection != null) {
                this.logger.trace("createFolderNode: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    private void ensureFolderExists(Workspace workspace, String folderPath) throws Exception {
        this.logger.trace("ensureFolderExists: workspace={0}, path={1}", new Object[]{workspace.getName(), folderPath});
        FolderNode folderNode = new FolderNode(workspace, folderPath);
        if (!this.pathExists(workspace.getServer(), folderNode.getUrl())) {
            StringBuilder path = new StringBuilder();
            for (char c : folderPath.toCharArray()) {
                if (c == '/') {
                    if (path.length() > 1) {
                        folderNode = new FolderNode(workspace, path.toString());
                        if (!this.pathExists(workspace.getServer(), folderNode.getUrl())) {
                            this.createFolderNode(workspace, folderNode.getPath());
                        }
                    }
                    path.append(c);
                    continue;
                }
                path.append(c);
                if (path.length() != folderPath.length()) continue;
                folderNode = new FolderNode(workspace, path.toString());
                if (this.pathExists(workspace.getServer(), folderNode.getUrl())) continue;
                this.createFolderNode(workspace, folderNode.getPath());
            }
        }
    }

    @Override
    public Collection<Repository> getRepositories(Server server) throws Exception {
        CheckArg.isNotNull((Object)server, (String)"server");
        this.logger.trace("getRepositories: server={0}", new Object[]{server});
        ServerNode serverNode = new ServerNode(server);
        HttpClientConnection connection = this.connect(server, serverNode.getFindRepositoriesUrl(), IJsonConstants.RequestMethod.GET);
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                Collection<Repository> collection = serverNode.getRepositories(connection.read());
                return collection;
            }
            this.logger.error(RestClientI18n.connectionErrorMsg, new Object[]{responseCode, "getRepositories"});
            String msg = RestClientI18n.getRepositoriesFailedMsg.text(new Object[]{server.getName(), responseCode});
            throw new RuntimeException(msg);
        }
        finally {
            if (connection != null) {
                this.logger.trace("getRepositories: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    @Override
    public URL getUrl(File file, String path, Workspace workspace) throws Exception {
        CheckArg.isNotNull((Object)file, (String)"file");
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        if (file.isDirectory()) {
            throw new IllegalArgumentException();
        }
        return new FileNode(workspace, path, file).getUrl();
    }

    @Override
    public Collection<Workspace> getWorkspaces(Repository repository) throws Exception {
        CheckArg.isNotNull((Object)repository, (String)"repository");
        this.logger.trace("getWorkspaces: repository={0}", new Object[]{repository});
        RepositoryNode repositoryNode = new RepositoryNode(repository);
        HttpClientConnection connection = this.connect(repository.getServer(), repositoryNode.getUrl(), IJsonConstants.RequestMethod.GET);
        try {
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                Collection<Workspace> collection = repositoryNode.getWorkspaces(connection.read());
                return collection;
            }
            this.logger.error(RestClientI18n.connectionErrorMsg, new Object[]{responseCode, "getWorkspaces"});
            String msg = RestClientI18n.getWorkspacesFailedMsg.text(new Object[]{repository.getName(), repository.getServer().getName(), responseCode});
            throw new RuntimeException(msg);
        }
        finally {
            if (connection != null) {
                this.logger.trace("getWorkspaces: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    String getFileContents(Workspace workspace, String path, File file) throws Exception {
        FileNode fileNode = new FileNode(workspace, path, file);
        HttpClientConnection connection = this.connect(workspace.getServer(), fileNode.getFileContentsUrl(), IJsonConstants.RequestMethod.GET);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            String result = connection.read();
            return fileNode.getFileContents(result);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pathExists(Server server, URL url) throws Exception {
        this.logger.trace("pathExists: url={0}", new Object[]{url});
        HttpClientConnection connection = this.connect(server, url, IJsonConstants.RequestMethod.GET);
        try {
            int responseCode = connection.getResponseCode();
            this.logger.trace("pathExists: responseCode={0}", new Object[]{responseCode});
            boolean bl = responseCode == 200;
            return bl;
        }
        finally {
            if (connection != null) {
                this.logger.trace("pathExists: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }

    public boolean pathExists(Workspace workspace, String path, File file) throws Exception {
        FileNode fileNode = new FileNode(workspace, path, file);
        return this.pathExists(workspace.getServer(), fileNode.getUrl());
    }

    @Override
    public Status publish(Workspace workspace, String path, File file) {
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)file, (String)"file");
        this.logger.trace("publish: workspace={0}, path={1}, file={2}", new Object[]{workspace.getName(), path, file.getAbsolutePath()});
        try {
            if (this.pathExists(workspace, path, file)) {
                this.unpublish(workspace, path, file);
            } else {
                this.ensureFolderExists(workspace, path);
            }
            this.createFileNode(workspace, path, file);
        }
        catch (Exception e) {
            String msg = RestClientI18n.publishFailedMsg.text(new Object[]{file.getAbsolutePath(), path, workspace.getName()});
            return new Status(Status.Severity.ERROR, msg, e);
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status unpublish(Workspace workspace, String path, File file) {
        CheckArg.isNotNull((Object)workspace, (String)"workspace");
        CheckArg.isNotNull((Object)path, (String)"path");
        CheckArg.isNotNull((Object)file, (String)"file");
        this.logger.trace("unpublish: workspace={0}, path={1}, file={2}", new Object[]{workspace.getName(), path, file.getAbsolutePath()});
        HttpClientConnection connection = null;
        try {
            FileNode fileNode = new FileNode(workspace, path, file);
            connection = this.connect(workspace.getServer(), fileNode.getUrl(), IJsonConstants.RequestMethod.DELETE);
            int responseCode = connection.getResponseCode();
            this.logger.trace("responseCode={0}", new Object[]{responseCode});
            if (responseCode != 204) {
                if (!this.pathExists(workspace.getServer(), fileNode.getUrl())) {
                    String msg = RestClientI18n.unpublishNeverPublishedMsg.text(new Object[]{file.getAbsolutePath(), workspace.getName(), path});
                    Status status = new Status(Status.Severity.INFO, msg, null);
                    return status;
                }
                this.logger.error(RestClientI18n.connectionErrorMsg, new Object[]{responseCode, "unpublish"});
                String msg = RestClientI18n.unpublishFailedMsg.text(new Object[]{file.getName(), workspace.getName(), path});
                throw new RuntimeException(msg);
            }
            Status status = Status.OK_STATUS;
            return status;
        }
        catch (Exception e) {
            String msg = RestClientI18n.unpublishFailedMsg.text(new Object[]{file.getAbsolutePath(), workspace.getName(), path});
            Status status = new Status(Status.Severity.ERROR, msg, e);
            return status;
        }
        finally {
            if (connection != null) {
                this.logger.trace("unpublish: leaving", new Object[0]);
                connection.disconnect();
            }
        }
    }
}

