/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.web.jcr.rest.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.ThreadSafe;
import org.jboss.dna.graph.SecurityContext;
import org.jboss.dna.jcr.JcrConfiguration;
import org.jboss.dna.jcr.JcrEngine;
import org.jboss.dna.jcr.SecurityContextCredentials;
import org.jboss.dna.web.jcr.rest.ServletSecurityContext;
import org.jboss.dna.web.jcr.rest.spi.RepositoryProvider;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.UnauthorizedException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class DnaJcrRepositoryProvider
implements RepositoryProvider {
    public static final String CONFIG_FILE = "org.jboss.dna.web.jcr.rest.CONFIG_FILE";
    private JcrEngine jcrEngine;

    @Override
    public Set<String> getJcrRepositoryNames() {
        return new HashSet<String>(this.jcrEngine.getRepositoryNames());
    }

    private Repository getRepository(String repositoryName) throws RepositoryException {
        return this.jcrEngine.getRepository(repositoryName);
    }

    @Override
    public void startup(ServletContext context) {
        String configFile = context.getInitParameter(CONFIG_FILE);
        try {
            InputStream configFileInputStream = this.getClass().getResourceAsStream(configFile);
            this.jcrEngine = new JcrConfiguration().loadFrom(configFileInputStream).build();
            this.jcrEngine.start();
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        catch (SAXException saxe) {
            throw new IllegalStateException(saxe);
        }
    }

    @Override
    public void shutdown() {
        this.jcrEngine.shutdown();
    }

    @Override
    public Session getSession(HttpServletRequest request, String repositoryName, String workspaceName) throws RepositoryException {
        Repository repository;
        assert (request != null);
        assert (request.getUserPrincipal() != null) : "Request must be authorized";
        if (request.getUserPrincipal() == null) {
            throw new UnauthorizedException("Client is not authorized");
        }
        try {
            repository = this.getRepository(repositoryName);
        }
        catch (RepositoryException re) {
            throw new NotFoundException(re.getMessage(), (Throwable)re);
        }
        return repository.login((Credentials)new SecurityContextCredentials((SecurityContext)new ServletSecurityContext(request)), workspaceName);
    }
}

