/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration;

import java.util.Properties;

public class GlobalConfiguration {
    private final boolean generateRevisionsForCollections;
    private final boolean warnOnUnsupportedTypes;
    private final boolean unversionedOptimisticLockingField;
    private final String correlatedSubqueryOperator;

    public GlobalConfiguration(Properties properties) {
        String generateRevisionsForCollectionsStr = properties.getProperty("org.jboss.envers.revisionOnCollectionChange", "true");
        this.generateRevisionsForCollections = Boolean.parseBoolean(generateRevisionsForCollectionsStr);
        String warnOnUnsupportedTypesStr = properties.getProperty("org.jboss.envers.warnOnUnsupportedTypes", "false");
        this.warnOnUnsupportedTypes = Boolean.parseBoolean(warnOnUnsupportedTypesStr);
        String ignoreOptimisticLockingPropertyStr = properties.getProperty("org.jboss.envers.unversionedOptimisticLockingField", "false");
        this.unversionedOptimisticLockingField = Boolean.parseBoolean(ignoreOptimisticLockingPropertyStr);
        this.correlatedSubqueryOperator = "org.hibernate.dialect.HSQLDialect".equals(properties.getProperty("hibernate.dialect")) ? "in" : "=";
    }

    public boolean isGenerateRevisionsForCollections() {
        return this.generateRevisionsForCollections;
    }

    public boolean isWarnOnUnsupportedTypes() {
        return this.warnOnUnsupportedTypes;
    }

    public boolean isUnversionedOptimisticLockingField() {
        return this.unversionedOptimisticLockingField;
    }

    public String getCorrelatedSubqueryOperator() {
        return this.correlatedSubqueryOperator;
    }
}

