/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration;

import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.jboss.envers.DefaultRevisionEntity;
import org.jboss.envers.RevisionEntity;
import org.jboss.envers.RevisionListener;
import org.jboss.envers.RevisionNumber;
import org.jboss.envers.RevisionTimestamp;
import org.jboss.envers.Versioned;
import org.jboss.envers.configuration.RevisionInfoConfigurationResult;
import org.jboss.envers.configuration.metadata.MetadataTools;
import org.jboss.envers.revisioninfo.DefaultRevisionInfoGenerator;
import org.jboss.envers.revisioninfo.RevisionInfoNumberReader;
import org.jboss.envers.revisioninfo.RevisionInfoQueryCreator;
import org.jboss.envers.tools.MutableBoolean;
import org.jboss.envers.tools.reflection.YClass;
import org.jboss.envers.tools.reflection.YProperty;
import org.jboss.envers.tools.reflection.YReflectionManager;

public class RevisionInfoConfiguration {
    private String revisionInfoEntityName = "org.jboss.envers.DefaultRevisionEntity";
    private String revisionInfoIdName = "id";
    private String revisionInfoTimestampName = "timestamp";
    private String revisionInfoTimestampType = "long";
    private String revisionPropType = "integer";

    private Document generateDefaultRevisionInfoXmlMapping() {
        Document document = DocumentHelper.createDocument();
        Element class_mapping = MetadataTools.createEntity(document, null, null, null, null, null);
        class_mapping.addAttribute("name", this.revisionInfoEntityName);
        class_mapping.addAttribute("table", "_revisions_info");
        Element idProperty = MetadataTools.addNativelyGeneratedId(class_mapping, this.revisionInfoIdName, this.revisionPropType);
        MetadataTools.addColumn(idProperty, "revision_id", null);
        Element timestampProperty = MetadataTools.addProperty(class_mapping, this.revisionInfoTimestampName, this.revisionInfoTimestampType, false);
        MetadataTools.addColumn(timestampProperty, "revision_timestamp", null);
        return document;
    }

    private Element generateRevisionInfoRelationMapping() {
        Document document = DocumentHelper.createDocument();
        Element rev_rel_mapping = document.addElement("key-many-to-one");
        rev_rel_mapping.addAttribute("type", this.revisionPropType);
        rev_rel_mapping.addAttribute("class", this.revisionInfoEntityName);
        return rev_rel_mapping;
    }

    private void searchForRevisionInfoCfgInProperties(YClass clazz, YReflectionManager reflectionManager, MutableBoolean revisionNumberFound, MutableBoolean revisionTimestampFound, String accessType) {
        for (YProperty property : clazz.getDeclaredProperties(accessType)) {
            RevisionNumber revisionNumber = property.getAnnotation(RevisionNumber.class);
            RevisionTimestamp revisionTimestamp = property.getAnnotation(RevisionTimestamp.class);
            if (revisionNumber != null) {
                if (revisionNumberFound.isSet()) {
                    throw new MappingException("Only one property may be annotated with @RevisionNumber!");
                }
                YClass revisionNumberClass = property.getType();
                if (reflectionManager.equals(revisionNumberClass, Integer.class) || reflectionManager.equals(revisionNumberClass, Integer.TYPE)) {
                    this.revisionInfoIdName = property.getName();
                    revisionNumberFound.set();
                } else if (reflectionManager.equals(revisionNumberClass, Long.class) || reflectionManager.equals(revisionNumberClass, Long.TYPE)) {
                    this.revisionInfoIdName = property.getName();
                    revisionNumberFound.set();
                    this.revisionPropType = "long";
                } else {
                    throw new MappingException("The field annotated with @RevisionNumber must be of type int, Integer, long or Long");
                }
            }
            if (revisionTimestamp == null) continue;
            if (revisionTimestampFound.isSet()) {
                throw new MappingException("Only one property may be annotated with @RevisionTimestamp!");
            }
            YClass revisionTimestampClass = property.getType();
            if (reflectionManager.equals(revisionTimestampClass, Long.class) || reflectionManager.equals(revisionTimestampClass, Long.TYPE)) {
                this.revisionInfoTimestampName = property.getName();
                revisionTimestampFound.set();
                continue;
            }
            throw new MappingException("The field annotated with @RevisionTimestamp must be of type long or Long");
        }
    }

    private void searchForRevisionInfoCfg(YClass clazz, YReflectionManager reflectionManager, MutableBoolean revisionNumberFound, MutableBoolean revisionTimestampFound) {
        YClass superclazz = clazz.getSuperclass();
        if (!"java.lang.Object".equals(superclazz.getName())) {
            this.searchForRevisionInfoCfg(superclazz, reflectionManager, revisionNumberFound, revisionTimestampFound);
        }
        this.searchForRevisionInfoCfgInProperties(clazz, reflectionManager, revisionNumberFound, revisionTimestampFound, "field");
        this.searchForRevisionInfoCfgInProperties(clazz, reflectionManager, revisionNumberFound, revisionTimestampFound, "property");
    }

    public RevisionInfoConfigurationResult configure(Configuration cfg, YReflectionManager reflectionManager) {
        Iterator classes = cfg.getClassMappings();
        boolean revisionEntityFound = false;
        DefaultRevisionInfoGenerator revisionInfoGenerator = null;
        Class revisionInfoClass = null;
        while (classes.hasNext()) {
            YClass clazz;
            PersistentClass pc = (PersistentClass)classes.next();
            try {
                clazz = reflectionManager.classForName(pc.getClassName(), this.getClass());
            }
            catch (ClassNotFoundException e) {
                throw new MappingException((Throwable)e);
            }
            RevisionEntity revisionEntity = clazz.getAnnotation(RevisionEntity.class);
            if (revisionEntity == null) continue;
            if (revisionEntityFound) {
                throw new MappingException("Only one entity may be annotated with @RevisionEntity!");
            }
            if (clazz.getAnnotation(Versioned.class) != null) {
                throw new MappingException("An entity annotated with @RevisionEntity cannot be versioned!");
            }
            revisionEntityFound = true;
            MutableBoolean revisionNumberFound = new MutableBoolean();
            MutableBoolean revisionTimestampFound = new MutableBoolean();
            this.searchForRevisionInfoCfg(clazz, reflectionManager, revisionNumberFound, revisionTimestampFound);
            if (!revisionNumberFound.isSet()) {
                throw new MappingException("An entity annotated with @RevisionEntity must have a field annotated with @RevisionNumber!");
            }
            if (!revisionTimestampFound.isSet()) {
                throw new MappingException("An entity annotated with @RevisionEntity must have a field annotated with @RevisionTimestamp!");
            }
            this.revisionInfoEntityName = pc.getEntityName();
            revisionInfoClass = pc.getMappedClass();
            revisionInfoGenerator = new DefaultRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, revisionEntity.value(), this.revisionInfoTimestampName);
        }
        Document revisionInfoXmlMapping = null;
        if (revisionInfoGenerator == null) {
            revisionInfoClass = DefaultRevisionEntity.class;
            revisionInfoGenerator = new DefaultRevisionInfoGenerator(this.revisionInfoEntityName, revisionInfoClass, RevisionListener.class, this.revisionInfoTimestampName);
            revisionInfoXmlMapping = this.generateDefaultRevisionInfoXmlMapping();
        }
        return new RevisionInfoConfigurationResult(revisionInfoGenerator, revisionInfoXmlMapping, new RevisionInfoQueryCreator(this.revisionInfoEntityName, this.revisionInfoIdName, this.revisionInfoTimestampName), this.generateRevisionInfoRelationMapping(), new RevisionInfoNumberReader(revisionInfoClass, this.revisionInfoIdName), this.revisionInfoEntityName);
    }
}

