/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration;

import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.hibernate.cfg.Configuration;
import org.jboss.envers.configuration.EntitiesConfigurator;
import org.jboss.envers.configuration.GlobalConfiguration;
import org.jboss.envers.configuration.RevisionInfoConfiguration;
import org.jboss.envers.configuration.RevisionInfoConfigurationResult;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.entities.EntitiesConfigurations;
import org.jboss.envers.revisioninfo.RevisionInfoNumberReader;
import org.jboss.envers.revisioninfo.RevisionInfoQueryCreator;
import org.jboss.envers.synchronization.VersionsSyncManager;
import org.jboss.envers.tools.reflection.YReflectionManager;

public class VersionsConfiguration {
    private final GlobalConfiguration globalCfg;
    private final VersionsEntitiesConfiguration verEntCfg;
    private final VersionsSyncManager versionsSyncManager;
    private final EntitiesConfigurations entCfg;
    private final RevisionInfoQueryCreator revisionInfoQueryCreator;
    private final RevisionInfoNumberReader revisionInfoNumberReader;
    private static Map<Configuration, VersionsConfiguration> cfgs = new WeakHashMap<Configuration, VersionsConfiguration>();

    public VersionsEntitiesConfiguration getVerEntCfg() {
        return this.verEntCfg;
    }

    public VersionsSyncManager getSyncManager() {
        return this.versionsSyncManager;
    }

    public GlobalConfiguration getGlobalCfg() {
        return this.globalCfg;
    }

    public EntitiesConfigurations getEntCfg() {
        return this.entCfg;
    }

    public RevisionInfoQueryCreator getRevisionInfoQueryCreator() {
        return this.revisionInfoQueryCreator;
    }

    public RevisionInfoNumberReader getRevisionInfoNumberReader() {
        return this.revisionInfoNumberReader;
    }

    public VersionsConfiguration(Configuration cfg) {
        Properties properties = cfg.getProperties();
        YReflectionManager reflectionManager = YReflectionManager.get(cfg);
        RevisionInfoConfiguration revInfoCfg = new RevisionInfoConfiguration();
        RevisionInfoConfigurationResult revInfoCfgResult = revInfoCfg.configure(cfg, reflectionManager);
        this.verEntCfg = new VersionsEntitiesConfiguration(properties, revInfoCfgResult.getRevisionInfoEntityName());
        this.globalCfg = new GlobalConfiguration(properties);
        this.versionsSyncManager = new VersionsSyncManager(revInfoCfgResult.getRevisionInfoGenerator());
        this.revisionInfoQueryCreator = revInfoCfgResult.getRevisionInfoQueryCreator();
        this.revisionInfoNumberReader = revInfoCfgResult.getRevisionInfoNumberReader();
        this.entCfg = new EntitiesConfigurator().configure(cfg, reflectionManager, this.globalCfg, this.verEntCfg, revInfoCfgResult.getRevisionInfoXmlMapping(), revInfoCfgResult.getRevisionInfoRelationMapping());
    }

    public static synchronized VersionsConfiguration getFor(Configuration cfg) {
        VersionsConfiguration verCfg = cfgs.get(cfg);
        if (verCfg == null) {
            verCfg = new VersionsConfiguration(cfg);
            cfgs.put(cfg, verCfg);
            cfg.buildMappings();
        }
        return verCfg;
    }
}

