/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.relation;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.property.Setter;
import org.jboss.envers.RevisionType;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.mapper.PersistentCollectionChangeData;
import org.jboss.envers.entities.mapper.PropertyMapper;
import org.jboss.envers.entities.mapper.relation.CommonCollectionMapperData;
import org.jboss.envers.entities.mapper.relation.lazy.initializor.Initializor;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.tools.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionMapper<T>
implements PropertyMapper {
    protected final CommonCollectionMapperData commonCollectionMapperData;
    protected final Class<? extends T> collectionClass;
    private final Constructor<? extends T> proxyConstructor;

    protected AbstractCollectionMapper(CommonCollectionMapperData commonCollectionMapperData, Class<? extends T> collectionClass, Class<? extends T> proxyClass) {
        this.commonCollectionMapperData = commonCollectionMapperData;
        this.collectionClass = collectionClass;
        try {
            this.proxyConstructor = proxyClass.getConstructor(Initializor.class);
        }
        catch (NoSuchMethodException e) {
            throw new VersionsException(e);
        }
    }

    protected abstract Collection getNewCollectionContent(PersistentCollection var1);

    protected abstract Collection getOldCollectionContent(Serializable var1);

    protected abstract Object getElement(Object var1);

    protected abstract void mapToMapFromObject(Map<String, Object> var1, Object var2);

    private void addCollectionChanges(List<PersistentCollectionChangeData> collectionChanges, Set<Object> changed, RevisionType revisionType, Serializable id) {
        for (Object changedObj : changed) {
            HashMap<String, Object> entityData = new HashMap<String, Object>();
            HashMap<String, Object> originalId = new HashMap<String, Object>();
            entityData.put(this.commonCollectionMapperData.getVerEntCfg().getOriginalIdPropName(), originalId);
            collectionChanges.add(new PersistentCollectionChangeData(this.commonCollectionMapperData.getVersionsMiddleEntityName(), entityData, this.getElement(changedObj)));
            this.commonCollectionMapperData.getReferencingIdData().getPrefixedMapper().mapToMapFromId(originalId, id);
            this.mapToMapFromObject(originalId, changedObj);
            entityData.put(this.commonCollectionMapperData.getVerEntCfg().getRevisionTypePropName(), (Object)revisionType);
        }
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        if (!this.commonCollectionMapperData.getCollectionReferencingPropertyName().equals(referencingPropertyName)) {
            return null;
        }
        ArrayList<PersistentCollectionChangeData> collectionChanges = new ArrayList<PersistentCollectionChangeData>();
        Collection newCollection = this.getNewCollectionContent(newColl);
        Collection oldCollection = this.getOldCollectionContent(oldColl);
        HashSet<Object> added = new HashSet<Object>();
        if (newColl != null) {
            added.addAll(newCollection);
        }
        if (oldColl != null) {
            added.removeAll(oldCollection);
        }
        this.addCollectionChanges(collectionChanges, added, RevisionType.ADD, id);
        HashSet<Object> deleted = new HashSet<Object>();
        if (oldColl != null) {
            deleted.addAll(oldCollection);
        }
        if (newColl != null) {
            deleted.removeAll(newCollection);
        }
        this.addCollectionChanges(collectionChanges, deleted, RevisionType.DEL, id);
        return collectionChanges;
    }

    @Override
    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        return false;
    }

    protected abstract Initializor<T> getInitializor(VersionsConfiguration var1, VersionsReaderImplementor var2, Object var3, Number var4);

    @Override
    public void mapToEntityFromMap(VersionsConfiguration verCfg, Object obj, Map data, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.commonCollectionMapperData.getCollectionReferencingPropertyName());
        try {
            setter.set(obj, this.proxyConstructor.newInstance(this.getInitializor(verCfg, versionsReader, primaryKey, revision)), null);
        }
        catch (InstantiationException e) {
            throw new VersionsException(e);
        }
        catch (IllegalAccessException e) {
            throw new VersionsException(e);
        }
        catch (InvocationTargetException e) {
            throw new VersionsException(e);
        }
    }
}

