/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.relation.lazy.initializor;

import java.util.List;
import java.util.Map;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.mapper.relation.MiddleComponentData;
import org.jboss.envers.entities.mapper.relation.lazy.initializor.AbstractCollectionInitializor;
import org.jboss.envers.entities.mapper.relation.query.RelationQueryGenerator;
import org.jboss.envers.reader.VersionsReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCollectionInitializor
extends AbstractCollectionInitializor<Object[]> {
    private final MiddleComponentData elementComponentData;
    private final MiddleComponentData indexComponentData;

    public ArrayCollectionInitializor(VersionsConfiguration verCfg, VersionsReaderImplementor versionsReader, RelationQueryGenerator queryGenerator, Object primaryKey, Number revision, MiddleComponentData elementComponentData, MiddleComponentData indexComponentData) {
        super(verCfg, versionsReader, queryGenerator, primaryKey, revision);
        this.elementComponentData = elementComponentData;
        this.indexComponentData = indexComponentData;
    }

    @Override
    protected Object[] initializeCollection(int size) {
        return new Object[size];
    }

    @Override
    protected void addToCollection(Object[] collection, Object collectionRow) {
        Object elementData = ((List)collectionRow).get(this.elementComponentData.getComponentIndex());
        Object element = this.elementComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)elementData, null, this.revision);
        Object indexData = ((List)collectionRow).get(this.indexComponentData.getComponentIndex());
        Object indexObj = this.indexComponentData.getComponentMapper().mapToObjectFromFullMap(this.entityInstantiator, (Map)indexData, element, this.revision);
        int index = ((Number)indexObj).intValue();
        collection[index] = element;
    }
}

