/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.reader;

import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.engine.SessionImplementor;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.exception.NotVersionedException;
import org.jboss.envers.exception.RevisionDoesNotExistException;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.query.RevisionProperty;
import org.jboss.envers.query.VersionsQueryCreator;
import org.jboss.envers.query.VersionsRestrictions;
import org.jboss.envers.reader.FirstLevelCache;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.tools.ArgumentsTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionsReaderImpl
implements VersionsReaderImplementor {
    private final VersionsConfiguration verCfg;
    private final SessionImplementor sessionImplementor;
    private final Session session;
    private final FirstLevelCache firstLevelCache;

    public VersionsReaderImpl(VersionsConfiguration verCfg, Session session, SessionImplementor sessionImplementor) {
        this.verCfg = verCfg;
        this.sessionImplementor = sessionImplementor;
        this.session = session;
        this.firstLevelCache = new FirstLevelCache();
    }

    private void checkSession() {
        if (!this.session.isOpen()) {
            throw new IllegalStateException("The associated entity manager is closed!");
        }
    }

    @Override
    public SessionImplementor getSessionImplementor() {
        return this.sessionImplementor;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public FirstLevelCache getFirstLevelCache() {
        return this.firstLevelCache;
    }

    @Override
    public <T> T find(Class<T> cls, Object primaryKey, Number revision) throws IllegalArgumentException, NotVersionedException, IllegalStateException {
        Object result;
        ArgumentsTools.checkNotNull(cls, "Entity class");
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        String entityName = cls.getName();
        if (!this.verCfg.getEntCfg().isVersioned(entityName)) {
            throw new NotVersionedException(entityName, entityName + " is not versioned!");
        }
        if (this.firstLevelCache.contains(entityName, revision, primaryKey)) {
            return (T)this.firstLevelCache.get(entityName, revision, primaryKey);
        }
        try {
            result = this.createQuery().forEntitiesAtRevision(cls, revision).add(VersionsRestrictions.idEq(primaryKey)).getSingleResult();
        }
        catch (NoResultException e) {
            result = null;
        }
        catch (NonUniqueResultException e) {
            throw new VersionsException(e);
        }
        return (T)result;
    }

    @Override
    public List<Number> getRevisions(Class<?> cls, Object primaryKey) throws IllegalArgumentException, NotVersionedException, IllegalStateException {
        ArgumentsTools.checkNotNull(cls, "Entity class");
        ArgumentsTools.checkNotNull(primaryKey, "Primary key");
        this.checkSession();
        String entityName = cls.getName();
        if (!this.verCfg.getEntCfg().isVersioned(entityName)) {
            throw new NotVersionedException(entityName, entityName + " is not versioned!");
        }
        return this.createQuery().forRevisionsOfEntity(cls, false, true).addProjection(RevisionProperty.revisionNumber()).add(VersionsRestrictions.idEq(primaryKey)).getResultList();
    }

    @Override
    public Date getRevisionDate(Number revision) throws IllegalArgumentException, RevisionDoesNotExistException, IllegalStateException {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        Query query = this.verCfg.getRevisionInfoQueryCreator().getRevisionDateQuery(this.session, revision);
        try {
            Long timestamp = (Long)query.uniqueResult();
            if (timestamp == null) {
                throw new RevisionDoesNotExistException(revision);
            }
            return new Date(timestamp);
        }
        catch (NonUniqueResultException e) {
            throw new VersionsException(e);
        }
    }

    @Override
    public Number getRevisionNumberForDate(Date date) {
        ArgumentsTools.checkNotNull(date, "Date of revision");
        this.checkSession();
        Query query = this.verCfg.getRevisionInfoQueryCreator().getRevisionNumberForDateQuery(this.session, date);
        try {
            Number res = (Number)query.uniqueResult();
            if (res == null) {
                throw new RevisionDoesNotExistException(date);
            }
            return res;
        }
        catch (NonUniqueResultException e) {
            throw new VersionsException(e);
        }
    }

    @Override
    public <T> T findRevision(Class<T> revisionEntityClass, Number revision) throws IllegalArgumentException, RevisionDoesNotExistException, IllegalStateException {
        ArgumentsTools.checkNotNull(revision, "Entity revision");
        ArgumentsTools.checkPositive(revision, "Entity revision");
        this.checkSession();
        Query query = this.verCfg.getRevisionInfoQueryCreator().getRevisionQuery(this.session, revision);
        try {
            Object revisionData = query.uniqueResult();
            if (revisionData == null) {
                throw new RevisionDoesNotExistException(revision);
            }
            return (T)revisionData;
        }
        catch (NonUniqueResultException e) {
            throw new VersionsException(e);
        }
    }

    @Override
    public VersionsQueryCreator createQuery() {
        return new VersionsQueryCreator(this.verCfg, this);
    }
}

