/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.synchronization.work;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.collection.PersistentCollection;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.entities.mapper.PersistentCollectionChangeData;
import org.jboss.envers.synchronization.work.AbstractVersionsWorkUnit;
import org.jboss.envers.synchronization.work.AddWorkUnit;
import org.jboss.envers.synchronization.work.CollectionChangeWorkUnit;
import org.jboss.envers.synchronization.work.DelWorkUnit;
import org.jboss.envers.synchronization.work.KeepCheckResult;
import org.jboss.envers.synchronization.work.KeepCheckVisitor;
import org.jboss.envers.synchronization.work.ModWorkUnit;
import org.jboss.envers.synchronization.work.VersionsWorkUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentCollectionChangeWorkUnit
extends AbstractVersionsWorkUnit
implements VersionsWorkUnit {
    private final List<PersistentCollectionChangeData> collectionChanges;
    private final String referencingPropertyName;

    public PersistentCollectionChangeWorkUnit(String entityName, VersionsConfiguration verCfg, PersistentCollection collection, String role, Serializable snapshot, Serializable id) {
        super(entityName, verCfg, null);
        this.referencingPropertyName = role.substring(entityName.length() + 1);
        this.collectionChanges = verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().mapCollectionChanges(this.referencingPropertyName, collection, snapshot, id);
    }

    @Override
    public boolean containsWork() {
        return this.collectionChanges != null && this.collectionChanges.size() != 0;
    }

    @Override
    public void perform(Session session, Object revisionData) {
        VersionsEntitiesConfiguration entitiesCfg = this.verCfg.getVerEntCfg();
        for (PersistentCollectionChangeData persistentCollectionChangeData : this.collectionChanges) {
            ((Map)persistentCollectionChangeData.getData().get(entitiesCfg.getOriginalIdPropName())).put(entitiesCfg.getRevisionPropName(), revisionData);
            session.save(persistentCollectionChangeData.getEntityName(), persistentCollectionChangeData.getData());
        }
    }

    public String getReferencingPropertyName() {
        return this.referencingPropertyName;
    }

    public List<PersistentCollectionChangeData> getCollectionChanges() {
        return this.collectionChanges;
    }

    @Override
    public KeepCheckResult check(AddWorkUnit second) {
        return null;
    }

    @Override
    public KeepCheckResult check(ModWorkUnit second) {
        return null;
    }

    @Override
    public KeepCheckResult check(DelWorkUnit second) {
        return null;
    }

    @Override
    public KeepCheckResult check(CollectionChangeWorkUnit second) {
        return null;
    }

    @Override
    public KeepCheckResult dispatch(KeepCheckVisitor first) {
        return null;
    }
}

