/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addons;

import java.util.Arrays;
import java.util.HashSet;
import javax.inject.Inject;
import org.jboss.forge.addons.facets.ForgeAddonAPIFacet;
import org.jboss.forge.addons.facets.ForgeAddonFacet;
import org.jboss.forge.addons.facets.ForgeAddonImplFacet;
import org.jboss.forge.addons.facets.ForgeAddonSPIFacet;
import org.jboss.forge.addons.facets.ForgeAddonTestFacet;
import org.jboss.forge.addons.facets.ForgeSimpleAddonFacet;
import org.jboss.forge.container.addons.AddonId;
import org.jboss.forge.container.versions.Version;
import org.jboss.forge.dependencies.Dependency;
import org.jboss.forge.dependencies.builder.DependencyBuilder;
import org.jboss.forge.facets.FacetFactory;
import org.jboss.forge.facets.Faceted;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.ProjectFacet;
import org.jboss.forge.projects.ProjectFactory;
import org.jboss.forge.projects.dependencies.DependencyInstaller;
import org.jboss.forge.projects.facets.MetadataFacet;
import org.jboss.forge.projects.facets.PackagingFacet;
import org.jboss.forge.resource.DirectoryResource;

class AddonProjectFactory {
    @Inject
    private FacetFactory facetFactory;
    @Inject
    private ProjectFactory projectFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    AddonProjectFactory() {
    }

    public Project createSimpleAddonProject(Project project, Version forgeVersion, Iterable<AddonId> dependencyAddons) {
        this.configureAddonProject(project);
        this.installSelectedAddons(project, dependencyAddons, false);
        return project;
    }

    public Project createAddonProject(Project project, Version forgeVersion, Iterable<AddonId> dependencyAddons) {
        ((PackagingFacet)project.getFacet(PackagingFacet.class)).setPackagingType("pom");
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        metadata.setProjectName(metadata.getProjectName() + "-parent");
        project.getProjectRoot().getChild("src").delete(true);
        this.installSelectedAddons(project, dependencyAddons, true);
        this.createSubmoduleProject(project, "addon", ForgeAddonFacet.class);
        this.createSubmoduleProject(project, "api", ForgeAddonAPIFacet.class);
        this.createSubmoduleProject(project, "impl", ForgeAddonImplFacet.class);
        this.createSubmoduleProject(project, "spi", ForgeAddonSPIFacet.class);
        this.createSubmoduleProject(project, "tests", ForgeAddonTestFacet.class);
        return project;
    }

    private void configureAddonProject(Project project) {
        project.install(this.facetFactory.create(ForgeAddonFacet.class, (Faceted)project));
    }

    private void installSelectedAddons(Project project, Iterable<AddonId> addons, boolean managed) {
        for (AddonId addon : addons) {
            String[] mavenCoords = addon.getName().split(":");
            DependencyBuilder dependency = DependencyBuilder.create().setGroupId(mavenCoords[0]).setArtifactId(mavenCoords[1]).setVersion(addon.getVersion().getVersionString()).setClassifier("forge-addon");
            if (managed) {
                this.dependencyInstaller.installManaged(project, (Dependency)dependency);
                continue;
            }
            this.dependencyInstaller.install(project, (Dependency)dependency);
        }
    }

    private Project createSubmoduleProject(Project parent, String moduleName, Class<? extends ProjectFacet> ... requiredProjectFacets) {
        DirectoryResource location = parent.getProjectRoot().getOrCreateChildDirectory(moduleName);
        HashSet<Class<Object>> facets = new HashSet<Class<Object>>();
        facets.addAll(Arrays.asList(requiredProjectFacets));
        facets.add(ForgeSimpleAddonFacet.class);
        Project project = this.projectFactory.createProject(location, facets);
        MetadataFacet metadata = (MetadataFacet)project.getFacet(MetadataFacet.class);
        MetadataFacet metadataParent = (MetadataFacet)parent.getFacet(MetadataFacet.class);
        metadata.setProjectName(metadataParent.getProjectName().replace("-parent", "") + "-" + moduleName);
        return project;
    }
}

