/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.addons;

import java.util.ArrayList;
import java.util.HashSet;
import javax.inject.Inject;
import org.jboss.forge.addons.AddonProjectFactory;
import org.jboss.forge.container.Forge;
import org.jboss.forge.container.addons.AddonId;
import org.jboss.forge.container.repositories.AddonRepository;
import org.jboss.forge.container.versions.SingleVersion;
import org.jboss.forge.container.versions.Version;
import org.jboss.forge.dependencies.Coordinate;
import org.jboss.forge.dependencies.DependencyQuery;
import org.jboss.forge.dependencies.DependencyResolver;
import org.jboss.forge.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.dependencies.builder.DependencyQueryBuilder;
import org.jboss.forge.projects.Project;
import org.jboss.forge.ui.context.UIBuilder;
import org.jboss.forge.ui.context.UIContext;
import org.jboss.forge.ui.context.UIValidationContext;
import org.jboss.forge.ui.input.UIInput;
import org.jboss.forge.ui.input.UISelectMany;
import org.jboss.forge.ui.input.UISelectOne;
import org.jboss.forge.ui.metadata.UICommandMetadata;
import org.jboss.forge.ui.metadata.WithAttributes;
import org.jboss.forge.ui.result.NavigationResult;
import org.jboss.forge.ui.result.Result;
import org.jboss.forge.ui.result.Results;
import org.jboss.forge.ui.util.Categories;
import org.jboss.forge.ui.util.Metadata;
import org.jboss.forge.ui.wizard.UIWizardStep;

public class ForgeAddonSetupStep
implements UIWizardStep {
    @Inject
    @WithAttributes(label="Create API,Implementation,Tests and Addon modules")
    private UIInput<Boolean> splitProjects;
    @Inject
    @WithAttributes(label="Forge Version:", required=true)
    private UISelectOne<Version> forgeVersion;
    @Inject
    @WithAttributes(label="Depend on these addons:")
    private UISelectMany<AddonId> addons;
    @Inject
    private DependencyResolver dependencyResolver;
    @Inject
    private Forge forge;
    @Inject
    private AddonProjectFactory addonProjectFactory;

    public UICommandMetadata getMetadata() {
        return Metadata.forCommand(this.getClass()).name("Forge Addon Setup").description("Enable Forge Addon development in your project.").category(Categories.create((String[])new String[]{"Project", "Forge"}));
    }

    public boolean isEnabled(UIContext context) {
        return true;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        this.configureVersions();
        this.configureSplitProjects();
        this.configureAddonDependencies();
        builder.add(this.forgeVersion).add(this.splitProjects).add(this.addons);
    }

    private void configureSplitProjects() {
        this.splitProjects.setDefaultValue((Object)Boolean.FALSE);
    }

    private void configureAddonDependencies() {
        HashSet<AddonId> choices = new HashSet<AddonId>();
        for (AddonRepository repository : this.forge.getRepositories()) {
            for (AddonId id : repository.listEnabled()) {
                choices.add(id);
            }
        }
        this.addons.setValueChoices(choices);
    }

    private void configureVersions() {
        CoordinateBuilder c = CoordinateBuilder.create().setGroupId("org.jboss.forge").setArtifactId("forge-addon-container");
        ArrayList<SingleVersion> versions = new ArrayList<SingleVersion>();
        for (Coordinate versionCoord : this.dependencyResolver.resolveVersions((DependencyQuery)DependencyQueryBuilder.create((Coordinate)c))) {
            versions.add(new SingleVersion(versionCoord.getVersion()));
        }
        this.forgeVersion.setValueChoices(versions);
        this.forgeVersion.setDefaultValue((Object)this.forge.getVersion());
    }

    public void validate(UIValidationContext validator) {
    }

    public Result execute(UIContext context) throws Exception {
        Project project = (Project)context.getAttribute(Project.class);
        Iterable dependencyAddons = this.addons.getValue();
        if (((Boolean)this.splitProjects.getValue()).booleanValue()) {
            this.addonProjectFactory.createAddonProject(project, (Version)this.forgeVersion.getValue(), dependencyAddons);
        } else {
            this.addonProjectFactory.createSimpleAddonProject(project, (Version)this.forgeVersion.getValue(), dependencyAddons);
        }
        return Results.success();
    }

    public NavigationResult next(UIContext context) throws Exception {
        return null;
    }
}

