/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.aesh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.inject.Singleton;
import org.jboss.aesh.console.settings.Settings;
import org.jboss.aesh.edit.KeyOperation;
import org.jboss.aesh.edit.actions.Operation;
import org.jboss.aesh.terminal.Key;
import org.jboss.aesh.terminal.Terminal;
import org.jboss.aesh.terminal.TestTerminal;
import org.jboss.forge.aesh.spi.ShellConfiguration;

@Singleton
public class TestShellConfiguration
implements ShellConfiguration {
    private PipedOutputStream stdin = new PipedOutputStream();
    private ByteArrayOutputStream stdout = new ByteArrayOutputStream();
    private ByteArrayOutputStream stderr = new ByteArrayOutputStream();

    public synchronized void configure() {
        try {
            this.reset();
            Settings.getInstance().setInputStream((InputStream)new PipedInputStream(this.stdin));
            Settings.getInstance().setStdOut((OutputStream)this.stdout);
            Settings.getInstance().setStdErr((OutputStream)this.stderr);
            Settings.getInstance().setName("test");
            Settings.getInstance().setTerminal((Terminal)new TestTerminal());
            Settings.getInstance().getOperationManager().addOperation(new KeyOperation(Key.ENTER, Operation.NEW_LINE));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not configure Shell.", e);
        }
    }

    private void reset() {
        this.stdin = new PipedOutputStream();
        this.stdout = new ByteArrayOutputStream();
        this.stderr = new ByteArrayOutputStream();
    }

    public synchronized OutputStream getStdIn() {
        return this.stdin;
    }

    public synchronized ByteArrayOutputStream getStdOut() {
        return this.stdout;
    }

    public synchronized ByteArrayOutputStream getStdErr() {
        return this.stderr;
    }
}

