/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.spi.JavaParserProvider;

public final class JavaParser {
    public static ServiceLoader<JavaParserProvider> loader = ServiceLoader.load(JavaParserProvider.class);
    private static List<JavaParserProvider> parsers;

    private static JavaParserProvider getParser() {
        if (parsers == null) {
            parsers = new ArrayList<JavaParserProvider>();
            for (JavaParserProvider p : loader) {
                parsers.add(p);
            }
        }
        if (parsers.size() == 0) {
            throw new IllegalStateException("No instances of [" + JavaParserProvider.class.getName() + "] were found on the classpath.");
        }
        return parsers.get(0);
    }

    public static JavaSource<?> parse(File file) throws FileNotFoundException {
        return JavaParser.getParser().parse(file);
    }

    public static JavaSource<?> parse(URL data) throws IOException {
        return JavaParser.getParser().parse(data);
    }

    public static JavaSource<?> parse(InputStream data) {
        return JavaParser.getParser().parse(data);
    }

    public static JavaSource<?> parse(char[] data) {
        return JavaParser.getParser().parse(data);
    }

    public static JavaSource<?> parse(String data) {
        return JavaParser.getParser().parse(data);
    }

    public static <T extends JavaSource<?>> T create(Class<T> type) {
        return JavaParser.getParser().create(type);
    }

    public static <T extends JavaSource<?>> T parse(Class<T> type, URL url) throws IOException {
        return JavaParser.getParser().parse(type, url);
    }

    public static <T extends JavaSource<?>> T parse(Class<T> type, File file) throws FileNotFoundException {
        return JavaParser.getParser().parse(type, file);
    }

    public static <T extends JavaSource<?>> T parse(Class<T> type, InputStream data) {
        return JavaParser.getParser().parse(type, data);
    }

    public static <T extends JavaSource<?>> T parse(Class<T> type, char[] data) {
        return JavaParser.getParser().parse(type, data);
    }

    public static <T extends JavaSource<?>> T parse(Class<T> type, String data) {
        return JavaParser.getParser().parse(type, data);
    }
}

