/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.jboss.forge.parser.java.Import;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.util.Types;

public class ImportImpl
implements Import {
    private AST ast = null;
    private CompilationUnit cu = null;
    private ImportDeclaration imprt = null;

    private void init(JavaSource<?> parent) {
        this.cu = (CompilationUnit)parent.getInternal();
        this.ast = this.cu.getAST();
    }

    public ImportImpl(JavaSource<?> parent) {
        this.init(parent);
        this.imprt = this.ast.newImportDeclaration();
    }

    public ImportImpl(JavaSource<?> parent, Object internal) {
        this.init(parent);
        this.imprt = (ImportDeclaration)internal;
    }

    public String getSimpleName() {
        return Types.toSimpleName((String)this.imprt.getName().getFullyQualifiedName());
    }

    public String getQualifiedName() {
        return this.imprt.getName().getFullyQualifiedName();
    }

    public Import setName(String name) {
        if (name.endsWith(".*")) {
            this.imprt.setName(this.ast.newName(Types.tokenizeClassName((String)name.replaceAll("\\.\\*", ""))));
            this.imprt.setOnDemand(true);
        } else {
            this.imprt.setName(this.ast.newName(Types.tokenizeClassName((String)name)));
        }
        return this;
    }

    public boolean isStatic() {
        return this.imprt.isStatic();
    }

    public Import setStatic(boolean value) {
        this.imprt.setStatic(value);
        return this;
    }

    public boolean isWildcard() {
        return this.imprt.isOnDemand();
    }

    public Object getInternal() {
        return this.imprt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.imprt == null ? 0 : this.imprt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportImpl other = (ImportImpl)obj;
        return !(this.imprt == null ? other.imprt != null : !this.imprt.equals((Object)other.imprt));
    }

    public String toString() {
        return "Import [" + this.getQualifiedName() + "]";
    }

    public String getPackage() {
        return Types.getPackage((String)this.getQualifiedName());
    }
}

