/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.Document;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.EnumConstant;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.Import;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaEnum;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.parser.java.SourceType;
import org.jboss.forge.parser.java.SyntaxError;
import org.jboss.forge.parser.java.Visibility;
import org.jboss.forge.parser.java.ast.MethodFinderVisitor;
import org.jboss.forge.parser.java.ast.TypeDeclarationFinderVisitor;
import org.jboss.forge.parser.java.impl.FieldImpl;
import org.jboss.forge.parser.java.impl.JavaEnumImpl;
import org.jboss.forge.parser.java.impl.MethodImpl;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;
import org.jboss.forge.parser.spi.JavaParserImpl;

class EnumConstantBodyImpl
implements EnumConstant.Body {
    private final JavaEnum javaEnum;
    private final EnumConstant<?> enumConstant;

    EnumConstantBodyImpl(JavaEnum javaEnum, EnumConstant<?> enumConstant) {
        this.javaEnum = javaEnum;
        this.enumConstant = enumConstant;
        this.getBody();
    }

    public String getCanonicalName() {
        return this.javaEnum.getCanonicalName() + "." + this.enumConstant.getName();
    }

    public String getQualifiedName() {
        return this.javaEnum.getQualifiedName() + "." + this.enumConstant.getName();
    }

    public List<SyntaxError> getSyntaxErrors() {
        return this.javaEnum.getSyntaxErrors();
    }

    public boolean hasSyntaxErrors() {
        return this.javaEnum.hasSyntaxErrors();
    }

    public boolean isClass() {
        return true;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isAnnotation() {
        return false;
    }

    public JavaSource<?> getEnclosingType() {
        return this.javaEnum;
    }

    public List<JavaSource<?>> getNestedClasses() {
        JavaEnumImpl parentImpl = (JavaEnumImpl)this.javaEnum;
        Document document = parentImpl.document;
        CompilationUnit unit = parentImpl.unit;
        ArrayList result = new ArrayList();
        List bodyDeclarations = this.getBody().bodyDeclarations();
        for (BodyDeclaration body : bodyDeclarations) {
            List<AbstractTypeDeclaration> declarations = this.getNestedDeclarations(body);
            for (AbstractTypeDeclaration declaration : declarations) {
                result.add(JavaParserImpl.getJavaSource(this, document, unit, (ASTNode)declaration));
            }
        }
        return result;
    }

    public SourceType getSourceType() {
        return SourceType.CLASS;
    }

    public String getPackage() {
        return this.javaEnum.getPackage();
    }

    public EnumConstant.Body setPackage(String name) {
        throw new UnsupportedOperationException();
    }

    public EnumConstant.Body setDefaultPackage() {
        throw new UnsupportedOperationException();
    }

    public boolean isDefaultPackage() {
        return this.javaEnum.isDefaultPackage();
    }

    public Import addImport(String className) {
        return this.javaEnum.addImport(className);
    }

    public Import addImport(Class<?> type) {
        return this.javaEnum.addImport(type);
    }

    public Import addImport(Import imprt) {
        return this.javaEnum.addImport(imprt);
    }

    public <T extends JavaSource<?>> Import addImport(T type) {
        return this.javaEnum.addImport(type);
    }

    public boolean hasImport(Class<?> type) {
        return this.javaEnum.hasImport(type);
    }

    public boolean hasImport(String type) {
        return this.javaEnum.hasImport(type);
    }

    public boolean requiresImport(Class<?> type) {
        return this.javaEnum.requiresImport(type);
    }

    public boolean requiresImport(String type) {
        return this.javaEnum.requiresImport(type);
    }

    public <T extends JavaSource<T>> boolean hasImport(T type) {
        return this.javaEnum.hasImport(type);
    }

    public boolean hasImport(Import imprt) {
        return this.javaEnum.hasImport(imprt);
    }

    public Import getImport(String literalValue) {
        return this.javaEnum.getImport(literalValue);
    }

    public Import getImport(Class<?> type) {
        return this.javaEnum.getImport(type);
    }

    public <T extends JavaSource<?>> Import getImport(T type) {
        return this.javaEnum.getImport(type);
    }

    public Import getImport(Import imprt) {
        return this.javaEnum.getImport(imprt);
    }

    public EnumConstant.Body removeImport(String name) {
        this.javaEnum.removeImport(name);
        return this;
    }

    public EnumConstant.Body removeImport(Class<?> type) {
        this.javaEnum.removeImport(type);
        return this;
    }

    public <T extends JavaSource<?>> EnumConstant.Body removeImport(T type) {
        this.javaEnum.removeImport(type);
        return this;
    }

    public EnumConstant.Body removeImport(Import imprt) {
        this.javaEnum.removeImport(imprt);
        return this;
    }

    public List<Import> getImports() {
        return this.javaEnum.getImports();
    }

    public String resolveType(String type) {
        return this.javaEnum.resolveType(type);
    }

    public String getName() {
        return this.enumConstant.getName();
    }

    public EnumConstant.Body setName(String name) {
        this.enumConstant.setName(name);
        return this;
    }

    public boolean isPackagePrivate() {
        return false;
    }

    public EnumConstant.Body setPackagePrivate() {
        return this;
    }

    public boolean isPublic() {
        return false;
    }

    public EnumConstant.Body setPublic() {
        return this;
    }

    public boolean isPrivate() {
        return true;
    }

    public EnumConstant.Body setPrivate() {
        return this;
    }

    public boolean isProtected() {
        return false;
    }

    public EnumConstant.Body setProtected() {
        return this;
    }

    public Visibility getVisibility() {
        return Visibility.PRIVATE;
    }

    public EnumConstant.Body setVisibility(Visibility scope) {
        return this;
    }

    public Annotation<EnumConstant.Body> addAnnotation() {
        throw new UnsupportedOperationException();
    }

    public Annotation<EnumConstant.Body> addAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        throw new UnsupportedOperationException();
    }

    public Annotation<EnumConstant.Body> addAnnotation(String className) {
        throw new UnsupportedOperationException();
    }

    public List<Annotation<EnumConstant.Body>> getAnnotations() {
        return Collections.emptyList();
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return false;
    }

    public boolean hasAnnotation(String type) {
        return false;
    }

    public Annotation<EnumConstant.Body> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return null;
    }

    public Annotation<EnumConstant.Body> getAnnotation(String type) {
        return null;
    }

    public EnumConstant.Body removeAnnotation(Annotation<EnumConstant.Body> annotation) {
        return this;
    }

    public Object getInternal() {
        return this.javaEnum.getInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AnonymousClassDeclaration getBody() {
        EnumConstantDeclaration enumConstantDeclaration;
        EnumConstantDeclaration enumConstantDeclaration2 = enumConstantDeclaration = (EnumConstantDeclaration)this.enumConstant.getInternal();
        synchronized (enumConstantDeclaration2) {
            AnonymousClassDeclaration result = enumConstantDeclaration.getAnonymousClassDeclaration();
            if (result == null) {
                String stub = "enum StubEnum { FOO() {}; }";
                JavaEnum temp = (JavaEnum)JavaParser.parse(JavaEnum.class, (String)"enum StubEnum { FOO() {}; }");
                AnonymousClassDeclaration body = ((EnumConstantBodyImpl)((EnumConstant)temp.getEnumConstants().get(0)).getBody()).getBody();
                AST ast = ((ASTNode)this.javaEnum.getInternal()).getAST();
                result = (AnonymousClassDeclaration)ASTNode.copySubtree((AST)ast, (ASTNode)body);
                enumConstantDeclaration.setAnonymousClassDeclaration(result);
            }
            return result;
        }
    }

    public EnumConstant.Body getOrigin() {
        return this;
    }

    public List<Member<EnumConstant.Body, ?>> getMembers() {
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(this.getFields());
        result.addAll(this.getMethods());
        return Collections.unmodifiableList(result);
    }

    public Field<EnumConstant.Body> addField() {
        FieldImpl<EnumConstant.Body> field = new FieldImpl<EnumConstant.Body>(this);
        this.addField(field);
        return field;
    }

    public Field<EnumConstant.Body> addField(String declaration) {
        String stub = "public class Stub { " + declaration + " }";
        JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
        List fields = temp.getFields();
        FieldImpl<EnumConstant.Body> result = null;
        for (Field stubField : fields) {
            Object variableDeclaration = stubField.getInternal();
            FieldImpl<EnumConstant.Body> field = new FieldImpl<EnumConstant.Body>(this, variableDeclaration, true);
            this.addField(field);
            if (result != null) continue;
            result = field;
        }
        return result;
    }

    private void addField(Field<EnumConstant.Body> field) {
        BodyDeclaration bodyDeclaration;
        List bodyDeclarations = this.getBody().bodyDeclarations();
        int idx = 0;
        Iterator i$ = bodyDeclarations.iterator();
        while (i$.hasNext() && (bodyDeclaration = (BodyDeclaration)i$.next()) instanceof FieldDeclaration) {
            ++idx;
        }
        bodyDeclarations.add(idx, (BodyDeclaration)((VariableDeclarationFragment)field.getInternal()).getParent());
    }

    public List<Field<EnumConstant.Body>> getFields() {
        ArrayList<FieldImpl<EnumConstantBodyImpl>> result = new ArrayList<FieldImpl<EnumConstantBodyImpl>>();
        List bodyDeclarations = this.getBody().bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (!(bodyDeclaration instanceof FieldDeclaration)) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
            List fragments = fieldDeclaration.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                result.add(new FieldImpl<EnumConstantBodyImpl>(this, fragment));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public Field<EnumConstant.Body> getField(String name) {
        for (Field<EnumConstant.Body> field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public boolean hasField(String name) {
        for (Field<EnumConstant.Body> field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasField(Field<EnumConstant.Body> field) {
        return this.getFields().contains(field);
    }

    public EnumConstant.Body removeField(Field<EnumConstant.Body> field) {
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.getInternal();
        Iterator declarationsIterator = this.getBody().bodyDeclarations().iterator();
        while (declarationsIterator.hasNext()) {
            List fragments;
            FieldDeclaration declaration;
            Object next = declarationsIterator.next();
            if (!(next instanceof FieldDeclaration) || !(declaration = (FieldDeclaration)next).equals((Object)fragment.getParent()) || !(fragments = declaration.fragments()).contains(fragment)) continue;
            if (fragments.size() == 1) {
                declarationsIterator.remove();
                break;
            }
            fragments.remove(fragment);
            break;
        }
        return this;
    }

    public boolean hasMethod(Method<EnumConstant.Body> method) {
        return this.getMethods().contains(method);
    }

    public boolean hasMethodSignature(String name) {
        return this.hasMethodSignature(name, new String[0]);
    }

    public boolean hasMethodSignature(String name, String ... paramTypes) {
        return this.getMethod(name, paramTypes) != null;
    }

    public boolean hasMethodSignature(String name, Class<?> ... paramTypes) {
        String[] types = new String[paramTypes == null ? 0 : paramTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = paramTypes[i].getName();
        }
        return this.hasMethodSignature(name, types);
    }

    public Method<EnumConstant.Body> getMethod(String name) {
        for (Method<EnumConstant.Body> method : this.getMethods()) {
            if (!method.getName().equals(name) || !method.getParameters().isEmpty()) continue;
            return method;
        }
        return null;
    }

    public Method<EnumConstant.Body> getMethod(String name, String ... paramTypes) {
        for (Method<EnumConstant.Body> local : this.getMethods()) {
            if (!local.getName().equals(name)) continue;
            List localParams = local.getParameters();
            if (paramTypes == null || !localParams.isEmpty() && localParams.size() != paramTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < localParams.size(); ++i) {
                if (Types.areEquivalent((String)((Parameter)localParams.get(i)).getType(), (String)paramTypes[i])) continue;
                matches = false;
            }
            if (!matches) continue;
            return local;
        }
        return null;
    }

    public Method<EnumConstant.Body> getMethod(String name, Class<?> ... paramTypes) {
        String[] types = new String[paramTypes == null ? 0 : paramTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = paramTypes[i].getName();
        }
        return this.getMethod(name, types);
    }

    public boolean hasMethodSignature(Method<?> method) {
        for (Method<EnumConstant.Body> local : this.getMethods()) {
            if (!local.getName().equals(method.getName())) continue;
            Iterator localParams = local.getParameters().iterator();
            for (Parameter methodParam : method.getParameters()) {
                if (localParams.hasNext() && Strings.areEqual((String)((Parameter)localParams.next()).getType(), (String)methodParam.getType())) continue;
                return false;
            }
            return !localParams.hasNext();
        }
        return false;
    }

    public EnumConstant.Body removeMethod(Method<EnumConstant.Body> method) {
        this.getBody().bodyDeclarations().remove(method.getInternal());
        return this;
    }

    public Method<EnumConstant.Body> addMethod() {
        MethodImpl<EnumConstant.Body> m = new MethodImpl<EnumConstant.Body>(this);
        this.getBody().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public Method<EnumConstant.Body> addMethod(String method) {
        MethodImpl<EnumConstant.Body> m = new MethodImpl<EnumConstant.Body>(this, method);
        this.getBody().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public List<Method<EnumConstant.Body>> getMethods() {
        ArrayList<MethodImpl<EnumConstantBodyImpl>> result = new ArrayList<MethodImpl<EnumConstantBodyImpl>>();
        MethodFinderVisitor methodFinderVisitor = new MethodFinderVisitor();
        this.getBody().accept((ASTVisitor)methodFinderVisitor);
        for (MethodDeclaration methodDeclaration : methodFinderVisitor.getMethods()) {
            result.add(new MethodImpl<EnumConstantBodyImpl>(this, methodDeclaration));
        }
        return Collections.unmodifiableList(result);
    }

    private List<AbstractTypeDeclaration> getNestedDeclarations(BodyDeclaration body) {
        TypeDeclarationFinderVisitor typeDeclarationFinder = new TypeDeclarationFinderVisitor();
        body.accept((ASTVisitor)typeDeclarationFinder);
        List<AbstractTypeDeclaration> declarations = typeDeclarationFinder.getTypeDeclarations();
        ArrayList<AbstractTypeDeclaration> result = new ArrayList<AbstractTypeDeclaration>(declarations);
        if (!declarations.isEmpty()) {
            AbstractTypeDeclaration first = declarations.remove(0);
            result.remove(first);
            for (AbstractTypeDeclaration declaration : declarations) {
                result.removeAll(this.getNestedDeclarations((BodyDeclaration)declaration));
            }
        }
        return result;
    }
}

