/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.Document;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaInterface;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.parser.java.ast.MethodFinderVisitor;
import org.jboss.forge.parser.java.impl.AbstractJavaSource;
import org.jboss.forge.parser.java.impl.FieldImpl;
import org.jboss.forge.parser.java.impl.JDTHelper;
import org.jboss.forge.parser.java.impl.JavaInterfaceImpl;
import org.jboss.forge.parser.java.impl.MethodImpl;
import org.jboss.forge.parser.java.source.FieldHolderSource;
import org.jboss.forge.parser.java.source.FieldSource;
import org.jboss.forge.parser.java.source.Import;
import org.jboss.forge.parser.java.source.InterfaceCapableSource;
import org.jboss.forge.parser.java.source.JavaClassSource;
import org.jboss.forge.parser.java.source.JavaSource;
import org.jboss.forge.parser.java.source.MemberSource;
import org.jboss.forge.parser.java.source.MethodHolderSource;
import org.jboss.forge.parser.java.source.MethodSource;
import org.jboss.forge.parser.java.source.ParameterSource;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;

public abstract class AbstractJavaSourceMemberHolder<O extends JavaSource<O>>
extends AbstractJavaSource<O>
implements InterfaceCapableSource<O>,
MethodHolderSource<O>,
FieldHolderSource<O> {
    protected AbstractJavaSourceMemberHolder(JavaSource<?> enclosingType, Document document, CompilationUnit unit, BodyDeclaration declaration) {
        super(enclosingType, document, unit, declaration);
    }

    public FieldSource<O> addField() {
        FieldImpl<AbstractJavaSourceMemberHolder> field = new FieldImpl<AbstractJavaSourceMemberHolder>(this);
        this.addField((Field<O>)field);
        return field;
    }

    public FieldSource<O> addField(String declaration) {
        String stub = "public class Stub { " + declaration + " }";
        JavaClassSource temp = (JavaClassSource)JavaParser.parse((String)stub);
        List fields = temp.getFields();
        FieldImpl<AbstractJavaSourceMemberHolder> result = null;
        for (FieldSource stubField : fields) {
            Object variableDeclaration = stubField.getInternal();
            FieldImpl<AbstractJavaSourceMemberHolder> field = new FieldImpl<AbstractJavaSourceMemberHolder>(this, variableDeclaration, true);
            this.addField((Field<O>)field);
            if (result != null) continue;
            result = field;
        }
        return result;
    }

    private void addField(Field<O> field) {
        List bodyDeclarations = this.getBodyDeclaration().bodyDeclarations();
        int idx = 0;
        for (Object object : bodyDeclarations) {
            if (!(object instanceof FieldDeclaration)) break;
            ++idx;
        }
        bodyDeclarations.add(idx, ((VariableDeclarationFragment)field.getInternal()).getParent());
    }

    public List<MemberSource<O, ?>> getMembers() {
        ArrayList result = new ArrayList();
        result.addAll(this.getFields());
        result.addAll(this.getMethods());
        return result;
    }

    public List<FieldSource<O>> getFields() {
        ArrayList<FieldImpl<AbstractJavaSourceMemberHolder>> result = new ArrayList<FieldImpl<AbstractJavaSourceMemberHolder>>();
        List bodyDeclarations = this.getBodyDeclaration().bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (!(bodyDeclaration instanceof FieldDeclaration)) continue;
            FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
            List fragments = fieldDeclaration.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                result.add(new FieldImpl<AbstractJavaSourceMemberHolder>(this, fragment));
            }
        }
        return Collections.unmodifiableList(result);
    }

    public FieldSource<O> getField(String name) {
        for (FieldSource<O> field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public boolean hasField(String name) {
        for (FieldSource<O> field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasField(Field<O> field) {
        return this.getFields().contains(field);
    }

    public O removeField(Field<O> field) {
        VariableDeclarationFragment fragment = (VariableDeclarationFragment)field.getInternal();
        Iterator declarationsIterator = this.getBodyDeclaration().bodyDeclarations().iterator();
        while (declarationsIterator.hasNext()) {
            List fragments;
            FieldDeclaration declaration;
            Object next = declarationsIterator.next();
            if (!(next instanceof FieldDeclaration) || !(declaration = (FieldDeclaration)next).equals((Object)fragment.getParent()) || !(fragments = declaration.fragments()).contains(fragment)) continue;
            if (fragments.size() == 1) {
                declarationsIterator.remove();
                break;
            }
            fragments.remove(fragment);
            break;
        }
        return (O)this;
    }

    public boolean hasMethod(Method<O, ?> method) {
        return this.getMethods().contains(method);
    }

    public boolean hasMethodSignature(String name) {
        return this.hasMethodSignature(name, new String[0]);
    }

    public boolean hasMethodSignature(String name, String ... paramTypes) {
        return this.getMethod(name, paramTypes) != null;
    }

    public boolean hasMethodSignature(String name, Class<?> ... paramTypes) {
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        String[] types = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            types[i] = paramTypes[i].getName();
        }
        return this.hasMethodSignature(name, types);
    }

    public MethodSource<O> getMethod(String name) {
        for (MethodSource<O> method : this.getMethods()) {
            if (!method.getName().equals(name) || method.getParameters().size() != 0) continue;
            return method;
        }
        return null;
    }

    public MethodSource<O> getMethod(String name, String ... paramTypes) {
        for (MethodSource<O> local : this.getMethods()) {
            if (!local.getName().equals(name)) continue;
            List localParams = local.getParameters();
            if (paramTypes == null || !localParams.isEmpty() && localParams.size() != paramTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < localParams.size(); ++i) {
                ParameterSource localParam = (ParameterSource)localParams.get(i);
                String type = paramTypes[i];
                if (Types.areEquivalent((String)localParam.getType(), (String)type)) continue;
                matches = false;
            }
            if (!matches) continue;
            return local;
        }
        return null;
    }

    public MethodSource<O> getMethod(String name, Class<?> ... paramTypes) {
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        String[] types = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            types[i] = paramTypes[i].getName();
        }
        return this.getMethod(name, types);
    }

    public boolean hasMethodSignature(Method<?, ?> method) {
        for (MethodSource<O> local : this.getMethods()) {
            if (!local.getName().equals(method.getName())) continue;
            Iterator localParams = local.getParameters().iterator();
            for (Parameter methodParam : method.getParameters()) {
                if (localParams.hasNext() && Strings.areEqual((String)((ParameterSource)localParams.next()).getType(), (String)methodParam.getType())) continue;
                return false;
            }
            return !localParams.hasNext();
        }
        return false;
    }

    public O removeMethod(Method<O, ?> method) {
        this.getBodyDeclaration().bodyDeclarations().remove(method.getInternal());
        return (O)this;
    }

    public MethodSource<O> addMethod() {
        MethodImpl<AbstractJavaSourceMemberHolder> m = new MethodImpl<AbstractJavaSourceMemberHolder>(this);
        this.getBodyDeclaration().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public MethodSource<O> addMethod(String method) {
        MethodImpl<AbstractJavaSourceMemberHolder> m = new MethodImpl<AbstractJavaSourceMemberHolder>(this, method);
        this.getBodyDeclaration().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public List<MethodSource<O>> getMethods() {
        ArrayList<MethodImpl<AbstractJavaSourceMemberHolder>> result = new ArrayList<MethodImpl<AbstractJavaSourceMemberHolder>>();
        MethodFinderVisitor methodFinderVisitor = new MethodFinderVisitor();
        this.body.accept((ASTVisitor)methodFinderVisitor);
        List<MethodDeclaration> methods = methodFinderVisitor.getMethods();
        for (MethodDeclaration methodDeclaration : methods) {
            result.add(new MethodImpl<AbstractJavaSourceMemberHolder>(this, methodDeclaration));
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> getInterfaces() {
        ArrayList<String> result = new ArrayList<String>();
        List<Type> superTypes = JDTHelper.getInterfaces((BodyDeclaration)this.getBodyDeclaration());
        for (Type type : superTypes) {
            Import imprt;
            String pkg;
            String name = JDTHelper.getTypeName(type);
            if (Types.isSimpleName((String)name) && this.hasImport(name) && !Strings.isNullOrEmpty((String)(pkg = (imprt = this.getImport(name)).getPackage()))) {
                name = pkg + "." + name;
            }
            result.add(name);
        }
        return result;
    }

    public O addInterface(String type) {
        if (!this.hasInterface(type)) {
            Type interfaceType = JDTHelper.getInterfaces((BodyDeclaration)((JavaInterfaceImpl)JavaParser.parse(JavaInterfaceImpl.class, (String)("public interface Mock extends " + Types.toSimpleName((String)type) + " {}"))).getBodyDeclaration()).get(0);
            if (this.hasInterface(Types.toSimpleName((String)type)) || this.hasImport(Types.toSimpleName((String)type))) {
                interfaceType = JDTHelper.getInterfaces((BodyDeclaration)((JavaInterfaceImpl)JavaParser.parse(JavaInterfaceImpl.class, (String)("public interface Mock extends " + type + " {}"))).getBodyDeclaration()).get(0);
            }
            this.addImport(type);
            ASTNode node = ASTNode.copySubtree((AST)this.unit.getAST(), (ASTNode)interfaceType);
            JDTHelper.getInterfaces((BodyDeclaration)this.getBodyDeclaration()).add((Type)node);
        }
        return (O)this;
    }

    public O addInterface(Class<?> type) {
        return this.addInterface(type.getName());
    }

    public O addInterface(JavaInterface<?> type) {
        return this.addInterface(type.getQualifiedName());
    }

    public boolean hasInterface(String type) {
        for (String name : this.getInterfaces()) {
            if (!Types.areEquivalent((String)name, (String)type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasInterface(Class<?> type) {
        return this.hasInterface(type.getName());
    }

    public boolean hasInterface(JavaInterface<?> type) {
        return this.hasInterface(type.getQualifiedName());
    }

    public O removeInterface(String type) {
        List<Type> interfaces = JDTHelper.getInterfaces((BodyDeclaration)this.getBodyDeclaration());
        for (Type i : interfaces) {
            if (!Types.areEquivalent((String)i.toString(), (String)type)) continue;
            interfaces.remove(i);
            break;
        }
        return (O)this;
    }

    public O removeInterface(Class<?> type) {
        return this.removeInterface(type.getName());
    }

    public O removeInterface(JavaInterface<?> type) {
        return this.removeInterface(type.getQualifiedName());
    }
}

