/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaType;
import org.jboss.forge.parser.java.Type;
import org.jboss.forge.parser.java.Visibility;
import org.jboss.forge.parser.java.VisibilityScoped;
import org.jboss.forge.parser.java.ast.AnnotationAccessor;
import org.jboss.forge.parser.java.ast.ModifierAccessor;
import org.jboss.forge.parser.java.impl.TypeImpl;
import org.jboss.forge.parser.java.source.AnnotationSource;
import org.jboss.forge.parser.java.source.AnnotationTargetSource;
import org.jboss.forge.parser.java.source.FieldSource;
import org.jboss.forge.parser.java.source.JavaSource;
import org.jboss.forge.parser.java.source.VisibilityScopedSource;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;

public class FieldImpl<O extends JavaSource<O>>
implements FieldSource<O> {
    private final AnnotationAccessor<O, FieldSource<O>> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    private O parent;
    private AST ast;
    private final FieldDeclaration field;
    private final VariableDeclarationFragment fragment;

    private void init(O parent) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
    }

    public FieldImpl(O parent) {
        this.init(parent);
        this.fragment = this.ast.newVariableDeclarationFragment();
        this.field = this.ast.newFieldDeclaration(this.fragment);
    }

    public FieldImpl(O parent, Object internal) {
        this(parent, internal, false);
    }

    public FieldImpl(O parent, Object internal, boolean copy) {
        this.init(parent);
        if (copy) {
            VariableDeclarationFragment newFieldFragment = (VariableDeclarationFragment)internal;
            FieldDeclaration newFieldDeclaration = (FieldDeclaration)newFieldFragment.getParent();
            this.field = (FieldDeclaration)ASTNode.copySubtree((AST)this.ast, (ASTNode)newFieldDeclaration);
            Iterator fragmentsIterator = this.field.fragments().iterator();
            VariableDeclarationFragment temp = null;
            while (fragmentsIterator.hasNext()) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fragmentsIterator.next();
                if (newFieldFragment.getName().getFullyQualifiedName().equals(variableDeclarationFragment.getName().getFullyQualifiedName())) {
                    temp = variableDeclarationFragment;
                    continue;
                }
                fragmentsIterator.remove();
            }
            this.fragment = temp;
        } else {
            this.fragment = (VariableDeclarationFragment)internal;
            this.field = (FieldDeclaration)this.fragment.getParent();
        }
    }

    public O getOrigin() {
        return (O)((JavaSource)this.parent.getOrigin());
    }

    public Object getInternal() {
        return this.fragment;
    }

    public AnnotationSource<O> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, FieldSource<O>>)this, (ASTNode)this.field);
    }

    public AnnotationSource<O> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.annotations.addAnnotation((AnnotationTargetSource<O, FieldSource<O>>)this, (ASTNode)this.field, clazz.getSimpleName());
    }

    public AnnotationSource<O> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTargetSource<O, FieldSource<O>>)this, (ASTNode)this.field, className);
    }

    public List<AnnotationSource<O>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTargetSource<O, FieldSource<O>>)this, (ASTNode)this.field);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, (ASTNode)this.field, type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, (ASTNode)this.field, type);
    }

    public AnnotationSource<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, FieldSource<O>>)this, (ASTNode)this.field, (Class<java.lang.annotation.Annotation>)type);
    }

    public AnnotationSource<O> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTargetSource<O, FieldSource<O>>)this, (ASTNode)this.field, type);
    }

    public FieldSource<O> removeAnnotation(Annotation<O> annotation) {
        return this.annotations.removeAnnotation(this, (ASTNode)this.field, annotation);
    }

    public String toString() {
        return this.field.toString();
    }

    public boolean isFinal() {
        return this.modifiers.hasModifier((ASTNode)this.field, Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    public FieldSource<O> setFinal(boolean finl) {
        if (finl) {
            this.modifiers.addModifier((ASTNode)this.field, Modifier.ModifierKeyword.FINAL_KEYWORD);
        } else {
            this.modifiers.removeModifier((ASTNode)this.field, Modifier.ModifierKeyword.FINAL_KEYWORD);
        }
        return this;
    }

    public boolean isStatic() {
        return this.modifiers.hasModifier((ASTNode)this.field, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    public FieldSource<O> setStatic(boolean statc) {
        if (statc) {
            this.modifiers.addModifier((ASTNode)this.field, Modifier.ModifierKeyword.STATIC_KEYWORD);
        } else {
            this.modifiers.removeModifier((ASTNode)this.field, Modifier.ModifierKeyword.STATIC_KEYWORD);
        }
        return this;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public FieldSource<O> setPackagePrivate() {
        this.modifiers.clearVisibility((ASTNode)this.field);
        return this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier((ASTNode)this.field, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public FieldSource<O> setPublic() {
        this.modifiers.clearVisibility((ASTNode)this.field);
        this.modifiers.addModifier((ASTNode)this.field, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier((ASTNode)this.field, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public FieldSource<O> setPrivate() {
        this.modifiers.clearVisibility((ASTNode)this.field);
        this.modifiers.addModifier((ASTNode)this.field, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier((ASTNode)this.field, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public FieldSource<O> setProtected() {
        this.modifiers.clearVisibility((ASTNode)this.field);
        this.modifiers.addModifier((ASTNode)this.field, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return this;
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public FieldSource<O> setVisibility(Visibility scope) {
        return (FieldSource)Visibility.set((VisibilityScopedSource)this, (Visibility)scope);
    }

    public String getName() {
        String result = null;
        for (Object f : this.field.fragments()) {
            if (!(f instanceof VariableDeclarationFragment)) continue;
            VariableDeclarationFragment frag = (VariableDeclarationFragment)f;
            result = frag.getName().getFullyQualifiedName();
            break;
        }
        return result;
    }

    public FieldSource<O> setName(String name) {
        this.fragment.setName(this.ast.newSimpleName(name));
        return this;
    }

    public String getType() {
        return Types.toSimpleName((String)this.getQualifiedType());
    }

    public String getQualifiedType() {
        org.eclipse.jdt.core.dom.Type fieldType = this.field.getType();
        String result = this.parent.resolveType(fieldType.toString());
        int extraDimensions = this.fragment.getExtraDimensions();
        if (fieldType != null) {
            if (fieldType.isArrayType()) {
                int dimensions = ((ArrayType)fieldType).getDimensions();
                for (int ctr = 0; ctr < dimensions; ++ctr) {
                    result = result + "[]";
                }
            }
            for (int dimensionsToAdd = 0; dimensionsToAdd < extraDimensions; ++dimensionsToAdd) {
                result = result + "[]";
            }
        }
        return result;
    }

    public Type<O> getTypeInspector() {
        return new TypeImpl<O>(this.parent, this.field.getStructuralProperty((StructuralPropertyDescriptor)FieldDeclaration.TYPE_PROPERTY));
    }

    public boolean isType(Class<?> type) {
        if (Strings.areEqual((String)type.getName(), (String)this.getQualifiedType())) {
            return true;
        }
        if (this.isPrimitive() && type.getSimpleName().equals(this.getType())) {
            return true;
        }
        String simpleName = type.getSimpleName();
        return Strings.areEqual((String)simpleName, (String)this.getQualifiedType()) && (this.getOrigin().hasImport(type) || !this.getOrigin().requiresImport(type));
    }

    public boolean isType(String name) {
        if (Strings.areEqual((String)name, (String)this.getQualifiedType())) {
            return true;
        }
        return (!Types.isQualified((String)name) || this.getOrigin().hasImport(name) || !this.getOrigin().requiresImport(name)) && Types.areEquivalent((String)name, (String)this.getQualifiedType());
    }

    public FieldSource<O> setType(Class<?> clazz) {
        if (this.parent.requiresImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.setType(clazz.getSimpleName());
    }

    public FieldSource<O> setType(JavaType<?> source) {
        return this.setType(source.getQualifiedName());
    }

    public FieldSource<O> setType(String typeName) {
        String simpleName = Types.toSimpleName((String)typeName);
        O origin = this.getOrigin();
        if (!Strings.areEqual((String)typeName, (String)simpleName) && origin.requiresImport(typeName)) {
            origin.addImport(typeName);
        }
        PrimitiveType.Code primitive = PrimitiveType.toCode((String)typeName);
        PrimitiveType type = null;
        if (primitive != null) {
            type = this.ast.newPrimitiveType(primitive);
        } else if (!origin.requiresImport(typeName)) {
            if (Types.isArray((String)typeName)) {
                String arrayType = Types.stripArray((String)typeName);
                int arrayDimension = Types.getArrayDimension((String)typeName);
                type = Types.isPrimitive((String)arrayType) ? this.ast.newArrayType((org.eclipse.jdt.core.dom.Type)this.ast.newPrimitiveType(PrimitiveType.toCode((String)arrayType)), arrayDimension) : this.ast.newArrayType((org.eclipse.jdt.core.dom.Type)this.ast.newSimpleType((Name)this.ast.newSimpleName(arrayType)), arrayDimension);
            } else {
                type = this.ast.newSimpleType((Name)this.ast.newSimpleName(simpleName));
            }
        } else {
            String[] className = Types.tokenizeClassName((String)typeName);
            Name name = this.ast.newName(className);
            type = this.ast.newSimpleType(name);
        }
        this.field.setType((org.eclipse.jdt.core.dom.Type)type);
        return this;
    }

    public String getLiteralInitializer() {
        String result = this.fragment.getInitializer().toString();
        return result;
    }

    public String getStringInitializer() {
        String result = Strings.unquote((String)this.fragment.getInitializer().toString());
        return result;
    }

    public FieldSource<O> setLiteralInitializer(String value) {
        String stub = "public class Stub { private String stub = " + value + " }";
        JavaClass temp = (JavaClass)JavaParser.parse(JavaClass.class, (String)stub);
        VariableDeclarationFragment tempFrag = (VariableDeclarationFragment)((Field)temp.getFields().get(0)).getInternal();
        this.fragment.setInitializer((Expression)ASTNode.copySubtree((AST)this.ast, (ASTNode)tempFrag.getInitializer()));
        return this;
    }

    public FieldSource<O> setStringInitializer(String value) {
        return this.setLiteralInitializer(Strings.enquote((String)value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        result = 31 * result + (this.fragment == null ? 0 : this.fragment.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FieldImpl other = (FieldImpl)obj;
        if (this.field == null ? other.field != null : !this.field.equals((Object)other.field)) {
            return false;
        }
        return !(this.fragment == null ? other.fragment != null : !this.fragment.equals((Object)other.fragment));
    }

    public boolean isPrimitive() {
        boolean result = false;
        org.eclipse.jdt.core.dom.Type type = this.field.getType();
        if (type != null) {
            result = type.isPrimitiveType();
        }
        return result;
    }

    public boolean isTransient() {
        return this.modifiers.hasModifier((ASTNode)this.field, Modifier.ModifierKeyword.TRANSIENT_KEYWORD);
    }

    public boolean isVolatile() {
        return this.modifiers.hasModifier((ASTNode)this.field, Modifier.ModifierKeyword.VOLATILE_KEYWORD);
    }
}

