/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jface.text.Document;
import org.jboss.forge.parser.ParserException;
import org.jboss.forge.parser.java.JavaType;
import org.jboss.forge.parser.java.ast.TypeDeclarationFinderVisitor;
import org.jboss.forge.parser.java.impl.JavaAnnotationImpl;
import org.jboss.forge.parser.java.impl.JavaClassImpl;
import org.jboss.forge.parser.java.impl.JavaEnumImpl;
import org.jboss.forge.parser.java.impl.JavaInterfaceImpl;
import org.jboss.forge.parser.java.impl.JavaPackageInfoImpl;
import org.jboss.forge.parser.java.source.JavaAnnotationSource;
import org.jboss.forge.parser.java.source.JavaClassSource;
import org.jboss.forge.parser.java.source.JavaEnumSource;
import org.jboss.forge.parser.java.source.JavaInterfaceSource;
import org.jboss.forge.parser.java.source.JavaPackageInfoSource;
import org.jboss.forge.parser.java.source.JavaSource;
import org.jboss.forge.parser.spi.JavaParserProvider;
import org.jboss.forge.parser.spi.Streams;

public class JavaParserImpl
implements JavaParserProvider {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaType<?> parse(InputStream data) {
        try {
            char[] source = Util.getInputStreamAsCharArray((InputStream)data, (int)data.available(), (String)"ISO8859_1");
            JavaType<?> javaType = this.parse(new String(source));
            return javaType;
        }
        catch (IOException e) {
            JavaType<?> javaType = null;
            return javaType;
        }
        finally {
            Streams.closeQuietly(data);
        }
    }

    private JavaType<?> parse(String data) {
        Document document = new Document(data);
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setSource(document.get().toCharArray());
        Hashtable options = JavaCore.getOptions();
        options.put("org.eclipse.jdt.core.compiler.source", "1.7");
        options.put("org.eclipse.jdt.core.encoding", "UTF-8");
        parser.setCompilerOptions((Map)options);
        parser.setResolveBindings(true);
        parser.setKind(8);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        unit.recordModifications();
        TypeDeclarationFinderVisitor visitor = new TypeDeclarationFinderVisitor();
        unit.accept((ASTVisitor)visitor);
        List<AbstractTypeDeclaration> declarations = visitor.getTypeDeclarations();
        if (!declarations.isEmpty()) {
            AbstractTypeDeclaration declaration = declarations.get(0);
            return JavaParserImpl.getJavaSource(null, document, unit, (ASTNode)declaration);
        }
        if (visitor.getPackageDeclaration() != null) {
            return JavaParserImpl.getJavaSource(null, document, unit, (ASTNode)visitor.getPackageDeclaration());
        }
        throw new ParserException("Could not find type declaration in Java source - is this actually code?");
    }

    public static JavaSource<?> getJavaSource(JavaSource<?> enclosingType, Document document, CompilationUnit unit, ASTNode declaration) {
        if (declaration instanceof TypeDeclaration) {
            TypeDeclaration typeDeclaration = (TypeDeclaration)declaration;
            if (typeDeclaration.isInterface()) {
                return new JavaInterfaceImpl(enclosingType, document, unit, (BodyDeclaration)typeDeclaration);
            }
            return new JavaClassImpl(enclosingType, document, unit, (BodyDeclaration)typeDeclaration);
        }
        if (declaration instanceof EnumDeclaration) {
            EnumDeclaration enumDeclaration = (EnumDeclaration)declaration;
            return new JavaEnumImpl(enclosingType, document, unit, (BodyDeclaration)enumDeclaration);
        }
        if (declaration instanceof AnnotationTypeDeclaration) {
            AnnotationTypeDeclaration annotationTypeDeclaration = (AnnotationTypeDeclaration)declaration;
            return new JavaAnnotationImpl(enclosingType, document, unit, (BodyDeclaration)annotationTypeDeclaration);
        }
        if (declaration instanceof PackageDeclaration) {
            PackageDeclaration packageDeclaration = (PackageDeclaration)declaration;
            return new JavaPackageInfoImpl(enclosingType, document, unit, packageDeclaration);
        }
        throw new ParserException("Unknown Java source type [" + declaration + "]");
    }

    public <T extends JavaSource<?>> T create(Class<T> type) {
        if (type != null) {
            if (type.isAssignableFrom(JavaClassSource.class)) {
                return (T)((JavaSource)this.parse("public class JavaClass { }"));
            }
            if (type.isAssignableFrom(JavaEnumSource.class)) {
                return (T)((JavaSource)this.parse("public enum JavaEnum { }"));
            }
            if (type.isAssignableFrom(JavaAnnotationSource.class)) {
                return (T)((JavaSource)this.parse("public @interface JavaAnnotation { }"));
            }
            if (type.isAssignableFrom(JavaInterfaceSource.class)) {
                return (T)((JavaSource)this.parse("public interface JavaInterface { }"));
            }
            if (type.isAssignableFrom(JavaPackageInfoSource.class)) {
                return (T)((JavaSource)this.parse("package org.example;"));
            }
        }
        return null;
    }
}

