/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.jboss.forge.container.util.OperatingSystemUtils;
import org.jboss.forge.environment.Environment;
import org.jboss.forge.facets.AbstractFacet;
import org.jboss.forge.facets.Faceted;
import org.jboss.forge.maven.dependencies.MavenContainer;
import org.jboss.forge.maven.environment.Network;
import org.jboss.forge.maven.projects.MavenFacet;
import org.jboss.forge.maven.projects.PlexusContainer;
import org.jboss.forge.maven.projects.util.NativeSystemCall;
import org.jboss.forge.maven.projects.util.NullOutputStream;
import org.jboss.forge.maven.projects.util.RepositoryUtils;
import org.jboss.forge.maven.resources.MavenPomResource;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.ProjectFacet;
import org.jboss.forge.resource.DirectoryResource;
import org.jboss.forge.resource.ResourceFactory;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.util.repository.DefaultProxySelector;

public class MavenFacetImpl
extends AbstractFacet<Project>
implements ProjectFacet,
MavenFacet {
    private ProjectBuildingRequest request;
    private ProjectBuildingResult buildingResult;
    private ProjectBuildingResult fullBuildingResult;
    private ProjectBuilder builder = null;
    @Inject
    private MavenContainer container;
    @Inject
    private Environment environment;
    @Inject
    private ResourceFactory factory;
    @Inject
    private PlexusContainer plexus;

    public ProjectBuilder getBuilder() {
        return this.builder;
    }

    public ProjectBuildingRequest getRequest() {
        return this.getBuildingRequest(Network.isOffline((Environment)this.environment));
    }

    public ProjectBuildingRequest getOfflineRequest() {
        return this.getBuildingRequest(true);
    }

    public ProjectBuildingRequest getBuildingRequest(boolean offline) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Settings settings = this.container.getSettings();
            DefaultMavenExecutionRequest executionRequest = new DefaultMavenExecutionRequest();
            this.plexus.lookup(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)executionRequest, this.container.getSettings());
            this.request = executionRequest.getProjectBuildingRequest();
            ArtifactRepository localRepository = RepositoryUtils.toArtifactRepository("local", new File(settings.getLocalRepository()).toURI().toURL().toString(), null, true, true);
            this.request.setLocalRepository(localRepository);
            ArrayList<ArtifactRepository> settingsRepos = new ArrayList<ArtifactRepository>();
            List activeProfiles = settings.getActiveProfiles();
            Map profiles = settings.getProfilesAsMap();
            for (String id : activeProfiles) {
                Profile profile = (Profile)profiles.get(id);
                if (profile == null) continue;
                List repositories = profile.getRepositories();
                for (Repository repository : repositories) {
                    settingsRepos.add(RepositoryUtils.convertFromMavenSettingsRepository(repository));
                }
            }
            if (!offline && settingsRepos.isEmpty()) {
                settingsRepos.add(RepositoryUtils.toArtifactRepository("CENTRAL", "http://repo1.maven.org/maven2/", null, true, false));
            }
            this.request.setRemoteRepositories(settingsRepos);
            this.request.setSystemProperties(System.getProperties());
            MavenRepositorySystemSession repositorySession = new MavenRepositorySystemSession();
            Proxy activeProxy = settings.getActiveProxy();
            if (activeProxy != null) {
                DefaultProxySelector dps = new DefaultProxySelector();
                dps.add(RepositoryUtils.convertFromMavenProxy(activeProxy), activeProxy.getNonProxyHosts());
                repositorySession.setProxySelector((ProxySelector)dps);
            }
            repositorySession.setLocalRepositoryManager((LocalRepositoryManager)new SimpleLocalRepositoryManager(settings.getLocalRepository()));
            repositorySession.setOffline(offline);
            this.request.setRepositorySession((RepositorySystemSession)repositorySession);
            this.request.setProcessPlugins(false);
            this.request.setResolveDependencies(false);
            ProjectBuildingRequest projectBuildingRequest = this.request;
            return projectBuildingRequest;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Maven project building request", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void setOrigin(Project project) {
        super.setOrigin((Faceted)project);
    }

    public boolean install() {
        if (!this.isInstalled()) {
            MavenPomResource pom = this.getPomResource();
            if (!pom.createNewFile()) {
                throw new IllegalStateException("Could not create POM file.");
            }
            pom.setContents(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/pom-template.xml"));
        }
        return this.isInstalled();
    }

    public MavenPomResource getPomResource() {
        return (MavenPomResource)((Project)this.getOrigin()).getProjectRoot().getChild("pom.xml").reify(MavenPomResource.class);
    }

    public boolean isInstalled() {
        MavenPomResource pom = this.getPomResource();
        return pom != null && pom.exists();
    }

    public Model getPOM() {
        return this.getPomResource().getCurrentModel();
    }

    public void setPOM(Model pom) {
        MavenXpp3Writer writer = new MavenXpp3Writer();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter fw = new OutputStreamWriter(outputStream);
        try {
            writer.write((Writer)fw, pom);
            this.getPomResource().setContents(outputStream.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write POM file: " + this.getPomResource().getFullyQualifiedName(), e);
        }
        finally {
            try {
                ((Writer)fw).close();
                outputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.invalidateBuildingResults();
    }

    public ProjectBuildingResult getPartialProjectBuildingResult() {
        if (this.buildingResult == null) {
            ProjectBuildingRequest request = null;
            File pomFile = (File)this.getPomResource().getUnderlyingResourceObject();
            try {
                request = this.getRequest();
                this.buildingResult = this.getBuilder().build(pomFile, request);
            }
            catch (ProjectBuildingException partial) {
                if (request != null) {
                    try {
                        request.setResolveDependencies(true);
                        this.fullBuildingResult = this.buildingResult = this.getBuilder().build(pomFile, request);
                    }
                    catch (Exception full) {
                        throw new RuntimeException(full);
                    }
                }
                throw new RuntimeException(partial);
            }
        }
        return this.buildingResult;
    }

    public ProjectBuildingResult getFullProjectBuildingResult() {
        if (this.fullBuildingResult == null) {
            ProjectBuildingRequest request = null;
            request = this.getRequest();
            File pomFile = (File)this.getPomResource().getUnderlyingResourceObject();
            if (request != null) {
                try {
                    request.setResolveDependencies(true);
                    this.fullBuildingResult = this.buildingResult = this.getBuilder().build(pomFile, request);
                }
                catch (Exception full) {
                    throw new RuntimeException(full);
                }
            } else {
                throw new RuntimeException("Project building request was null");
            }
        }
        return this.fullBuildingResult;
    }

    private void invalidateBuildingResults() {
        this.buildingResult = null;
        this.fullBuildingResult = null;
    }

    public String resolveProperties(String input) {
        String result = input;
        if (input != null) {
            Properties properties = this.getPartialProjectBuildingResult().getProject().getProperties();
            for (Map.Entry<Object, Object> e : properties.entrySet()) {
                String key = "\\$\\{" + e.getKey().toString() + "\\}";
                Object value = e.getValue();
                result = result.replaceAll(key, value.toString());
            }
        }
        return result;
    }

    public boolean executeMavenEmbedded(List<String> parameters) {
        return this.executeMavenEmbedded(parameters.toArray(new String[0]));
    }

    public boolean executeMavenEmbedded(String[] parms) {
        return this.executeMavenEmbedded(System.out, System.err, parms);
    }

    public boolean executeMavenEmbedded(PrintStream out, PrintStream err, String[] parms) {
        MavenCli cli;
        int i;
        if (parms == null || parms.length == 0) {
            parms = new String[]{""};
        }
        return (i = (cli = new MavenCli()).doMain(parms, ((Project)this.getOrigin()).getProjectRoot().getFullyQualifiedName(), out, err)) == 0;
    }

    public boolean executeMaven(List<String> parameters) {
        return this.executeMaven(parameters.toArray(new String[0]));
    }

    public boolean executeMaven(String[] selected) {
        return this.executeMaven(new NullOutputStream(), selected);
    }

    public boolean executeMaven(OutputStream out, String[] parms) {
        try {
            return 0 == NativeSystemCall.execFromPath(this.getMvnCommand(), parms, out, ((Project)this.getOrigin()).getProjectRoot());
        }
        catch (IOException e) {
            return this.executeMavenEmbedded(parms);
        }
    }

    private String getMvnCommand() {
        return OperatingSystemUtils.isWindows() ? "mvn.bat" : "mvn";
    }

    public DirectoryResource getLocalRepositoryDirectory() {
        return (DirectoryResource)this.factory.create((Object)new File(this.container.getSettings().getLocalRepository())).reify(DirectoryResource.class);
    }
}

