/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects.facets;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.jboss.forge.facets.AbstractFacet;
import org.jboss.forge.facets.Faceted;
import org.jboss.forge.maven.projects.MavenFacet;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.facets.ResourceFacet;
import org.jboss.forge.resource.DirectoryResource;
import org.jboss.forge.resource.FileResource;

@Dependent
public class MavenResourceFacet
extends AbstractFacet<Project>
implements ResourceFacet {
    public List<DirectoryResource> getResourceFolders() {
        ArrayList<DirectoryResource> result = new ArrayList<DirectoryResource>();
        result.add(this.getResourceFolder());
        result.add(this.getTestResourceFolder());
        return result;
    }

    public DirectoryResource getResourceFolder() {
        return ((Project)this.getOrigin()).getProjectRoot().getChildDirectory("src" + File.separator + "main" + File.separator + "resources");
    }

    public DirectoryResource getTestResourceFolder() {
        return ((Project)this.getOrigin()).getProjectRoot().getChildDirectory("src" + File.separator + "test" + File.separator + "resources");
    }

    public void setOrigin(Project origin) {
        super.setOrigin((Faceted)origin);
    }

    public boolean isInstalled() {
        return ((Project)this.getOrigin()).hasFacet(MavenFacet.class) && this.getResourceFolder().exists();
    }

    public boolean install() {
        if (!this.isInstalled()) {
            for (DirectoryResource folder : this.getResourceFolders()) {
                folder.mkdirs();
            }
        }
        return true;
    }

    public FileResource<?> getResource(String relativePath) {
        return (FileResource)this.getResourceFolder().getChild(relativePath);
    }

    public FileResource<?> getTestResource(String relativePath) {
        return (FileResource)this.getTestResourceFolder().getChild(relativePath);
    }

    public FileResource<?> createResource(char[] bytes, String relativeFilename) {
        FileResource file = (FileResource)this.getResourceFolder().getChild(relativeFilename);
        file.setContents(bytes);
        return file;
    }

    public FileResource<?> createTestResource(char[] bytes, String relativeFilename) {
        FileResource file = (FileResource)this.getTestResourceFolder().getChild(relativeFilename);
        file.setContents(bytes);
        return file;
    }
}

