/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects;

import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.jboss.forge.maven.projects.MavenFacet;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.ProjectAssociationProvider;
import org.jboss.forge.projects.ProjectFactory;
import org.jboss.forge.resource.DirectoryResource;

public class MavenMultiModuleProvider
implements ProjectAssociationProvider {
    @Inject
    private ProjectFactory projectFactory;

    public void associate(Project project, DirectoryResource parentDir) {
        if (this.canAssociate(project, parentDir)) {
            Project parent = this.projectFactory.findProject(parentDir);
            MavenFacet parentMavenFacet = (MavenFacet)parent.getFacet(MavenFacet.class);
            Model parentPom = parentMavenFacet.getPOM();
            parentPom.setPackaging("pom");
            String moduleDir = project.getProjectRoot().getFullyQualifiedName().substring(parent.getProjectRoot().getFullyQualifiedName().length());
            if (moduleDir.startsWith("/")) {
                moduleDir = moduleDir.substring(1);
            }
            parentPom.addModule(moduleDir);
            parentMavenFacet.setPOM(parentPom);
            MavenFacet projectMavenFacet = (MavenFacet)project.getFacet(MavenFacet.class);
            Model pom = projectMavenFacet.getPOM();
            Parent projectParent = new Parent();
            projectParent.setGroupId(parentPom.getGroupId());
            projectParent.setArtifactId(parentPom.getArtifactId());
            projectParent.setVersion(parentPom.getVersion());
            pom.setParent(projectParent);
            projectMavenFacet.setPOM(pom);
        }
    }

    public boolean canAssociate(Project project, DirectoryResource parent) {
        return parent.getChild("pom.xml").exists() && project.getProjectRoot().getChild("pom.xml").exists();
    }
}

