/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.projects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.forge.environment.Environment;
import org.jboss.forge.maven.environment.Network;
import org.jboss.forge.maven.projects.MavenFacet;
import org.jboss.forge.projects.Project;
import org.jboss.forge.projects.building.BuildException;
import org.jboss.forge.projects.building.ProjectBuilder;
import org.jboss.forge.projects.facets.PackagingFacet;
import org.jboss.forge.resource.Resource;

public class MavenProjectBuilder
implements ProjectBuilder {
    private final Environment environment;
    private final Project project;
    private boolean runTests = true;
    private final List<String> args = new ArrayList<String>();

    public MavenProjectBuilder(Environment environment, Project project) {
        this.environment = environment;
        this.project = project;
    }

    public ProjectBuilder addArguments(String ... args) {
        this.args.addAll(Arrays.asList(args));
        return this;
    }

    public ProjectBuilder runTests(boolean test) {
        this.runTests = test;
        return this;
    }

    public Resource<?> build() {
        boolean success;
        ArrayList<String> selected = new ArrayList<String>();
        selected.addAll(Arrays.asList("clean", "package"));
        if (this.args != null && !this.args.isEmpty()) {
            selected.clear();
            selected.addAll(this.args);
        }
        if (Network.isOffline((Environment)this.environment)) {
            selected.add("--offline");
        }
        if (!this.runTests) {
            selected.add("-Dmaven.test.skip=true");
        }
        if (success = ((MavenFacet)this.project.getFacet(MavenFacet.class)).executeMaven(selected)) {
            return ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getFinalArtifact();
        }
        throw new BuildException("Build failed.");
    }
}

